/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.planner;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.planner.QueryPlan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Leaf {
    private int leafStepNo = 0;
    private String tableName = "";
    private String targetTableName;
    public static final int REGULAR = 1;
    public static final int SUBQUERY_JOIN = 2;
    public static final int SUBQUERY_DATA_DOWN = 3;
    private int leafType = 1;
    private String selectStatement;
    private String nonProjectionPart;
    public ArrayList<Projection> selectColumns;
    public LinkedHashMap<String, Projection> selectColumnMap;
    private boolean distinct = false;
    private StringBuilder sbCreateTableColumns = new StringBuilder(128);
    private String createCorrelatedTableString = "";
    private String correlatedSelectString = "";
    private List<Join> joinConditions;
    private String joinTableName;
    private List<String> tableList;
    protected List<String> extendedTableList;
    protected List<String> extendedAliasList;
    protected List extendedOuter;
    protected List extendedOuterLevel;
    private List<String> conditions;
    protected List<Projection> groupByColumns;
    private List<String> havingConditions;
    private boolean combinerStep = false;
    private int addedGroupCount = 0;
    private boolean combineOnMain = false;
    private boolean extraStep = false;
    protected List<String> tempTableDropList;
    protected QueryPlan subplan;
    protected QueryPlan outerSubplan;
    protected List<QueryPlan> uncorrelatedSubplanList;
    private static int unnamedColCount = 0;
    protected List<DBNode> queryNodeList;
    private boolean correlatedHashable = false;
    protected SqlExpression correlatedParentHashableExpression;
    protected SqlExpression correlatedChildHashableExpression;
    protected String correlatedJoinTableName;
    private List<String> correlatedColumnList;
    protected String finalInClausePartitioningTable = null;
    private boolean suppressedGroupBy = false;
    private String hashTableName = null;
    private String hashColumn = null;
    private boolean lookupStep = false;
    private boolean singleStepCorrelated = false;
    private String singleCorrelatedHash = null;
    private HashMap<AttributeColumn, String> newAliasTable = new HashMap();
    private long limit = -1L;
    private long offset = -1L;
    public boolean usesOid = false;
    protected List<SqlExpression> outerExprList;
    protected List<SqlExpression> innerExprList;
    private String outerNodeIdColumn = null;
    protected int lastOuterLevel = 0;
    private List<OuterIdColumn> outerIdColumnList = new ArrayList<OuterIdColumn>();
    private short serialColumnPosition = (short)-1;
    private String whereClause;
    private SqlExpression partitionParameterExpression = null;
    private String outerTestString;

    public Leaf() {
        this.selectColumnMap = new LinkedHashMap();
        this.selectColumns = new ArrayList();
        this.tableList = new ArrayList<String>();
        this.extendedTableList = new ArrayList<String>();
        this.extendedAliasList = new ArrayList<String>();
        this.extendedOuter = new ArrayList();
        this.extendedOuterLevel = new ArrayList();
        this.tempTableDropList = new ArrayList<String>();
        this.joinConditions = new ArrayList<Join>();
        this.conditions = new ArrayList<String>();
        this.groupByColumns = new ArrayList<Projection>();
        this.havingConditions = new ArrayList<String>();
        this.queryNodeList = new ArrayList<DBNode>();
        this.uncorrelatedSubplanList = new ArrayList<QueryPlan>();
    }

    public String getSelect() {
        return this.getSelectStatement();
    }

    public String getTempTargetCreateStmt() {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (Props.XDB_USE_LOAD_FOR_STEP) {
            stringBuilder.append(Props.XDB_SQLCOMMAND_CREATEGLOBALTEMPTABLE_START).append(" ").append(IdentifierHandler.quote(this.targetTableName)).append(" (").append(this.sbCreateTableColumns.toString()).append(") ").append(Props.XDB_SQLCOMMAND_CREATEGLOBALTEMPTABLE_SUFFIX);
        } else {
            stringBuilder.append(Props.XDB_SQLCOMMAND_CREATETEMPTABLE_START).append(" ").append(IdentifierHandler.quote(this.targetTableName)).append(" (").append(this.sbCreateTableColumns.toString()).append(") ").append(Props.XDB_SQLCOMMAND_CREATETEMPTABLE_SUFFIX);
        }
        return stringBuilder.toString();
    }

    public String appendProjection(SqlExpression sqlExpression, boolean bl) {
        String string;
        if (this.sbCreateTableColumns.length() != 0) {
            this.sbCreateTableColumns.append(",");
        }
        sqlExpression.rebuildString();
        Projection projection = new Projection(sqlExpression.getExprString());
        projection.alias = sqlExpression.getAlias();
        if (sqlExpression.isTempExpr()) {
            string = sqlExpression.getAlias();
        } else if (bl && sqlExpression.getAlias().length() > 0) {
            string = sqlExpression.getAlias();
            if (this.isCreateColumn(string)) {
                string = this.generateColumnName();
                this.newAliasTable.put(sqlExpression.getColumn(), string);
            }
        } else if (sqlExpression.getExprType() == 4) {
            string = sqlExpression.getColumn().tempColumnAlias.length() > 0 ? sqlExpression.getColumn().tempColumnAlias : (sqlExpression.getColumn().columnAlias.length() > 0 ? sqlExpression.getColumn().columnAlias : sqlExpression.getColumn().columnName);
            if (this.isCreateColumn(string)) {
                string = this.generateColumnName();
                if (sqlExpression.getColumn().columnAlias.length() == 0) {
                    sqlExpression.setAlias(string);
                }
                this.newAliasTable.put(sqlExpression.getColumn(), string);
            }
        } else if (bl && sqlExpression.getAggAlias().length() > 0) {
            string = sqlExpression.getAggAlias();
        } else if (sqlExpression.getAlias().length() > 0) {
            string = sqlExpression.getAlias();
            if (this.isCreateColumn(string)) {
                string = this.generateColumnName();
                this.newAliasTable.put(sqlExpression.getColumn(), string);
            }
        } else {
            string = this.generateColumnName();
            sqlExpression.setAlias(string);
        }
        projection.createString = string;
        this.selectColumns.add(projection);
        this.selectColumnMap.put(projection.projectString, projection);
        try {
            this.sbCreateTableColumns.append(" ");
            this.sbCreateTableColumns.append(IdentifierHandler.quote(string));
            this.sbCreateTableColumns.append(" ");
            this.sbCreateTableColumns.append(sqlExpression.getExprDataType().getTypeString());
        }
        catch (Exception exception) {
            String string2 = ErrorMessageRepository.ERROR_GETTING_TYPE_INFO + sqlExpression.getExprString();
            throw new XDBServerException(string2, exception, ErrorMessageRepository.ERROR_GETTING_TYPE_INFO_CODE);
        }
        return string;
    }

    public String appendProjectionFromExpr(SqlExpression sqlExpression, boolean bl) {
        return this.appendProjection(sqlExpression, bl);
    }

    public boolean isProjection(String string) {
        if (string == null) {
            return false;
        }
        return this.selectColumnMap.get(string) != null;
    }

    public boolean isCreateColumn(String string) {
        for (Projection projection : this.selectColumns) {
            if (string.compareToIgnoreCase(projection.createString) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupByColumn(String string) {
        for (Projection projection : this.groupByColumns) {
            if (string.compareToIgnoreCase(projection.projectString) != 0) continue;
            return true;
        }
        return false;
    }

    private String getSelectClause() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("SELECT ");
        if (this.distinct) {
            stringBuilder.append(" distinct ");
        }
        int n = 0;
        for (Projection projection : this.selectColumns) {
            if (n++ > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(projection.projectString);
            String string = projection.getCreateColumnName();
            if (string == null || string.length() <= 0) continue;
            stringBuilder.append(" AS ").append(IdentifierHandler.quote(string));
        }
        return stringBuilder.toString();
    }

    private String determineWhereClause(List<String> list) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(128);
        for (n = 0; n < list.size(); ++n) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(list.get(n));
        }
        for (n = 0; n < this.conditions.size(); ++n) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this.conditions.get(n));
        }
        if (stringBuilder.length() > 0) {
            return " WHERE " + stringBuilder.toString();
        }
        return "";
    }

    public void determineSelectStatement(QueryPlan queryPlan) {
        String string;
        String string2;
        int n;
        int n2 = 0;
        String string3 = "";
        String string4 = this.getSelectClause();
        if (this.joinTableName != null && this.joinTableName.length() > 0) {
            this.tableList.add(this.joinTableName);
            queryPlan.trackTable(this.joinTableName, this);
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        if (this.joinTableName != null) {
            stringBuilder.append(IdentifierHandler.quote(this.joinTableName));
        }
        StringBuilder stringBuilder2 = new StringBuilder(64);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (n = 0; n < this.joinConditions.size(); ++n) {
            arrayList.add(this.joinConditions.get(n).getJoinString());
        }
        for (n = 0; n < this.extendedTableList.size(); ++n) {
            String string5 = this.extendedTableList.get(n);
            arrayList2.add(string5);
            arrayList3.add(this.extendedAliasList.get(n));
        }
        n = 0;
        while (arrayList2.size() > 0 && n != arrayList2.size()) {
            n = arrayList2.size();
            for (int i = 0; i < arrayList2.size(); ++i) {
                string2 = (String)arrayList2.get(i);
                string = (String)arrayList3.get(i);
                if (stringBuilder.length() == 0) {
                    stringBuilder2.append(IdentifierHandler.quote(string2));
                    string3 = IdentifierHandler.quote(string2);
                    if (string.length() > 0 && string.compareTo(string2) != 0) {
                        stringBuilder2.append(" ").append(IdentifierHandler.quote(string));
                    }
                    stringBuilder = new StringBuilder(stringBuilder2);
                    arrayList2.remove(i);
                    arrayList3.remove(i);
                    this.extendedOuter.remove(i);
                    this.extendedOuterLevel.remove(i);
                    continue;
                }
                n2 = (Integer)this.extendedOuterLevel.get(i);
                stringBuilder2 = new StringBuilder(32);
                if (n2 != this.lastOuterLevel) {
                    stringBuilder2.append(" LEFT OUTER JOIN ").append(IdentifierHandler.quote(string2));
                } else {
                    stringBuilder2.append(" INNER JOIN ").append(IdentifierHandler.quote(string2));
                }
                if (string.length() > 0 && string.compareTo(string2) != 0) {
                    stringBuilder2.append(" ").append(IdentifierHandler.quote(string));
                }
                StringBuilder stringBuilder3 = new StringBuilder(32);
                for (int j = 0; j < arrayList.size(); ++j) {
                    String string6 = arrayList.get(j);
                    String string7 = IdentifierHandler.quote(string2);
                    String string8 = IdentifierHandler.quote(string);
                    if (string6.indexOf(" " + string7 + ".") <= 0 && string6.indexOf("(" + string7 + ".") < 0 && string6.indexOf(string7 + ".") != 0 && string6.indexOf(" " + string8 + ".") <= 0 && string6.indexOf("(" + string8 + ".") < 0 && string6.indexOf(string8 + ".") != 0) continue;
                    boolean bl = false;
                    for (int k = 0; k < arrayList2.size(); ++k) {
                        String string9;
                        String string10 = IdentifierHandler.quote((String)arrayList2.get(k));
                        if (string10.compareTo(string7) != 0 && string10.compareTo(string3) != 0 && string6.indexOf(string10 + ".") >= 0) {
                            bl = true;
                        }
                        if ((string9 = IdentifierHandler.quote((String)arrayList3.get(k))).compareTo(string8) == 0 || string9.compareTo(string3) == 0 || string6.indexOf(string9 + ".") < 0) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    if (stringBuilder3.length() == 0) {
                        stringBuilder3.append("ON");
                    } else {
                        stringBuilder3.append(" AND");
                    }
                    stringBuilder3.append(" ").append(string6);
                    arrayList.remove(j);
                    --j;
                }
                if (stringBuilder3.length() <= 0 && arrayList.size() != 0) continue;
                stringBuilder.append(" ").append((CharSequence)stringBuilder2).append(" ").append(stringBuilder3.toString());
                arrayList2.remove(i);
                arrayList3.remove(i);
                this.extendedOuter.remove(i);
                this.extendedOuterLevel.remove(i);
                --i;
                this.lastOuterLevel = n2;
            }
        }
        if (stringBuilder.indexOf(" ON ") < 0) {
            if (Props.XDB_SQL_USECROSSJOIN) {
                stringBuilder = new StringBuilder(stringBuilder.toString().replaceAll(" INNER ", " CROSS "));
            } else {
                stringBuilder = new StringBuilder(stringBuilder.toString().replaceAll(" INNER ", ","));
                stringBuilder = new StringBuilder(stringBuilder.toString().replaceAll("JOIN", " "));
            }
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            string2 = (String)arrayList2.get(i);
            string = (String)arrayList3.get(i);
            stringBuilder2.setLength(0);
            if (stringBuilder.length() == 0) {
                stringBuilder2.append(IdentifierHandler.quote(string2));
                string3 = IdentifierHandler.quote(string2);
                if (string.length() > 0 && string.compareTo(string2) != 0) {
                    stringBuilder2.append(" ").append(IdentifierHandler.quote(string));
                }
                stringBuilder = new StringBuilder(stringBuilder2);
                arrayList2.remove(i);
                arrayList3.remove(i);
                continue;
            }
            if (stringBuilder.length() > 0) {
                if (Props.XDB_SQL_USECROSSJOIN) {
                    stringBuilder2.append(" CROSS JOIN ").append(IdentifierHandler.quote(string2));
                } else {
                    stringBuilder2.append(" ,").append(IdentifierHandler.quote(string2));
                }
                if (string.length() > 0 && string.compareTo(string2) != 0) {
                    stringBuilder2.append(" ").append(IdentifierHandler.quote(string));
                }
            }
            stringBuilder.append(" ").append((CharSequence)stringBuilder2);
        }
        this.whereClause = this.determineWhereClause(arrayList);
        this.nonProjectionPart = stringBuilder.length() == 0 ? this.whereClause : "FROM " + stringBuilder.toString() + " " + this.whereClause + this.determineGroupByClause() + this.determineHavingClause();
        this.setSelectStatement(string4 + " " + this.nonProjectionPart);
    }

    private String determineGroupByClause() {
        if (this.isSuppressedGroupBy()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        for (Projection projection : this.groupByColumns) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(" group by ");
            } else {
                stringBuilder.append(", ");
            }
            if (projection.forceGroupQuote) {
                stringBuilder.append(IdentifierHandler.quote(projection.projectString));
                continue;
            }
            stringBuilder.append(projection.projectString);
        }
        return stringBuilder.toString();
    }

    private String determineHavingClause() {
        StringBuilder stringBuilder = new StringBuilder(64);
        for (String string : this.havingConditions) {
            if (stringBuilder.length() == 0) {
                stringBuilder.append(" having ");
            } else {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    protected String getNonProjectionSelectPart() {
        return this.nonProjectionPart;
    }

    protected void setNonProjectionSelectPart(String string) {
        this.nonProjectionPart = string;
    }

    protected void addCorrelatedColumn(SqlExpression sqlExpression) {
        if (this.correlatedColumnList == null) {
            this.correlatedColumnList = new ArrayList<String>();
        }
        if (sqlExpression.getExprType() == 4) {
            String string = sqlExpression.getColumn().columnAlias != null && sqlExpression.getColumn().columnAlias.length() > 0 ? sqlExpression.getColumn().columnAlias : sqlExpression.getColumn().columnName;
            for (String string2 : this.correlatedColumnList) {
                if (!string2.equals(string)) continue;
                return;
            }
            this.correlatedColumnList.add(string);
        }
    }

    protected List<String> getCorrelatedColumns() {
        return this.correlatedColumnList;
    }

    public void updateTempAliases() {
        for (AttributeColumn attributeColumn : this.newAliasTable.keySet()) {
            String string;
            if (attributeColumn == null) continue;
            attributeColumn.tempColumnAlias = string = this.newAliasTable.get(attributeColumn);
        }
        this.newAliasTable.clear();
    }

    private void addOuterIdColumns(QueryPlan queryPlan) {
        this.usesOid = true;
        SysDatabase sysDatabase = queryPlan.getSysDatabase();
        int n = queryPlan.getCurrentOuterCounter();
        Projection projection = null;
        for (String string : this.extendedTableList) {
            SysTable sysTable = sysDatabase.getSysTable(string);
            List<SysColumn> list = sysTable.getRowID();
            if (!sysTable.isTrueRowID()) {
                if (Props.XDB_USE_OID_IN_OUTER) {
                    this.addOid(queryPlan);
                    continue;
                }
                throw new XDBServerException("Cannot perform outer join for this version unless the outer most table has unique row identifying information, either a primary key, unique index or XROWID,or, if user allows OID usage with xdb.use_oid_in_outer.");
            }
            int n2 = 0;
            for (SysColumn sysColumn : list) {
                ExpressionType expressionType = new ExpressionType();
                expressionType.type = sysColumn.getColType();
                expressionType.length = sysColumn.getColLength();
                expressionType.precision = sysColumn.getColPrecision();
                expressionType.scale = sysColumn.getColScale();
                OuterIdColumn outerIdColumn = new OuterIdColumn(sysColumn.getColName(), "XOID" + n + "_" + ++n2, expressionType, false);
                this.outerIdColumnList.add(outerIdColumn);
                projection = new Projection(IdentifierHandler.quote(this.extendedTableList.get(0)) + "." + IdentifierHandler.quote(sysColumn.getColName()));
                projection.alias = outerIdColumn.selectColumnName;
                this.selectColumns.add(projection);
                this.selectColumnMap.put(projection.projectString, projection);
                this.sbCreateTableColumns.append(", ").append(IdentifierHandler.quote(outerIdColumn.selectColumnName)).append(" ").append(expressionType.getTypeString());
            }
        }
    }

    public String addOid(QueryPlan queryPlan) {
        this.usesOid = true;
        int n = queryPlan.getCurrentOuterCounter();
        String string = "XOID" + n;
        Projection projection = null;
        projection = this.joinTableName == null ? new Projection(IdentifierHandler.quote(this.extendedTableList.get(0)) + ".OID") : new Projection(IdentifierHandler.quote(this.joinTableName) + ".OID");
        projection.alias = string;
        this.selectColumns.add(projection);
        this.selectColumnMap.put(projection.projectString, projection);
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(-5, 0, 0, 0);
        OuterIdColumn outerIdColumn = new OuterIdColumn(projection.projectString, string, expressionType, false);
        this.outerIdColumnList.add(outerIdColumn);
        this.sbCreateTableColumns.append(", ").append(string).append(" BIGINT");
        return string;
    }

    public void addOuterIdToColumnList(String string) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(-5, 0, 0, 0);
        OuterIdColumn outerIdColumn = new OuterIdColumn(string, string, expressionType, true);
        this.outerIdColumnList.add(outerIdColumn);
    }

    public String addOuterIdSerial(QueryPlan queryPlan) {
        int n = queryPlan.getCurrentOuterCounter();
        String string = "XSERIALID" + n;
        this.sbCreateTableColumns.append(", ").append(IdentifierHandler.quote(string)).append(" BIGINT");
        Projection projection = new Projection("0");
        projection.alias = string;
        this.selectColumns.add(projection);
        this.selectColumnMap.put(projection.projectString, projection);
        this.addOuterIdToColumnList(string);
        return string;
    }

    public String addXnodeid(QueryPlan queryPlan) {
        int n = queryPlan.getCurrentOuterCounter();
        String string = "XONODEID" + n;
        Projection projection = new Projection(string);
        projection.alias = "";
        this.selectColumns.add(projection);
        this.selectColumnMap.put(projection.projectString, projection);
        this.sbCreateTableColumns.append(", ").append(IdentifierHandler.quote(string)).append(" INT");
        return string;
    }

    public String getColumnListString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        for (Projection projection : this.selectColumns) {
            String string = projection.getCreateColumnName();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (string != null && string.length() > 0) {
                stringBuilder.append(string);
                continue;
            }
            if (projection.alias != null && projection.alias.length() > 0) {
                stringBuilder.append(projection.alias);
                continue;
            }
            stringBuilder.append(projection.projectString);
        }
        return stringBuilder.toString();
    }

    public void updateSelectForOuter(QueryPlan queryPlan, boolean bl) {
        if (bl) {
            this.addOuterIdColumns(queryPlan);
        }
        this.outerNodeIdColumn = this.addXnodeid(queryPlan);
        queryPlan.incrementOuterCounter();
        if (this.getSelectStatement() != null) {
            String string = this.getOuterColumnSourceString();
            if (string.length() > 0) {
                string = string + ", ";
            }
            this.setSelectStatement(this.getSelectStatement().replaceAll("FROM " + IdentifierHandler.quote(this.joinTableName), ", " + string + this.outerNodeIdColumn + " FROM " + IdentifierHandler.quote(this.joinTableName)));
        }
    }

    protected String getOuterColumnSelectString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        for (OuterIdColumn outerIdColumn : this.outerIdColumnList) {
            if (outerIdColumn.selectColumnName == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(IdentifierHandler.quote(outerIdColumn.getSelectColumnName()));
        }
        return stringBuilder.toString();
    }

    protected String getOuterColumnSourceString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        for (OuterIdColumn outerIdColumn : this.outerIdColumnList) {
            if (outerIdColumn.sourceColumnName == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (outerIdColumn.isPseudoSerial) {
                stringBuilder.append("0 AS ");
            }
            stringBuilder.append(outerIdColumn.sourceColumnName);
        }
        return stringBuilder.toString();
    }

    protected String getOuterNodeIdColumn() {
        return this.outerNodeIdColumn;
    }

    protected String getWhereClause() {
        return this.whereClause;
    }

    protected void resetProjections() {
        this.selectColumns = new ArrayList();
        this.selectColumnMap = new LinkedHashMap();
        this.sbCreateTableColumns = new StringBuilder(128);
    }

    private String generateColumnName() {
        return "EXPRESSION_" + this.leafStepNo + "_" + ++unnamedColCount;
    }

    protected void addJoin(QueryCondition queryCondition, String string) {
        Join join = new Join(queryCondition, string);
        this.joinConditions.add(join);
    }

    protected List<SqlExpression> createSqlExprFromOuterIdColumns(String string) {
        ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
        for (OuterIdColumn outerIdColumn : this.outerIdColumnList) {
            AttributeColumn attributeColumn = new AttributeColumn();
            attributeColumn.setColumnName(outerIdColumn.getSelectColumnName());
            attributeColumn.setTableName(string);
            attributeColumn.setTableAlias(string);
            attributeColumn.columnType = outerIdColumn.columnExprType;
            SqlExpression sqlExpression = new SqlExpression();
            sqlExpression.setExprType(4);
            sqlExpression.setColumn(attributeColumn);
            sqlExpression.setExprDataType(attributeColumn.columnType);
            arrayList.add(sqlExpression);
        }
        return arrayList;
    }

    protected Leaf createDerivedOuterLeaf() {
        Leaf leaf = new Leaf();
        leaf.queryNodeList = this.queryNodeList;
        leaf.distinct = this.distinct;
        leaf.joinTableName = this.joinTableName;
        leaf.targetTableName = this.targetTableName + "_o";
        leaf.tableName = this.tableName;
        leaf.extendedTableList.addAll(this.extendedTableList);
        leaf.extendedAliasList.addAll(this.extendedAliasList);
        leaf.extendedOuter.addAll(this.extendedOuter);
        leaf.extendedOuterLevel.addAll(this.extendedOuterLevel);
        leaf.joinConditions.addAll(this.joinConditions);
        String string = "";
        Iterator<SqlExpression> iterator = this.outerExprList.iterator();
        Iterator<SqlExpression> iterator2 = this.innerExprList.iterator();
        while (iterator.hasNext()) {
            SqlExpression sqlExpression = iterator.next();
            SqlExpression sqlExpression2 = iterator2.next();
            leaf.appendProjectionFromExpr(sqlExpression, false);
            if (string.length() > 0) {
                string = string + " AND ";
            }
            string = string + sqlExpression2.getExprString() + " IS NULL";
        }
        leaf.setOuterTestString(string);
        return leaf;
    }

    public boolean hasProjections() {
        return this.selectColumns != null && this.selectColumns.size() > 0;
    }

    public void addUsedTable(String string) {
        this.tableList.add(string);
    }

    public void addCondition(String string) {
        this.conditions.add(string);
    }

    public void addHavingCondition(String string) {
        this.havingConditions.add(string);
    }

    public static String normalizeHashColumnName(String string) {
        String string2 = new String(string);
        while (string2.lastIndexOf(46) > 0 && string2.length() > 1) {
            string2 = string2.substring(string2.lastIndexOf(46) + 1);
        }
        if (string2.endsWith(")") && string2.length() > 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return IdentifierHandler.stripQuotes(string2);
    }

    public void setHashInfo(String string, String string2) {
        this.hashTableName = string;
        this.hashColumn = Leaf.normalizeHashColumnName(string2);
    }

    public void incrementAddedGroupCount() {
        ++this.addedGroupCount;
    }

    public String getOuterTestString() {
        return this.outerTestString;
    }

    public void setOuterTestString(String string) {
        this.outerTestString = string;
    }

    protected int getLeafStepNo() {
        return this.leafStepNo;
    }

    protected void setLeafStepNo(int n) {
        this.leafStepNo = n;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public void setTargetTableName(String string) {
        this.targetTableName = string;
    }

    public int getLeafType() {
        return this.leafType;
    }

    public void setLeafType(int n) {
        this.leafType = n;
    }

    public String getSelectStatement() {
        return this.selectStatement;
    }

    public void setSelectStatement(String string) {
        this.selectStatement = string;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    public String getCreateTableColumns() {
        return this.sbCreateTableColumns.toString();
    }

    public String getCreateCorrelatedTableString() {
        return this.createCorrelatedTableString;
    }

    public void setCreateCorrelatedTableString(String string) {
        this.createCorrelatedTableString = string;
    }

    public String getCorrelatedSelectString() {
        return this.correlatedSelectString;
    }

    public void setCorrelatedSelectString(String string) {
        this.correlatedSelectString = string;
    }

    public String getJoinTableName() {
        return this.joinTableName;
    }

    public void setJoinTableName(String string) {
        this.joinTableName = string;
    }

    public boolean isCombinerStep() {
        return this.combinerStep;
    }

    public void setCombinerStep(boolean bl) {
        this.combinerStep = bl;
    }

    public boolean isCombineOnMain() {
        return this.combineOnMain;
    }

    public void setCombineOnMain(boolean bl) {
        this.combineOnMain = bl;
    }

    public boolean isExtraStep() {
        return this.extraStep;
    }

    public void setExtraStep(boolean bl) {
        this.extraStep = bl;
    }

    public boolean isCorrelatedHashable() {
        return this.correlatedHashable;
    }

    public void setCorrelatedHashable(boolean bl) {
        this.correlatedHashable = bl;
    }

    public boolean isSuppressedGroupBy() {
        return this.suppressedGroupBy;
    }

    public void setSuppressedGroupBy(boolean bl) {
        this.suppressedGroupBy = bl;
    }

    public String getHashTableName() {
        return this.hashTableName;
    }

    public String getHashColumn() {
        return this.hashColumn;
    }

    public boolean isLookupStep() {
        return this.lookupStep;
    }

    public void setLookupStep(boolean bl) {
        this.lookupStep = bl;
    }

    public boolean isSingleStepCorrelated() {
        return this.singleStepCorrelated;
    }

    public void setSingleStepCorrelated(boolean bl) {
        this.singleStepCorrelated = bl;
    }

    public String getSingleCorrelatedHash() {
        return this.singleCorrelatedHash;
    }

    public void setSingleCorrelatedHash(String string) {
        this.singleCorrelatedHash = string;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long l) {
        this.limit = l;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public short getSerialColumnPosition() {
        return this.serialColumnPosition;
    }

    public void setSerialColumnPosition(short s) {
        this.serialColumnPosition = s;
    }

    public SqlExpression getPartitionParameterExpression() {
        return this.partitionParameterExpression;
    }

    public void setPartitionParameterExpression(SqlExpression sqlExpression) {
        this.partitionParameterExpression = sqlExpression;
    }

    public int getAddedGroupCount() {
        return this.addedGroupCount;
    }

    public class OuterIdColumn {
        private String sourceColumnName;
        private String selectColumnName;
        private ExpressionType columnExprType;
        private boolean isPseudoSerial;

        public OuterIdColumn(String string, String string2, ExpressionType expressionType, boolean bl) {
            this.sourceColumnName = string;
            this.selectColumnName = string2;
            this.columnExprType = expressionType;
            this.isPseudoSerial = bl;
        }

        public String getSelectColumnName() {
            return this.selectColumnName;
        }
    }

    public class Join {
        private String joinString = "";
        public QueryCondition aQueryCondition;

        public Join(QueryCondition queryCondition, String string) {
            this.aQueryCondition = queryCondition;
            this.joinString = string;
        }

        public String getJoinString() {
            return this.joinString;
        }

        public QueryCondition getQueryCondition() {
            return this.aQueryCondition;
        }
    }

    public class Projection {
        public String projectString;
        public String alias;
        public int groupByPosition = 0;
        private String createString;
        public boolean forceGroupQuote = false;

        public Projection(String string) {
            this.projectString = string;
        }

        public void setCreateColumnName(String string) {
            this.createString = string;
        }

        public String getCreateColumnName() {
            return this.createString;
        }
    }
}

