/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.optimizer;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ColumnNotFoundException;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.IRebuildString;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationNode
implements IRebuildString {
    private static AtomicInteger nextCount = new AtomicInteger(1);
    public static final int FAKE = 1;
    public static final int TABLE = 2;
    public static final int SUBQUERY_SCALAR = 3;
    public static final int SUBQUERY_RELATION = 4;
    public static final int SUBQUERY_NONCORRELATED = 5;
    public static final int SUBQUERY_CORRELATED = 6;
    public static final int SUBQUERY_CORRELATED_PH = 7;
    private int nodeId;
    private int nodeType = 2;
    private List<SqlExpression> projectionList;
    private List<QueryCondition> conditionList;
    private List<RelationNode> joinList;
    private List<AttributeColumn> condColumnList;
    private List<AttributeColumn> correlatedColumnList;
    private String tableName;
    private String alias;
    private boolean hasNotOwnAlias = false;
    private int rowsize;
    private long estCost;
    private long estRowsReturned;
    private String relationString = "";
    private boolean isTemporaryTable;
    private XDBSessionContext client;
    private SqlExpression parentNoncorExpr;
    private SqlExpression parentCorrelatedExpr;
    private short outerLevel = 0;
    private List<RelationNode> childrenNodes = new ArrayList<RelationNode>();
    private List<RelationNode> parentNodes = new ArrayList<RelationNode>();
    private QueryTree subqueryTree;
    private String currentTempTableName = "";

    public RelationNode() {
        this.projectionList = new ArrayList<SqlExpression>();
        this.conditionList = new ArrayList<QueryCondition>();
        this.joinList = new ArrayList<RelationNode>();
        this.condColumnList = new ArrayList<AttributeColumn>();
        this.correlatedColumnList = new ArrayList<AttributeColumn>();
    }

    public boolean isSubquery() {
        return this.nodeType == 3 || this.nodeType == 4 || this.nodeType == 5 || this.nodeType == 6;
    }

    public void toString(String string) {
    }

    public SqlExpression getMatchingSqlExpression(AttributeColumn attributeColumn) throws ColumnNotFoundException {
        if (this.nodeType == 4 && this.subqueryTree != null) {
            for (SqlExpression sqlExpression : this.subqueryTree.getProjectionList()) {
                if (!sqlExpression.getOuterAlias().equalsIgnoreCase(attributeColumn.columnName)) {
                    if (sqlExpression.getAlias().equals("") && sqlExpression.getProjectionLabel().equalsIgnoreCase(attributeColumn.columnName)) {
                        return sqlExpression;
                    }
                    if (!sqlExpression.getAlias().equalsIgnoreCase(attributeColumn.columnName) || !sqlExpression.getColumn().getTableName().equalsIgnoreCase(attributeColumn.getTableName())) continue;
                    if (sqlExpression.getOuterAlias().equals("")) {
                        sqlExpression.setOuterAlias(sqlExpression.getAlias());
                    }
                    return sqlExpression;
                }
                return sqlExpression;
            }
        }
        throw new ColumnNotFoundException("columns " + attributeColumn.columnName, this.alias + "Table " + this.tableName);
    }

    public void handleAliasForSingleTableSubQueryNode() {
        if (this.nodeType == 4 && this.subqueryTree != null && (this.tableName.equals("") || this.tableName.equalsIgnoreCase(this.alias)) && this.subqueryTree.getRelationNodeList().size() == 1) {
            RelationNode relationNode = this.subqueryTree.getRelationNodeList().get(0);
            if (relationNode.nodeType == 4 && this.subqueryTree != null) {
                relationNode.handleAliasForSingleTableSubQueryNode();
            }
            if (relationNode.tableName == null && relationNode.alias == null) {
                relationNode.tableName = this.alias;
                relationNode.alias = this.alias;
            }
            if (relationNode.tableName.equalsIgnoreCase(relationNode.alias)) {
                relationNode.alias = this.alias;
                for (SqlExpression sqlExpression : relationNode.projectionList) {
                    sqlExpression.getColumn().setTableAlias(relationNode.alias);
                    sqlExpression.rebuildExpression();
                }
                for (SqlExpression sqlExpression : this.subqueryTree.getGroupByList()) {
                    sqlExpression.rebuildExpression();
                }
                for (SqlExpression sqlExpression : this.subqueryTree.getOrderByOrphans()) {
                    sqlExpression.rebuildExpression();
                }
                for (SqlExpression sqlExpression : this.subqueryTree.getScalarSubqueryList()) {
                    sqlExpression.rebuildExpression();
                }
                for (SqlExpression sqlExpression : this.subqueryTree.getSelectOrphans()) {
                    sqlExpression.rebuildExpression();
                }
                if (this.subqueryTree.getWhereRootCondition() != null) {
                    this.subqueryTree.getWhereRootCondition().rebuildCondString();
                }
            }
        }
    }

    public static int getNextCount() {
        return nextCount.incrementAndGet();
    }

    @Override
    public String rebuildString() {
        switch (this.nodeType) {
            case 2: {
                if (this.currentTempTableName.equals("")) {
                    this.relationString = IdentifierHandler.quote(this.tableName);
                    if (this.tableName.equals(this.alias)) break;
                    this.relationString = this.relationString + " as " + IdentifierHandler.quote(this.alias);
                    break;
                }
                this.relationString = IdentifierHandler.quote(this.currentTempTableName);
                break;
            }
            case 4: {
                this.relationString = "(" + IdentifierHandler.quote(this.subqueryTree.rebuildString()) + ") as " + IdentifierHandler.quote(this.alias);
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new XDBServerException(ErrorMessageRepository.ILLEGAL_RELATIONNODE_TYPE, 0, ErrorMessageRepository.ILLEGAL_RELATIONNODE_TYPE_CODE);
            }
        }
        return this.relationString;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableAlis() {
        return this.alias;
    }

    public boolean isTemporaryTable() {
        return this.isTemporaryTable;
    }

    public void setTemporaryTable(boolean bl) {
        this.isTemporaryTable = bl;
    }

    public XDBSessionContext getClient() {
        return this.client;
    }

    public void setClient(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    public void addParentNodes(Collection<RelationNode> collection, boolean bl, short s) {
        this.parentNodes.addAll(collection);
        for (RelationNode relationNode : collection) {
            relationNode.childrenNodes.add(this);
            if (relationNode.outerLevel > this.outerLevel) {
                this.outerLevel = relationNode.outerLevel;
            }
            if (!bl) continue;
            this.outerLevel = s;
        }
    }

    public void addSiblingJoin(RelationNode relationNode) {
        if (relationNode.outerLevel > this.outerLevel) {
            this.outerLevel = relationNode.outerLevel;
        }
        for (RelationNode relationNode2 : relationNode.getParentNodes()) {
            this.parentNodes.add(relationNode2);
            relationNode2.childrenNodes.add(this);
        }
    }

    public boolean isCorrelatedSubquery() {
        return this.nodeType == 6;
    }

    public boolean isCorrelatedPlaceholder() {
        return this.nodeType == 7;
    }

    public boolean isUncorrelatedSubquery() {
        return this.nodeType == 5;
    }

    public boolean isScalarSubquery() {
        return this.nodeType == 3;
    }

    public boolean isRelationSubquery() {
        return this.nodeType == 4;
    }

    public boolean isTable() {
        return this.nodeType == 2;
    }

    public List<RelationNode> getParentNodes() {
        return this.parentNodes;
    }

    public void notifyOuterLevelInserted(RelationNode relationNode, short s) {
        if (relationNode != this && this.outerLevel >= s) {
            this.outerLevel = (short)(this.outerLevel + 1);
        }
    }

    public SysTable getSysTable(SysDatabase sysDatabase) throws IllegalArgumentException, XDBServerException {
        if (sysDatabase == null) {
            throw new IllegalArgumentException("Database is NULL");
        }
        if (this.tableName == null) {
            throw new XDBServerException(ErrorMessageRepository.TABLE_NOT_FOUND, 0, ErrorMessageRepository.TABLE_NOT_FOUND_CODE);
        }
        return sysDatabase.getSysTable(this.tableName);
    }

    public short getOuterLevel() {
        return this.outerLevel;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public String getAlias() {
        return this.alias;
    }

    public List<AttributeColumn> getCondColumnList() {
        return this.condColumnList;
    }

    public List<QueryCondition> getConditionList() {
        return this.conditionList;
    }

    public List<AttributeColumn> getCorrelatedColumnList() {
        return this.correlatedColumnList;
    }

    public void setCurrentTempTableName(String string) {
        this.currentTempTableName = string;
    }

    public String getCurrentTempTableName() {
        return this.currentTempTableName;
    }

    public void setEstCost(long l) {
        this.estCost = l;
    }

    public long getEstCost() {
        return this.estCost;
    }

    public void setEstRowsReturned(long l) {
        this.estRowsReturned = l;
    }

    public long getEstRowsReturned() {
        return this.estRowsReturned;
    }

    public boolean hasNotOwnAlias() {
        return this.hasNotOwnAlias;
    }

    public void setJoinList(List<RelationNode> list) {
        this.joinList = list;
    }

    public List<RelationNode> getJoinList() {
        return this.joinList;
    }

    public void setNodeId(int n) {
        this.nodeId = n;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeType(int n) {
        this.nodeType = n;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setParentCorrelatedExpr(SqlExpression sqlExpression) {
        this.parentCorrelatedExpr = sqlExpression;
    }

    public SqlExpression getParentCorrelatedExpr() {
        return this.parentCorrelatedExpr;
    }

    public void setParentNoncorExpr(SqlExpression sqlExpression) {
        this.parentNoncorExpr = sqlExpression;
    }

    public SqlExpression getParentNoncorExpr() {
        return this.parentNoncorExpr;
    }

    public List<SqlExpression> getProjectionList() {
        return this.projectionList;
    }

    public String getRelationString() {
        return this.relationString;
    }

    public void setRowsize(int n) {
        this.rowsize = n;
    }

    public int getRowsize() {
        return this.rowsize;
    }

    public void setSubqueryTree(QueryTree queryTree) {
        this.subqueryTree = queryTree;
    }

    public QueryTree getSubqueryTree() {
        return this.subqueryTree;
    }
}

