/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata.partitions;

import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobinPartitionMap
implements PartitionMap {
    private static final long serialVersionUID = -269652343536584158L;
    private Integer[] partitions;
    private transient int currentIdx = -1;

    @Override
    public Collection<Integer> findPartitions(String string) {
        return this.allPartitions();
    }

    @Override
    public void generateDistribution(Collection<Integer> collection) {
        this.partitions = collection.toArray(new Integer[collection.size()]);
        Arrays.sort((Object[])this.partitions);
    }

    @Override
    public Collection<Integer> getPartitions(String string) {
        if (this.currentIdx < 0) {
            Random random = new Random(System.currentTimeMillis());
            this.currentIdx = random.nextInt(this.partitions.length);
        }
        if (++this.currentIdx == this.partitions.length) {
            this.currentIdx = 0;
        }
        return Collections.singleton(this.partitions[this.currentIdx]);
    }

    @Override
    public Collection<Integer> joinPartitions() {
        return this.allPartitions();
    }

    @Override
    public Collection<Integer> allPartitions() {
        return Arrays.asList(this.partitions);
    }

    @Override
    public int getRedundancyLevel() {
        return 1;
    }

    @Override
    public PartitionMap clone() {
        try {
            return (PartitionMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readMapFromMetadataDB(MetaData metaData, SysTable sysTable) throws SQLException {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        String string = "SELECT nodeid from xsystabparts WHERE tableid = " + sysTable.getTableId() + " ORDER BY nodeid";
        ResultSet resultSet = metaData.executeQuery(string);
        try {
            while (resultSet.next()) {
                treeSet.add(resultSet.getInt(1));
            }
        }
        finally {
            resultSet.close();
        }
        this.partitions = treeSet.toArray(new Integer[treeSet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMapToMetadataDB(MetaData metaData, SysDatabase sysDatabase, int n) throws SQLException {
        int n2 = 0;
        String string = "SELECT max(partid) FROM xsystabparts";
        ResultSet resultSet = metaData.executeQuery(string);
        try {
            resultSet.next();
            n2 = resultSet.getInt(1) + 1;
        }
        finally {
            resultSet.close();
        }
        for (Integer n3 : this.partitions) {
            String string2 = "INSERT INTO xsystabparts (partid, tableid, dbid, nodeid) VALUES (" + n2++ + ", " + n + ", " + sysDatabase.getDbid() + ", " + n3 + ")";
            metaData.executeUpdate(string2);
        }
    }

    @Override
    public void removeMapFromMetadataDB(MetaData metaData, SysTable sysTable) throws SQLException {
        String string = "DELETE FROM xsystabparts WHERE tableid = " + sysTable.getTableId();
        metaData.executeUpdate(string);
    }
}

