/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysTablespace;
import com.edb.gridsql.parser.SqlCreateTableSpace;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class SyncCreateTablespace
implements IMetaDataUpdate {
    private static final XLogger logger = XLogger.getLogger(SyncCreateTablespace.class);
    private XDBSessionContext client;
    private SqlCreateTableSpace parent;
    private int tablespaceID;

    public SyncCreateTablespace(SqlCreateTableSpace sqlCreateTableSpace) {
        this.parent = sqlCreateTableSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(XDBSessionContext xDBSessionContext) throws Exception {
        int n;
        this.client = xDBSessionContext;
        MetaData metaData = MetaData.getMetaData();
        ResultSet resultSet = metaData.executeQuery("SELECT max(tablespaceid) FROM xsystablespaces");
        try {
            resultSet.next();
            this.tablespaceID = resultSet.getInt(1) + 1;
        }
        finally {
            resultSet.close();
        }
        String string = "INSERT INTO xsystablespaces (tablespaceid, tablespacename, ownerid) VALUES (" + this.tablespaceID + ", " + "'" + this.parent.getName() + "', " + xDBSessionContext.getCurrentUser().getUserID() + ")";
        metaData.executeUpdate(string);
        resultSet = metaData.executeQuery("SELECT max(tablespacelocid) FROM xsystablespacelocs");
        try {
            resultSet.next();
            n = resultSet.getInt(1) + 1;
        }
        finally {
            resultSet.close();
        }
        string = "INSERT INTO xsystablespacelocs (tablespacelocid, tablespaceid, filepath, nodeid) VALUES (?, ?, ?, ?)";
        PreparedStatement preparedStatement = metaData.prepareStatement(string);
        preparedStatement.setInt(2, this.tablespaceID);
        for (Map.Entry<DBNode, String> entry : this.parent.getLocations().entrySet()) {
            preparedStatement.setInt(1, n++);
            preparedStatement.setString(3, entry.getValue());
            preparedStatement.setInt(4, entry.getKey().getNodeId());
            if (preparedStatement.executeUpdate() == 1) continue;
            XDBServerException xDBServerException = new XDBServerException("Failed to insert row into \"xsystablespacelocs\"");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    public void refresh() throws Exception {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (Map.Entry<DBNode, String> entry : this.parent.getLocations().entrySet()) {
            hashMap.put(new Integer(entry.getKey().getNodeId()), entry.getValue());
        }
        SysTablespace sysTablespace = new SysTablespace(this.tablespaceID, this.parent.getName(), this.client.getCurrentUser().getUserID(), hashMap);
        MetaData.getMetaData().addTablespace(sysTablespace);
    }
}

