/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.SendMessageHelper;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.communication.message.SendRowsMessage;
import com.edb.gridsql.engine.AckTracker;
import com.edb.gridsql.engine.NodeProducerThread;
import com.edb.gridsql.engine.loader.Loader;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBGeneratorException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.SysSerialGenerator;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.metadata.partitions.ReplicatedPartitionMap;
import com.edb.gridsql.misc.RSHelper;
import com.edb.gridsql.planner.StepDetail;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerSender {
    private static final XLogger logger = XLogger.getLogger(ProducerSender.class);
    private static final int MAX_UNACKED_MESSAGES = 10;
    private static final Integer COORDINATOR_NODE = new Integer(Props.XDB_COORDINATOR_NODE);
    private long dataSeqNo;
    private AckTracker anAckTracker = null;
    private LinkedBlockingQueue<NodeMessage> producerQueue;
    private SendMessageHelper sendHelper;
    private int maxUnackedCount = 0;
    private boolean abortFlag = false;
    private HashMap<Integer, NodeMessage> nodeMsgTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProducerSender(SendMessageHelper sendMessageHelper, LinkedBlockingQueue<NodeMessage> linkedBlockingQueue) {
        this.sendHelper = sendMessageHelper;
        this.producerQueue = linkedBlockingQueue;
        this.dataSeqNo = 0L;
        this.nodeMsgTable = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInserts(StepDetail stepDetail) {
        ArrayList<Integer> arrayList = stepDetail.consumerNodeList;
        if (!Props.XDB_USE_LOAD_FOR_STEP) {
            this.dataSeqNo = 0L;
            this.anAckTracker = new AckTracker();
            this.anAckTracker.init(new HashMap(), arrayList);
            this.maxUnackedCount = arrayList == null || arrayList.size() == 0 ? 10 : arrayList.size() + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void sendToNodes(ResultSet resultSet, StepDetail stepDetail, Object object, int n, int n2) throws SQLException, XDBServerException {
        Object exception;
        boolean bl;
        Object object2;
        IntermediateSerialGeneratorClient intermediateSerialGeneratorClient;
        block60: {
            void var10_17;
            PartitionMap bl2;
            Serializable serializable;
            intermediateSerialGeneratorClient = null;
            if (stepDetail.getSerialColumnPosition() > 0) {
                intermediateSerialGeneratorClient = new IntermediateSerialGeneratorClient();
            }
            if (!Props.XDB_USE_LOAD_FOR_STEP) break block60;
            Loader loader = new Loader(resultSet, stepDetail.getInsertColumnString());
            Collection<Integer> collection = stepDetail.consumerNodeList;
            if (Props.XDB_ENABLE_ACTIVITY_LOG) {
                Object sendRowsMessage;
                if (stepDetail.getDestType() == 2 || stepDetail.getDestType() == 6) {
                    sendRowsMessage = (SendRowsMessage)NodeMessage.getNodeMessage(46);
                    ((NodeMessage)sendRowsMessage).setRequestId(n2);
                    ((SendRowsMessage)sendRowsMessage).setDestNodeForRows(1);
                    this.sendHelper.sendMessage(new Integer(0), (NodeMessage)sendRowsMessage);
                } else {
                    sendRowsMessage = stepDetail.consumerNodeList.iterator();
                    while (sendRowsMessage.hasNext()) {
                        Integer serializable22;
                        Integer n3 = serializable22 = (Integer)sendRowsMessage.next();
                        serializable = (SendRowsMessage)NodeMessage.getNodeMessage(46);
                        serializable.setRequestId(n2);
                        serializable.setDestNodeForRows(n3);
                        this.sendHelper.sendMessage(new Integer(0), (NodeMessage)serializable);
                    }
                }
            }
            if (stepDetail.getDestType() == 5 || stepDetail.getDestType() == 2 || stepDetail.getDestType() == 6 || stepDetail.combineOnCoordFirst) {
                if (collection == null) {
                    collection = Collections.singleton(COORDINATOR_NODE);
                } else if (!collection.contains(COORDINATOR_NODE)) {
                    collection = new HashSet<Integer>(collection);
                    collection.add(COORDINATOR_NODE);
                }
            }
            NodeProducerThread.CATEGORY_NODEQUERYTIME.debug("Sending results to Nodes:" + collection);
            int n4 = -1;
            if (stepDetail.getDestType() == 4) {
                n4 = stepDetail.getHashColumnPosition() > 0 ? stepDetail.getHashColumnPosition() - 1 : resultSet.findColumn(stepDetail.getHashColumn()) - 1;
            }
            if ((bl2 = stepDetail.getPartitionMap()) == null) {
                ReplicatedPartitionMap replicatedPartitionMap = new ReplicatedPartitionMap();
                replicatedPartitionMap.generateDistribution(collection);
            }
            loader.setTargetTableInfoExt(stepDetail.targetTable, n4, (PartitionMap)var10_17, stepDetail.getHashDataType(), stepDetail.getSerialColumnPosition(), intermediateSerialGeneratorClient, stepDetail.getDestType() == 7, stepDetail.suppressSendingNodeId, stepDetail.nodeInfos);
            try {
                HashMap<Integer, Long> exception2;
                loader.prepareLoad(null);
                boolean bl3 = false;
                try {
                    NodeProducerThread.CATEGORY_NODEQUERYTIME.debug("Run Writers");
                    loader.runWriters();
                    bl3 = true;
                    Object var14_26 = null;
                    NodeProducerThread.CATEGORY_NODEQUERYTIME.debug("Finish load");
                }
                catch (Throwable throwable) {
                    HashMap<Integer, Long> exception3;
                    Object var14_27 = null;
                    NodeProducerThread.CATEGORY_NODEQUERYTIME.debug("Finish load");
                    loader.finishLoad(bl3);
                    if (Props.XDB_ENABLE_ACTIVITY_LOG && (exception3 = loader.getRowCountMap()) != null) {
                        Iterator<Integer> iterator = exception3.keySet().iterator();
                        while (iterator.hasNext()) {
                            Integer n5;
                            Integer n6 = n5 = iterator.next();
                            SendRowsMessage sendRowsMessage = (SendRowsMessage)NodeMessage.getNodeMessage(47);
                            sendRowsMessage.setRequestId(n2);
                            sendRowsMessage.setDestNodeForRows(n6);
                            sendRowsMessage.setNumRowsSent(exception3.get(n6));
                            this.sendHelper.sendMessage(new Integer(0), sendRowsMessage);
                        }
                    }
                    throw throwable;
                }
                loader.finishLoad(bl3);
                if (Props.XDB_ENABLE_ACTIVITY_LOG && (exception2 = loader.getRowCountMap()) != null) {
                    Iterator<Integer> exception4 = exception2.keySet().iterator();
                    while (exception4.hasNext()) {
                        Integer n7;
                        Integer n8 = n7 = exception4.next();
                        SendRowsMessage sendRowsMessage = (SendRowsMessage)NodeMessage.getNodeMessage(47);
                        sendRowsMessage.setRequestId(n2);
                        sendRowsMessage.setDestNodeForRows(n8);
                        sendRowsMessage.setNumRowsSent(exception2.get(n8));
                        this.sendHelper.sendMessage(new Integer(0), sendRowsMessage);
                    }
                }
                return;
            }
            catch (Exception exception5) {
                logger.catching(exception5);
                serializable = new XDBServerException("Can not send data to Nodes", exception5);
                logger.throwing((Throwable)serializable);
                throw serializable;
            }
        }
        int n9 = 0;
        boolean[] blArray = null;
        if (object == null) {
            object = resultSet.getStatement().getConnection();
        }
        int n10 = 0;
        Object object3 = object;
        synchronized (object3) {
            object2 = resultSet.getMetaData();
            n9 = object2.getColumnCount();
            if (stepDetail.suppressSendingNodeId) {
                --n9;
            }
            blArray = RSHelper.getQuoteInfo(resultSet);
            boolean bl4 = resultSet.next();
            object.notify();
        }
        this.initInserts(stepDetail);
        object3 = new StringBuffer();
        object2 = stepDetail.targetSchema.indexOf("XSERIALID") > 0 ? "INSERT INTO " + stepDetail.targetTable + "(" + stepDetail.getInsertColumnString() + ") VALUES " : "INSERT INTO " + stepDetail.targetTable + " VALUES ";
        while (bl) {
            Object object4;
            int exception6;
            ++n10;
            ((StringBuffer)object3).setLength(0);
            String string = null;
            if (!Props.XDB_JUST_DATA_VALUES) {
                ((StringBuffer)object3).append((String)object2);
            }
            ((StringBuffer)object3).append("(");
            for (exception6 = 1; exception6 <= n9; ++exception6) {
                if (exception6 > 1) {
                    ((StringBuffer)object3).append(',');
                }
                if (stepDetail.getSerialColumnPosition() == exception6) {
                    try {
                        ((StringBuffer)object3).append("" + intermediateSerialGeneratorClient.allocateValue());
                        continue;
                    }
                    catch (XDBGeneratorException xDBGeneratorException) {
                        throw new XDBServerException("Can not generate serial value: " + xDBGeneratorException.getMessage());
                    }
                }
                if (resultSet.getString(exception6) == null) {
                    ((StringBuffer)object3).append("NULL");
                    continue;
                }
                if (blArray[exception6 - 1]) {
                    ((StringBuffer)object3).append("'");
                    object4 = resultSet.getString(exception6);
                    if (((String)object4).indexOf("'") >= 0) {
                        object4 = ((String)object4).replaceAll("'", "''");
                    }
                    ((StringBuffer)object3).append((String)object4);
                    ((StringBuffer)object3).append("'");
                    continue;
                }
                object4 = resultSet.getString(exception6);
                ((StringBuffer)object3).append((String)object4);
            }
            ((StringBuffer)object3).append(")");
            string = ((StringBuffer)object3).toString();
            if (stepDetail.getDestType() == 1 || stepDetail.getDestType() == 5) {
                try {
                    this.insertOnNodeList(string, stepDetail);
                }
                catch (Exception exception7) {
                    logger.catching(exception7);
                    object4 = new XDBServerException(ErrorMessageRepository.INSERT_FAILED_ON_NODE + "( " + 0 + "," + string + " ) " + exception7.getMessage(), exception7, ErrorMessageRepository.INSERT_FAILED_ON_NODE_CODE);
                    logger.throwing((Throwable)object4);
                    throw object4;
                }
            }
            if (stepDetail.combineOnCoordFirst) {
                try {
                    this.insertOnNode(0, string);
                }
                catch (Exception exception8) {
                    logger.catching(exception8);
                    object4 = new XDBServerException(ErrorMessageRepository.INSERT_FAILED_ON_NODE + "( " + 0 + "," + "[ " + string + " ]" + " )", exception8, ErrorMessageRepository.INSERT_FAILED_ON_NODE_CODE);
                    logger.throwing((Throwable)object4);
                    throw object4;
                }
            }
            if (stepDetail.getDestType() == 3) {
                try {
                    this.insertOnNode(stepDetail.getDestNode(), string);
                }
                catch (Exception exception9) {
                    logger.catching(exception9);
                    object4 = new XDBServerException(ErrorMessageRepository.INSERT_FAILED_ON_NODE + "( " + 0 + "," + string + " )", exception9, ErrorMessageRepository.INSERT_FAILED_ON_NODE_CODE);
                    logger.throwing((Throwable)object4);
                    throw object4;
                }
            }
            if (stepDetail.getDestType() == 4) {
                int n12 = stepDetail.getHashColumnPosition() == 0 ? stepDetail.getNodeId(resultSet.getString(stepDetail.getHashColumn())) : stepDetail.getNodeId(resultSet.getString(stepDetail.getHashColumnPosition()));
                try {
                    this.insertOnNode(n12, string);
                }
                catch (Exception exception10) {
                    logger.catching(exception10);
                    object4 = new XDBServerException(ErrorMessageRepository.INSERT_FAILED_ON_NODE + "( " + 0 + "," + string + " )", exception10, ErrorMessageRepository.INSERT_FAILED_ON_NODE_CODE);
                    logger.throwing((Throwable)object4);
                    throw object4;
                }
            }
            if (stepDetail.getDestType() == 7) {
                exception6 = resultSet.getInt(resultSet.getMetaData().getColumnCount());
                try {
                    this.insertOnNode(exception6, string);
                }
                catch (Exception exception11) {
                    logger.catching(exception11);
                    XDBServerException xDBServerException = new XDBServerException(ErrorMessageRepository.INSERT_FAILED_ON_NODE + "( " + 0 + "," + string + " )", exception11, ErrorMessageRepository.INSERT_FAILED_ON_NODE_CODE);
                    logger.throwing(xDBServerException);
                    throw xDBServerException;
                }
            }
            if (stepDetail.getDestType() == 2) {
                try {
                    this.insertOnNode(0, string);
                }
                catch (Exception exception12) {
                    logger.catching(exception12);
                    object4 = new XDBServerException(ErrorMessageRepository.INSERT_FAILED_ON_NODE + "( " + 0 + "," + string + " )", exception12, ErrorMessageRepository.INSERT_FAILED_ON_NODE_CODE);
                    logger.throwing((Throwable)object4);
                    throw object4;
                }
            }
            exception = object;
            synchronized (exception) {
                bl = resultSet.next();
                object.notify();
            }
        }
        try {
            this.finishInserts(stepDetail.getDestType());
        }
        catch (Exception exception13) {
            logger.catching(exception13);
            exception = new XDBServerException(ErrorMessageRepository.INSERT_FAILED, exception13, ErrorMessageRepository.INSERT_FAILED_CODE);
            logger.throwing((Throwable)exception);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOnNodeList(String string, StepDetail stepDetail) throws XDBServerException {
        if (!Props.XDB_USE_LOAD_FOR_STEP) {
            NodeMessage nodeMessage = this.nodeMsgTable.get(null);
            if (nodeMessage == null) {
                Integer[] integerArray;
                boolean bl;
                ++this.dataSeqNo;
                nodeMessage = NodeMessage.getNodeMessage(16);
                nodeMessage.setDataSeqNo(this.dataSeqNo);
                boolean bl2 = bl = stepDetail.getDestType() == 5 || stepDetail.combineOnCoordFirst;
                if (stepDetail.consumerNodeList == null) {
                    Integer[] integerArray2;
                    if (bl) {
                        Integer[] integerArray3 = new Integer[1];
                        integerArray2 = integerArray3;
                        integerArray3[0] = new Integer(0);
                    } else {
                        integerArray2 = null;
                    }
                    integerArray = integerArray2;
                } else {
                    integerArray = new Integer[stepDetail.consumerNodeList.size() + (bl ? 1 : 0)];
                    stepDetail.consumerNodeList.toArray(integerArray);
                    if (bl) {
                        integerArray[integerArray.length - 1] = new Integer(0);
                    }
                }
                nodeMessage.setTargetNodeIDs(integerArray);
                this.nodeMsgTable.put(null, nodeMessage);
            }
            nodeMessage.addRowData(string);
            if (!nodeMessage.canAddRows()) {
                this.sendHelper.sendMessageByDestInMessage(nodeMessage);
                this.nodeMsgTable.remove(null);
                this.anAckTracker.addPacket(new Long(nodeMessage.getDataSeqNo()), nodeMessage);
                this.checkAcks(this.maxUnackedCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAcks(int n) throws XDBServerException {
        try {
            while (this.anAckTracker != null && this.anAckTracker.getUnackedKeyCount() > n || !this.producerQueue.isEmpty()) {
                NodeMessage nodeMessage = null;
                if (this.abortFlag) {
                    return;
                }
                nodeMessage = this.producerQueue.poll(5L, TimeUnit.SECONDS);
                if (nodeMessage == null) continue;
                if (nodeMessage.getMessageType() == 17) {
                    this.anAckTracker.register(new Long(nodeMessage.getDataSeqNo()), nodeMessage.getSourceNodeID());
                    continue;
                }
                XDBServerException xDBServerException = new XDBServerException(ErrorMessageRepository.UNEXPECTED_MESSAGE_RECIEVED + "(" + NodeMessage.getMessageTypeString(nodeMessage.getMessageType()) + " , " + NodeMessage.getMessageTypeString(17) + ") ", nodeMessage.getCause(), ErrorMessageRepository.UNEXPECTED_MESSAGE_RECIEVED_CODE);
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertOnNode(int n, String string) throws XDBServerException {
        if (!Props.XDB_USE_LOAD_FOR_STEP) {
            NodeMessage nodeMessage = this.nodeMsgTable.get(n);
            if (nodeMessage == null) {
                nodeMessage = NodeMessage.getNodeMessage(16);
                nodeMessage.setDataSeqNo(++this.dataSeqNo);
                this.nodeMsgTable.put(n, nodeMessage);
            }
            nodeMessage.addRowData(string);
            if (!nodeMessage.canAddRows()) {
                this.sendHelper.sendMessage(new Integer(n), nodeMessage);
                this.nodeMsgTable.remove(n);
                this.anAckTracker.addPacket(new Long(nodeMessage.getDataSeqNo()), nodeMessage, Collections.singleton(n));
                this.checkAcks(this.maxUnackedCount);
                nodeMessage = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishInserts(int n) throws XDBServerException {
        if (!Props.XDB_USE_LOAD_FOR_STEP && !this.abortFlag) {
            for (Map.Entry<Integer, NodeMessage> entry : this.nodeMsgTable.entrySet()) {
                NodeMessage nodeMessage = entry.getValue();
                if (entry.getKey() == null) {
                    this.sendHelper.sendMessageByDestInMessage(nodeMessage);
                    this.anAckTracker.addPacket(nodeMessage.getDataSeqNo(), nodeMessage);
                    continue;
                }
                this.sendHelper.sendMessage(entry.getKey(), nodeMessage);
                this.anAckTracker.addPacket(nodeMessage.getDataSeqNo(), nodeMessage, Collections.singleton(entry.getKey()));
            }
            this.checkAcks(0);
        }
    }

    public void setAbort(boolean bl) {
        this.abortFlag = bl;
    }

    private class IntermediateSerialGeneratorClient
    extends SysSerialGenerator {
        private IntermediateSerialGeneratorClient() {
        }

        protected void update() throws XDBGeneratorException {
            this.update(1L);
        }
    }
}

