/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import java.sql.ResultSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionResult {
    public static final int COMMAND_UNKNOWN = -1;
    public static final int COMMAND_SELECT = 0;
    public static final int COMMAND_ADD_NODES = 1;
    public static final int COMMAND_ALTER_TABLE = 2;
    public static final int COMMAND_ALTER_TABLESPACE = 3;
    public static final int COMMAND_ALTER_USER = 4;
    public static final int COMMAND_VACUUM_ANALYZE = 5;
    public static final int COMMAND_BEGIN_TRAN = 6;
    public static final int COMMAND_CLUSTER = 7;
    public static final int COMMAND_COMMIT_TRAN = 8;
    public static final int COMMAND_ROLLBACK_TRAN = 9;
    public static final int COMMAND_CREATE_INDEX = 10;
    public static final int COMMAND_CREATE_TABLE = 11;
    public static final int COMMAND_CREATE_TABLESPACE = 12;
    public static final int COMMAND_CREATE_USER = 13;
    public static final int COMMAND_CREATE_VIEW = 14;
    public static final int COMMAND_DELETE_TABLE = 15;
    public static final int COMMAND_INSERT_TABLE = 16;
    public static final int COMMAND_UPDATE_TABLE = 17;
    public static final int COMMAND_DROP_INDEX = 18;
    public static final int COMMAND_DROP_TABLE = 19;
    public static final int COMMAND_DROP_TABLESPACE = 20;
    public static final int COMMAND_DROP_NODES = 21;
    public static final int COMMAND_DROP_USER = 22;
    public static final int COMMAND_DROP_VIEW = 23;
    public static final int COMMAND_GRANT = 24;
    public static final int COMMAND_REVOKE = 25;
    public static final int COMMAND_BULK_INSERT = 26;
    public static final int COMMAND_SHOW = 27;
    public static final int COMMAND_MOVE_ROWS = 28;
    public static final int COMMAND_RENAME_TABLE = 29;
    public static final int COMMAND_TRUNCATE = 30;
    public static final int COMMAND_ISOLATION = 31;
    public static final int COMMAND_CREATE_DATABASE = 32;
    public static final int COMMAND_PERSIST_DATABASE = 33;
    public static final int COMMAND_DROP_DATABASE = 34;
    public static final int COMMAND_START_DATABASE = 35;
    public static final int COMMAND_STOP_DATABASE = 36;
    public static final int COMMAND_LOGIN = 37;
    public static final int COMMAND_LOGOUT = 38;
    public static final int COMMAND_KILL = 39;
    public static final int COMMAND_SERVER_PROPS = 40;
    public static final int COMMAND_ERROR = 41;
    public static final int COMMAND_BATCH_EXEC = 42;
    public static final int COMMAND_DIRECT_EXEC = 43;
    public static final int COMMAND_NODE_INFO = 44;
    public static final int COMMAND_COPY_IN = 45;
    public static final int COMMAND_COPY_OUT = 46;
    public static final int COMMAND_DEALLOCATE = 47;
    public static final int CONTENT_TYPE_EMPTY = 0;
    public static final int CONTENT_TYPE_ROWCOUNT = 1;
    public static final int CONTENT_TYPE_RESULTSET = 2;
    public static final int CONTENT_TYPE_EXCEPTION = 3;
    public static final int CONTENT_TYPE_SUBRESULTS = 4;
    public static final int CONTENT_TYPE_GENERATOR_VALUE = 5;
    public static final int CONTENT_TYPE_SERIALIZED_OBJECT = 6;
    public static final int CONTENT_TYPE_NODE_INFO = 7;
    private int kind;
    private int contentType;
    private int rowsAffected;
    private ResultSet rs = null;
    private Exception ex = null;
    private long rangeStart = 0L;
    private byte[] serializedObject = null;
    private NodeDBConnectionInfo[] connectionInfos = null;
    private Map<Integer, ExecutionResult> subResults;

    public static ExecutionResult createSuccessResult(int n) {
        return new ExecutionResult(n);
    }

    public static ExecutionResult createRowCountResult(int n, int n2) {
        return new ExecutionResult(n, n2);
    }

    public static ExecutionResult createResultSetResult(int n, ResultSet resultSet) {
        return new ExecutionResult(n, resultSet);
    }

    public static ExecutionResult createErrorResult(Exception exception) {
        return new ExecutionResult(exception);
    }

    public static ExecutionResult createGeneratorRangeResult(int n, long l) {
        return new ExecutionResult(n, l);
    }

    public static ExecutionResult createSerializedObjectResult(int n, byte[] byArray) {
        return new ExecutionResult(n, byArray);
    }

    public static ExecutionResult createNodeConnectionInfoResult(NodeDBConnectionInfo[] nodeDBConnectionInfoArray) {
        return new ExecutionResult(nodeDBConnectionInfoArray);
    }

    public static ExecutionResult createMultipleResult(int n, Map<Integer, ExecutionResult> map) {
        return new ExecutionResult(n, map);
    }

    private ExecutionResult(int n) {
        this.contentType = 0;
        this.kind = n;
        this.rowsAffected = -2;
    }

    private ExecutionResult(int n, int n2) {
        this.contentType = 1;
        this.kind = n;
        this.rowsAffected = n2;
    }

    private ExecutionResult(int n, ResultSet resultSet) {
        this.contentType = 2;
        this.kind = n;
        this.rs = resultSet;
    }

    private ExecutionResult(Exception exception) {
        this.contentType = 3;
        this.kind = 41;
        this.ex = exception;
    }

    private ExecutionResult(int n, long l) {
        this.contentType = 5;
        this.kind = n;
        this.rangeStart = l;
    }

    private ExecutionResult(int n, byte[] byArray) {
        this.contentType = 6;
        this.kind = n;
        this.serializedObject = byArray;
    }

    private ExecutionResult(NodeDBConnectionInfo[] nodeDBConnectionInfoArray) {
        this.contentType = 7;
        this.kind = 44;
        this.connectionInfos = nodeDBConnectionInfoArray;
    }

    private ExecutionResult(int n, Map<Integer, ExecutionResult> map) {
        this.contentType = 4;
        this.kind = n;
        this.subResults = map;
    }

    public int getKind() {
        return this.kind;
    }

    public int getContentType() {
        return this.contentType;
    }

    public boolean isError() {
        return this.kind == 41;
    }

    public int getRowCount() {
        return this.rowsAffected;
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public Exception getException() {
        return this.ex;
    }

    public long getRangeStart() {
        return this.rangeStart;
    }

    public byte[] getSerializedObject() {
        return this.serializedObject;
    }

    public NodeDBConnectionInfo[] getNodeConnectionInfo() {
        return this.connectionInfos;
    }

    public Map<Integer, ExecutionResult> getSubResults() {
        return this.subResults;
    }

    public boolean hasResultSet() {
        if (this.rs != null) {
            return true;
        }
        if (this.subResults != null) {
            for (ExecutionResult executionResult : this.subResults.values()) {
                if (executionResult.rs == null) continue;
                return true;
            }
        }
        return false;
    }
}

