<HTML>
<HEAD>	
	<TITLE>
	FusionCharts - Database + JavaScript Example
	</TITLE>
	
<!---
'We've included ../Includes/FusionCharts.cfm, which contains functions
'to help us easily embed the charts.
--->
<cfinclude template="../Includes/FusionCharts.cfm">
	
	<!---
	In this example, we show a combination of database + JavaScript rendering using FusionCharts.
	
	The entire app (page) can be summarized as under. This app shows the break-down
	of factory wise output generated. In a pie chart, we first show the sum of quantity
	generated by each factory. These pie slices, when clicked would show detailed date-wise
	output of that factory.
	
	The XML data for the pie chart is fully created in CFM at run-time. CFM interacts
	with the database and creates the XML for this.
	Now, for the column chart (date-wise output report), we do not submit request to the server.
	Instead we store the data for the factories in JavaScript arrays. These JavaScript
	arrays are rendered by our CFM Code (at run-time). We also have a few defined JavaScript
	functions which react to the click event of pie slice.

	
	Before the page is rendered, we need to connect to the database and get the
	data, as we'll need to convert this data into JavaScript variables.
	
	The following string will contain the JS Data and variables.
	This string will be built in CFM and rendered at run-time as JavaScript.
	--->

	<cfquery name="qry" datasource="dev">
		select * from Factory_Master
	</cfquery>
	
	<cfset jsVarString = "">

	<cfset indexCount = 0>
	<cfloop query="qry">
		<cfset indexCount = indexCount + 1>
		<cfset factoryID = qry.FactoryId>
		<cfset factoryName = qry.FactoryName>
		
		<!--- 		
		Create JavaScript code to add sub-array to data array
		data is an array defined in JavaScript (see below)
		We've added tabs and new lines to data so that if you View Source of the
		output HTML, it will appear properly. It helps during debugging
		--->
		<cfset jsVarString = jsVarString  & "data[" & indexCount & "] = new Array();" & Chr(13) & Chr(10)>
		
		<cfquery name="qryDetails" datasource="dev">
			select * from Factory_Output where FactoryId=#factoryID# order by DatePro Asc
		</cfquery>

		<cfloop query="qryDetails">
			<!---
			Put this data into JavaScript as another nested array.
			Finally the array would look like data[factoryIndex][i][dataLabel,dataValue]
			--->
			<cfset jsVarString = jsVarString &  "data[" & indexCount & "].push(new Array('" & datePart("d",qryDetails.DatePro) & "/" & datePart("m",qryDetails.DatePro) & "'," & qryDetails.Quantity & "));" & Chr(13) & Chr(10)>
		</cfloop>
	</cfloop>
	
	<SCRIPT LANGUAGE="Javascript" SRC="../../FusionCharts/FusionCharts.js">
		//You need to include the above JS file, if you intend to embed the chart using JavaScript.
		//Embedding using JavaScripts avoids the "Click to Activate..." issue in Internet Explorer
		//When you make your own charts, make sure that the path to this JS file is correct. Else, you would get JavaScript errors.
	</SCRIPT>
	
	<SCRIPT LANGUAGE="JavaScript">
		//Here, we use a mix of server side script (CFM) and JavaScript to
		//render our data for factory chart in JavaScript variables. We'll later
		//utilize this data to dynamically plot charts.
		
		//All our data is stored in the data array. From CFM, we iterate through
		//each recordset of data and then store it as nested arrays in this data array.
		var data = new Array();
		
		<!--- Write the data as JavaScript variables here --->
		<cfoutput>#jsVarString#</cfoutput>
		<!---
		The data is now present as arrays in JavaScript. Local JavaScript functions
		can access it and make use of it. We'll see how to make use of it.
		--->
		
		/** 
		 * updateChart method is invoked when the user clicks on a pie slice.
		 * In this method, we get the index of the factory, build the XML data
		 * for that that factory, using data stored in data array, and finally
		 * update the Column Chart.
		 *	@param	factoryIndex	Sequential Index of the factory.
		*/		
		function updateChart(factoryIndex){
			//Storage for XML data document
			var strXML = "<chart palette='2' caption='Factory " + factoryIndex  + " Output ' subcaption='(In Units)' xAxisName='Date' showValues='1' labelStep='2' >";
			
			//Add <set> elements
			var i=0;
			for (i=0; i<data[factoryIndex].length; i++){
				strXML = strXML + "<set label='" + data[factoryIndex][i][0] + "' value='" + data[factoryIndex][i][1] + "' />";
			}
			
			//Closing Chart Element
			strXML = strXML + "</chart>";
						
			//Get reference to chart object using Dom ID "FactoryDetailed"
			var chartObj = getChartFromId("FactoryDetailed");
			//Update it's XML
			chartObj.setDataXML(strXML);
		}
	</SCRIPT>
	<style type="text/css">
	<!--
	body {
		font-family: Arial, Helvetica, sans-serif;
		font-size: 12px;
	}
	.text{
		font-family: Arial, Helvetica, sans-serif;
		font-size: 12px;
	}
	-->
	</style>
</HEAD>
	
<BODY>

<CENTER>
<h2>FusionCharts Database + JavaScript Example</h2>
<h4>Inter-connected charts - Click on any pie slice to see detailed chart below.</h4>
<p>The charts in this page have been dynamically generated using data contained in a database. We've NOT hard-coded the data in JavaScript.</p>
<!---
	Initialize the Pie chart with sum of production for each of the factories
	strXML will be used to store the entire XML document generated
--->
	<cfset indexCount=0>
	
	<!--- Generate the chart element --->
	<cfset strXML = "<chart caption='Factory Output report' subCaption='By Quantity' pieSliceDepth='30' showBorder='1' formatNumberScale='0' numberSuffix=' Units' >">
	
	<!--- Iterate through each factory --->
	<cfquery name="qry" datasource="dev">
		select * from Factory_Master
	</cfquery>
	
	<cfloop query="qry">
		<cfset indexCount = indexCount + 1>
		<cfset factoryID = qry.FactoryId>
		<cfset factoryName = qry.FactoryName>
		<!--- Now get details for this factory --->
		<cfquery name="qryDetails" datasource="dev">
			select sum(Quantity) as TotOutput from Factory_Output where FactoryId=#factoryID#
		</cfquery>
		<!--- Generate <set label='..' value='..'/>	--->
		<cfset strXML = strXML & "<set label='#factoryName#' value='#qryDetails.totOutput#' link='javaScript:updateChart(" & indexCount & ")'/>">
	</cfloop>

	<!--- Finally, close <chart> element --->
	<cfset strXML = strXML & "</chart>">
	
	<!--- Create the chart - Pie 3D Chart with data from strXML --->
	<cfoutput>#renderChart("../../FusionCharts/Pie3D.swf", "", strXML, "FactorySum", 500, 250, false, false)#</cfoutput>
	<BR>
<!---
	Column 2D Chart with changed "No data to display" message
	We initialize the chart with <chart></chart>
--->
	<cfoutput>#renderChart("../../FusionCharts/Column2D.swf?ChartNoDataText=Please select a factory from pie chart above to view detailed data.", "", "<chart></chart>", "FactoryDetailed", 600, 250, false, false)#</cfoutput>
<BR><BR>
<a href='../NoChart.html' target="_blank">Unable to see the charts above?</a>
</CENTER>
</BODY>
</HTML>