CREATE TABLE `platform_users` (
  `ID` int DEFAULT NULL,
  `username` varchar(60) character set utf8 NOT NULL,
  CONSTRAINT `PriKey_platform_users` PRIMARY KEY (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `platform_users` (`username`) VALUES ('Admin');

CREATE TABLE `platform_groups` (
  `ID` int DEFAULT NULL,
  `groupname` varchar(60) character set utf8 NOT NULL,
  CONSTRAINT `PriKey_platform_groups` PRIMARY KEY (`groupname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_folders` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `parent` int DEFAULT NULL,
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_col_files_folders` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_files_folders_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_files_folders_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_files_folders_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_types` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_col_files_types` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_files_types_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `folder` int NOT NULL,
  `type` int DEFAULT NULL,
  `deleted` tinyint DEFAULT '0',
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `filenum` varchar(255) character set utf8 DEFAULT NULL,
  `status` tinyint DEFAULT '0',
  `keywords` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  `versioncount` int DEFAULT '0',
  CONSTRAINT `PriKey_col_files_files` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_files_files_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_files_files_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_files_files_folder` FOREIGN KEY (`folder`) REFERENCES `col_files_folders` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_files_files_type` FOREIGN KEY (`type`) REFERENCES `col_files_types` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_items` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `file` int NOT NULL,
  `filename` varchar(255) character set utf8 DEFAULT NULL,
  `version` varchar(255) character set utf8 DEFAULT NULL,
  `mimetype` varchar(255) character set utf8 DEFAULT NULL,
  `size` int DEFAULT '0',
  `comment` text character set utf8 DEFAULT NULL,
  `binfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_col_files_items` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_files_items_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_files_items_file` FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_journal` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `file` int NOT NULL,
  `date` int DEFAULT '0',
  `subject` varchar(255) character set utf8 DEFAULT NULL,
  `text` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_col_files_journal` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_files_journal_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_files_journal_file` FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_shortcuts` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int DEFAULT '0',
  `file` int NOT NULL,
  CONSTRAINT `PriKey_col_files_shortcuts` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_files_shortcuts_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_files_shortcuts_file` FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_columns` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_col_forums_columns` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_forums_columns_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_forums` (
  `ID` int NOT NULL auto_increment,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `column` int DEFAULT NULL,
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  `lastentry` int DEFAULT '0',
  CONSTRAINT `PriKey_col_forums_forums` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_forums_forums_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_forums_forums_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_forums_forums_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_forums_forums_column` FOREIGN KEY (`column`) REFERENCES `col_forums_columns` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_topics` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `forum` int NOT NULL,
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `lastentry` int DEFAULT '0',
  CONSTRAINT `PriKey_col_forums_topics` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_forums_topics_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_forums_topics_forum` FOREIGN KEY (`forum`) REFERENCES `col_forums_forums` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_entries` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `topic` int NOT NULL,
  `flag` tinyint DEFAULT '0',
  `text` text character set utf8 DEFAULT NULL,
  `attachname` varchar(255) character set utf8 DEFAULT NULL,
  `attachbinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_col_forums_entries` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_forums_entries_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_forums_entries_topic` FOREIGN KEY (`topic`) REFERENCES `col_forums_topics` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_notify` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `forum` int NOT NULL,
  CONSTRAINT `PriKey_col_forums_notify` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_forums_notify_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_forums_notify_forum` FOREIGN KEY (`forum`) REFERENCES `col_forums_forums` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_view` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `forum` int NOT NULL,
  CONSTRAINT `PriKey_col_forums_view` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_forums_view_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_forums_view_forum` FOREIGN KEY (`forum`) REFERENCES `col_forums_forums` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_messages_folders` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `parent` int DEFAULT NULL,
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_col_messages_folders` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_messages_folders_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_messages_folders_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_messages_folders_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_messages_accounts` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `activity` tinyint DEFAULT '0',
  `default` tinyint DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `email` varchar(255) character set utf8 DEFAULT NULL,
  `server` varchar(255) character set utf8 DEFAULT NULL,
  `port` smallint DEFAULT '0',
  `protocol` varchar(255) character set utf8 DEFAULT NULL,
  `username` varchar(255) character set utf8 DEFAULT NULL,
  `password` varchar(255) character set utf8 DEFAULT NULL,
  `movetoprimary` tinyint DEFAULT '0',
  `moveto` int DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  `leavemsg` tinyint DEFAULT '0',
  CONSTRAINT `PriKey_col_messages_accounts` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_messages_accounts_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_messages_accounts_moveto` FOREIGN KEY (`moveto`) REFERENCES `col_messages_folders` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_messages_messages` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `account` int DEFAULT NULL,
  `primaryfolder` tinyint DEFAULT '0',
  `folder` int DEFAULT NULL,
  `flag` tinyint DEFAULT '0',
  `date` int DEFAULT '0',
  `subject` varchar(255) character set utf8 DEFAULT NULL,
  `sender` varchar(255) character set utf8 DEFAULT NULL,
  `sender_name` varchar(255) character set utf8 DEFAULT NULL,
  `to` varchar(255) character set utf8 DEFAULT NULL,
  `to_name` varchar(255) character set utf8 DEFAULT NULL,
  `cc` varchar(255) character set utf8 DEFAULT NULL,
  `bcc` varchar(255) character set utf8 DEFAULT NULL,
  `reply_to` varchar(255) character set utf8 DEFAULT NULL,
  `count_to` int DEFAULT '0',
  `contenttype` varchar(255) character set utf8 DEFAULT NULL,
  `binfile` varchar(32) character set utf8 DEFAULT NULL,
  `keywords` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_col_messages_messages` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_messages_messages_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_messages_messages_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_messages_messages_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_messages_messages_account` FOREIGN KEY (`account`) REFERENCES `col_messages_accounts` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_messages_messages_folder` FOREIGN KEY (`folder`) REFERENCES `col_messages_folders` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_messages_msglog` (
  `ID` int NOT NULL auto_increment,
  `account` int NOT NULL,
  `uid` int DEFAULT '0',
  CONSTRAINT `PriKey_col_messages_msglog` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_messages_msglog_account` FOREIGN KEY (`account`) REFERENCES `col_messages_accounts` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_messages_templates` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `default` tinyint DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `text` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_col_messages_templates` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_messages_templates_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_messages_templates_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_messages_templates_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_news_channels` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `type` tinyint DEFAULT '0',
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `newsfeed` varchar(255) character set utf8 DEFAULT NULL,
  `link` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_col_news_channels` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_news_channels_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_news_channels_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_news_channels_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_news_newsitems` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `channel` int DEFAULT NULL,
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `pubdate` int DEFAULT '0',
  `link` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_col_news_newsitems` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_news_newsitems_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_news_newsitems_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_news_newsitems_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_news_newsitems_channel` FOREIGN KEY (`channel`) REFERENCES `col_news_channels` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_news_view` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `channel` int NOT NULL,
  CONSTRAINT `PriKey_col_news_view` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_col_news_view_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_col_news_view_channel` FOREIGN KEY (`channel`) REFERENCES `col_news_channels` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_contacts_companies` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8  DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `director` varchar(255) character set utf8 DEFAULT NULL,
  `traderegister` varchar(255) character set utf8 DEFAULT NULL,
  `taxcode` varchar(255) character set utf8 DEFAULT NULL,
  `address` varchar(255) character set utf8 DEFAULT NULL,
  `postalcode` varchar(255) character set utf8 DEFAULT NULL,
  `city` varchar(255) character set utf8 DEFAULT NULL,
  `region` varchar(255) character set utf8 DEFAULT NULL,
  `country` varchar(255) character set utf8 DEFAULT NULL,
  `phone` varchar(255) character set utf8 DEFAULT NULL,
  `phone2` varchar(255) character set utf8 DEFAULT NULL,
  `fax` varchar(255) character set utf8 DEFAULT NULL,
  `fax2` varchar(255) character set utf8 DEFAULT NULL,
  `email` varchar(255) character set utf8 DEFAULT NULL,
  `website` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_org_contacts_companies` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_contacts_companies_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_contacts_companies_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_contacts_companies_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_contacts_people` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `lastname` varchar(255) character set utf8 DEFAULT NULL,
  `firstname` varchar(255) character set utf8 DEFAULT NULL,
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `company` varchar(255) character set utf8 DEFAULT NULL,
  `position` varchar(255) character set utf8 DEFAULT NULL,
  `workgroup` varchar(255) character set utf8 DEFAULT NULL,
  `address` varchar(255) character set utf8 DEFAULT NULL,
  `postalcode` varchar(255) character set utf8 DEFAULT NULL,
  `city` varchar(255) character set utf8 DEFAULT NULL,
  `region` varchar(255) character set utf8 DEFAULT NULL,
  `country` varchar(255) character set utf8 DEFAULT NULL,
  `phone` varchar(255) character set utf8 DEFAULT NULL,
  `phone2` varchar(255) character set utf8 DEFAULT NULL,
  `cell` varchar(255) character set utf8 DEFAULT NULL,
  `fax` varchar(255) character set utf8 DEFAULT NULL,
  `fax2` varchar(255) character set utf8 DEFAULT NULL,
  `pager` varchar(255) character set utf8 DEFAULT NULL,
  `iptel` varchar(255) character set utf8 DEFAULT NULL,
  `email` varchar(255) character set utf8 DEFAULT NULL,
  `usebirthdate` tinyint DEFAULT '0',
  `birthdate` int DEFAULT '0',
  `description` text character set utf8 DEFAULT NULL,
  `picbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_org_contacts_people` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_contacts_people_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_contacts_people_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_contacts_people_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_customers_customers` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `customernum` varchar(255) character set utf8 DEFAULT NULL,
  `status` tinyint DEFAULT '0',
  `risk` tinyint DEFAULT '0',
  `dispatch` tinyint DEFAULT '0',
  `payment` tinyint DEFAULT '0',
  `prefcontact` tinyint DEFAULT '0',
  `person` int DEFAULT NULL,
  `company` int DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  `usebilling` tinyint DEFAULT '0',
  `billingaddr` varchar(255) character set utf8 DEFAULT NULL,
  `billingpc` varchar(255) character set utf8 DEFAULT NULL,
  `billingcity` varchar(255) character set utf8 DEFAULT NULL,
  `billingcountry` varchar(255) character set utf8 DEFAULT NULL,
  `useshipping` tinyint DEFAULT '0',
  `shippingaddr` varchar(255) character set utf8 DEFAULT NULL,
  `shippingpc` varchar(255) character set utf8 DEFAULT NULL,
  `shippingcity` varchar(255) character set utf8 DEFAULT NULL,
  `shippingcountry` varchar(255) character set utf8 DEFAULT NULL,
  `bank` varchar(255) character set utf8 DEFAULT NULL,
  `bankid` varchar(255) character set utf8 DEFAULT NULL,
  `account` varchar(255) character set utf8 DEFAULT NULL,
  `cctype` tinyint DEFAULT '0',
  `ccnum` varchar(255) character set utf8 DEFAULT NULL,
  `ccvalid` varchar(5) character set utf8 DEFAULT NULL,
  `ccauth` varchar(3) character set utf8 DEFAULT NULL,
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_customers_customers` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_customers_customers_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_customers_customers_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_customers_customers_person` FOREIGN KEY (`person`) REFERENCES `org_contacts_people` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_customers_customers_company` FOREIGN KEY (`company`) REFERENCES `org_contacts_companies` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_deliveries` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `deliverynum` varchar(255) character set utf8 DEFAULT NULL,
  `customer` int DEFAULT NULL,
  `date` int DEFAULT '0',
  `status` tinyint DEFAULT '0',
  `discount` double DEFAULT '0',
  `netamount` double DEFAULT '0',
  `tax` double DEFAULT '0',
  `itemsbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_billing_deliveries` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_billing_deliveries_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_billing_deliveries_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_invoices` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `invoicenum` varchar(255) character set utf8 DEFAULT NULL,
  `customer` int DEFAULT NULL,
  `date` int DEFAULT '0',
  `duedate` int DEFAULT '0',
  `status` tinyint DEFAULT '0',
  `amountpayable` double DEFAULT '0',
  `payment` double DEFAULT '0',
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_billing_invoices` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_billing_invoices_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_billing_invoices_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_invoices_deliveries` (
  `ID` int NOT NULL auto_increment,
  `invoice` int NOT NULL,
  `delivery` int NOT NULL,
  CONSTRAINT `PriKey_crm_billing_invoices_deliveries` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_billing_invoices_deliveries_invoice` FOREIGN KEY (`invoice`) REFERENCES `crm_billing_invoices` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_billing_invoices_deliveries_delivery` FOREIGN KEY (`delivery`) REFERENCES `crm_billing_deliveries` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_offers` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `quotationnum` varchar(255) character set utf8 DEFAULT NULL,
  `customer` int DEFAULT NULL,
  `date` int DEFAULT '0',
  `duedate` int DEFAULT '0',
  `status` tinyint DEFAULT '0',
  `discount` double DEFAULT '0',
  `netamount` double DEFAULT '0',
  `tax` double DEFAULT '0',
  `margin` double DEFAULT '0',
  `itemsbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_billing_offers` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_billing_offers_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_billing_offers_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_orders` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `ordernum` varchar(255) character set utf8 DEFAULT NULL,
  `customer` int DEFAULT NULL,
  `date` int DEFAULT '0',
  `duedate` int DEFAULT '0',
  `status` tinyint DEFAULT '0',
  `discount` double DEFAULT '0',
  `netamount` double DEFAULT '0',
  `tax` double DEFAULT '0',
  `margin` double DEFAULT '0',
  `itemsbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_billing_orders` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_billing_orders_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_billing_orders_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_payments` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `invoice` int NOT NULL,
  `date` int DEFAULT '0',
  `account` varchar(255) character set utf8 DEFAULT NULL,
  `reference` varchar(255) character set utf8 DEFAULT NULL,
  `amount` double DEFAULT '0',
  CONSTRAINT `PriKey_crm_billing_payments` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_billing_payments_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_billing_payments_invoice` FOREIGN KEY (`invoice`) REFERENCES `crm_billing_invoices` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_templates` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `type` tinyint DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `inputbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `outputbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `pdfbinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_billing_templates` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_billing_templates_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_printouts` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `type` tinyint DEFAULT '0',
  `transaction` int NOT NULL,
  `transactionnum` varchar(255) character set utf8 DEFAULT NULL,
  `template` int DEFAULT NULL,
  `maildate` int DEFAULT '0',
  `databinfile` varchar(32) character set utf8 DEFAULT NULL,
  `pdfbinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_billing_printouts` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_billing_printouts_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_billing_printouts_template` FOREIGN KEY (`template`) REFERENCES `crm_billing_templates` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_requests` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `requestnum` varchar(255) character set utf8 DEFAULT NULL,
  `customer` int DEFAULT NULL,
  `date` int DEFAULT '0',
  `status` tinyint DEFAULT '0',
  `itemsbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_billing_requests` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_billing_requests_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_billing_requests_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_campaigns_campaigns` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `datefrom` int DEFAULT '0',
  `dateto` int DEFAULT '0',
  `status` tinyint DEFAULT '0',
  `media` tinyint DEFAULT '0',
  `replyrate` tinyint DEFAULT '0',
  `projectedeffort` double DEFAULT '0',
  `budget` double DEFAULT '0',
  `description` text character set utf8 DEFAULT NULL,
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_campaigns_campaigns` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_campaigns_campaigns_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_campaigns_campaigns_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_campaigns_addressees` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `campaign` int NOT NULL,
  `customer` int NOT NULL,
  `flag` tinyint DEFAULT '0',
  CONSTRAINT `PriKey_crm_campaigns_addressees` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_campaigns_addressees_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_campaigns_addressees_campaign` FOREIGN KEY (`campaign`) REFERENCES `crm_campaigns_campaigns` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_campaigns_addressees_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_campaigns_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `campaign` int NOT NULL,
  `file` int NOT NULL,
  CONSTRAINT `PriKey_crm_campaigns_files` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_campaigns_files_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_campaigns_files_campaign` FOREIGN KEY (`campaign`) REFERENCES `crm_campaigns_campaigns` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_campaigns_files_file` FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_campaigns_records` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `campaign` int NOT NULL,
  `text` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_campaigns_records` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_campaigns_records_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_campaigns_records_campaign` FOREIGN KEY (`campaign`) REFERENCES `crm_campaigns_campaigns` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_tasks_tasks` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `parent` int DEFAULT NULL,
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `duedate` int DEFAULT '0',
  `status` tinyint DEFAULT '0',
  `progress` tinyint DEFAULT '0',
  `priority` tinyint DEFAULT '0',
  `projectedeffort` double DEFAULT '0',
  `actualeffort` double DEFAULT '0',
  `budget` double DEFAULT '0',
  `costs` double DEFAULT '0',
  `description` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_org_tasks_tasks` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_tasks_tasks_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_tasks_tasks_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_tasks_tasks_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_tasks_tasks_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_campaigns_tasks` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `campaign` int NOT NULL,
  `task` int NOT NULL,
  CONSTRAINT `PriKey_crm_campaigns_tasks` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_campaigns_tasks_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_campaigns_tasks_campaign` FOREIGN KEY (`campaign`) REFERENCES `crm_campaigns_campaigns` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_campaigns_tasks_task` FOREIGN KEY (`task`) REFERENCES `org_tasks_tasks` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_cases_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_cases_categories` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_cases_categories_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_cases_cases` (
  `ID` int NOT NULL auto_increment,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `casenum` varchar(255) character set utf8 DEFAULT NULL,
  `customer` int DEFAULT NULL,
  `status` tinyint DEFAULT '0',
  `priority` tinyint DEFAULT '0',
  `category` int DEFAULT NULL,
  `projectedeffort` double DEFAULT '0',
  `budget` double DEFAULT '0',
  `materialcosts` double DEFAULT '0',
  `message` int DEFAULT NULL,
  `databinfile` varchar(32) character set utf8 DEFAULT NULL,
  `itemsbinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_cases_cases` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_cases_cases_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_cases_cases_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_cases_cases_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_cases_cases_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_cases_cases_category` FOREIGN KEY (`category`) REFERENCES `crm_cases_categories` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_cases_cases_message` FOREIGN KEY (`message`) REFERENCES `col_messages_messages` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_cases_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `case` int NOT NULL,
  `file` int NOT NULL,
  CONSTRAINT `PriKey_crm_cases_files` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_cases_files_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_cases_files_case` FOREIGN KEY (`case`) REFERENCES `crm_cases_cases` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_cases_files_file` FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_cases_records` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `case` int NOT NULL,
  `text` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_cases_records` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_cases_records_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_cases_records_case` FOREIGN KEY (`case`) REFERENCES `crm_cases_cases` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_cases_tasks` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `case` int NOT NULL,
  `task` int NOT NULL,
  CONSTRAINT `PriKey_crm_cases_tasks` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_cases_tasks_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_cases_tasks_case` FOREIGN KEY (`case`) REFERENCES `crm_cases_cases` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_cases_tasks_task` FOREIGN KEY (`task`) REFERENCES `org_tasks_tasks` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_contracts_classes` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `default` tinyint DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  `inputbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `outputbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `pdfbinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_contracts_classes` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_contracts_classes_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_contracts_contracts` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `contractnum` varchar(255) character set utf8 DEFAULT NULL,
  `customer` int DEFAULT NULL,
  `class` int NOT NULL,
  `datefrom` int DEFAULT '0',
  `usedateto` tinyint DEFAULT '0',
  `dateto` int DEFAULT '0',
  `usedatecancel` tinyint DEFAULT '0',
  `datecancel` int DEFAULT '0',
  `status` tinyint DEFAULT '0',
  `databinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_contracts_contracts` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_contracts_contracts_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_contracts_contracts_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_contracts_contracts_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_contracts_contracts_class` FOREIGN KEY (`class`) REFERENCES `crm_contracts_classes` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_contracts_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `contract` int NOT NULL,
  `file` int NOT NULL,
  CONSTRAINT `PriKey_crm_contracts_files` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_contracts_files_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_contracts_files_contract` FOREIGN KEY (`contract`) REFERENCES `crm_contracts_contracts` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_contracts_files_file` FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_contracts_records` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `contract` int NOT NULL,
  `text` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_contracts_records` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_contracts_records_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_contracts_records_contract` FOREIGN KEY (`contract`) REFERENCES `crm_contracts_contracts` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_customers_groups` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_customers_groups` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_customers_groups_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_customers_customers_groups` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `customer` int NOT NULL,
  `group` int NOT NULL,
  CONSTRAINT `PriKey_crm_customers_customers_groups` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_customers_customers_groups_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_customers_customers_groups_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_customers_customers_groups_group` FOREIGN KEY (`group`) REFERENCES `crm_customers_groups` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_customers_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `customer` int NOT NULL,
  `file` int NOT NULL,
  CONSTRAINT `PriKey_crm_customers_files` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_customers_files_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_customers_files_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_customers_files_file` FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_customers_journal` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `customer` int NOT NULL,
  `date` int DEFAULT '0',
  `label` tinyint DEFAULT '0',
  `contact` int DEFAULT NULL,
  `subject` varchar(255) character set utf8 DEFAULT NULL,
  `text` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_customers_journal` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_customers_journal_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_customers_journal_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_customers_journal_contact` FOREIGN KEY (`contact`) REFERENCES `org_contacts_people` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_opportunities_opportunities` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `customer` int DEFAULT NULL,
  `status` tinyint DEFAULT '0',
  `probability` tinyint DEFAULT '0',
  `closedate` int DEFAULT '0',
  `priority` tinyint DEFAULT '0',
  `forecast` tinyint DEFAULT '0',
  `worstcase` double DEFAULT '0',
  `mostlikely` double DEFAULT '0',
  `upside` double DEFAULT '0',
  `description` text character set utf8 DEFAULT NULL,
  `message` int DEFAULT NULL,
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_opportunities_opportunities` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_opportunities_opportunities_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_opportunities_opportunities_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_opportunities_opportunities_customer` FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_opportunities_opportunities_message` FOREIGN KEY (`message`) REFERENCES `col_messages_messages` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_opportunities_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `opportunity` int NOT NULL,
  `file` int NOT NULL,
  CONSTRAINT `PriKey_crm_opportunities_files` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_opportunities_files_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_opportunities_files_opportunity` FOREIGN KEY (`opportunity`) REFERENCES `crm_opportunities_opportunities` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_opportunities_files_file` FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_opportunities_records` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `opportunity` int NOT NULL,
  `text` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_crm_opportunities_records` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_crm_opportunities_records_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_crm_opportunities_records_opportunity` FOREIGN KEY (`opportunity`) REFERENCES `crm_opportunities_opportunities` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_archive_locations` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_archive_locations` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_archive_locations_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_archive_rooms` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `location` int NOT NULL,
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `roomnum` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  `lastinsert` int DEFAULT '0',
  `mapbinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_archive_rooms_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_archive_rooms_location` FOREIGN KEY (`location`) REFERENCES `erp_archive_locations` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_archive_shelves` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `room` int NOT NULL,
  `name` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_archive_shelves` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_archive_shelves_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_archive_shelves_room` FOREIGN KEY (`room`) REFERENCES `erp_archive_rooms` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_archive_types` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_archive_types` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_archive_types_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_archive_elements` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `shelf` int NOT NULL,
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `elementid` varchar(255) character set utf8 DEFAULT NULL,
  `type` int DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_archive_elements` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_archive_elements_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_archive_elements_shelf` FOREIGN KEY (`shelf`) REFERENCES `erp_archive_shelves` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_archive_elements_type` FOREIGN KEY (`type`) REFERENCES `erp_archive_types` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `number` smallint DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_categories` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_categories_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_storages` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `default` tinyint DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_storages` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_storages_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_storages_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_items` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `storage` int NOT NULL,
  `useserials` tinyint DEFAULT '0',
  `evalmethod` tinyint DEFAULT '0',
  `periode` tinyint DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `manufacturer` varchar(255) character set utf8 DEFAULT NULL,
  `itemnum` varchar(255) character set utf8 DEFAULT NULL,
  `location` varchar(255) character set utf8 DEFAULT NULL,
  `quantity` tinyint DEFAULT '0',
  `barcode` varchar(255) character set utf8 DEFAULT NULL,
  `price` double DEFAULT '0',
  `taxrate` tinyint DEFAULT '0',
  `minstock` int DEFAULT '0',
  `weight` double DEFAULT '0',
  `dimx` double DEFAULT '0',
  `dimy` double DEFAULT '0',
  `dimz` double DEFAULT '0',
  `description` text character set utf8 DEFAULT NULL,
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_items` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_items_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_items_storage` FOREIGN KEY (`storage`) REFERENCES `erp_stockcalc_storages` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_productions` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `item` int NOT NULL,
  `date` int DEFAULT '0',
  `productionid` varchar(255) character set utf8 DEFAULT NULL,
  `output` int DEFAULT '0',
  `target` int DEFAULT '0',
  `materialcosts` double DEFAULT '0',
  `manufactcosts` double DEFAULT '0',
  `itemsbinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_productions` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_productions_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_productions_item` FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_depletions` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `item` int NOT NULL,
  `date` int DEFAULT '0',
  `delivery` int DEFAULT NULL,
  `production` int DEFAULT NULL,
  `purpose` varchar(255) character set utf8 DEFAULT NULL,
  `amount` int DEFAULT '0',
  `price` double DEFAULT '0',
  CONSTRAINT `PriKey_erp_stockcalc_depletions` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_depletions_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_depletions_item` FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_depletions_delivery` FOREIGN KEY (`delivery`) REFERENCES `crm_billing_deliveries` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_depletions_production` FOREIGN KEY (`production`) REFERENCES `erp_stockcalc_productions` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_depletions_serials` (
  `ID` int NOT NULL auto_increment,
  `depletion` int NOT NULL,
  `serial` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_depletions_serials` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_depletions_serials_depletion` FOREIGN KEY (`depletion`) REFERENCES `erp_stockcalc_depletions` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_devices` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `item` int NOT NULL,
  `serial` varchar(255) character set utf8 DEFAULT NULL,
  `location` varchar(255) character set utf8 DEFAULT NULL,
  `reference` varchar(255) character set utf8 DEFAULT NULL,
  `comment` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_devices` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_devices_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_devices_item` FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `item` int NOT NULL,
  `file` int NOT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_files` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_files_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_files_item` FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_files_file` FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_items_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `item` int NOT NULL,
  `category` int NOT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_items_categories` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_items_categories_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_items_categories_item` FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_items_categories_category` FOREIGN KEY (`category`) REFERENCES `erp_stockcalc_categories` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_suppliers_suppliers` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `vendornum` varchar(255) character set utf8 DEFAULT NULL,
  `status` tinyint DEFAULT '0',
  `customernum` varchar(255) character set utf8 DEFAULT NULL,
  `dispatch` tinyint DEFAULT '0',
  `payment` tinyint DEFAULT '0',
  `prefcontact` tinyint DEFAULT '0',
  `bank` varchar(255) character set utf8 DEFAULT NULL,
  `bankid` varchar(255) character set utf8 DEFAULT NULL,
  `account` varchar(255) character set utf8 DEFAULT NULL,
  `person` int DEFAULT NULL,
  `company` int DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  `lastupload` int DEFAULT '0',
  `pricelistbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `extdatabinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_suppliers_suppliers` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_suppliers_suppliers_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_suppliers_suppliers_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_suppliers_suppliers_person` FOREIGN KEY (`person`) REFERENCES `org_contacts_people` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_suppliers_suppliers_company` FOREIGN KEY (`company`) REFERENCES `org_contacts_companies` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_orders` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `item` int NOT NULL,
  `flag` tinyint DEFAULT '0',
  `date` int DEFAULT '0',
  `orderid` varchar(255) character set utf8 DEFAULT NULL,
  `supplier` int DEFAULT NULL,
  `amount` int DEFAULT '0',
  `delivered` int DEFAULT '0',
  `price` double DEFAULT '0',
  `etd` int DEFAULT '0',
  `td` int DEFAULT '0',
  CONSTRAINT `PriKey_erp_stockcalc_orders` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_orders_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_orders_item` FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_orders_supplier` FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_incoming` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `item` int NOT NULL,
  `date` int DEFAULT '0',
  `order` int DEFAULT NULL,
  `production` int DEFAULT NULL,
  `amount` int DEFAULT '0',
  `price` double DEFAULT '0',
  `periode` tinyint DEFAULT '0',
  CONSTRAINT `PriKey_erp_stockcalc_incoming` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_incoming_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_incoming_item` FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_incoming_order` FOREIGN KEY (`order`) REFERENCES `erp_stockcalc_orders` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_incoming_production` FOREIGN KEY (`production`) REFERENCES `erp_stockcalc_productions` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_incoming_serials` (
  `ID` int NOT NULL auto_increment,
  `incoming` int NOT NULL,
  `serial` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_incoming_serials` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_incoming_serials_incoming` FOREIGN KEY (`incoming`) REFERENCES `erp_stockcalc_incoming` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_templates` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `inputbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `outputbinfile` varchar(32) character set utf8 DEFAULT NULL,
  `pdfbinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_templates` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_templates_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_printouts` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `orderid` varchar(255) character set utf8 DEFAULT NULL,
  `template` int DEFAULT NULL,
  `maildate` int DEFAULT '0',
  `databinfile` varchar(32) character set utf8 DEFAULT NULL,
  `pdfbinfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_printouts` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_printouts_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_printouts_template` FOREIGN KEY (`template`) REFERENCES `erp_stockcalc_templates` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_suppliers` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `item` int NOT NULL,
  `supplier` int NOT NULL,
  CONSTRAINT `PriKey_erp_stockcalc_suppliers` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_stockcalc_suppliers_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_suppliers_item` FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_stockcalc_suppliers_supplier` FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_suppliers_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `supplier` int NOT NULL,
  `category` int NOT NULL,
  CONSTRAINT `PriKey_erp_suppliers_categories` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_suppliers_categories_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_suppliers_categories_supplier` FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_suppliers_categories_category` FOREIGN KEY (`category`) REFERENCES `erp_stockcalc_categories` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_suppliers_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `supplier` int NOT NULL,
  `file` int NOT NULL,
  CONSTRAINT `PriKey_erp_suppliers_files` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_suppliers_files_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_suppliers_files_supplier` FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_suppliers_files_file` FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_suppliers_invoices` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `supplier` int NOT NULL,
  `flag` tinyint DEFAULT '0',
  `invoicenum` varchar(255) character set utf8 DEFAULT NULL,
  `billingdate` int DEFAULT '0',
  `duedate` int DEFAULT '0',
  `netamount` double DEFAULT '0',
  `totalamount` double DEFAULT '0',
  `payment` double DEFAULT '0',
  `comment` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_suppliers_invoices` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_suppliers_invoices_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_suppliers_invoices_supplier` FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_suppliers_journal` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `supplier` int NOT NULL,
  `date` int DEFAULT '0',
  `label` tinyint DEFAULT '0',
  `contact` int DEFAULT NULL,
  `subject` varchar(255) character set utf8 DEFAULT NULL,
  `text` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_erp_suppliers_journal` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_erp_suppliers_journal_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_suppliers_journal_supplier` FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_erp_suppliers_journal_contact` FOREIGN KEY (`contact`) REFERENCES `org_contacts_people` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_calendar_events` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `location` varchar(255) character set utf8 DEFAULT NULL,
  `datefrom` int DEFAULT '0',
  `dateto` int DEFAULT '0',
  `repeat` tinyint DEFAULT '0',
  `interval` int DEFAULT '0',
  `usedaterepeat` tinyint DEFAULT '0',
  `daterepeat` int DEFAULT '0',
  `label` tinyint DEFAULT '0',
  `display` tinyint DEFAULT '0',
  `description` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_org_calendar_events` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_calendar_events_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_calendar_events_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_calendar_events_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_calendar_invitations` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `event` int NOT NULL,
  `flag` tinyint DEFAULT '0',
  CONSTRAINT `PriKey_org_calendar_invitations` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_calendar_invitations_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_calendar_invitations_event` FOREIGN KEY (`event`) REFERENCES `org_calendar_events` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_contacts_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_org_contacts_categories` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_contacts_categories_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_contacts_companies_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `company` int NOT NULL,
  `category` int NOT NULL,
  CONSTRAINT `PriKey_org_contacts_companies_categories` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_contacts_companies_categories_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_contacts_companies_categories_company` FOREIGN KEY (`company`) REFERENCES `org_contacts_companies` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_contacts_companies_categories_category` FOREIGN KEY (`category`) REFERENCES `org_contacts_categories` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_contacts_people_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `person` int NOT NULL,
  `category` int NOT NULL,
  CONSTRAINT `PriKey_org_contacts_people_categories` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_contacts_people_categories_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_contacts_people_categories_person` FOREIGN KEY (`person`) REFERENCES `org_contacts_people` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_contacts_people_categories_category` FOREIGN KEY (`category`) REFERENCES `org_contacts_categories` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_contacts_people_companies` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `person` int NOT NULL,
  `company` int NOT NULL,
  CONSTRAINT `PriKey_org_contacts_people_companies` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_contacts_people_companies_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_contacts_people_companies_person` FOREIGN KEY (`person`) REFERENCES `org_contacts_people` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_contacts_people_companies_company` FOREIGN KEY (`company`) REFERENCES `org_contacts_companies` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_followup_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_org_followup_categories` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_followup_categories_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_followup_reminders` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `category` int DEFAULT NULL,
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `duedate` int DEFAULT '0',
  `status` tinyint DEFAULT '0',
  `priority` tinyint DEFAULT '0',
  `description` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_org_followup_reminders` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_followup_reminders_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_followup_reminders_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_followup_reminders_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_followup_reminders_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_followup_reminders_category` FOREIGN KEY (`category`) REFERENCES `org_followup_categories` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_followup_associates` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `reminder` int NOT NULL,
  `entity` varchar(60) character set utf8 DEFAULT NULL,
  `index` int DEFAULT '0',
  CONSTRAINT `PriKey_org_followup_associates` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_followup_associates_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_followup_associates_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_followup_associates_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_followup_associates_reminder` FOREIGN KEY (`reminder`) REFERENCES `org_followup_reminders` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_links_linklists` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_org_links_linklists` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_links_linklists_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_links_linklists_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_links_linklists_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_links_links` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `linklist` int NOT NULL,
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `url` varchar(255) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  `numviews` int DEFAULT '0',
  CONSTRAINT `PriKey_org_links_links` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_links_links_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_links_links_linklist` FOREIGN KEY (`linklist`) REFERENCES `org_links_linklists` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_links_view` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `linklist` int NOT NULL,
  CONSTRAINT `PriKey_org_links_view` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_links_view_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_links_view_linklist` FOREIGN KEY (`linklist`) REFERENCES `org_links_linklists` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_notes_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_org_notes_categories` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_notes_categories_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_notes_notes` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `assigneduser` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `category` int DEFAULT NULL,
  `title` varchar(255) character set utf8 DEFAULT NULL,
  `text` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_org_notes_notes` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_notes_notes_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_notes_notes_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_notes_notes_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_notes_notes_assigneduser` FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_notes_notes_category` FOREIGN KEY (`category`) REFERENCES `org_notes_categories` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_tasks_records` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `task` int NOT NULL,
  `text` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_org_tasks_records` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_org_tasks_records_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_org_tasks_records_task` FOREIGN KEY (`task`) REFERENCES `org_tasks_tasks` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_accesskeys` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `key` varchar(32) character set utf8 DEFAULT NULL,
  `description` text character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_platform_accesskeys` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_platform_accesskeys_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_boarditems` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `text` varchar(255) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_platform_boarditems` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_platform_boarditems_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_charts` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `activity` tinyint DEFAULT '0',
  `timeoriented` tinyint DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `binfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_platform_charts` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_platform_charts_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_exporttemplates` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `activity` tinyint DEFAULT '0',
  `entity` varchar(60) character set utf8 DEFAULT NULL,
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `binfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_platform_exporttemplates` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_platform_exporttemplates_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_monitor` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 DEFAULT NULL,
  `ownergroup` varchar(60) character set utf8 DEFAULT NULL,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `UMI` varchar(60) character set utf8 DEFAULT NULL,
  `entity` varchar(60) character set utf8 DEFAULT NULL,
  `index` int DEFAULT '0',
  `url` varchar(255) character set utf8 DEFAULT NULL,
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `action` tinyint DEFAULT '0',
  CONSTRAINT `PriKey_platform_monitor` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_platform_monitor_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_platform_monitor_ownergroup` FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_platform_monitor_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_services` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `activity` tinyint DEFAULT '0',
  `name` varchar(255) character set utf8 DEFAULT NULL,
  `event` tinyint DEFAULT '0',
  `entity` varchar(60) character set utf8 DEFAULT NULL,
  `schedule` int DEFAULT '0',
  `interval` int DEFAULT '0',
  `binfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_platform_services` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_platform_services_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_services_accesskeys` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 DEFAULT NULL,
  `creationdate` int DEFAULT '0',
  `service` int NOT NULL,
  `accesskey` int NOT NULL,
  CONSTRAINT `PriKey_platform_services_accesskeys` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_platform_services_accesskeys_creator` FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `ForKey_platform_services_accesskeys_service` FOREIGN KEY (`service`) REFERENCES `platform_services` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ForKey_platform_services_accesskeys_accesskey` FOREIGN KEY (`accesskey`) REFERENCES `platform_accesskeys` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_settings` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int DEFAULT '0',
  `lastmodified` int DEFAULT '0',
  `UMI` varchar(60) character set utf8 DEFAULT NULL,
  `binfile` varchar(32) character set utf8 DEFAULT NULL,
  CONSTRAINT `PriKey_platform_settings` PRIMARY KEY (`ID`),
  CONSTRAINT `ForKey_platform_settings_owneruser` FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;