CREATE TABLE `platform_users` (
  `ID` int default NULL,
  `username` varchar(60) character set utf8 NOT NULL,
  PRIMARY KEY (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `platform_users` (`username`) VALUES ('Admin');

CREATE TABLE `platform_groups` (
  `ID` int default NULL,
  `groupname` varchar(60) character set utf8 NOT NULL,
  PRIMARY KEY (`groupname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_folders` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `parent` int default NULL,
  `name` varchar(255) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_types` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `folder` int NOT NULL,
  `type` int default NULL,
  `deleted` tinyint default '0',
  `title` varchar(255) character set utf8 default NULL,
  `filenum` varchar(255) character set utf8 default NULL,
  `status` tinyint default '0',
  `keywords` varchar(255) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  `versioncount` int default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`folder`) REFERENCES `col_files_folders` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`type`) REFERENCES `col_files_types` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_items` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `file` int NOT NULL,
  `filename` varchar(255) character set utf8 default NULL,
  `version` varchar(255) character set utf8 default NULL,
  `mimetype` varchar(255) character set utf8 default NULL,
  `size` int default '0',
  `comment` text character set utf8 default NULL,
  `binfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_journal` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `file` int NOT NULL,
  `date` int default '0',
  `subject` varchar(255) character set utf8 default NULL,
  `text` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_files_shortcuts` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int default '0',
  `file` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_columns` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_forums` (
  `ID` int NOT NULL auto_increment,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `column` int default NULL,
  `name` varchar(255) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  `lastentry` int default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`column`) REFERENCES `col_forums_columns` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_topics` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `forum` int NOT NULL,
  `title` varchar(255) character set utf8 default NULL,
  `lastentry` int default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`forum`) REFERENCES `col_forums_forums` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_entries` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `topic` int NOT NULL,
  `flag` tinyint default '0',
  `text` text character set utf8 default NULL,
  `attachname` varchar(255) character set utf8 default NULL,
  `attachbinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`topic`) REFERENCES `col_forums_topics` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_notify` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `forum` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`forum`) REFERENCES `col_forums_forums` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_forums_view` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `forum` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`forum`) REFERENCES `col_forums_forums` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_messages_folders` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `parent` int default NULL,
  `name` varchar(255) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_messages_accounts` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `activity` tinyint default '0',
  `default` tinyint default '0',
  `name` varchar(255) character set utf8 default NULL,
  `email` varchar(255) character set utf8 default NULL,
  `server` varchar(255) character set utf8 default NULL,
  `port` smallint default '0',
  `protocol` varchar(255) character set utf8 default NULL,
  `username` varchar(255) character set utf8 default NULL,
  `password` varchar(255) character set utf8 default NULL,
  `movetoprimary` tinyint default '0',
  `moveto` int default NULL,
  `description` text character set utf8 default NULL,
  `leavemsg` tinyint default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`moveto`) REFERENCES `col_messages_folders` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_messages_messages` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `account` int default NULL,
  `primaryfolder` tinyint default '0',
  `folder` int default NULL,
  `flag` tinyint default '0',
  `date` int default '0',
  `subject` varchar(255) character set utf8 default NULL,
  `sender` varchar(255) character set utf8 default NULL,
  `sender_name` varchar(255) character set utf8 default NULL,
  `to` varchar(255) character set utf8 default NULL,
  `to_name` varchar(255) character set utf8 default NULL,
  `cc` varchar(255) character set utf8 default NULL,
  `bcc` varchar(255) character set utf8 default NULL,
  `reply_to` varchar(255) character set utf8 default NULL,
  `count_to` int default '0',
  `contenttype` varchar(255) character set utf8 default NULL,
  `binfile` varchar(32) character set utf8 default NULL,
  `keywords` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`account`) REFERENCES `col_messages_accounts` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`folder`) REFERENCES `col_messages_folders` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_messages_msglog` (
  `ID` int NOT NULL auto_increment,
  `account` int NOT NULL,
  `uid` int default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`account`) REFERENCES `col_messages_accounts` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_messages_templates` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `default` tinyint default '0',
  `name` varchar(255) character set utf8 default NULL,
  `text` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_news_channels` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int default '0',
  `activity` tinyint default '0',
  `type` tinyint default '0',
  `title` varchar(255) character set utf8 default NULL,
  `newsfeed` varchar(255) character set utf8 default NULL,
  `link` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `col_news_newsitems` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int default '0',
  `channel` int default NULL,
  `title` varchar(255) character set utf8 default NULL,
  `pubdate` int default '0',
  `link` varchar(255) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`channel`) REFERENCES `col_news_channels` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_contacts_companies` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8  default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  `director` varchar(255) character set utf8 default NULL,
  `traderegister` varchar(255) character set utf8 default NULL,
  `taxcode` varchar(255) character set utf8 default NULL,
  `address` varchar(255) character set utf8 default NULL,
  `postalcode` varchar(255) character set utf8 default NULL,
  `city` varchar(255) character set utf8 default NULL,
  `region` varchar(255) character set utf8 default NULL,
  `country` varchar(255) character set utf8 default NULL,
  `phone` varchar(255) character set utf8 default NULL,
  `phone2` varchar(255) character set utf8 default NULL,
  `fax` varchar(255) character set utf8 default NULL,
  `fax2` varchar(255) character set utf8 default NULL,
  `email` varchar(255) character set utf8 default NULL,
  `website` varchar(255) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_customers_customers` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  `customernum` varchar(255) character set utf8 default NULL,
  `status` tinyint default '0',
  `risk` tinyint default '0',
  `dispatch` tinyint default '0',
  `payment` tinyint default '0',
  `prefcontact` tinyint default '0',
  `contact` int default NULL,
  `description` text character set utf8 default NULL,
  `usebilling` tinyint default '0',
  `billingaddr` varchar(255) character set utf8 default NULL,
  `billingpc` varchar(255) character set utf8 default NULL,
  `billingcity` varchar(255) character set utf8 default NULL,
  `billingcountry` varchar(255) character set utf8 default NULL,
  `useshipping` tinyint default '0',
  `shippingaddr` varchar(255) character set utf8 default NULL,
  `shippingpc` varchar(255) character set utf8 default NULL,
  `shippingcity` varchar(255) character set utf8 default NULL,
  `shippingcountry` varchar(255) character set utf8 default NULL,
  `bank` varchar(255) character set utf8 default NULL,
  `bankid` varchar(255) character set utf8 default NULL,
  `account` varchar(255) character set utf8 default NULL,
  `cctype` tinyint default '0',
  `ccnum` varchar(255) character set utf8 default NULL,
  `ccvalid` varchar(5) character set utf8 default NULL,
  `ccauth` varchar(3) character set utf8 default NULL,
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`contact`) REFERENCES `org_contacts_companies` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_deliveries` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `deliverynum` varchar(255) character set utf8 default NULL,
  `customer` int default NULL,
  `date` int default '0',
  `status` tinyint default '0',
  `discount` double default '0',
  `netamount` double default '0',
  `tax` double default '0',
  `itemsbinfile` varchar(32) character set utf8 default NULL,
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_invoices` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `invoicenum` varchar(255) character set utf8 default NULL,
  `customer` int default NULL,
  `date` int default '0',
  `duedate` int default '0',
  `status` tinyint default '0',
  `amountpayable` double default '0',
  `payment` double default '0',
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_invoices_deliveries` (
  `ID` int NOT NULL auto_increment,
  `invoice` int NOT NULL,
  `delivery` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`invoice`) REFERENCES `crm_billing_invoices` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`delivery`) REFERENCES `crm_billing_deliveries` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_offers` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `quotationnum` varchar(255) character set utf8 default NULL,
  `customer` int default NULL,
  `date` int default '0',
  `duedate` int default '0',
  `status` tinyint default '0',
  `discount` double default '0',
  `netamount` double default '0',
  `tax` double default '0',
  `margin` double default '0',
  `itemsbinfile` varchar(32) character set utf8 default NULL,
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_orders` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `ordernum` varchar(255) character set utf8 default NULL,
  `customer` int default NULL,
  `date` int default '0',
  `duedate` int default '0',
  `status` tinyint default '0',
  `discount` double default '0',
  `netamount` double default '0',
  `tax` double default '0',
  `margin` double default '0',
  `itemsbinfile` varchar(32) character set utf8 default NULL,
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_payments` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `invoice` int NOT NULL,
  `date` int default '0',
  `account` varchar(255) character set utf8 default NULL,
  `reference` varchar(255) character set utf8 default NULL,
  `amount` double default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`invoice`) REFERENCES `crm_billing_invoices` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_templates` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `type` tinyint default '0',
  `name` varchar(255) character set utf8 default NULL,
  `inputbinfile` varchar(32) character set utf8 default NULL,
  `outputbinfile` varchar(32) character set utf8 default NULL,
  `pdfbinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_printouts` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `type` tinyint default '0',
  `transaction` int NOT NULL,
  `transactionnum` varchar(255) character set utf8 default NULL,
  `template` int default NULL,
  `maildate` int default '0',
  `databinfile` varchar(32) character set utf8 default NULL,
  `pdfbinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`template`) REFERENCES `crm_billing_templates` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_billing_requests` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `requestnum` varchar(255) character set utf8 default NULL,
  `customer` int default NULL,
  `date` int default '0',
  `status` tinyint default '0',
  `itemsbinfile` varchar(32) character set utf8 default NULL,
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_campaigns_campaigns` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `title` varchar(255) character set utf8 default NULL,
  `datefrom` int default '0',
  `dateto` int default '0',
  `status` tinyint default '0',
  `media` tinyint default '0',
  `replyrate` tinyint default '0',
  `projectedeffort` double default '0',
  `budget` double default '0',
  `description` text character set utf8 default NULL,
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_campaigns_addressees` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `campaign` int NOT NULL,
  `customer` int NOT NULL,
  `flag` tinyint default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`campaign`) REFERENCES `crm_campaigns_campaigns` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_campaigns_journal` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `campaign` int NOT NULL,
  `date` int default '0',
  `subject` varchar(255) character set utf8 default NULL,
  `text` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`campaign`) REFERENCES `crm_campaigns_campaigns` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_campaigns_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `campaign` int NOT NULL,
  `file` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`campaign`) REFERENCES `crm_campaigns_campaigns` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_tasks_tasks` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `parent` int default NULL,
  `title` varchar(255) character set utf8 default NULL,
  `duedate` int default '0',
  `status` tinyint default '0',
  `progress` tinyint default '0',
  `priority` tinyint default '0',
  `projectedeffort` double default '0',
  `actualeffort` double default '0',
  `budget` double default '0',
  `costs` double default '0',
  `description` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_campaigns_tasks` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `campaign` int NOT NULL,
  `task` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`campaign`) REFERENCES `crm_campaigns_campaigns` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`task`) REFERENCES `org_tasks_tasks` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_cases_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_cases_cases` (
  `ID` int NOT NULL auto_increment,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `title` varchar(255) character set utf8 default NULL,
  `casenum` varchar(255) character set utf8 default NULL,
  `customer` int default NULL,
  `status` tinyint default '0',
  `priority` tinyint default '0',
  `category` int default NULL,
  `projectedeffort` double default '0',
  `budget` double default '0',
  `materialcosts` double default '0',
  `message` int default NULL,
  `databinfile` varchar(32) character set utf8 default NULL,
  `itemsbinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`category`) REFERENCES `crm_cases_categories` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`message`) REFERENCES `col_messages_messages` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_cases_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `case` int NOT NULL,
  `file` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`case`) REFERENCES `crm_cases_cases` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_cases_journal` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `case` int NOT NULL,
  `date` int default '0',
  `subject` varchar(255) character set utf8 default NULL,
  `text` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`case`) REFERENCES `crm_cases_cases` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_cases_tasks` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `case` int NOT NULL,
  `task` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`case`) REFERENCES `crm_cases_cases` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`task`) REFERENCES `org_tasks_tasks` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_contracts_classes` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `default` tinyint default '0',
  `name` varchar(255) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  `inputbinfile` varchar(32) character set utf8 default NULL,
  `outputbinfile` varchar(32) character set utf8 default NULL,
  `pdfbinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_contracts_contracts` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `title` varchar(255) character set utf8 default NULL,
  `contractnum` varchar(255) character set utf8 default NULL,
  `customer` int default NULL,
  `class` int NOT NULL,
  `datefrom` int default '0',
  `usedateto` tinyint default '0',
  `dateto` int default '0',
  `usedatecancel` tinyint default '0',
  `datecancel` int default '0',
  `status` tinyint default '0',
  `databinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`class`) REFERENCES `crm_contracts_classes` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_contracts_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `contract` int NOT NULL,
  `file` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`contract`) REFERENCES `crm_contracts_contracts` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_contracts_journal` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `contract` int NOT NULL,
  `date` int default '0',
  `subject` varchar(255) character set utf8 default NULL,
  `text` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`contract`) REFERENCES `crm_contracts_contracts` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_customers_groups` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_customers_customers_groups` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `customer` int NOT NULL,
  `group` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`group`) REFERENCES `crm_customers_groups` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_customers_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `customer` int NOT NULL,
  `file` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_contacts_people` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  `lastname` varchar(255) character set utf8 default NULL,
  `firstname` varchar(255) character set utf8 default NULL,
  `title` varchar(255) character set utf8 default NULL,
  `company` varchar(255) character set utf8 default NULL,
  `position` varchar(255) character set utf8 default NULL,
  `workgroup` varchar(255) character set utf8 default NULL,
  `address` varchar(255) character set utf8 default NULL,
  `postalcode` varchar(255) character set utf8 default NULL,
  `city` varchar(255) character set utf8 default NULL,
  `region` varchar(255) character set utf8 default NULL,
  `country` varchar(255) character set utf8 default NULL,
  `phone` varchar(255) character set utf8 default NULL,
  `phone2` varchar(255) character set utf8 default NULL,
  `cell` varchar(255) character set utf8 default NULL,
  `fax` varchar(255) character set utf8 default NULL,
  `fax2` varchar(255) character set utf8 default NULL,
  `pager` varchar(255) character set utf8 default NULL,
  `iptel` varchar(255) character set utf8 default NULL,
  `email` varchar(255) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  `picbinfile` varchar(32) character set utf8 default NULL,
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_customers_journal` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `customer` int NOT NULL,
  `date` int default '0',
  `label` tinyint default '0',
  `contact` int default NULL,
  `subject` varchar(255) character set utf8 default NULL,
  `text` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`contact`) REFERENCES `org_contacts_people` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_opportunities_opportunities` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `title` varchar(255) character set utf8 default NULL,
  `customer` int default NULL,
  `status` tinyint default '0',
  `probability` tinyint default '0',
  `closedate` int default '0',
  `priority` tinyint default '0',
  `forecast` tinyint default '0',
  `worstcase` double default '0',
  `mostlikely` double default '0',
  `upside` double default '0',
  `description` text character set utf8 default NULL,
  `message` int default NULL,
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`customer`) REFERENCES `crm_customers_customers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`message`) REFERENCES `col_messages_messages` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_opportunities_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `opportunity` int NOT NULL,
  `file` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`opportunity`) REFERENCES `crm_opportunities_opportunities` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `crm_opportunities_journal` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `opportunity` int NOT NULL,
  `date` int default '0',
  `subject` varchar(255) character set utf8 default NULL,
  `text` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`opportunity`) REFERENCES `crm_opportunities_opportunities` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_archive_locations` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_archive_rooms` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `location` int NOT NULL,
  `name` varchar(255) character set utf8 default NULL,
  `roomnum` varchar(255) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  `lastinsert` int default '0',
  `mapbinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`location`) REFERENCES `erp_archive_locations` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_archive_shelves` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `room` int NOT NULL,
  `name` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`room`) REFERENCES `erp_archive_rooms` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_archive_types` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_archive_elements` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `shelf` int NOT NULL,
  `name` varchar(255) character set utf8 default NULL,
  `elementid` varchar(255) character set utf8 default NULL,
  `type` int default NULL,
  `description` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`shelf`) REFERENCES `erp_archive_shelves` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`type`) REFERENCES `erp_archive_types` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `number` smallint default '0',
  `name` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_storages` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `default` tinyint default '0',
  `name` varchar(255) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_items` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `storage` int NOT NULL,
  `useserials` tinyint default '0',
  `evalmethod` tinyint default '0',
  `periode` tinyint default '0',
  `name` varchar(255) character set utf8 default NULL,
  `manufacturer` varchar(255) character set utf8 default NULL,
  `itemnum` varchar(255) character set utf8 default NULL,
  `location` varchar(255) character set utf8 default NULL,
  `quantity` tinyint default '0',
  `barcode` varchar(255) character set utf8 default NULL,
  `price` double default '0',
  `taxrate` tinyint default '0',
  `minstock` int default '0',
  `weight` double default '0',
  `dimx` double default '0',
  `dimy` double default '0',
  `dimz` double default '0',
  `description` text character set utf8 default NULL,
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`storage`) REFERENCES `erp_stockcalc_storages` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_productions` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `item` int NOT NULL,
  `date` int default '0',
  `productionid` varchar(255) character set utf8 default NULL,
  `output` int default '0',
  `target` int default '0',
  `materialcosts` double default '0',
  `manufactcosts` double default '0',
  `itemsbinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_depletions` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `item` int NOT NULL,
  `date` int default '0',
  `delivery` int default NULL,
  `production` int default NULL,
  `purpose` varchar(255) character set utf8 default NULL,
  `amount` int default '0',
  `price` double default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`delivery`) REFERENCES `crm_billing_deliveries` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`production`) REFERENCES `erp_stockcalc_productions` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_depletions_serials` (
  `ID` int NOT NULL auto_increment,
  `depletion` int NOT NULL,
  `serial` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`depletion`) REFERENCES `erp_stockcalc_depletions` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_devices` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `item` int NOT NULL,
  `serial` varchar(255) character set utf8 default NULL,
  `location` varchar(255) character set utf8 default NULL,
  `reference` varchar(255) character set utf8 default NULL,
  `comment` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `item` int NOT NULL,
  `file` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_items_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `item` int NOT NULL,
  `category` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`category`) REFERENCES `erp_stockcalc_categories` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_suppliers_suppliers` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  `vendornum` varchar(255) character set utf8 default NULL,
  `status` tinyint default '0',
  `customernum` varchar(255) character set utf8 default NULL,
  `dispatch` tinyint default '0',
  `payment` tinyint default '0',
  `prefcontact` tinyint default '0',
  `bank` varchar(255) character set utf8 default NULL,
  `bankid` varchar(255) character set utf8 default NULL,
  `account` varchar(255) character set utf8 default NULL,
  `contact` int default NULL,
  `description` text character set utf8 default NULL,
  `lastupload` int default '0',
  `pricelistbinfile` varchar(32) character set utf8 default NULL,
  `extdatabinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`contact`) REFERENCES `org_contacts_companies` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_orders` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `item` int NOT NULL,
  `flag` tinyint default '0',
  `date` int default '0',
  `orderid` varchar(255) character set utf8 default NULL,
  `supplier` int default NULL,
  `amount` int default '0',
  `delivered` int default '0',
  `price` double default '0',
  `etd` int default '0',
  `td` int default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_incoming` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `item` int NOT NULL,
  `date` int default '0',
  `order` int default NULL,
  `production` int default NULL,
  `amount` int default '0',
  `price` double default '0',
  `periode` tinyint default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`order`) REFERENCES `erp_stockcalc_orders` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`production`) REFERENCES `erp_stockcalc_productions` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_incoming_serials` (
  `ID` int NOT NULL auto_increment,
  `incoming` int NOT NULL,
  `serial` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`incoming`) REFERENCES `erp_stockcalc_incoming` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_templates` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  `inputbinfile` varchar(32) character set utf8 default NULL,
  `outputbinfile` varchar(32) character set utf8 default NULL,
  `pdfbinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_printouts` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `orderid` varchar(255) character set utf8 default NULL,
  `template` int default NULL,
  `maildate` int default '0',
  `databinfile` varchar(32) character set utf8 default NULL,
  `pdfbinfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`template`) REFERENCES `erp_stockcalc_templates` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_stockcalc_suppliers` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `item` int NOT NULL,
  `supplier` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`item`) REFERENCES `erp_stockcalc_items` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_suppliers_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `supplier` int NOT NULL,
  `category` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`category`) REFERENCES `erp_stockcalc_categories` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_suppliers_files` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `supplier` int NOT NULL,
  `file` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`file`) REFERENCES `col_files_files` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_suppliers_invoices` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `supplier` int NOT NULL,
  `flag` tinyint default '0',
  `invoicenum` varchar(255) character set utf8 default NULL,
  `billingdate` int default '0',
  `duedate` int default '0',
  `netamount` double default '0',
  `totalamount` double default '0',
  `payment` double default '0',
  `comment` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `erp_suppliers_journal` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `supplier` int NOT NULL,
  `date` int default '0',
  `label` tinyint default '0',
  `contact` int default NULL,
  `subject` varchar(255) character set utf8 default NULL,
  `text` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`supplier`) REFERENCES `erp_suppliers_suppliers` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`contact`) REFERENCES `org_contacts_people` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_calendar_events` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `title` varchar(255) character set utf8 default NULL,
  `location` varchar(255) character set utf8 default NULL,
  `datefrom` int default '0',
  `dateto` int default '0',
  `repeat` tinyint default '0',
  `interval` int default '0',
  `usedaterepeat` tinyint default '0',
  `daterepeat` int default '0',
  `label` tinyint default '0',
  `display` tinyint default '0',
  `description` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_calendar_invitations` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `event` int NOT NULL,
  `flag` tinyint default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`event`) REFERENCES `org_calendar_events` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_contacts_people_companies` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `person` int NOT NULL,
  `company` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`person`) REFERENCES `org_contacts_people` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`company`) REFERENCES `org_contacts_companies` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_followup_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_followup_reminders` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `category` int default NULL,
  `title` varchar(255) character set utf8 default NULL,
  `duedate` int default '0',
  `status` tinyint default '0',
  `priority` tinyint default '0',
  `description` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`category`) REFERENCES `org_followup_categories` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_followup_associates` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `reminder` int NOT NULL,
  `entity` varchar(60) character set utf8 default NULL,
  `index` int default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`reminder`) REFERENCES `org_followup_reminders` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_links_columns` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_links_links` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `column` int default NULL,
  `title` varchar(255) character set utf8 default NULL,
  `url` varchar(255) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  `numviews` int default '0',
  `lastview` int default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`column`) REFERENCES `org_links_columns` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_notes_categories` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_notes_notes` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `assigneduser` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `category` int default NULL,
  `title` varchar(255) character set utf8 default NULL,
  `text` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`assigneduser`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`category`) REFERENCES `org_notes_categories` (`ID`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `org_tasks_records` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `task` int NOT NULL,
  `text` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`task`) REFERENCES `org_tasks_tasks` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_accesskeys` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `name` varchar(255) character set utf8 default NULL,
  `key` varchar(32) character set utf8 default NULL,
  `description` text character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_boarditems` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `text` varchar(255) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_charts` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `activity` tinyint default '0',
  `timeoriented` tinyint default '0',
  `name` varchar(255) character set utf8 default NULL,
  `binfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_exporttemplates` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `activity` tinyint default '0',
  `entity` varchar(60) character set utf8 default NULL,
  `name` varchar(255) character set utf8 default NULL,
  `binfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_monitor` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 default NULL,
  `ownergroup` varchar(60) character set utf8 default NULL,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `UMI` varchar(60) character set utf8 default NULL,
  `entity` varchar(60) character set utf8 default NULL,
  `index` int default '0',
  `url` varchar(255) character set utf8 default NULL,
  `name` varchar(255) character set utf8 default NULL,
  `action` tinyint default '0',
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`ownergroup`) REFERENCES `platform_groups` (`groupname`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_services` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `activity` tinyint default '0',
  `name` varchar(255) character set utf8 default NULL,
  `event` tinyint default '0',
  `entity` varchar(60) character set utf8 default NULL,
  `schedule` int default '0',
  `interval` int default '0',
  `binfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_services_accesskeys` (
  `ID` int NOT NULL auto_increment,
  `creator` varchar(60) character set utf8 default NULL,
  `creationdate` int default '0',
  `service` int NOT NULL,
  `accesskey` int NOT NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`creator`) REFERENCES `platform_users` (`username`) ON DELETE SET NULL ON UPDATE CASCADE,
  FOREIGN KEY (`service`) REFERENCES `platform_services` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY (`accesskey`) REFERENCES `platform_accesskeys` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `platform_settings` (
  `ID` int NOT NULL auto_increment,
  `owneruser` varchar(60) character set utf8 NOT NULL,
  `creationdate` int default '0',
  `lastmodified` int default '0',
  `UMI` varchar(60) character set utf8 default NULL,
  `binfile` varchar(32) character set utf8 default NULL,
  PRIMARY KEY (`ID`),
  FOREIGN KEY (`owneruser`) REFERENCES `platform_users` (`username`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;