/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching;

import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs2_0BrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs2_1BrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs3_0BrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs3_1BrowserLaunching;
import edu.stanford.ejalbert.launching.misc.SunOSBrowserLaunching;
import edu.stanford.ejalbert.launching.misc.UnixNetscapeBrowserLaunching;
import edu.stanford.ejalbert.launching.windows.WindowsBrowserLaunching;
import net.sf.wraplog.AbstractLogger;

public class BrowserLaunchingFactory {
    public static IBrowserLaunching createSystemBrowserLaunching(AbstractLogger logger) throws UnsupportedOperatingSystemException {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            logger.info("Mac OS");
            String mrjVersion = System.getProperty("mrj.version");
            String majorMRJVersion = mrjVersion.substring(0, 3);
            try {
                double version = Double.valueOf(majorMRJVersion);
                logger.info("version=" + Double.toString(version));
                if (version == 2.0) {
                    return new MacOs2_0BrowserLaunching();
                }
                if (version >= 2.1 && version < 3.0) {
                    return new MacOs2_1BrowserLaunching();
                }
                if (version == 3.0) {
                    return new MacOs3_0BrowserLaunching();
                }
                if (version >= 3.1) {
                    return new MacOs3_1BrowserLaunching();
                }
                throw new UnsupportedOperatingSystemException("Unsupported MRJ version: " + version);
            }
            catch (NumberFormatException nfe) {
                throw new UnsupportedOperatingSystemException("Invalid MRJ version: " + mrjVersion);
            }
        }
        if (osName.startsWith("Windows")) {
            logger.info("Windows OS");
            if (osName.indexOf("9") != -1) {
                return new WindowsBrowserLaunching(logger, "windows.win9x");
            }
            if (osName.indexOf("2000") != -1 || osName.indexOf("XP") != -1) {
                return new WindowsBrowserLaunching(logger, "windows.win2000");
            }
            return new WindowsBrowserLaunching(logger, "windows.winNT");
        }
        if (osName.startsWith("SunOS")) {
            logger.info("SunOS");
            return new SunOSBrowserLaunching(logger);
        }
        logger.info("Unix-type OS");
        return new UnixNetscapeBrowserLaunching(logger, "/edu/stanford/ejalbert/launching/misc/linuxUnixConfig.properties");
    }
}

