/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RTFUtility {
    private RTFEditorKit m_editor;
    private Document m_doc;
    private static final Map<String, String> LOCALEID_MAPPING = new HashMap<String, String>();

    public String strip(String text) {
        String result;
        this.initialise();
        text = this.processDoubleByteChars(text);
        try {
            int length = this.m_doc.getLength();
            if (length != 0) {
                this.m_doc.remove(0, length);
            }
            StringReader reader = new StringReader(text);
            this.m_editor.read(reader, this.m_doc, 0);
            result = this.m_doc.getText(0, this.m_doc.getLength());
        }
        catch (Exception ex) {
            result = text;
        }
        return result;
    }

    private void initialise() {
        if (this.m_editor == null) {
            this.m_editor = new RTFEditorKit();
        }
        if (this.m_doc == null) {
            this.m_doc = this.m_editor.createDefaultDocument();
        }
    }

    private String processDoubleByteChars(String text) {
        String[] tokens = text.split("\\\\");
        int index = 0;
        String currentEncoding = null;
        StringBuffer result = new StringBuffer(text.length());
        boolean collectingBytes = false;
        LinkedList<String> bytes = new LinkedList<String>();
        boolean firstWord = true;
        while (index < tokens.length) {
            String token = tokens[index];
            if (token.length() != 0) {
                String decodedText;
                if (token.charAt(0) == '\'') {
                    if (!collectingBytes) {
                        collectingBytes = true;
                    }
                    bytes.add(token.substring(1, 3));
                    if (token.length() > 3) {
                        decodedText = this.processBytes(bytes, currentEncoding);
                        if (firstWord) {
                            firstWord = false;
                            result.append(' ');
                        }
                        result.append(decodedText);
                        collectingBytes = false;
                        bytes.clear();
                        result.append(token.substring(3));
                    }
                    ++index;
                    continue;
                }
                if (collectingBytes) {
                    decodedText = this.processBytes(bytes, currentEncoding);
                    if (firstWord) {
                        result.append(' ');
                    }
                    result.append(decodedText);
                    collectingBytes = false;
                    bytes.clear();
                }
                if (token.startsWith("lang") || token.startsWith("deflang")) {
                    currentEncoding = this.processEncoding(token);
                }
            }
            firstWord = true;
            if (index != 0) {
                result.append('\\');
            }
            result.append(token);
            ++index;
        }
        return result.toString();
    }

    private String processEncoding(String token) {
        int index;
        String localeID = null;
        for (index = 0; index < token.length() && !Character.isDigit(token.charAt(index)); ++index) {
        }
        if (index != token.length()) {
            StringBuffer sb = new StringBuffer(token.length());
            while (index < token.length() && Character.isDigit(token.charAt(index))) {
                sb.append(token.charAt(index));
                ++index;
            }
            localeID = sb.toString();
        }
        String encoding = LOCALEID_MAPPING.get(localeID);
        return encoding;
    }

    private String processBytes(LinkedList<String> bytes, String currentEncoding) {
        byte[] raw = new byte[bytes.size()];
        int byteIndex = 0;
        for (String hexByte : bytes) {
            raw[byteIndex++] = Integer.decode("0x" + hexByte).byteValue();
        }
        String result = "";
        try {
            result = new String(raw, currentEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    static {
        LOCALEID_MAPPING.put("1025", "Cp1256");
        LOCALEID_MAPPING.put("1026", "Cp1251");
        LOCALEID_MAPPING.put("1027", "Cp1252");
        LOCALEID_MAPPING.put("1028", "Cp950");
        LOCALEID_MAPPING.put("1029", "Cp1250");
        LOCALEID_MAPPING.put("1030", "Cp1252");
        LOCALEID_MAPPING.put("1031", "Cp1252");
        LOCALEID_MAPPING.put("1032", "Cp1253");
        LOCALEID_MAPPING.put("1033", "Cp1252");
        LOCALEID_MAPPING.put("1034", "Cp1252");
        LOCALEID_MAPPING.put("1035", "Cp1252");
        LOCALEID_MAPPING.put("1036", "Cp1252");
        LOCALEID_MAPPING.put("1037", "Cp1255");
        LOCALEID_MAPPING.put("1038", "Cp1250");
        LOCALEID_MAPPING.put("1039", "Cp1252");
        LOCALEID_MAPPING.put("1040", "Cp1252");
        LOCALEID_MAPPING.put("1041", "SJIS");
        LOCALEID_MAPPING.put("1042", "Cp949");
        LOCALEID_MAPPING.put("1043", "Cp1252");
        LOCALEID_MAPPING.put("1044", "Cp1252");
        LOCALEID_MAPPING.put("1045", "Cp1250");
        LOCALEID_MAPPING.put("1046", "Cp1252");
        LOCALEID_MAPPING.put("1048", "Cp1250");
        LOCALEID_MAPPING.put("1049", "Cp1251");
        LOCALEID_MAPPING.put("1050", "Cp1250");
        LOCALEID_MAPPING.put("1051", "Cp1250");
        LOCALEID_MAPPING.put("1052", "Cp1250");
        LOCALEID_MAPPING.put("1053", "Cp1252");
        LOCALEID_MAPPING.put("1054", "Cp874");
        LOCALEID_MAPPING.put("1055", "Cp1254");
        LOCALEID_MAPPING.put("1056", "Cp1256");
        LOCALEID_MAPPING.put("1057", "Cp1252");
        LOCALEID_MAPPING.put("1058", "Cp1251");
        LOCALEID_MAPPING.put("1059", "Cp1251");
        LOCALEID_MAPPING.put("1060", "Cp1250");
        LOCALEID_MAPPING.put("1061", "Cp1257");
        LOCALEID_MAPPING.put("1062", "Cp1257");
        LOCALEID_MAPPING.put("1063", "Cp1257");
        LOCALEID_MAPPING.put("1065", "Cp1256");
        LOCALEID_MAPPING.put("1066", "Cp1258");
        LOCALEID_MAPPING.put("1068", "Cp1254");
        LOCALEID_MAPPING.put("1069", "Cp1252");
        LOCALEID_MAPPING.put("1071", "Cp1251");
        LOCALEID_MAPPING.put("1078", "Cp1252");
        LOCALEID_MAPPING.put("1080", "Cp1252");
        LOCALEID_MAPPING.put("1086", "Cp1252");
        LOCALEID_MAPPING.put("1087", "Cp1251");
        LOCALEID_MAPPING.put("1088", "Cp1251");
        LOCALEID_MAPPING.put("1089", "Cp1252");
        LOCALEID_MAPPING.put("1091", "Cp1254");
        LOCALEID_MAPPING.put("1092", "Cp1251");
        LOCALEID_MAPPING.put("1104", "Cp1251");
        LOCALEID_MAPPING.put("1110", "Cp1252");
        LOCALEID_MAPPING.put("2049", "Cp1256");
        LOCALEID_MAPPING.put("2052", "MS936");
        LOCALEID_MAPPING.put("2055", "Cp1252");
        LOCALEID_MAPPING.put("2057", "Cp1252");
        LOCALEID_MAPPING.put("2058", "Cp1252");
        LOCALEID_MAPPING.put("2060", "Cp1252");
        LOCALEID_MAPPING.put("2064", "Cp1252");
        LOCALEID_MAPPING.put("2067", "Cp1252");
        LOCALEID_MAPPING.put("2068", "Cp1252");
        LOCALEID_MAPPING.put("2070", "Cp1252");
        LOCALEID_MAPPING.put("2074", "Cp1250");
        LOCALEID_MAPPING.put("2077", "Cp1252");
        LOCALEID_MAPPING.put("2092", "Cp1251");
        LOCALEID_MAPPING.put("2110", "Cp1252");
        LOCALEID_MAPPING.put("2115", "Cp1251");
        LOCALEID_MAPPING.put("3073", "Cp1256");
        LOCALEID_MAPPING.put("3076", "Cp950");
        LOCALEID_MAPPING.put("3079", "Cp1252");
        LOCALEID_MAPPING.put("3081", "Cp1252");
        LOCALEID_MAPPING.put("3082", "Cp1252");
        LOCALEID_MAPPING.put("3084", "Cp1252");
        LOCALEID_MAPPING.put("3098", "Cp1251");
        LOCALEID_MAPPING.put("4097", "Cp1256");
        LOCALEID_MAPPING.put("4100", "MS936");
        LOCALEID_MAPPING.put("4103", "Cp1252");
        LOCALEID_MAPPING.put("4105", "Cp1252");
        LOCALEID_MAPPING.put("4106", "Cp1252");
        LOCALEID_MAPPING.put("4108", "Cp1252");
        LOCALEID_MAPPING.put("5121", "Cp1256");
        LOCALEID_MAPPING.put("5124", "Cp950");
        LOCALEID_MAPPING.put("5127", "Cp1252");
        LOCALEID_MAPPING.put("5129", "Cp1252");
        LOCALEID_MAPPING.put("5130", "Cp1252");
        LOCALEID_MAPPING.put("5132", "Cp1252");
        LOCALEID_MAPPING.put("6145", "Cp1256");
        LOCALEID_MAPPING.put("6153", "Cp1252");
        LOCALEID_MAPPING.put("6154", "Cp1252");
        LOCALEID_MAPPING.put("6156", "Cp1252");
        LOCALEID_MAPPING.put("7169", "Cp1256");
        LOCALEID_MAPPING.put("7177", "Cp1252");
        LOCALEID_MAPPING.put("7178", "Cp1252");
        LOCALEID_MAPPING.put("8193", "Cp1256");
        LOCALEID_MAPPING.put("8201", "Cp1252");
        LOCALEID_MAPPING.put("8202", "Cp1252");
        LOCALEID_MAPPING.put("9217", "Cp1256");
        LOCALEID_MAPPING.put("9225", "Cp1252");
        LOCALEID_MAPPING.put("9226", "Cp1252");
        LOCALEID_MAPPING.put("10241", "Cp1256");
        LOCALEID_MAPPING.put("10249", "Cp1252");
        LOCALEID_MAPPING.put("10250", "Cp1252");
        LOCALEID_MAPPING.put("11265", "Cp1256");
        LOCALEID_MAPPING.put("11273", "Cp1252");
        LOCALEID_MAPPING.put("11274", "Cp1252");
        LOCALEID_MAPPING.put("12289", "Cp1256");
        LOCALEID_MAPPING.put("12297", "Cp1252");
        LOCALEID_MAPPING.put("12298", "Cp1252");
        LOCALEID_MAPPING.put("13313", "Cp1256");
        LOCALEID_MAPPING.put("13321", "Cp1252");
        LOCALEID_MAPPING.put("13322", "Cp1252");
        LOCALEID_MAPPING.put("14337", "Cp1256");
        LOCALEID_MAPPING.put("14346", "Cp1252");
        LOCALEID_MAPPING.put("15361", "Cp1256");
        LOCALEID_MAPPING.put("15370", "Cp1252");
        LOCALEID_MAPPING.put("16385", "Cp1256");
        LOCALEID_MAPPING.put("16394", "Cp1252");
        LOCALEID_MAPPING.put("17418", "Cp1252");
        LOCALEID_MAPPING.put("18442", "Cp1252");
        LOCALEID_MAPPING.put("19466", "Cp1252");
        LOCALEID_MAPPING.put("20490", "Cp1252");
    }
}

