/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpp.CompObj;
import net.sf.mpxj.mpp.MPP12Reader;
import net.sf.mpxj.mpp.MPP8Reader;
import net.sf.mpxj.mpp.MPP9Reader;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class MPPReader
extends AbstractProjectReader {
    private boolean m_preserveNoteFormatting;
    private String m_readPassword;
    private String m_writePassword;
    private static final Map<String, Class<? extends MPPVariantReader>> FILE_CLASS_MAP = new HashMap<String, Class<? extends MPPVariantReader>>();

    public ProjectFile read(InputStream is) throws MPXJException {
        try {
            ProjectFile projectFile = new ProjectFile();
            POIFSFileSystem fs = new POIFSFileSystem(is);
            DirectoryEntry root = fs.getRoot();
            CompObj compObj = new CompObj((InputStream)new DocumentInputStream((DocumentEntry)root.getEntry("\u0001CompObj")));
            String format = compObj.getFileFormat();
            Class<? extends MPPVariantReader> readerClass = FILE_CLASS_MAP.get(format);
            if (readerClass == null) {
                throw new MPXJException("Invalid file format: " + format);
            }
            MPPVariantReader reader = readerClass.newInstance();
            reader.process(this, projectFile, root);
            projectFile.setAutoOutlineNumber(true);
            projectFile.updateStructure();
            projectFile.setAutoOutlineNumber(false);
            for (Task task : projectFile.getAllTasks()) {
                task.setSummary(task.getChildTasks().size() != 0);
            }
            projectFile.updateUniqueCounters();
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        catch (IllegalAccessException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        catch (InstantiationException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public boolean getPreserveNoteFormatting() {
        return this.m_preserveNoteFormatting;
    }

    public void setPreserveNoteFormatting(boolean preserveNoteFormatting) {
        this.m_preserveNoteFormatting = preserveNoteFormatting;
    }

    public void setReadPassword(String password) {
        this.m_readPassword = password;
    }

    public String getReadPassword() {
        return this.m_readPassword;
    }

    public void setWritePassword(String password) {
        this.m_writePassword = password;
    }

    public String getWritePassword() {
        return this.m_writePassword;
    }

    static {
        FILE_CLASS_MAP.put("MSProject.MPP9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT12", MPP12Reader.class);
    }
}

