/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.ProjectDateFormat;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectHeader
extends ProjectEntity {
    private String m_currencySymbol;
    private CurrencySymbolPosition m_symbolPosition = CurrencySymbolPosition.BEFORE;
    private Number m_currencyDigits;
    private char m_thousandsSeparator;
    private char m_decimalSeparator;
    private TimeUnit m_defaultDurationUnits = TimeUnit.DAYS;
    private boolean m_defaultDurationIsFixed;
    private TimeUnit m_defaultWorkUnits;
    private Rate m_defaultStandardRate;
    private Rate m_defaultOvertimeRate;
    private boolean m_updatingTaskStatusUpdatesResourceStatus;
    private boolean m_splitInProgressTasks;
    private DateOrder m_dateOrder = DateOrder.MDY;
    private ProjectTimeFormat m_timeFormat = ProjectTimeFormat.TWELVE_HOUR;
    private Date m_defaultStartTime;
    private char m_dateSeparator;
    private char m_timeSeparator;
    private String m_amText;
    private String m_pmText;
    private ProjectDateFormat m_dateFormat = ProjectDateFormat.DD_MM_YY;
    private ProjectDateFormat m_barTextDateFormat;
    private String m_projectTitle;
    private String m_company;
    private String m_manager;
    private String m_calendarName;
    private Date m_startDate;
    private Date m_finishDate;
    private ScheduleFrom m_scheduleFrom = ScheduleFrom.START;
    private Date m_currentDate;
    private String m_comments;
    private Number m_cost;
    private Number m_baselineCost;
    private Number m_actualCost;
    private Duration m_work;
    private Duration m_baselineWork;
    private Duration m_actualWork;
    private Number m_work2;
    private Duration m_duration;
    private Duration m_baselineDuration;
    private Duration m_actualDuration;
    private Number m_percentageComplete;
    private Date m_baselineStart;
    private Date m_baselineFinish;
    private Date m_actualStart;
    private Date m_actualFinish;
    private Duration m_startVariance;
    private Duration m_finishVariance;
    private String m_subject;
    private String m_author;
    private String m_keywords;
    private Date m_defaultEndTime;
    private boolean m_projectExternallyEdited;
    private String m_category;
    private Number m_minutesPerDay;
    private Number m_daysPerMonth;
    private Number m_minutesPerWeek;
    private boolean m_fiscalYearStart;
    private EarnedValueMethod m_defaultTaskEarnedValueMethod;
    private boolean m_removeFileProperties;
    private boolean m_moveCompletedEndsBack;
    private boolean m_newTasksEstimated;
    private boolean m_spreadActualCost;
    private boolean m_multipleCriticalPaths;
    private boolean m_autoAddNewResourcesAndTasks;
    private Date m_lastSaved;
    private Date m_statusDate;
    private boolean m_moveRemainingStartsBack;
    private boolean m_autolink;
    private boolean m_microsoftProjectServerURL;
    private boolean m_honorConstraints;
    private boolean m_adminProject;
    private boolean m_insertedProjectsLikeSummary;
    private String m_name;
    private boolean m_spreadPercentComplete;
    private boolean m_moveCompletedEndsForward;
    private boolean m_editableActualCosts;
    private String m_uniqueID;
    private Integer m_revision;
    private boolean m_newTasksEffortDriven;
    private boolean m_moveRemainingStartsForward;
    private boolean m_actualsInSync;
    private TaskType m_defaultTaskType;
    private EarnedValueMethod m_earnedValueMethod;
    private Date m_creationDate;
    private Date m_extendedCreationDate;
    private AccrueType m_defaultFixedCostAccrual;
    private Integer m_criticalSlackLimit;
    private Integer m_baselineForEarnedValue;
    private Integer m_fiscalYearStartMonth;
    private boolean m_newTaskStartIsProjectStart;
    private Day m_weekStartDay;
    private boolean m_calculateMultipleCriticalPaths;
    private Map<Integer, Object> m_documentSummaryInformation;
    private static final char DEFAULT_TIME_SEPARATOR = ':';
    private static final Double DEFAULT_COST = new Double(0.0);
    private static final Integer DEFAULT_CRITICAL_SLACK_LIMIT = new Integer(0);
    private static final Integer DEFAULT_BASELINE_FOR_EARNED_VALUE = new Integer(0);
    private static final Integer DEFAULT_FISCAL_YEAR_START_MONTH = new Integer(1);
    private static final Day DEFAULT_WEEK_START_DAY = Day.MONDAY;
    private static final Duration DEFAULT_WORK = Duration.getInstance(0, TimeUnit.HOURS);
    private static final Double DEFAULT_WORK2 = new Double(0.0);
    private static final Duration DEFAULT_DURATION = Duration.getInstance(0, TimeUnit.DAYS);
    private static final ScheduleFrom DEFAULT_SCHEDULE_FROM = ScheduleFrom.START;
    private static final Double DEFAULT_PERCENT_COMPLETE = new Double(0.0);
    private static final String DEFAULT_CALENDAR_NAME = "Standard";
    private static final Integer DEFAULT_MINUTES_PER_DAY = new Integer(480);
    private static final Integer DEFAULT_DAYS_PER_MONTH = new Integer(20);
    private static final Integer DEFAULT_MINUTES_PER_WEEK = new Integer(2400);

    ProjectHeader(ProjectFile file) {
        super(file);
        this.setCurrencySymbol("$");
        this.setSymbolPosition(CurrencySymbolPosition.BEFORE);
        this.setCurrencyDigits(new Integer(2));
        this.setThousandsSeparator(',');
        this.setDecimalSeparator('.');
        this.setDateOrder(DateOrder.DMY);
        this.setTimeFormat(ProjectTimeFormat.TWELVE_HOUR);
        this.setIntegerDefaultStartTime(new Integer(480));
        this.setDateSeparator('/');
        this.setTimeSeparator(':');
        this.setAMText("am");
        this.setPMText("pm");
        this.setDateFormat(ProjectDateFormat.DD_MM_YYYY);
        this.setBarTextDateFormat(ProjectDateFormat.DD_MM_YYYY);
        this.setDefaultDurationUnits(TimeUnit.DAYS);
        this.setDefaultDurationIsFixed(false);
        this.setDefaultWorkUnits(TimeUnit.HOURS);
        this.setMinutesPerDay(new Integer(480));
        this.setMinutesPerWeek(new Integer(2400));
        this.setDefaultStandardRate(new Rate(10.0, TimeUnit.HOURS));
        this.setDefaultOvertimeRate(new Rate(15.0, TimeUnit.HOURS));
        this.setUpdatingTaskStatusUpdatesResourceStatus(true);
        this.setSplitInProgressTasks(false);
        this.setProjectTitle("Project1");
        this.setCompany(null);
        this.setManager(null);
        this.setCalendarName(DEFAULT_CALENDAR_NAME);
        this.setStartDate(null);
        this.setFinishDate(null);
        this.setScheduleFrom(DEFAULT_SCHEDULE_FROM);
        this.setCurrentDate(new Date());
        this.setComments(null);
        this.setCost(DEFAULT_COST);
        this.setBaselineCost(DEFAULT_COST);
        this.setActualCost(DEFAULT_COST);
        this.setWork(DEFAULT_WORK);
        this.setBaselineWork(DEFAULT_WORK);
        this.setActualWork(DEFAULT_WORK);
        this.setWork2(DEFAULT_WORK2);
        this.setDuration(DEFAULT_DURATION);
        this.setBaselineDuration(DEFAULT_DURATION);
        this.setActualDuration(DEFAULT_DURATION);
        this.setPercentageComplete(DEFAULT_PERCENT_COMPLETE);
        this.setBaselineStart(null);
        this.setBaselineFinish(null);
        this.setActualStart(null);
        this.setActualFinish(null);
        this.setStartVariance(DEFAULT_DURATION);
        this.setFinishVariance(DEFAULT_DURATION);
        this.setSubject(null);
        this.setAuthor(null);
        this.setKeywords(null);
        this.setProjectExternallyEdited(false);
        this.setMinutesPerDay(DEFAULT_MINUTES_PER_DAY);
        this.setDaysPerMonth(DEFAULT_DAYS_PER_MONTH);
        this.setMinutesPerWeek(DEFAULT_MINUTES_PER_WEEK);
        this.setFiscalYearStart(false);
        this.setDefaultTaskEarnedValueMethod(EarnedValueMethod.PERCENT_COMPLETE);
        this.setNewTasksEstimated(true);
        this.setAutoAddNewResourcesAndTasks(true);
        this.setAutolink(true);
        this.setMicrosoftProjectServerURL(true);
        this.setDefaultTaskType(TaskType.FIXED_UNITS);
        this.setDefaultFixedCostAccrual(AccrueType.END);
        this.setCriticalSlackLimit(DEFAULT_CRITICAL_SLACK_LIMIT);
        this.setBaselineForEarnedValue(DEFAULT_BASELINE_FOR_EARNED_VALUE);
        this.setFiscalYearStartMonth(DEFAULT_FISCAL_YEAR_START_MONTH);
        this.setNewTaskStartIsProjectStart(true);
        this.setWeekStartDay(DEFAULT_WEEK_START_DAY);
    }

    public TimeUnit getDefaultDurationUnits() {
        return this.m_defaultDurationUnits;
    }

    public void setDefaultDurationUnits(TimeUnit units) {
        this.m_defaultDurationUnits = units;
    }

    public boolean getDefaultDurationIsFixed() {
        return this.m_defaultDurationIsFixed;
    }

    public void setDefaultDurationIsFixed(boolean fixed) {
        this.m_defaultDurationIsFixed = fixed;
    }

    public TimeUnit getDefaultWorkUnits() {
        return this.m_defaultWorkUnits;
    }

    public void setDefaultWorkUnits(TimeUnit units) {
        this.m_defaultWorkUnits = units;
    }

    public Rate getDefaultStandardRate() {
        return this.m_defaultStandardRate;
    }

    public void setDefaultStandardRate(Rate rate) {
        this.m_defaultStandardRate = rate;
    }

    public Rate getDefaultOvertimeRate() {
        return this.m_defaultOvertimeRate;
    }

    public void setDefaultOvertimeRate(Rate rate) {
        this.m_defaultOvertimeRate = rate;
    }

    public boolean getUpdatingTaskStatusUpdatesResourceStatus() {
        return this.m_updatingTaskStatusUpdatesResourceStatus;
    }

    public void setUpdatingTaskStatusUpdatesResourceStatus(boolean flag) {
        this.m_updatingTaskStatusUpdatesResourceStatus = flag;
    }

    public boolean getSplitInProgressTasks() {
        return this.m_splitInProgressTasks;
    }

    public void setSplitInProgressTasks(boolean flag) {
        this.m_splitInProgressTasks = flag;
    }

    public DateOrder getDateOrder() {
        return this.m_dateOrder;
    }

    public void setDateOrder(DateOrder dateOrder) {
        this.m_dateOrder = dateOrder;
    }

    public ProjectTimeFormat getTimeFormat() {
        return this.m_timeFormat;
    }

    public void setTimeFormat(ProjectTimeFormat timeFormat) {
        this.m_timeFormat = timeFormat;
    }

    public void setIntegerDefaultStartTime(Integer time) {
        if (time != null) {
            int minutes = time;
            int hours = minutes / 60;
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, minutes -= hours * 60);
            cal.set(11, hours);
            Date date = cal.getTime();
            this.setDefaultStartTime(date);
        }
    }

    public Date getDefaultStartTime() {
        return this.m_defaultStartTime;
    }

    public void setDefaultStartTime(Date defaultStartTime) {
        this.m_defaultStartTime = defaultStartTime;
    }

    public char getDateSeparator() {
        return this.m_dateSeparator;
    }

    public void setDateSeparator(char dateSeparator) {
        this.m_dateSeparator = dateSeparator;
    }

    public char getTimeSeparator() {
        return this.m_timeSeparator;
    }

    public void setTimeSeparator(char timeSeparator) {
        this.m_timeSeparator = timeSeparator;
    }

    public void setTimeSeparator(Character timeSeparator) {
        this.setTimeSeparator(timeSeparator == null ? (char)':' : (char)timeSeparator.charValue());
    }

    public String getAMText() {
        return this.m_amText;
    }

    public void setAMText(String amText) {
        this.m_amText = amText;
    }

    public String getPMText() {
        return this.m_pmText;
    }

    public void setPMText(String pmText) {
        this.m_pmText = pmText;
    }

    public ProjectDateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public void setDateFormat(ProjectDateFormat dateFormat) {
        this.m_dateFormat = dateFormat;
    }

    public ProjectDateFormat getBarTextDateFormat() {
        return this.m_barTextDateFormat;
    }

    public void setBarTextDateFormat(ProjectDateFormat dateFormat) {
        this.m_barTextDateFormat = dateFormat;
    }

    public Date getDefaultEndTime() {
        return this.m_defaultEndTime;
    }

    public void setDefaultEndTime(Date date) {
        this.m_defaultEndTime = date;
    }

    public void setProjectTitle(String projectTitle) {
        this.m_projectTitle = projectTitle;
    }

    public String getProjectTitle() {
        return this.m_projectTitle;
    }

    public void setCompany(String company) {
        this.m_company = company;
    }

    public String getCompany() {
        return this.m_company;
    }

    public void setManager(String manager) {
        this.m_manager = manager;
    }

    public String getManager() {
        return this.m_manager;
    }

    public void setCalendarName(String calendarName) {
        if (calendarName == null || calendarName.length() == 0) {
            calendarName = DEFAULT_CALENDAR_NAME;
        }
        this.m_calendarName = calendarName;
    }

    public String getCalendarName() {
        return this.m_calendarName;
    }

    public void setStartDate(Date startDate) {
        this.m_startDate = startDate;
    }

    public Date getStartDate() {
        Date result = this.m_startDate;
        if (result == null) {
            result = this.getParentFile().getStartDate();
        }
        return result;
    }

    public Date getFinishDate() {
        Date result = this.m_finishDate;
        if (result == null) {
            result = this.getParentFile().getFinishDate();
        }
        return result;
    }

    public void setFinishDate(Date finishDate) {
        this.m_finishDate = finishDate;
    }

    public ScheduleFrom getScheduleFrom() {
        return this.m_scheduleFrom;
    }

    public void setScheduleFrom(ScheduleFrom scheduleFrom) {
        this.m_scheduleFrom = scheduleFrom;
    }

    public Date getCurrentDate() {
        return this.m_currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.m_currentDate = currentDate;
    }

    public String getComments() {
        return this.m_comments;
    }

    public void setComments(String comments) {
        this.m_comments = comments;
    }

    public Number getCost() {
        return this.m_cost;
    }

    public void setCost(Number cost) {
        this.m_cost = cost;
    }

    public void setBaselineCost(Number baselineCost) {
        this.m_baselineCost = baselineCost;
    }

    public Number getBaselineCost() {
        return this.m_baselineCost;
    }

    public void setActualCost(Number actualCost) {
        this.m_actualCost = actualCost;
    }

    public Number getActualCost() {
        return this.m_actualCost;
    }

    public void setWork(Duration work) {
        this.m_work = work;
    }

    public Duration getWork() {
        return this.m_work;
    }

    public void setBaselineWork(Duration baselineWork) {
        this.m_baselineWork = baselineWork;
    }

    public Duration getBaselineWork() {
        return this.m_baselineWork;
    }

    public void setActualWork(Duration actualWork) {
        this.m_actualWork = actualWork;
    }

    public Duration getActualWork() {
        return this.m_actualWork;
    }

    public Number getWork2() {
        return this.m_work2;
    }

    public void setWork2(Number work2) {
        this.m_work2 = work2;
    }

    public Duration getDuration() {
        return this.m_duration;
    }

    public void setDuration(Duration duration) {
        this.m_duration = duration;
    }

    public Duration getBaselineDuration() {
        return this.m_baselineDuration;
    }

    public void setBaselineDuration(Duration baselineDuration) {
        this.m_baselineDuration = baselineDuration;
    }

    public Duration getActualDuration() {
        return this.m_actualDuration;
    }

    public void setActualDuration(Duration actualDuration) {
        this.m_actualDuration = actualDuration;
    }

    public Number getPercentageComplete() {
        return this.m_percentageComplete;
    }

    public void setPercentageComplete(Number percentComplete) {
        this.m_percentageComplete = percentComplete;
    }

    public void setBaselineStart(Date baselineStartDate) {
        this.m_baselineStart = baselineStartDate;
    }

    public Date getBaselineStart() {
        return this.m_baselineStart;
    }

    public void setBaselineFinish(Date baselineFinishDate) {
        this.m_baselineFinish = baselineFinishDate;
    }

    public Date getBaselineFinish() {
        return this.m_baselineFinish;
    }

    public void setActualStart(Date actualStartDate) {
        this.m_actualStart = actualStartDate;
    }

    public Date getActualStart() {
        return this.m_actualStart;
    }

    public void setActualFinish(Date actualFinishDate) {
        this.m_actualFinish = actualFinishDate;
    }

    public Date getActualFinish() {
        return this.m_actualFinish;
    }

    public Duration getStartVariance() {
        return this.m_startVariance;
    }

    public void setStartVariance(Duration startVariance) {
        this.m_startVariance = startVariance;
    }

    public Duration getFinishVariance() {
        return this.m_finishVariance;
    }

    public void setFinishVariance(Duration finishVariance) {
        this.m_finishVariance = finishVariance;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    public String getAuthor() {
        return this.m_author;
    }

    public void setAuthor(String author) {
        this.m_author = author;
    }

    public String getKeywords() {
        return this.m_keywords;
    }

    public void setKeywords(String keywords) {
        this.m_keywords = keywords;
    }

    public void setCurrencySymbol(String symbol) {
        if (symbol == null) {
            symbol = "$";
        }
        this.m_currencySymbol = symbol;
    }

    public String getCurrencySymbol() {
        return this.m_currencySymbol;
    }

    public void setSymbolPosition(CurrencySymbolPosition posn) {
        this.m_symbolPosition = posn;
    }

    public CurrencySymbolPosition getSymbolPosition() {
        return this.m_symbolPosition;
    }

    public void setCurrencyDigits(Number currDigs) {
        this.m_currencyDigits = currDigs;
    }

    public Number getCurrencyDigits() {
        return this.m_currencyDigits;
    }

    public void setThousandsSeparator(char sep) {
        this.m_thousandsSeparator = sep;
    }

    public char getThousandsSeparator() {
        return this.m_thousandsSeparator;
    }

    public void setDecimalSeparator(char decSep) {
        this.m_decimalSeparator = decSep;
    }

    public char getDecimalSeparator() {
        return this.m_decimalSeparator;
    }

    public boolean getProjectExternallyEdited() {
        return this.m_projectExternallyEdited;
    }

    public void setProjectExternallyEdited(boolean projectExternallyEdited) {
        this.m_projectExternallyEdited = projectExternallyEdited;
    }

    public String getCategory() {
        return this.m_category;
    }

    public void setCategory(String category) {
        this.m_category = category;
    }

    public Number getDaysPerMonth() {
        return this.m_daysPerMonth;
    }

    public void setDaysPerMonth(Number daysPerMonth) {
        if (daysPerMonth != null) {
            this.m_daysPerMonth = daysPerMonth;
        }
    }

    public Number getMinutesPerDay() {
        return this.m_minutesPerDay;
    }

    public void setMinutesPerDay(Number minutesPerDay) {
        if (minutesPerDay != null) {
            this.m_minutesPerDay = minutesPerDay;
        }
    }

    public Number getMinutesPerWeek() {
        return this.m_minutesPerWeek;
    }

    public void setMinutesPerWeek(Number minutesPerWeek) {
        if (minutesPerWeek != null) {
            this.m_minutesPerWeek = minutesPerWeek;
        }
    }

    public boolean getFiscalYearStart() {
        return this.m_fiscalYearStart;
    }

    public void setFiscalYearStart(boolean fiscalYearStart) {
        this.m_fiscalYearStart = fiscalYearStart;
    }

    public EarnedValueMethod getDefaultTaskEarnedValueMethod() {
        return this.m_defaultTaskEarnedValueMethod;
    }

    public void setDefaultTaskEarnedValueMethod(EarnedValueMethod defaultTaskEarnedValueMethod) {
        this.m_defaultTaskEarnedValueMethod = defaultTaskEarnedValueMethod;
    }

    public boolean getRemoveFileProperties() {
        return this.m_removeFileProperties;
    }

    public void setRemoveFileProperties(boolean removeFileProperties) {
        this.m_removeFileProperties = removeFileProperties;
    }

    public boolean getMoveCompletedEndsBack() {
        return this.m_moveCompletedEndsBack;
    }

    public void setMoveCompletedEndsBack(boolean moveCompletedEndsBack) {
        this.m_moveCompletedEndsBack = moveCompletedEndsBack;
    }

    public boolean getNewTasksEstimated() {
        return this.m_newTasksEstimated;
    }

    public void setNewTasksEstimated(boolean newTasksEstimated) {
        this.m_newTasksEstimated = newTasksEstimated;
    }

    public boolean getSpreadActualCost() {
        return this.m_spreadActualCost;
    }

    public void setSpreadActualCost(boolean spreadActualCost) {
        this.m_spreadActualCost = spreadActualCost;
    }

    public boolean getMultipleCriticalPaths() {
        return this.m_multipleCriticalPaths;
    }

    public void setMultipleCriticalPaths(boolean multipleCriticalPaths) {
        this.m_multipleCriticalPaths = multipleCriticalPaths;
    }

    public boolean getAutoAddNewResourcesAndTasks() {
        return this.m_autoAddNewResourcesAndTasks;
    }

    public void setAutoAddNewResourcesAndTasks(boolean autoAddNewResourcesAndTasks) {
        this.m_autoAddNewResourcesAndTasks = autoAddNewResourcesAndTasks;
    }

    public Date getLastSaved() {
        return this.m_lastSaved;
    }

    public void setLastSaved(Date lastSaved) {
        this.m_lastSaved = lastSaved;
    }

    public Date getStatusDate() {
        return this.m_statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.m_statusDate = statusDate;
    }

    public boolean getMoveRemainingStartsBack() {
        return this.m_moveRemainingStartsBack;
    }

    public void setMoveRemainingStartsBack(boolean moveRemainingStartsBack) {
        this.m_moveRemainingStartsBack = moveRemainingStartsBack;
    }

    public boolean getAutolink() {
        return this.m_autolink;
    }

    public void setAutolink(boolean autolink) {
        this.m_autolink = autolink;
    }

    public boolean getMicrosoftProjectServerURL() {
        return this.m_microsoftProjectServerURL;
    }

    public void setMicrosoftProjectServerURL(boolean microsoftProjectServerURL) {
        this.m_microsoftProjectServerURL = microsoftProjectServerURL;
    }

    public boolean getHonorConstraints() {
        return this.m_honorConstraints;
    }

    public void setHonorConstraints(boolean honorConstraints) {
        this.m_honorConstraints = honorConstraints;
    }

    public boolean getAdminProject() {
        return this.m_adminProject;
    }

    public void setAdminProject(boolean adminProject) {
        this.m_adminProject = adminProject;
    }

    public boolean getInsertedProjectsLikeSummary() {
        return this.m_insertedProjectsLikeSummary;
    }

    public void setInsertedProjectsLikeSummary(boolean insertedProjectsLikeSummary) {
        this.m_insertedProjectsLikeSummary = insertedProjectsLikeSummary;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public boolean getSpreadPercentComplete() {
        return this.m_spreadPercentComplete;
    }

    public void setSpreadPercentComplete(boolean spreadPercentComplete) {
        this.m_spreadPercentComplete = spreadPercentComplete;
    }

    public boolean getMoveCompletedEndsForward() {
        return this.m_moveCompletedEndsForward;
    }

    public void setMoveCompletedEndsForward(boolean moveCompletedEndsForward) {
        this.m_moveCompletedEndsForward = moveCompletedEndsForward;
    }

    public boolean getEditableActualCosts() {
        return this.m_editableActualCosts;
    }

    public void setEditableActualCosts(boolean editableActualCosts) {
        this.m_editableActualCosts = editableActualCosts;
    }

    public String getUniqueID() {
        return this.m_uniqueID;
    }

    public void setUniqueID(String uniqueID) {
        this.m_uniqueID = uniqueID;
    }

    public Integer getRevision() {
        return this.m_revision;
    }

    public boolean getNewTasksEffortDriven() {
        return this.m_newTasksEffortDriven;
    }

    public void setNewTasksEffortDriven(boolean newTasksEffortDriven) {
        this.m_newTasksEffortDriven = newTasksEffortDriven;
    }

    public void setRevision(Integer revision) {
        this.m_revision = revision;
    }

    public boolean getMoveRemainingStartsForward() {
        return this.m_moveRemainingStartsForward;
    }

    public void setMoveRemainingStartsForward(boolean moveRemainingStartsForward) {
        this.m_moveRemainingStartsForward = moveRemainingStartsForward;
    }

    public boolean getActualsInSync() {
        return this.m_actualsInSync;
    }

    public void setActualsInSync(boolean actualsInSync) {
        this.m_actualsInSync = actualsInSync;
    }

    public TaskType getDefaultTaskType() {
        return this.m_defaultTaskType;
    }

    public void setDefaultTaskType(TaskType defaultTaskType) {
        this.m_defaultTaskType = defaultTaskType;
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return this.m_earnedValueMethod;
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.m_earnedValueMethod = earnedValueMethod;
    }

    public Date getCreationDate() {
        return this.m_creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.m_creationDate = creationDate;
    }

    public Date getExtendedCreationDate() {
        return this.m_extendedCreationDate;
    }

    public AccrueType getDefaultFixedCostAccrual() {
        return this.m_defaultFixedCostAccrual;
    }

    public void setDefaultFixedCostAccrual(AccrueType defaultFixedCostAccrual) {
        this.m_defaultFixedCostAccrual = defaultFixedCostAccrual;
    }

    public void setExtendedCreationDate(Date creationDate) {
        this.m_extendedCreationDate = creationDate;
    }

    public Integer getCriticalSlackLimit() {
        return this.m_criticalSlackLimit;
    }

    public void setCriticalSlackLimit(Integer criticalSlackLimit) {
        this.m_criticalSlackLimit = criticalSlackLimit;
    }

    public Integer getBaselineForEarnedValue() {
        return this.m_baselineForEarnedValue;
    }

    public void setBaselineForEarnedValue(Integer baselineForEarnedValue) {
        this.m_baselineForEarnedValue = baselineForEarnedValue;
    }

    public Integer getFiscalYearStartMonth() {
        return this.m_fiscalYearStartMonth;
    }

    public void setFiscalYearStartMonth(Integer fiscalYearStartMonth) {
        this.m_fiscalYearStartMonth = fiscalYearStartMonth;
    }

    public boolean getNewTaskStartIsProjectStart() {
        return this.m_newTaskStartIsProjectStart;
    }

    public void setNewTaskStartIsProjectStart(boolean newTaskStartIsProjectStart) {
        this.m_newTaskStartIsProjectStart = newTaskStartIsProjectStart;
    }

    public Day getWeekStartDay() {
        return this.m_weekStartDay;
    }

    public void setWeekStartDay(Day weekStartDay) {
        this.m_weekStartDay = weekStartDay;
    }

    public void setCalculateMultipleCriticalPaths(boolean flag) {
        this.m_calculateMultipleCriticalPaths = flag;
    }

    public boolean getCalculateMultipleCriticalPaths() {
        return this.m_calculateMultipleCriticalPaths;
    }

    public void setDocumentSummaryInformation(Map<Integer, Object> documentSummaryInformation) {
        this.m_documentSummaryInformation = documentSummaryInformation;
    }

    public Map<Integer, Object> getDocumentSummaryInformation() {
        return this.m_documentSummaryInformation;
    }
}

