/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

import ch.randelshofer.quaqua.util.Preferences;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;

public class Images {
    private static GraphiteFilter graphiteFilter;
    private static Properties canGraphite;

    private Images() {
    }

    private static GraphiteFilter getGraphiteFilter() {
        if (graphiteFilter == null) {
            graphiteFilter = new GraphiteFilter();
        }
        return graphiteFilter;
    }

    public static Image createImage(Class baseClass, String location) {
        return Images.createImage(baseClass.getResource(location));
    }

    public static Image createImage(URL resource) {
        Image image = Toolkit.getDefaultToolkit().createImage(resource);
        if (Preferences.getString("AppleAquaColorVariant").equals("6") && Images.canGraphite(resource)) {
            image = Images.toGraphite(image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canGraphite(URL resource) {
        String file;
        int i;
        if (canGraphite == null) {
            Class clazz = Images.class;
            synchronized (clazz) {
                if (canGraphite == null) {
                    Properties p = new Properties();
                    try {
                        p.load(Images.class.getResourceAsStream("graphiteable.properties"));
                    }
                    catch (IOException e) {
                        System.err.println("Failed to load graphiteable.properties: " + e);
                    }
                    canGraphite = p;
                }
            }
        }
        if ((i = (file = resource.getFile()).lastIndexOf(File.separatorChar)) != -1) {
            file = file.substring(i + 1);
        }
        return canGraphite.containsKey(file);
    }

    private static Image toGraphite(Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), Images.getGraphiteFilter()));
    }

    public static BufferedImage toBufferedImage(RenderedImage rImg) {
        BufferedImage image;
        if (rImg instanceof BufferedImage) {
            image = (BufferedImage)rImg;
        } else {
            Raster r = rImg.getData();
            WritableRaster wr = WritableRaster.createWritableRaster(r.getSampleModel(), null);
            rImg.copyData(wr);
            image = new BufferedImage(rImg.getColorModel(), wr, rImg.getColorModel().isAlphaPremultiplied(), null);
        }
        return image;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = null;
        if (System.getProperty("java.version").startsWith("1.4.1_")) {
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        } else {
            boolean hasAlpha;
            try {
                hasAlpha = Images.hasAlpha(image);
            }
            catch (IllegalAccessError e) {
                hasAlpha = true;
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                int transparency = 1;
                if (hasAlpha) {
                    transparency = 3;
                }
                GraphicsDevice gs = ge.getDefaultScreenDevice();
                GraphicsConfiguration gc = gs.getDefaultConfiguration();
                bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (bimage == null) {
                int type = 1;
                if (hasAlpha) {
                    type = 2;
                }
                bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
            }
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage[] split(Image image, int count, boolean isHorizontal) {
        BufferedImage src = Images.toBufferedImage(image);
        if (count == 1) {
            return new BufferedImage[]{src};
        }
        BufferedImage[] parts = new BufferedImage[count];
        for (int i = 0; i < count; ++i) {
            parts[i] = isHorizontal ? src.getSubimage(src.getWidth() / count * i, 0, src.getWidth() / count, src.getHeight()) : src.getSubimage(0, src.getHeight() / count * i, src.getWidth(), src.getHeight() / count);
        }
        return parts;
    }

    public static class GraphiteFilter
    extends RGBImageFilter {
        private static final float saturationAdjust = 0.179f;
        private static float hueAdjust = 0.0052f;
        private static float brightnessAdjust = 0.09f;
        private float[] hsb = new float[3];

        public int filterRGB(int x, int y, int rgb) {
            int alpha = rgb & 0xFF000000;
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb & 0xFF;
            float RW = 0.273393f;
            float RG = 0.273393f;
            float RB = 0.273393f;
            float a = RW + 0.179f;
            float b = RW;
            float c = RW;
            float d = RG;
            float e = RG + 0.179f;
            float f = RG;
            float g = RB;
            float h = RB;
            float i = RB + 0.179f;
            int outputRed = (int)(a * (float)red + d * (float)green + g * (float)blue);
            int outputGreen = (int)(b * (float)red + e * (float)green + h * (float)blue);
            int outputBlue = (int)(c * (float)red + f * (float)green + i * (float)blue);
            return alpha | outputRed << 16 | outputGreen << 8 | outputBlue;
        }
    }
}

