/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.color.InactivatableColorUIResource;
import ch.randelshofer.quaqua.util.ViewportPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class QuaquaTableUI
extends BasicTableUI
implements ViewportPainter {
    private PropertyChangeListener propertyChangeListener;
    private ListSelectionListener listSelectionListener;
    private TableColumnModelListener columnModelListener;
    private Handler handler;
    private boolean isStriped = false;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaTableUI();
    }

    protected KeyListener createKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 157) {
                    e.consume();
                }
            }
        };
    }

    private Color getAlternateColor(int modulo) {
        if (modulo == 0) {
            return UIManager.getColor("Table.alternateBackground.0");
        }
        return UIManager.getColor("Table.alternateBackground.1");
    }

    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.table.addPropertyChangeListener(this.propertyChangeListener);
        this.listSelectionListener = this.createListSelectionListener();
        if (this.table.getSelectionModel() != null) {
            this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        }
        this.columnModelListener = this.createTableColumnModelListener();
        if (this.table.getColumnModel() != null) {
            this.table.getColumnModel().addColumnModelListener(this.columnModelListener);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        if (this.table.getSelectionModel() != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
        }
        if (this.table.getColumnModel() != null) {
            this.table.getColumnModel().removeColumnModelListener(this.columnModelListener);
        }
        this.propertyChangeListener = null;
        this.listSelectionListener = null;
    }

    protected void installDefaults() {
        super.installDefaults();
        Object property = this.table.getClientProperty("Quaqua.Table.style");
        this.isStriped = property != null && property.equals("striped");
        this.updateStriped();
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    private void updateStriped() {
    }

    public void paint(Graphics g, JComponent c) {
        boolean ltr;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        int cMin = this.table.columnAtPoint((ltr = this.table.getComponentOrientation().isLeftToRight()) ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        this.paintCells(g, rMin, rMax, cMin, cMax);
        this.paintGrid(g, rMin, rMax, cMin, cMax);
    }

    public void paintViewport(Graphics g, JViewport c) {
        int y;
        Dimension vs = c.getSize();
        Dimension ts = this.table.getSize();
        Point p = this.table.getLocation();
        int rh = this.table.getRowHeight();
        int n = this.table.getRowCount();
        int row = Math.abs(p.y / rh);
        int th = n * rh - row * rh;
        if (this.isStriped) {
            g.setColor(this.getAlternateColor(1));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            g.setColor(this.getAlternateColor(0));
            if (ts.width < vs.width) {
                int ymax = Math.min(th, vs.height);
                for (y = p.y + row * rh; y < ymax; y += rh) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    ++row;
                }
            }
            if (th < vs.height) {
                row = n;
                y = th;
                while (y < vs.height) {
                    if (row % 2 == 0) {
                        g.fillRect(0, y, vs.width, rh);
                    }
                    y += rh;
                    ++row;
                }
            }
        } else {
            g.setColor(this.table.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (this.table.getShowHorizontalLines()) {
            g.setColor(this.table.getGridColor());
            if (ts.width < vs.width) {
                row = Math.abs(p.y / rh);
                for (y = p.y + row * rh + rh - 1; y < th; y += rh) {
                    g.drawLine(0, y, vs.width, y);
                }
            }
            if (th < vs.height) {
                for (y = th + rh - 1; y < vs.height; y += rh) {
                    g.drawLine(0, y, vs.width, y);
                }
            }
        }
        if (th < vs.height && this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            TableColumnModel cm = this.table.getColumnModel();
            n = cm.getColumnCount();
            int y2 = th;
            int x = this.table.getX() - 1;
            for (int i = 0; i < n; ++i) {
                TableColumn col = cm.getColumn(i);
                g.drawLine(x += col.getWidth(), y2, x, vs.height);
            }
        }
    }

    private void paintGrid(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        g.setColor(this.table.getGridColor());
        Rectangle minCell = this.table.getCellRect(rMin, cMin, true);
        Rectangle maxCell = this.table.getCellRect(rMax, cMax, true);
        Rectangle damagedArea = minCell.union(maxCell);
        if (this.table.getShowHorizontalLines()) {
            int tableWidth = damagedArea.x + damagedArea.width;
            int y = damagedArea.y;
            for (int row = rMin; row <= rMax; ++row) {
                g.drawLine(damagedArea.x, (y += this.table.getRowHeight(row)) - 1, tableWidth - 1, y - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            Rectangle vacatedColumnRect;
            TableColumn draggedColumn;
            JTableHeader header = this.table.getTableHeader();
            TableColumn tableColumn = draggedColumn = header == null ? null : header.getDraggedColumn();
            if (draggedColumn != null) {
                int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
                Rectangle minDraggedCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
                Rectangle maxDraggedCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
                vacatedColumnRect = minDraggedCell.union(maxDraggedCell);
                vacatedColumnRect.x += header.getDraggedDistance();
            } else {
                vacatedColumnRect = new Rectangle(0, 0, -1, -1);
            }
            TableColumnModel cm = this.table.getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                int x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    if ((x += w) >= vacatedColumnRect.x && x <= vacatedColumnRect.x + vacatedColumnRect.width) continue;
                    g.drawLine(x - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                int x = damagedArea.x + damagedArea.width;
                for (int column = cMin; column < cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    if ((x -= w) >= vacatedColumnRect.x && x <= vacatedColumnRect.x + vacatedColumnRect.width) continue;
                    g.drawLine(x - 1, 0, x - 1, tableHeight - 1);
                }
                g.drawLine(x -= cm.getColumn(cMax).getWidth(), 0, x, tableHeight - 1);
            }
        }
    }

    private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
        int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
        Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
        Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
        Rectangle vacatedColumnRect = minCell.union(maxCell);
        g.setColor(this.table.getParent().getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        vacatedColumnRect.x += distance;
        g.setColor(this.table.getBackground());
        g.fillRect(vacatedColumnRect.x, vacatedColumnRect.y, vacatedColumnRect.width, vacatedColumnRect.height);
        if (this.table.getShowVerticalLines()) {
            g.setColor(this.table.getGridColor());
            int x1 = vacatedColumnRect.x;
            int y1 = vacatedColumnRect.y;
            int x2 = x1 + vacatedColumnRect.width - 1;
            int y2 = y1 + vacatedColumnRect.height - 1;
            g.drawLine(x1 - 1, y1, x1 - 1, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        boolean isFocused = this.isFocused();
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = this.table.getCellRect(row, draggedColumnIndex, false);
            r.x += distance;
            this.paintCell(g, r, row, draggedColumnIndex, isFocused);
            if (!this.table.getShowHorizontalLines()) continue;
            g.setColor(this.table.getGridColor());
            Rectangle rcr = this.table.getCellRect(row, draggedColumnIndex, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g.drawLine(x1, y2, x2, y2);
        }
    }

    private int viewIndexForColumn(TableColumn aColumn) {
        TableColumnModel cm = this.table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }

    private boolean isFocused() {
        return this.table.isEditing() || QuaquaUtilities.isFocused(this.table);
    }

    private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        boolean isFocused = this.isFocused();
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column, isFocused);
                    }
                    cellRect.x += columnWidth;
                }
            }
        } else {
            for (int row = rMin; row <= rMax; ++row) {
                int columnWidth;
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, row, cMin, isFocused);
                }
                for (int column = cMin + 1; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn == draggedColumn) continue;
                    this.paintCell(g, cellRect, row, column, isFocused);
                }
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column, boolean isFocused) {
        Color background = UIManager.getColor("Table.selectionBackground");
        Color foreground = UIManager.getColor("Table.selectionForeground");
        if (background instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)background).setActive(isFocused && (this.table.getRowSelectionAllowed() || this.table.getColumnSelectionAllowed()));
        }
        if (foreground instanceof InactivatableColorUIResource) {
            ((InactivatableColorUIResource)foreground).setActive(isFocused && (this.table.getRowSelectionAllowed() || this.table.getColumnSelectionAllowed()) && this.table.isCellSelected(row, column));
        }
        Dimension spacing = this.table.getIntercellSpacing();
        if (this.table.getShowHorizontalLines()) {
            --spacing.height;
        }
        if (this.table.getShowVerticalLines()) {
            --spacing.width;
        }
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setFont(this.table.getFont());
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            if (this.isStriped) {
                g.setColor(this.getAlternateColor(row % 2));
                g.fillRect(cellRect.x - spacing.width, cellRect.y, cellRect.width + spacing.width * 2, cellRect.height + spacing.height);
            }
            if (this.table.isCellSelected(row, column)) {
                g.setColor(background);
                g.fillRect(cellRect.x - spacing.width, cellRect.y, cellRect.width + spacing.width * 2, cellRect.height);
            }
            if (component instanceof UIResource && component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
            }
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
        if (!isFocused) {
            if (background instanceof InactivatableColorUIResource) {
                ((InactivatableColorUIResource)background).setActive(true);
            }
            if (foreground instanceof InactivatableColorUIResource) {
                ((InactivatableColorUIResource)foreground).setActive(true);
            }
        }
    }

    protected MouseInputListener createMouseInputListener() {
        if (QuaquaManager.getProperty("Quaqua.Table.useJ2SE5MouseHandler", "false").equals("true") || QuaquaManager.getProperty("java.version").startsWith("1.4") || QuaquaManager.getProperty("java.version").startsWith("1.5")) {
            return new MouseHandler();
        }
        return super.createMouseInputListener();
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private ListSelectionListener createListSelectionListener() {
        return this.getHandler();
    }

    private TableColumnModelListener createTableColumnModelListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        private void repaintSelection() {
            int[] rows = QuaquaTableUI.this.table.getSelectedRows();
            Object dirtyRect = null;
            for (int r = 0; r < rows.length; ++r) {
                int n = QuaquaTableUI.this.table.getColumnCount();
                for (int c = 0; c < n; ++c) {
                    QuaquaTableUI.this.table.repaint(QuaquaTableUI.this.table.getCellRect(rows[r], c, false));
                }
            }
        }

        public void focusGained(FocusEvent e) {
            this.repaintSelection();
        }

        public void focusLost(FocusEvent e) {
            this.repaintSelection();
        }
    }

    public class MouseHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean selectedOnPress;
        private boolean mouseReleaseDeselects;
        private static final int MOUSE_DRAG_DOES_NOTHING = 0;
        private static final int MOUSE_DRAG_SELECTS = 1;
        private static final int MOUSE_DRAG_TOGGLES_SELECTION = 2;
        private int mouseDragAction;
        private int toggledRow = -1;
        private int toggledColumn = -1;

        public void mouseClicked(MouseEvent e) {
        }

        private void setDispatchComponent(MouseEvent e) {
            Component editorComponent = QuaquaTableUI.this.table.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(QuaquaTableUI.this.table, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !QuaquaTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(QuaquaTableUI.this.table, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        private void setValueIsAdjusting(boolean flag) {
            QuaquaTableUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
            QuaquaTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        private boolean shouldIgnore(MouseEvent e) {
            return e.isConsumed() || !SwingUtilities.isLeftMouseButton(e) || !QuaquaTableUI.this.table.isEnabled() || e.isPopupTrigger() && (QuaquaTableUI.this.table.rowAtPoint(e.getPoint()) == -1 || QuaquaTableUI.this.table.isRowSelected(QuaquaTableUI.this.table.rowAtPoint(e.getPoint())));
        }

        public void mousePressed(MouseEvent e) {
            this.mouseDragAction = 0;
            this.mouseReleaseDeselects = false;
            this.toggledColumn = -1;
            this.toggledRow = -1;
            Point p = e.getPoint();
            int row = QuaquaTableUI.this.table.rowAtPoint(p);
            int column = QuaquaTableUI.this.table.columnAtPoint(p);
            if (QuaquaTableUI.this.table.editCellAt(row, column, e)) {
                this.setDispatchComponent(e);
                this.repostEvent(e);
            }
            QuaquaTableUI.this.table.requestFocusInWindow();
            if (!(row == -1 || column == -1 || QuaquaTableUI.this.table.isRowSelected(row) && e.isPopupTrigger())) {
                int anchorIndex = QuaquaTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
                String javaVersion = System.getProperty("java.version");
                if (javaVersion.startsWith("1.4") && (e.getModifiersEx() & 0x900) == 256 || !javaVersion.startsWith("1.4") && (e.getModifiersEx() & 0x1900) == 256) {
                    QuaquaTableUI.this.table.changeSelection(row, column, true, false);
                    this.toggledRow = row;
                    this.toggledColumn = column;
                    this.mouseDragAction = 2;
                } else if ((e.getModifiersEx() & 0x1840) == 64 && anchorIndex != -1) {
                    QuaquaTableUI.this.table.changeSelection(row, column, false, true);
                    this.mouseDragAction = 1;
                } else if ((e.getModifiersEx() & 0x140) == 0) {
                    if (QuaquaTableUI.this.table.isCellSelected(row, column)) {
                        this.mouseReleaseDeselects = QuaquaTableUI.this.table.isFocusOwner();
                    } else {
                        QuaquaTableUI.this.table.changeSelection(row, column, false, false);
                        this.mouseDragAction = 1;
                    }
                }
            }
            QuaquaTableUI.this.table.getSelectionModel().setValueIsAdjusting(this.mouseDragAction != 0);
        }

        public void mouseReleased(MouseEvent e) {
            this.repostEvent(e);
            this.mouseDragAction = 0;
            if (this.mouseReleaseDeselects) {
                int row = QuaquaTableUI.this.table.rowAtPoint(e.getPoint());
                int column = QuaquaTableUI.this.table.columnAtPoint(e.getPoint());
                QuaquaTableUI.this.table.changeSelection(row, column, false, false);
            }
            QuaquaTableUI.this.table.getSelectionModel().setValueIsAdjusting(false);
            if (QuaquaTableUI.this.table.isRequestFocusEnabled() && !QuaquaTableUI.this.table.isEditing()) {
                QuaquaTableUI.this.table.requestFocus();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            TableCellEditor editor = QuaquaTableUI.this.table.getCellEditor();
            if (editor == null || editor.shouldSelectCell(e)) {
                this.mouseReleaseDeselects = false;
                if (this.mouseDragAction == 1) {
                    int row = QuaquaTableUI.this.table.rowAtPoint(e.getPoint());
                    int column = QuaquaTableUI.this.table.columnAtPoint(e.getPoint());
                    if (row != -1 && column != -1) {
                        Rectangle cellBounds = QuaquaTableUI.this.table.getCellRect(row, column, true);
                        QuaquaTableUI.this.table.scrollRectToVisible(cellBounds);
                        QuaquaTableUI.this.table.changeSelection(row, column, false, true);
                    }
                } else if (this.mouseDragAction == 2) {
                    int row = QuaquaTableUI.this.table.rowAtPoint(e.getPoint());
                    int column = QuaquaTableUI.this.table.columnAtPoint(e.getPoint());
                    boolean isCellSelection = QuaquaTableUI.this.table.getCellSelectionEnabled();
                    if (row != -1 && column != -1 && (!isCellSelection && row != this.toggledRow || isCellSelection && (row != this.toggledRow || column != this.toggledColumn))) {
                        Rectangle cellBounds = QuaquaTableUI.this.table.getCellRect(row, column, true);
                        QuaquaTableUI.this.table.scrollRectToVisible(cellBounds);
                        QuaquaTableUI.this.table.changeSelection(row, column, true, false);
                        this.toggledRow = row;
                        this.toggledColumn = column;
                    }
                }
            }
        }
    }

    private class Handler
    implements PropertyChangeListener,
    ListSelectionListener,
    TableColumnModelListener {
        private boolean rowSelectionAdjusting;

        private Handler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String name = event.getPropertyName();
            if (name.equals("Quaqua.Table.style")) {
                Object value = event.getNewValue();
                QuaquaTableUI.this.isStriped = value != null && value.equals("striped");
                QuaquaTableUI.this.updateStriped();
            } else if (name.equals("showVerticalLines") || name.equals("showHorizontalLines")) {
                if (QuaquaTableUI.this.table.getParent() instanceof JViewport) {
                    QuaquaTableUI.this.table.getParent().repaint();
                }
            } else if (name.equals("selectionModel")) {
                if (event.getOldValue() != null) {
                    ((ListSelectionModel)event.getOldValue()).removeListSelectionListener(QuaquaTableUI.this.listSelectionListener);
                }
                if (event.getNewValue() != null) {
                    ((ListSelectionModel)event.getNewValue()).addListSelectionListener(QuaquaTableUI.this.listSelectionListener);
                }
            } else if (name.equals("columnModel")) {
                if (event.getOldValue() != null) {
                    ((TableColumnModel)event.getOldValue()).removeColumnModelListener(QuaquaTableUI.this.columnModelListener);
                }
                if (event.getNewValue() != null) {
                    ((TableColumnModel)event.getNewValue()).addColumnModelListener(QuaquaTableUI.this.columnModelListener);
                }
            } else if (name.equals("tableCellEditor")) {
                QuaquaTableUI.this.table.repaint();
            } else if (name.equals("JComponent.sizeVariant")) {
                QuaquaUtilities.applySizeVariant(QuaquaTableUI.this.table);
            }
        }

        public void columnAdded(TableColumnModelEvent e) {
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        private int getAdjustedIndex(int index, boolean row) {
            int compare = row ? QuaquaTableUI.this.table.getRowCount() : QuaquaTableUI.this.table.getColumnCount();
            return index < compare ? index : -1;
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
            ListSelectionModel selectionModel = QuaquaTableUI.this.table.getSelectionModel();
            int firstIndex = this.limit(e.getFirstIndex(), 0, QuaquaTableUI.this.table.getColumnCount() - 1);
            int lastIndex = this.limit(e.getLastIndex(), 0, QuaquaTableUI.this.table.getColumnCount() - 1);
            int minRow = 0;
            int maxRow = QuaquaTableUI.this.table.getRowCount() - 1;
            if (QuaquaTableUI.this.table.getRowSelectionAllowed()) {
                minRow = selectionModel.getMinSelectionIndex();
                maxRow = selectionModel.getMaxSelectionIndex();
                int leadRow = this.getAdjustedIndex(selectionModel.getLeadSelectionIndex(), true);
                if (minRow == -1 || maxRow == -1) {
                    if (leadRow == -1) {
                        return;
                    }
                    minRow = maxRow = leadRow;
                } else if (leadRow != -1) {
                    minRow = Math.min(minRow, leadRow);
                    maxRow = Math.max(maxRow, leadRow);
                }
            }
            Rectangle firstColumnRect = QuaquaTableUI.this.table.getCellRect(minRow, firstIndex, false);
            Rectangle lastColumnRect = QuaquaTableUI.this.table.getCellRect(maxRow, lastIndex, false);
            Rectangle dirtyRegion = firstColumnRect.union(lastColumnRect);
            Dimension intercellSpacing = QuaquaTableUI.this.table.getIntercellSpacing();
            if (intercellSpacing != null) {
                dirtyRegion.width += ((QuaquaTableUI)QuaquaTableUI.this).table.getIntercellSpacing().width;
            }
            QuaquaTableUI.this.table.repaint(dirtyRegion);
        }

        public void valueChanged(ListSelectionEvent e) {
            boolean isAdjusting = e.getValueIsAdjusting();
            if (this.rowSelectionAdjusting && !isAdjusting) {
                this.rowSelectionAdjusting = false;
                return;
            }
            this.rowSelectionAdjusting = isAdjusting;
            if (QuaquaTableUI.this.table.getRowCount() <= 0 || QuaquaTableUI.this.table.getColumnCount() <= 0) {
                return;
            }
            int firstIndex = this.limit(e.getFirstIndex(), 0, QuaquaTableUI.this.table.getRowCount() - 1);
            int lastIndex = this.limit(e.getLastIndex(), 0, QuaquaTableUI.this.table.getRowCount() - 1);
            Rectangle firstRowRect = QuaquaTableUI.this.table.getCellRect(firstIndex, 0, true);
            Rectangle lastRowRect = QuaquaTableUI.this.table.getCellRect(lastIndex, QuaquaTableUI.this.table.getColumnCount() - 1, true);
            Rectangle dirtyRegion = firstRowRect.union(lastRowRect);
            dirtyRegion.width += ((QuaquaTableUI)QuaquaTableUI.this).table.getIntercellSpacing().width;
            QuaquaTableUI.this.table.repaint(dirtyRegion);
        }

        private int limit(int i, int a, int b) {
            return Math.min(b, Math.max(i, a));
        }
    }
}

