/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class QuaquaPopupFactory {
    static final int LIGHT_WEIGHT_POPUP = 0;
    static final int MEDIUM_WEIGHT_POPUP = 1;
    static final int HEAVY_WEIGHT_POPUP = 2;
    private int popupType = 0;
    private static final int MAX_CACHE_SIZE = 5;

    int getPopupType() {
        return this.popupType;
    }

    private int getPopupType(Component owner, Component contents, int ownerX, int ownerY) {
        return this.getPopupType();
    }

    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        if (contents == null) {
            throw new IllegalArgumentException("Popup.getPopup must be passed non-null contents");
        }
        int popupType = this.getPopupType(owner, contents, x, y);
        Popup popup = this.getPopup(owner, contents, x, y, popupType);
        if (popup == null) {
            popup = this.getPopup(owner, contents, x, y, 2);
        }
        return popup;
    }

    private Popup getPopup(Component owner, Component contents, int ownerX, int ownerY, int popupType) {
        switch (popupType) {
            case 0: {
                return this.getLightWeightPopup(owner, contents, ownerX, ownerY);
            }
            case 1: {
                return this.getMediumWeightPopup(owner, contents, ownerX, ownerY);
            }
        }
        return this.getLightWeightPopup(owner, contents, ownerX, ownerY);
    }

    private Popup getLightWeightPopup(Component owner, Component contents, int ownerX, int ownerY) {
        return LightWeightPopup.getLightWeightPopup(owner, contents, ownerX, ownerY);
    }

    private Popup getMediumWeightPopup(Component owner, Component contents, int ownerX, int ownerY) {
        return MediumWeightPopup.getMediumWeightPopup(owner, contents, ownerX, ownerY);
    }

    static Point convertScreenLocationToParent(Container parent, int x, int y) {
        for (Container p = parent; p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            Point point = new Point(x, y);
            SwingUtilities.convertPointFromScreen(point, parent);
            return point;
        }
        throw new Error("convertScreenLocationToParent: no window ancestor");
    }

    private static class MediumWeightPopup
    extends ContainerPopup {
        private static final Object mediumWeightPopupCacheKey = new StringBuffer("PopupFactory.mediumPopupCache");
        private JRootPane rootPane;

        private MediumWeightPopup() {
        }

        static Popup getMediumWeightPopup(Component owner, Component contents, int ownerX, int ownerY) {
            MediumWeightPopup popup = new MediumWeightPopup();
            if (popup == null) {
                popup = new MediumWeightPopup();
            }
            popup.reset(owner, contents, ownerX, ownerY);
            return popup;
        }

        public void hide() {
            super.hide();
            this.rootPane.getContentPane().removeAll();
        }

        public void show() {
            Component component = this.getComponent();
            Container parent = null;
            if (this.owner != null) {
                parent = this.owner.getParent();
            }
            while (!(parent instanceof Window) && !(parent instanceof Applet) && parent != null) {
                parent = parent.getParent();
            }
            if (parent instanceof RootPaneContainer) {
                parent = ((RootPaneContainer)((Object)parent)).getLayeredPane();
                Point p = QuaquaPopupFactory.convertScreenLocationToParent(parent, this.x, this.y);
                component.setVisible(false);
                component.setLocation(p.x, p.y);
                ((JLayeredPane)parent).add(component, JLayeredPane.POPUP_LAYER, 0);
            } else {
                Point p = QuaquaPopupFactory.convertScreenLocationToParent(parent, this.x, this.y);
                component.setLocation(p.x, p.y);
                component.setVisible(false);
                parent.add(component);
            }
            component.setVisible(true);
        }

        Component createComponent(Component owner) {
            Panel component = new Panel(new BorderLayout());
            this.rootPane = new JRootPane();
            component.add((Component)this.rootPane, "Center");
            return component;
        }

        void reset(Component owner, Component contents, int ownerX, int ownerY) {
            super.reset(owner, contents, ownerX, ownerY);
            Component component = this.getComponent();
            component.setLocation(ownerX, ownerY);
            this.rootPane.getContentPane().add(contents, "Center");
            contents.invalidate();
            component.validate();
            this.pack();
        }
    }

    private static class LightWeightPopup
    extends ContainerPopup {
        private LightWeightPopup() {
        }

        static Popup getLightWeightPopup(Component owner, Component contents, int ownerX, int ownerY) {
            LightWeightPopup popup = new LightWeightPopup();
            popup.reset(owner, contents, ownerX, ownerY);
            return popup;
        }

        public void hide() {
            super.hide();
            Container component = (Container)this.getComponent();
            component.removeAll();
        }

        public void show() {
            Serializable p;
            Serializable parent = null;
            if (this.owner != null) {
                parent = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
            }
            for (p = parent; p != null; p = ((Component)p).getParent()) {
                if (p instanceof JRootPane) {
                    if (((Component)p).getParent() instanceof JInternalFrame) continue;
                    parent = ((JRootPane)p).getLayeredPane();
                    continue;
                }
                if (p instanceof Window) {
                    if (parent != null) break;
                    parent = p;
                    break;
                }
                if (p instanceof JApplet) break;
            }
            p = QuaquaPopupFactory.convertScreenLocationToParent((Container)parent, this.x, this.y);
            Component component = this.getComponent();
            component.setLocation(((Point)p).x, ((Point)p).y);
            if (parent instanceof JLayeredPane) {
                ((JLayeredPane)parent).add(component, JLayeredPane.POPUP_LAYER, 0);
            } else {
                ((Container)parent).add(component);
            }
        }

        Component createComponent(Component owner) {
            JPanel component = new JPanel(new BorderLayout(), true);
            component.setBorder(new LineBorder(new Color(0xB2B2B2)));
            component.setOpaque(true);
            return component;
        }

        void reset(Component owner, Component contents, int ownerX, int ownerY) {
            super.reset(owner, contents, ownerX, ownerY);
            JComponent component = (JComponent)this.getComponent();
            component.setLocation(ownerX, ownerY);
            component.add(contents, "Center");
            contents.invalidate();
            this.pack();
        }
    }

    private static class ContainerPopup
    extends Popup {
        Component owner;
        int x;
        int y;
        Component component;

        private ContainerPopup() {
        }

        Component getComponent() {
            if (this.component == null) {
                this.component = this.createComponent(this.owner);
            }
            return this.component;
        }

        Component createComponent(Component owner) {
            return null;
        }

        public void hide() {
            Container parent;
            Component component = this.getComponent();
            if (component != null && (parent = component.getParent()) != null) {
                Rectangle bounds = component.getBounds();
                parent.remove(component);
                parent.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            this.owner = null;
        }

        public void pack() {
            Component component = this.getComponent();
            if (component != null) {
                component.setSize(component.getPreferredSize());
            }
        }

        void reset(Component owner, Component contents, int ownerX, int ownerY) {
            if (owner instanceof JFrame || owner instanceof JDialog || owner instanceof JWindow) {
                owner = ((RootPaneContainer)((Object)owner)).getLayeredPane();
            }
            this.x = ownerX;
            this.y = ownerY;
            this.owner = owner;
        }

        boolean overlappedByOwnedWindow() {
            Component component = this.getComponent();
            if (this.owner != null && component != null) {
                Window w = SwingUtilities.getWindowAncestor(this.owner);
                if (w == null) {
                    return false;
                }
                Window[] ownedWindows = w.getOwnedWindows();
                if (ownedWindows != null) {
                    Rectangle bnd = component.getBounds();
                    for (int i = 0; i < ownedWindows.length; ++i) {
                        Window owned = ownedWindows[i];
                        if (!owned.isVisible() || !bnd.intersects(owned.getBounds())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        boolean fitsOnScreen() {
            Component component = this.getComponent();
            if (this.owner != null && component != null) {
                int width = component.getWidth();
                int height = component.getHeight();
                for (Container parent = this.owner.getParent(); parent != null; parent = parent.getParent()) {
                    if (parent instanceof JFrame || parent instanceof JDialog || parent instanceof JWindow) {
                        Rectangle r = parent.getBounds();
                        Insets i = parent.getInsets();
                        r.x += i.left;
                        r.y += i.top;
                        r.width -= i.left + i.right;
                        r.height -= i.top + i.bottom;
                        return SwingUtilities.isRectangleContainingRectangle(r, new Rectangle(this.x, this.y, width, height));
                    }
                    if (parent instanceof JApplet) {
                        Rectangle r = parent.getBounds();
                        Point p = parent.getLocationOnScreen();
                        r.x = p.x;
                        r.y = p.y;
                        return SwingUtilities.isRectangleContainingRectangle(r, new Rectangle(this.x, this.y, width, height));
                    }
                    if (parent instanceof Window || parent instanceof Applet) break;
                }
            }
            return false;
        }
    }
}

