/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.util.CachedPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;

public class Quaqua14SquareButtonBorder
extends CachedPainter
implements Border {
    private static final Color[] defaultColors = new Color[]{new Color(0x828282), new Color(0xFDFDFD), new Color(0xEFEFEF), new Color(0xDFDFDF), new Color(0xF1F1F1), new Color(0xE2E2E2), new Color(0xFDFDFD), new Color(0, 0, 0, 15), new Color(0, 0, 0, 7)};
    private static final Color[] selectedColors = new Color[]{new Color(0x484848), new Color(0x909090), new Color(0x858585), new Color(0x737373), new Color(0x868686), new Color(0x787878), new Color(0x909090), new Color(0, 0, 0, 15), new Color(0, 0, 0, 7)};
    private static final Color[] disabledColors = new Color[]{new Color(-1719500158, true), new Color(-1711407619, true), new Color(-1712328721, true), new Color(-1713381409, true), new Color(-1712197135, true), new Color(-1713184030, true), new Color(-1711407619, true), new Color(0, 0, 0, 15), new Color(0, 0, 0, 7)};
    private static final Color[] disabledSelectedColors = new Color[]{new Color(-1723316152, true), new Color(-1718579056, true), new Color(-1719302779, true), new Color(-1720487053, true), new Color(-1719236986, true), new Color(-1720158088, true), new Color(-1718579056, true), new Color(0, 0, 0, 15), new Color(0, 0, 0, 7)};

    public Quaqua14SquareButtonBorder() {
        super(8);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 1, 1);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
        if (config == null) {
            return new BufferedImage(w, h, 3);
        }
        return config.createCompatibleImage(w, h, 3);
    }

    public void paintBorder(Component c, Graphics gr, int x, int y, int width, int height) {
        if (height <= 0 || width <= 0) {
            return;
        }
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        Object[] colors = button.isEnabled() ? (model.isSelected() || model.isArmed() && model.isPressed() ? selectedColors : defaultColors) : (model.isSelected() ? disabledSelectedColors : disabledColors);
        this.paint(c, gr, x, y, width, height, colors);
    }

    protected void paintToImage(Component c, Graphics gr, int width, int height, Object[] args) {
        Graphics2D g = (Graphics2D)gr.create();
        Color[] colors = (Color[])args;
        g.setColor(colors[0]);
        g.drawRect(0, 0, width - 1, height - 1);
        g.setColor(colors[1]);
        g.drawLine(1, 1, width - 2, 1);
        g.setColor(colors[2]);
        g.drawLine(1, 2, width - 2, 2);
        g.setColor(colors[3]);
        g.drawLine(1, 3, width - 2, 3);
        g.setColor(colors[4]);
        g.drawLine(1, height - 2, width - 2, height - 2);
        Paint oldPaint = g.getPaint();
        g.setPaint(new GradientPaint(0.0f, 4.0f, colors[5], 0.0f, height - 6, colors[6]));
        g.fillRect(1, 4, width - 2, height - 6);
        g.setColor(colors[7]);
        g.setPaint(oldPaint);
        g.drawLine(1, 1, 1, height - 2);
        g.drawLine(width - 2, 1, width - 2, height - 2);
        g.setColor(colors[8]);
        g.drawLine(2, 2, 2, height - 3);
        g.drawLine(width - 3, 3, width - 3, height - 3);
        g.dispose();
    }
}

