/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaComboBoxUI;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaMenuPainterClient;
import ch.randelshofer.quaqua.QuaquaPopupFactory;
import ch.randelshofer.quaqua.color.PaintableColor;
import ch.randelshofer.quaqua.util.Methods;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class Quaqua14PopupMenuUI
extends BasicPopupMenuUI
implements QuaquaMenuPainterClient {
    private static boolean checkedUnpostPopup;
    private static boolean unpostPopup;
    private transient PopupMenuListener popupMenuListener = null;
    private MenuKeyListener menuKeyListener = null;
    static boolean menuKeyboardHelperInstalled;
    static MenuKeyboardHelper menuKeyboardHelper;
    private static transient MouseGrabber mouseGrabber;

    public static ComponentUI createUI(JComponent x) {
        return new Quaqua14PopupMenuUI();
    }

    public void installDefaults() {
        super.installDefaults();
    }

    protected void installListeners() {
        if (this.popupMenuListener == null) {
            this.popupMenuListener = new QuaquaPopupMenuListener();
        }
        this.popupMenu.addPopupMenuListener(this.popupMenuListener);
        if (this.menuKeyListener == null) {
            this.menuKeyListener = new QuaquaMenuKeyListener();
        }
        Methods.invokeIfExists(this.popupMenu, "addMenuKeyListener", MenuKeyListener.class, this.menuKeyListener);
        if (mouseGrabber == null) {
            mouseGrabber = new MouseGrabber();
        }
        if (!menuKeyboardHelperInstalled) {
            if (menuKeyboardHelper == null) {
                menuKeyboardHelper = new MenuKeyboardHelper();
            }
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            msm.addChangeListener(menuKeyboardHelper);
            menuKeyboardHelperInstalled = true;
        }
    }

    protected void uninstallListeners() {
        if (this.popupMenuListener != null) {
            this.popupMenu.removePopupMenuListener(this.popupMenuListener);
        }
        if (this.menuKeyListener != null) {
            Methods.invokeIfExists(this.popupMenu, "removeMenuKeyListener", MenuKeyListener.class, this.menuKeyListener);
        }
        if (mouseGrabber != null) {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            msm.removeChangeListener(mouseGrabber);
            mouseGrabber.ungrabWindow();
            mouseGrabber = null;
        }
    }

    public void paintBackground(Graphics g, JComponent component, int menuWidth, int menuHeight) {
        Color bgColor = UIManager.getColor("PopupMenu.selectionBackground");
        AbstractButton menuItem = (AbstractButton)component;
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        if (menuItem.isOpaque()) {
            if (model.isArmed() || model.isSelected()) {
                ((Graphics2D)g).setPaint(PaintableColor.getPaint(bgColor, component));
                g.fillRect(0, 0, menuWidth, menuHeight);
            } else {
                ((Graphics2D)g).setPaint(PaintableColor.getPaint(menuItem.getBackground(), component));
                g.fillRect(0, 0, menuWidth, menuHeight);
            }
            g.setColor(oldColor);
        }
    }

    static JPopupMenu getLastPopup() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] p = msm.getSelectedPath();
        JPopupMenu popup = null;
        for (int i = p.length - 1; popup == null && i >= 0; --i) {
            if (!(p[i] instanceof JPopupMenu)) continue;
            popup = (JPopupMenu)p[i];
        }
        return popup;
    }

    private static MenuElement nextEnabledChild(MenuElement[] e, int fromIndex, int toIndex) {
        for (int i = fromIndex; i <= toIndex; ++i) {
            Component comp;
            if (e[i] == null || (comp = e[i].getComponent()) == null || !comp.isEnabled() || !comp.isVisible()) continue;
            return e[i];
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] e, int fromIndex, int toIndex) {
        for (int i = fromIndex; i >= toIndex; --i) {
            Component comp;
            if (e[i] == null || (comp = e[i].getComponent()) == null || !comp.isEnabled() || !comp.isVisible()) continue;
            return e[i];
        }
        return null;
    }

    static MenuElement findEnabledChild(MenuElement[] e, int fromIndex, boolean forward) {
        MenuElement result = null;
        if (forward) {
            result = Quaqua14PopupMenuUI.nextEnabledChild(e, fromIndex + 1, e.length - 1);
            if (result == null) {
                result = Quaqua14PopupMenuUI.nextEnabledChild(e, 0, fromIndex - 1);
            }
        } else {
            result = Quaqua14PopupMenuUI.previousEnabledChild(e, fromIndex - 1, 0);
            if (result == null) {
                result = Quaqua14PopupMenuUI.previousEnabledChild(e, e.length - 1, fromIndex + 1);
            }
        }
        return result;
    }

    static MenuElement getFirstPopup() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] p = msm.getSelectedPath();
        MenuElement me = null;
        for (int i = 0; me == null && i < p.length; ++i) {
            if (!(p[i] instanceof JPopupMenu)) continue;
            me = p[i];
        }
        return me;
    }

    private static boolean doUnpostPopupOnDeactivation() {
        if (!checkedUnpostPopup) {
            Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String pKey = "sun.swing.unpostPopupsOnWindowDeactivation";
                    String value = System.getProperty(pKey, "true");
                    return Boolean.valueOf(value);
                }
            });
            unpostPopup = b;
            checkedUnpostPopup = true;
        }
        return unpostPopup;
    }

    public Popup getPopup(JPopupMenu popup, int x, int y) {
        if (!QuaquaManager.getBoolean("PopupMenu.enableHeavyWeightPopup")) {
            return new QuaquaPopupFactory().getPopup(popup.getInvoker(), popup, x, y);
        }
        return super.getPopup(popup, x, y);
    }

    static List getPopups() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] p = msm.getSelectedPath();
        ArrayList<JPopupMenu> list = new ArrayList<JPopupMenu>(p.length);
        for (int i = 0; i < p.length; ++i) {
            if (!(p[i] instanceof JPopupMenu)) continue;
            list.add((JPopupMenu)p[i]);
        }
        return list;
    }

    static ActionMap getActionMap() {
        return new ActionMap();
    }

    static InputMap getInputMap(JPopupMenu popup, JComponent c) {
        ComponentInputMap windowInputMap = null;
        Object[] bindings = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings");
        if (bindings != null) {
            Object[] km;
            windowInputMap = LookAndFeel.makeComponentInputMap(c, bindings);
            if (!popup.getComponentOrientation().isLeftToRight() && (km = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings.RightToLeft")) != null) {
                ComponentInputMap rightToLeftInputMap = LookAndFeel.makeComponentInputMap(c, km);
                ((InputMap)rightToLeftInputMap).setParent(windowInputMap);
                windowInputMap = rightToLeftInputMap;
            }
        }
        return windowInputMap;
    }

    private static boolean checkInvokerEqual(MenuElement present, MenuElement last) {
        Component invokerPresent = present.getComponent();
        Component invokerLast = last.getComponent();
        if (invokerPresent instanceof JPopupMenu) {
            invokerPresent = ((JPopupMenu)invokerPresent).getInvoker();
        }
        if (invokerLast instanceof JPopupMenu) {
            invokerLast = ((JPopupMenu)invokerLast).getInvoker();
        }
        return invokerPresent == invokerLast;
    }

    static {
        menuKeyboardHelperInstalled = false;
        menuKeyboardHelper = null;
        mouseGrabber = null;
    }

    private static class MenuKeyboardHelper
    implements ChangeListener,
    KeyListener {
        private Component lastFocused = null;
        private MenuElement[] lastPathSelected = new MenuElement[0];
        private JPopupMenu lastPopup;
        private JRootPane invokerRootPane;
        private ActionMap menuActionMap = Quaqua14PopupMenuUI.getActionMap();
        private InputMap menuInputMap;
        private boolean focusTraversalKeysEnabled;
        private boolean receivedKeyPressed = false;
        private FocusListener rootPaneFocusListener = new FocusAdapter(){

            public void focusGained(FocusEvent ev) {
                Component opposite = ev.getOppositeComponent();
                if (opposite != null) {
                    MenuKeyboardHelper.this.lastFocused = opposite;
                }
                ev.getComponent().removeFocusListener(this);
            }
        };

        private MenuKeyboardHelper() {
        }

        void removeItems() {
            if (this.lastFocused != null) {
                Window cfw;
                if (!this.lastFocused.requestFocusInWindow() && (cfw = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) != null && "###focusableSwingPopup###".equals(cfw.getName())) {
                    this.lastFocused.requestFocus();
                }
                this.lastFocused = null;
            }
            if (this.invokerRootPane != null) {
                this.invokerRootPane.removeKeyListener(menuKeyboardHelper);
                this.invokerRootPane.setFocusTraversalKeysEnabled(this.focusTraversalKeysEnabled);
                this.removeUIInputMap(this.invokerRootPane, this.menuInputMap);
                this.removeUIActionMap(this.invokerRootPane, this.menuActionMap);
                this.invokerRootPane = null;
            }
            this.receivedKeyPressed = false;
        }

        JPopupMenu getActivePopup(MenuElement[] path) {
            for (int i = path.length - 1; i >= 0; --i) {
                MenuElement elem = path[i];
                if (!(elem instanceof JPopupMenu)) continue;
                return (JPopupMenu)elem;
            }
            return null;
        }

        void addUIInputMap(JComponent c, InputMap map) {
            InputMap parent;
            InputMap lastNonUI = null;
            for (parent = c.getInputMap(2); parent != null && !(parent instanceof UIResource); parent = parent.getParent()) {
                lastNonUI = parent;
            }
            if (lastNonUI == null) {
                c.setInputMap(2, map);
            } else {
                lastNonUI.setParent(map);
            }
            map.setParent(parent);
        }

        void addUIActionMap(JComponent c, ActionMap map) {
            ActionMap parent;
            ActionMap lastNonUI = null;
            for (parent = c.getActionMap(); parent != null && !(parent instanceof UIResource); parent = parent.getParent()) {
                lastNonUI = parent;
            }
            if (lastNonUI == null) {
                c.setActionMap(map);
            } else {
                lastNonUI.setParent(map);
            }
            map.setParent(parent);
        }

        void removeUIInputMap(JComponent c, InputMap map) {
            InputMap im = null;
            for (InputMap parent = c.getInputMap(2); parent != null; parent = parent.getParent()) {
                if (parent == map) {
                    if (im == null) {
                        c.setInputMap(2, map.getParent());
                        break;
                    }
                    im.setParent(map.getParent());
                    break;
                }
                im = parent;
            }
        }

        void removeUIActionMap(JComponent c, ActionMap map) {
            ActionMap im = null;
            for (ActionMap parent = c.getActionMap(); parent != null; parent = parent.getParent()) {
                if (parent == map) {
                    if (im == null) {
                        c.setActionMap(map.getParent());
                        break;
                    }
                    im.setParent(map.getParent());
                    break;
                }
                im = parent;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void stateChanged(ChangeEvent ev) {
            if (!(UIManager.getLookAndFeel() instanceof BasicLookAndFeel)) {
                MenuSelectionManager msm = MenuSelectionManager.defaultManager();
                msm.removeChangeListener(this);
                menuKeyboardHelperInstalled = false;
                return;
            }
            MenuSelectionManager msm = (MenuSelectionManager)ev.getSource();
            MenuElement[] p = msm.getSelectedPath();
            JPopupMenu popup = this.getActivePopup(p);
            if (popup != null && !popup.isFocusable()) {
                return;
            }
            if (this.lastPathSelected.length != 0 && p.length != 0 && !Quaqua14PopupMenuUI.checkInvokerEqual(p[0], this.lastPathSelected[0])) {
                this.removeItems();
                this.lastPathSelected = new MenuElement[0];
            }
            if (this.lastPathSelected.length == 0 && p.length > 0) {
                void var5_10;
                if (popup == null) {
                    if (p.length != 2 || !(p[0] instanceof JMenuBar) || !(p[1] instanceof JMenu)) return;
                    JComponent jComponent = (JComponent)((Object)p[1]);
                    popup = ((JMenu)jComponent).getPopupMenu();
                } else {
                    Component c = popup.getInvoker();
                    if (c instanceof JFrame) {
                        JRootPane jRootPane = ((JFrame)c).getRootPane();
                    } else if (c instanceof JApplet) {
                        JRootPane jRootPane = ((JApplet)c).getRootPane();
                    } else {
                        while (!(c instanceof JComponent)) {
                            if (c == null) {
                                return;
                            }
                            c = c.getParent();
                        }
                        JComponent jComponent = (JComponent)c;
                    }
                }
                this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.invokerRootPane = SwingUtilities.getRootPane((Component)var5_10);
                if (this.invokerRootPane != null) {
                    this.invokerRootPane.addFocusListener(this.rootPaneFocusListener);
                    this.invokerRootPane.requestFocus(true);
                    this.invokerRootPane.addKeyListener(menuKeyboardHelper);
                    this.focusTraversalKeysEnabled = this.invokerRootPane.getFocusTraversalKeysEnabled();
                    this.invokerRootPane.setFocusTraversalKeysEnabled(false);
                    this.menuInputMap = Quaqua14PopupMenuUI.getInputMap(popup, this.invokerRootPane);
                    this.addUIInputMap(this.invokerRootPane, this.menuInputMap);
                    this.addUIActionMap(this.invokerRootPane, this.menuActionMap);
                }
            } else if (this.lastPathSelected.length != 0 && p.length == 0) {
                this.removeItems();
            } else if (popup != this.lastPopup) {
                this.receivedKeyPressed = false;
            }
            this.lastPathSelected = p;
            this.lastPopup = popup;
        }

        public void keyPressed(KeyEvent ev) {
            this.receivedKeyPressed = true;
            MenuSelectionManager.defaultManager().processKeyEvent(ev);
        }

        public void keyReleased(KeyEvent ev) {
            if (this.receivedKeyPressed) {
                this.receivedKeyPressed = false;
                MenuSelectionManager.defaultManager().processKeyEvent(ev);
            }
        }

        public void keyTyped(KeyEvent ev) {
            if (this.receivedKeyPressed) {
                MenuSelectionManager.defaultManager().processKeyEvent(ev);
            }
        }
    }

    private class QuaquaMenuKeyListener
    implements MenuKeyListener {
        MenuElement menuToOpen = null;

        private QuaquaMenuKeyListener() {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
            if (this.menuToOpen != null) {
                JPopupMenu subpopup = ((JMenu)this.menuToOpen).getPopupMenu();
                MenuElement subitem = Quaqua14PopupMenuUI.findEnabledChild(subpopup.getSubElements(), -1, true);
                ArrayList<MenuElement> lst = new ArrayList<MenuElement>(Arrays.asList(e.getPath()));
                lst.add(this.menuToOpen);
                lst.add(subpopup);
                if (subitem != null) {
                    lst.add(subitem);
                }
                MenuElement[] newPath = new MenuElement[]{};
                newPath = lst.toArray(newPath);
                MenuSelectionManager.defaultManager().setSelectedPath(newPath);
                e.consume();
            }
            this.menuToOpen = null;
        }

        public void menuKeyPressed(MenuKeyEvent e) {
            if (!Character.isLetterOrDigit(e.getKeyChar())) {
                return;
            }
            int keyCode = e.getKeyCode();
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            MenuElement[] items = Quaqua14PopupMenuUI.this.popupMenu.getSubElements();
            int currentIndex = -1;
            int matches = 0;
            int firstMatch = -1;
            int[] indexes = null;
            for (int j = 0; j < items.length; ++j) {
                if (!(items[j] instanceof JMenuItem)) continue;
                JMenuItem item = (JMenuItem)items[j];
                if (item.isEnabled() && item.isVisible() && keyCode == item.getMnemonic()) {
                    if (matches == 0) {
                        firstMatch = j;
                        ++matches;
                    } else {
                        if (indexes == null) {
                            indexes = new int[items.length];
                            indexes[0] = firstMatch;
                        }
                        indexes[matches++] = j;
                    }
                }
                if (!item.isArmed()) continue;
                currentIndex = matches - 1;
            }
            if (matches != 0) {
                if (matches == 1) {
                    JMenuItem item = (JMenuItem)items[firstMatch];
                    if (item instanceof JMenu) {
                        this.menuToOpen = item;
                    } else if (item.isEnabled()) {
                        manager.clearSelectedPath();
                        item.doClick();
                    }
                    e.consume();
                } else {
                    MenuElement newItem = null;
                    newItem = items[indexes[(currentIndex + 1) % matches]];
                    MenuElement[] newPath = new MenuElement[path.length + 1];
                    System.arraycopy(path, 0, newPath, 0, path.length);
                    newPath[path.length] = newItem;
                    manager.setSelectedPath(newPath);
                    e.consume();
                }
            }
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }
    }

    private class QuaquaPopupMenuListener
    implements PopupMenuListener {
        private QuaquaPopupMenuListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }

    private static class MouseGrabber
    implements ChangeListener,
    AWTEventListener,
    ComponentListener,
    WindowListener {
        Window grabbedWindow;
        MenuElement[] lastPathSelected;

        public MouseGrabber() {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            msm.addChangeListener(this);
            this.lastPathSelected = msm.getSelectedPath();
            if (this.lastPathSelected.length != 0) {
                this.grabWindow(this.lastPathSelected);
            }
        }

        void grabWindow(MenuElement[] newPath) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(MouseGrabber.this, 131120L);
                    return null;
                }
            });
            Component invoker = newPath[0].getComponent();
            if (invoker instanceof JPopupMenu) {
                invoker = ((JPopupMenu)invoker).getInvoker();
            }
            Window window = this.grabbedWindow = invoker instanceof Window ? (Window)invoker : SwingUtilities.getWindowAncestor(invoker);
            if (this.grabbedWindow != null) {
                this.grabbedWindow.addComponentListener(this);
                this.grabbedWindow.addWindowListener(this);
            }
        }

        void ungrabWindow() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(MouseGrabber.this);
                    return null;
                }
            });
            if (this.grabbedWindow != null) {
                this.grabbedWindow.removeComponentListener(this);
                this.grabbedWindow.removeWindowListener(this);
                this.grabbedWindow = null;
            }
        }

        public void stateChanged(ChangeEvent e) {
            MenuSelectionManager msm = MenuSelectionManager.defaultManager();
            MenuElement[] p = msm.getSelectedPath();
            if (this.lastPathSelected.length == 0 && p.length != 0) {
                this.grabWindow(p);
            }
            if (this.lastPathSelected.length != 0 && p.length == 0) {
                this.ungrabWindow();
            }
            this.lastPathSelected = p;
        }

        public void eventDispatched(AWTEvent ev) {
            switch (ev.getID()) {
                case 501: {
                    Component src = (Component)ev.getSource();
                    if (this.isInPopup(src) || src instanceof JMenu && ((JMenu)src).isSelected()) {
                        return;
                    }
                    if (src instanceof JComponent && ((JComponent)src).getClientProperty("doNotCancelPopup") == QuaquaComboBoxUI.HIDE_POPUP_KEY) break;
                    this.cancelPopupMenu();
                    boolean consumeEvent = UIManager.getBoolean("PopupMenu.consumeEventOnClose");
                    if (!consumeEvent || src instanceof MenuElement) break;
                    ((MouseEvent)ev).consume();
                    break;
                }
                case 502: {
                    Component src = (Component)ev.getSource();
                    MouseEvent event = (MouseEvent)ev;
                    if (!(src instanceof JMenu) && src instanceof JMenuItem) break;
                    if (event.getClickCount() == 0) {
                        Point p = event.getPoint();
                        MouseEvent dragEvent = new MouseEvent(src, 506, event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
                        MenuSelectionManager.defaultManager().processMouseEvent(dragEvent);
                    }
                    MenuSelectionManager.defaultManager().processMouseEvent((MouseEvent)ev);
                    break;
                }
                case 506: {
                    MenuSelectionManager.defaultManager().processMouseEvent((MouseEvent)ev);
                    break;
                }
                case 507: {
                    if (this.isInPopup((Component)ev.getSource())) {
                        return;
                    }
                    this.cancelPopupMenu();
                }
            }
        }

        boolean isInPopup(Component src) {
            for (Component c = src; c != null && !(c instanceof Applet) && !(c instanceof Window); c = c.getParent()) {
                if (!(c instanceof JPopupMenu)) continue;
                return true;
            }
            return false;
        }

        void cancelPopupMenu() {
            JPopupMenu firstPopup = (JPopupMenu)Quaqua14PopupMenuUI.getFirstPopup();
            List popups = Quaqua14PopupMenuUI.getPopups();
            Iterator iter = popups.iterator();
            while (iter.hasNext()) {
                JPopupMenu popup = (JPopupMenu)iter.next();
                popup.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }

        public void componentResized(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        public void componentMoved(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        public void componentShown(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        public void componentHidden(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        public void windowClosing(WindowEvent e) {
            this.cancelPopupMenu();
        }

        public void windowClosed(WindowEvent e) {
            this.cancelPopupMenu();
        }

        public void windowIconified(WindowEvent e) {
            this.cancelPopupMenu();
        }

        public void windowDeactivated(WindowEvent e) {
            if (Quaqua14PopupMenuUI.doUnpostPopupOnDeactivation()) {
                this.cancelPopupMenu();
            }
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }
    }
}

