/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class RolloverProducer
implements MouseListener,
MouseMotionListener {
    public static final String CLICKED_KEY = "swingx.clicked";
    public static final String ROLLOVER_KEY = "swingx.rollover";
    protected Point rollover = new Point(-1, -1);

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.updateRollover(e, CLICKED_KEY);
    }

    public void mouseEntered(MouseEvent e) {
        this.updateRollover(e, ROLLOVER_KEY);
    }

    public void mouseExited(MouseEvent e) {
        if (e.getSource() instanceof JComponent) {
            ((JComponent)e.getSource()).putClientProperty(ROLLOVER_KEY, null);
            ((JComponent)e.getSource()).putClientProperty(CLICKED_KEY, null);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.updateRollover(e, ROLLOVER_KEY);
    }

    protected void updateRollover(MouseEvent e, String property) {
        this.updateRolloverPoint((JComponent)e.getComponent(), e.getPoint());
        this.updateClientProperty((JComponent)e.getSource(), property);
    }

    protected void updateClientProperty(JComponent component, String property) {
        Point p = (Point)component.getClientProperty(property);
        if (p == null || this.rollover.x != p.x || this.rollover.y != p.y) {
            component.putClientProperty(property, new Point(this.rollover));
        }
    }

    protected void updateRolloverPoint(JComponent component, Point mousePoint) {
    }
}

