unit MainFrm;

interface

// Use this define, if you want to enable Gif support
// For Delphi 3-2006: with Anders Melander's TGifImage
//   http://www.torry.net/vcl/graphics/gif/gifimage.exe (original)
//   http://www.trichview.com/resources/thirdparty/gifimage.zip (update)
// For Delphi 2007 or newer: with Delphi's TGifImage
{.$DEFINE USEGIFIMAGE}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, ShellApi,
  Dialogs, StdCtrls, ComCtrls, RVStyle, RVScroll, RVTypes,
  RichView, RVFuncs, ExtCtrls, RVEdit, CRVData, CRVFData, RVOfficeCnv

  {$IFDEF USEGIFIMAGE}
  , GifImage // change to GifImg for Delphi 2007 or newer
  {$ENDIF}
  , SclRView, Ruler, RVRuler, SclRVRuler;

type
  TfrmMain = class(TForm)
    od: TOpenDialog;
    rvs: TRVStyle;
    Panel1: TPanel;
    btnOpen: TButton;
    rvc: TRVOfficeConverter;
    btnSave: TButton;
    sd: TSaveDialog;
    pb: TProgressBar;
    Panel2: TPanel;
    SclRVRuler1: TSclRVRuler;
    Panel3: TPanel;
    srv: TSRichViewEdit;
    SclRVRuler2: TSclRVRuler;
    Panel4: TPanel;
    RVRulerItemSelector1: TRVRulerItemSelector;
    procedure btnOpenClick(Sender: TObject);
    procedure rvcConverting(Sender: TObject; Percent: Integer);
    procedure btnSaveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure rveReadHyperlink(Sender: TCustomRichView; const Target,
      Extras: String; DocFormat: TRVLoadFormat; var StyleNo,
      ItemTag: Integer; var ItemName: TRVRawByteString);
    procedure rveJump(Sender: TObject; id: Integer);
    procedure rveWriteHyperlink(Sender: TCustomRichView; id: Integer;
      RVData: TCustomRVData; ItemNo: Integer; SaveFormat: TRVSaveFormat;
      var Target, Extras: string);
    procedure SclRVRuler1MarginChanged(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

{====================== Import and export =====================================}
procedure TfrmMain.FormCreate(Sender: TObject);
begin
  od.Filter := 'RTF (Built-In RichView Import)|*.rtf|'+rvc.GetImportFilter;
  sd.Filter := 'RTF (Built-In RichView Export)|*.rtf|'+rvc.GetExportFilter;

  srv.RichViewEdit.Clear;
  srv.RichViewEdit.AddNL('This demo shows how to use Microsoft Office text converters.',0,0);
  srv.RichViewEdit.AddNL('First items in filters (file masks) of the file-selection dialogs are RTF import/export '+
            'by the component itself. Others use converters.',0,0);
  srv.RichViewEdit.AddNL('For HTML import testing, look at test/test.htm.',0,0);
  srv.RichViewEdit.AddNL('After loading, Ctrl+click any hypertext link to view its target.',0,0);
  srv.RichViewEdit.AddNL('You''ll see option for HTML export via converters. You can use it, but native RichView HTML'+
            ' export gives much better results.',0,0);
  srv.RichViewEdit.Format;
  srv.UpdateRect(srv.ClientRect);
end;
{------------------------------------------------------------------------------}
procedure TfrmMain.btnOpenClick(Sender: TObject);
var r: Boolean;
begin
  if not od.Execute then
    exit;
  srv.RichViewEdit.Clear;
  srv.RichViewEdit.Format;
  srv.RichViewEdit.Update;

  srv.RichViewEdit.Clear;
  if od.FilterIndex=1 then
    r := srv.RichViewEdit.LoadRTF(od.FileName)
  else begin
    pb.Visible := True;
    r:= rvc.ImportRV(od.FileName, srv.RichViewEdit, od.FilterIndex-2);
  end;
  if not r then
    Application.MessageBox('Error','Error',0);
  pb.Visible := False;
  srv.SetRVMargins;
  srv.RichViewEdit.Format;
  srv.RichViewEdit.SetFocus;
end;
{------------------------------------------------------------------------------}
procedure TfrmMain.btnSaveClick(Sender: TObject);
var r: Boolean;
begin
  if not sd.Execute then
    exit;
  pb.Visible := True;
  if sd.FilterIndex=1 then
    r := srv.RichViewEdit.SaveRTF(sd.FileName,False)
  else begin
    pb.Visible := True;
    r:= rvc.ExportRV(sd.FileName, srv.RichViewEdit, sd.FilterIndex-2);
  end;
  if not r then
    Application.MessageBox('Error','Error',0);
  pb.Visible := False;
  srv.RichViewEdit.SetFocus;
end;
{------------------------------------------------------------------------------}
procedure TfrmMain.rvcConverting(Sender: TObject; Percent: Integer);
begin
  pb.Position := Percent;
end;
{============================ Hypertext =======================================}
// We store URLs in tags
procedure TfrmMain.rveReadHyperlink(Sender: TCustomRichView; const Target,
  Extras: String; DocFormat: TRVLoadFormat; var StyleNo, ItemTag: Integer;
  var ItemName: TRVRawByteString);
begin
  ItemTag := Integer(StrNew(PChar(Target)));
end;
{------------------------------------------------------------------------------}
procedure TfrmMain.rveWriteHyperlink(Sender: TCustomRichView; id: Integer;
  RVData: TCustomRVData; ItemNo: Integer; SaveFormat: TRVSaveFormat;
  var Target, Extras: string);
begin
  Target := PChar(RVData.GetItemTag(ItemNo));
end;
{------------------------------------------------------------------------------}
procedure TfrmMain.rveJump(Sender: TObject; id: Integer);
var ItemNo: Integer;
    RVData: TCustomRVFormattedData;
    s: String;
begin
  srv.RichViewEdit.GetJumpPointLocation(id, RVData, ItemNo);
  s := PChar(RVData.GetItemTag(ItemNo));
  ShellExecute(0, 'open', PChar(s), nil, nil, SW_SHOW);
end;
{------------------------------------------------------------------------------}
procedure TfrmMain.SclRVRuler1MarginChanged(Sender: TObject);
begin
end;

{==============================================================================}
{$IFDEF USEGIFIMAGE}

initialization
  RegisterClass(TGifImage);
{$ENDIF}

end.
