unit Demo5Frm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RVStyle, RVScroll, RichView, StdCtrls, ExtCtrls, Menus, RVFuncs, ShellApi,
  SclRView, RVEdit;

type
  TfrmDemo5 = class(TForm)
    pan: TPanel;
    edit: TEdit;
    rvs: TRVStyle;
    pm: TPopupMenu;
    mitFreezescrolling: TMenuItem;
    srv: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure editKeyPress(Sender: TObject; var Key: Char);
    procedure rvSelect(Sender: TObject);
    procedure pmPopup(Sender: TObject);
    procedure mitFreezescrollingClick(Sender: TObject);
    procedure rvJump(Sender: TObject; id: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDemo5: TfrmDemo5;

implementation

{$R *.DFM}
{--------------------------------------------------------------}
procedure AddWithURLs(s: String; rv: TRichViewEdit; DefStyle, UrlStyle: Integer);
var Before, CurrentWord, Space: String;
    p: Integer;
    ParaNo: Integer;
begin
   ParaNo := 0;
   Before := '';
   if s = '' then begin
     rv.AddNL('', DefStyle, ParaNo);
     exit;
   end;
   while s<>'' do begin
     p := Pos(' ', s);
     if p=0 then p := Length(s)+1;
     CurrentWord := Copy(s, 1, p-1);
     Space := Copy(s, p, 1);
     s := Copy(s, p+1, Length(s));
     if RVIsURL(CurrentWord) or RVIsEmail(CurrentWord) then begin
        if Before<>'' then begin
          rv.AddNL(Before, DefStyle, ParaNo);
          ParaNo := -1;
          Before := '';
        end;
        rv.AddNL(CurrentWord, UrlStyle, ParaNo);
        ParaNo := -1;
        if Space<>'' then rv.Add(Space, DefStyle);
        end
     else
       Before := Before + CurrentWord+Space;
   end;
   if Before<>'' then
     rv.AddNL(Before, DefStyle, ParaNo);
end;
{--------------------------------------------------------------}
procedure TfrmDemo5.FormCreate(Sender: TObject);
begin
  srv.SetMargin(5, 5, 5, 5);

  pan.ClientHeight := edit.Height;
  edit.SetBounds(0,0,pan.ClientWidth,pan.ClientHeight);
  srv.RichViewEdit.AddNL('Use right-click menu to freeze scrolling when appending text', 2, 0);
  srv.RichViewEdit.AddNL('Try quick-copy: selection is copied automatically when done', 2, 0);
  AddWithURLs('You can use URLs and e-mail ( like www.trichview.com )',
              srv.RichViewEdit, 2, 1);
  srv.RichViewEdit.Format;
end;
{--------------------------------------------------------------}
procedure TfrmDemo5.FormResize(Sender: TObject);
begin
 edit.Width := pan.ClientWidth;
end;
{--------------------------------------------------------------}
procedure TfrmDemo5.editKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then begin
    AddWithURLS(edit.Text,srv.RichViewEdit,0,1);
    srv.RichViewEdit.FormatTail;
    Key := #0;
    edit.Text := '';
  end;
end;
{--------------------------------------------------------------}
procedure TfrmDemo5.rvSelect(Sender: TObject);
begin
  // Quick-copy
  if srv.RichViewEdit.SelectionExists then begin
    srv.RichViewEdit.CopyDef;
    srv.RichViewEdit.Deselect;
    srv.RichViewEdit.Invalidate;
  end;
end;
{--------------------------------------------------------------}
procedure TfrmDemo5.pmPopup(Sender: TObject);
begin
  mitFreezeScrolling.Checked := not (rvoScrollToEnd in srv.RichViewEdit.Options);
end;
{--------------------------------------------------------------}
procedure TfrmDemo5.mitFreezescrollingClick(Sender: TObject);
begin
  if (rvoScrollToEnd in srv.RichViewEdit.Options) then
    srv.RichViewEdit.Options := srv.RichViewEdit.Options-[rvoScrollToEnd]
  else
    srv.RichViewEdit.Options := srv.RichViewEdit.Options+[rvoScrollToEnd];
end;
{--------------------------------------------------------------}
procedure TfrmDemo5.rvJump(Sender: TObject; id: Integer);
var ItemNo: Integer;
    s: String;
begin
  ItemNo := srv.RichViewEdit.GetJumpPointItemNo(id);
  s := srv.RichViewEdit.GetItemText(ItemNo);
  if not RVIsURL(s) and RVIsEmail(s) then
    s := 'mailto:'+s;
  ShellExecute(Application.Handle, 'open', PChar(s), nil, nil, SW_NORMAL);
end;
{--------------------------------------------------------------}
procedure TfrmDemo5.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then Close;
end;



end.
