unit Demo1Frm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RVStyle, CRVData, RVScroll, RichView, StdCtrls, Menus, SclRView;

type
  TfrmDemo1 = class(TForm)
    lst: TListBox;
    pm: TPopupMenu;
    mitShowCP: TMenuItem;
    srv: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure rvCheckpointVisible(Sender: TSRichViewEdit;
      RVData: TCustomRVData; ItemNo: Integer);
    procedure lstDblClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure pmPopup(Sender: TObject);
    procedure mitShowCPClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


implementation
uses MainFrm;
{$R *.DFM}
{-----------------------------------------------------------}
procedure TfrmDemo1.FormCreate(Sender: TObject);
var SearchRec: TSearchRec;
begin
  srv.SetMargin(5, 5, 5, 5);

  lst.Items.BeginUpdate;
  srv.RichViewEdit.AddNL('When you scroll this document to some file, the corresponding item'+
    ' in the list box is highlighted.',sncomHeading,0);
  srv.RichViewEdit.AddNL('Double-click on the left listbox to scroll to the file.',
    sncomHeading,0);
  srv.RichViewEdit.AddNL('Right-click to show/hide "checkpoints".',
    sncomHeading,0);
  if FindFirst(ExtractFilePath(Application.ExeName)+'*.pas', 0,SearchRec) = 0 then
    repeat
      lst.Items.Add(SearchRec.Name);
      // Marking next added item with checkpoint
      srv.RichViewEdit.AddNamedCheckpointEx(SearchRec.Name, True);
      // Adding name of file
      srv.RichViewEdit.AddNL(SearchRec.Name,sncomKeyword,3);
      // Adding text from file.
      // Last parameter = True, so all text will be loaded as one
      // paragraph, and displayed in the single frame
      srv.RichViewEdit.LoadText(ExtractFilePath(Application.ExeName)+SearchRec.Name, sncomNormal, 2, True);
    until FindNext(SearchRec)<>0;
  FindClose(SearchRec);
  lst.Items.EndUpdate;
  srv.RichViewEdit.Format;
end;
{-----------------------------------------------------------}
procedure TfrmDemo1.rvCheckpointVisible(Sender: TSRichViewEdit;
  RVData: TCustomRVData; ItemNo: Integer);
var Name: String;
    Tag: Integer;
    RE: Boolean;
    CheckpointData : TCheckpointData;
begin
  if RVData <> nil then begin
    CheckpointData := RVData.GetItemCheckpoint(ItemNo);
    srv.RichViewEdit.GetCheckpointInfo(CheckpointData, Tag, Name, RE);
    lst.ItemIndex := srv.RichViewEdit.GetCheckpointNo(CheckpointData);
    end
  else
    lst.ItemIndex := -1;
end;
{-----------------------------------------------------------}
procedure TfrmDemo1.lstDblClick(Sender: TObject);
var CheckpointIndex: Integer;
    Y : Integer;
begin
  CheckpointIndex := lst.ItemIndex;
  if CheckpointIndex=-1 then exit;

  Y := srv.RichViewEdit.GetCheckpointY(CheckpointIndex);
  Y := srv.convertRVtoSRV(Point(0, Y)).Y;
  srv.VScrollPos := Round(Y + srv.OffsetDocY) div srv.RichViewEdit.VSmallStep;
end;
{-----------------------------------------------------------}
procedure TfrmDemo1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then Close;
end;
{-----------------------------------------------------------}
procedure TfrmDemo1.pmPopup(Sender: TObject);
begin
  mitShowCP.Checked := rvoShowCheckpoints in srv.RichViewEdit.Options;
end;
{-----------------------------------------------------------}
procedure TfrmDemo1.mitShowCPClick(Sender: TObject);
begin
  if rvoShowCheckpoints in srv.RichViewEdit.Options then
    srv.RichViewEdit.Options := srv.RichViewEdit.Options - [rvoShowCheckpoints]
  else
    srv.RichViewEdit.Options := srv.RichViewEdit.Options + [rvoShowCheckpoints];
  srv.RichViewEdit.Invalidate;
end;

end.
