unit MPropertyControls;

interface

uses SysUtils, StdCtrls, Comctrls, ExtCtrls, Controls, Graphics, SRVButton,
     SRVCheckBox, SRVEdit, SRVGroupBox, SRVLabel, SRVPanel, SRVRadioButton,
     SRVPaintBox, SRVMediaPlayer;

function GetPropertyValue(AControl : TControl; PropertyName : String) : String;
procedure SetPropertyValue(AControl : TControl; PropertyName, PropertyValue : String);

{Get Property}
function GetPVSRVButton(AControl : TSRVButton; PropertyName : String) : String;
function GetPVSRVEdit(AControl : TSRVEdit; PropertyName : String) : String;
function GetPVSRVCheckBox(AControl : TSRVCheckBox; PropertyName : String) : String;
function GetPVSRVRadioButton(AControl : TSRVRadioButton; PropertyName : String) : String;
function GetPVSRVLabel(AControl : TSRVLabel; PropertyName : String) : String;
function GetPVSRVPaintBox(AControl : TSRVPaintBox; PropertyName : String) : String;
function GetPVSRVGroupBox(AControl : TSRVGroupBox; PropertyName : String) : String;
function GetPVSRVPanel(AControl : TSRVPanel; PropertyName : String) : String;
function GetPVSRVMediaPlayer(AControl : TSRVMediaPlayer; PropertyName : String) : String;

function GetPVButton(AControl : TButton; PropertyName : String) : String;
function GetPVCheckBox(AControl : TCheckBox; PropertyName : String) : String;
function GetPVEdit(AControl : TEdit; PropertyName : String) : String;
function GetPVMemo(AControl : TMemo; PropertyName : String) : String;
function GetPVMonthCalendar(AControl : TMonthCalendar; PropertyName : String) : String;
function GetPVPanel(AControl : TPanel; PropertyName : String) : String;
function GetPVProgressBar(AControl : TProgressBar; PropertyName : String) : String;
function GetPVRadioButton(AControl : TRadioButton; PropertyName : String) : String;
function GetPVToolBar(AControl : TToolBar; PropertyName : String) : String;
function GetPVToolButton(AControl : TToolButton; PropertyName : String) : String;
function GetPVTrackBar(AControl : TTrackBar; PropertyName : String) : String;

{Set Property}
procedure SetPVSRVButton(AControl : TSRVButton; PropertyName, PropertyValue : String);
procedure SetPVSRVEdit(AControl : TSRVEdit; PropertyName, PropertyValue : String);
procedure SetPVSRVCheckBox(AControl : TSRVCheckBox; PropertyName, PropertyValue : String);
procedure SetPVSRVRadioButton(AControl : TSRVRadioButton; PropertyName, PropertyValue : String);
procedure SetPVSRVLabel(AControl : TSRVLabel; PropertyName, PropertyValue : String);
procedure SetPVSRVPaintBox(AControl : TSRVPaintBox; PropertyName, PropertyValue : String);
procedure SetPVSRVGroupBox(AControl : TSRVGroupBox; PropertyName, PropertyValue : String);
procedure SetPVSRVPanel(AControl : TSRVPanel; PropertyName, PropertyValue : String);
procedure SetPVSRVMediaPlayer(AControl : TSRVMediaPlayer; PropertyName, PropertyValue : String);

procedure SetPVButton(AControl : TButton; PropertyName, PropertyValue : String);
procedure SetPVCheckBox(AControl : TCheckBox; PropertyName, PropertyValue : String);
procedure SetPVEdit(AControl : TEdit; PropertyName, PropertyValue : String);
procedure SetPVMemo(AControl : TMemo; PropertyName, PropertyValue : String);
procedure SetPVMonthCalendar(AControl : TMonthCalendar; PropertyName, PropertyValue : String);
procedure SetPVPanel(AControl : TPanel; PropertyName, PropertyValue : String);
procedure SetPVProgressBar(AControl : TProgressBar; PropertyName, PropertyValue : String);
procedure SetPVRadioButton(AControl : TRadioButton; PropertyName, PropertyValue : String);
procedure SetPVToolBar(AControl : TToolBar; PropertyName, PropertyValue : String);
procedure SetPVToolButton(AControl : TToolButton; PropertyName, PropertyValue : String);
procedure SetPVTrackBar(AControl : TTrackBar; PropertyName, PropertyValue : String);

var
   CurFont : TFont;

implementation

uses MRWProperty;

function GetPropertyValue(AControl : TControl; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Name' then
    Result := AControl.Name;
  if PropertyName = 'Width' then
    Result := IntToStr(AControl.Width);
  if PropertyName = 'Height' then
    Result := IntToStr(AControl.Height);
  if PropertyName = 'Align' then
    Result := GetAlign(AControl.Align);
  if PropertyName = 'Enabled' then
    Result := GetEnabled(AControl);
  if PropertyName = 'Hint' then
    Result := AControl.Hint;
  if PropertyName = 'ShowHint' then
    Result := GetBool(AControl.ShowHint);

  If Result <> '' then exit;

  if AControl is TSRVButton then
    Result := GetPVSRVButton(TSRVButton(AControl), PropertyName);
  if AControl is TSRVEdit then
    Result := GetPVSRVEdit(TSRVEdit(AControl), PropertyName);
  if AControl is TSRVCheckBox then
    Result := GetPVSRVCheckBox(TSRVCheckBox(AControl), PropertyName);
  if AControl is TSRVRadioButton then
    Result := GetPVSRVRadioButton(TSRVRadioButton(AControl), PropertyName);
  if AControl is TSRVLabel then
    Result := GetPVSRVLabel(TSRVLabel(AControl), PropertyName);
  if AControl is TSRVPaintBox then
    Result := GetPVSRVPaintBox(TSRVPaintBox(AControl), PropertyName);
  if AControl is TSRVGroupBox then
    Result := GetPVSRVGroupBox(TSRVGroupBox(AControl), PropertyName);
  if AControl is TSRVPanel then
    Result := GetPVSRVPanel(TSRVPanel(AControl), PropertyName);
  if AControl is TSRVMediaPlayer then
    Result := GetPVSRVMediaPlayer(TSRVMediaPlayer(AControl), PropertyName);
  if AControl is TToolBar then
    Result := GetPVToolBar(TToolBar(AControl), PropertyName);
  if AControl is TToolButton then
    Result := GetPVToolButton(TToolButton(AControl), PropertyName);
  if AControl is TTrackBar then
    Result := GetPVTrackBar(TTrackBar(AControl), PropertyName);
  if AControl is TRadioButton then
    Result := GetPVRadioButton(TRadioButton(AControl), PropertyName);
  if AControl is TProgressBar then
    Result := GetPVProgressBar(TProgressBar(AControl), PropertyName);
  if AControl is TPanel then
    Result := GetPVPanel(TPanel(AControl), PropertyName);
  if AControl is TMonthCalendar then
    Result := GetPVMonthCalendar(TMonthCalendar(AControl), PropertyName);
  if AControl is TMemo then
    Result := GetPVMemo(TMemo(AControl), PropertyName);
  if AControl is TEdit then
    Result := GetPVEdit(TEdit(AControl), PropertyName);
  if AControl is TCheckBox then
    Result := GetPVCheckBox(TCheckBox(AControl), PropertyName);
  if AControl is TButton then
    Result := GetPVButton(TButton(AControl), PropertyName);
end;

procedure SetPropertyValue(AControl : TControl; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Name' then
    AControl.Name := PropertyValue;
  if PropertyName = 'Width' then
    AControl.Width := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'Height' then
    AControl.Height := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'Align' then
    AControl.Align := SetAlign(PropertyValue);
  if PropertyName = 'Enabled' then
    AControl.Enabled := SetBool(PropertyValue);
  if PropertyName = 'Hint' then
    AControl.Hint := PropertyValue;
  if PropertyName = 'ShowHint' then
    AControl.ShowHint := SetBool(PropertyValue);

  if AControl is TSRVButton then
    SetPVSRVButton(TSRVButton(AControl), PropertyName, PropertyValue);
  if AControl is TSRVEdit then
    SetPVSRVEdit(TSRVEdit(AControl), PropertyName, PropertyValue);
  if AControl is TSRVCheckBox then
    SetPVSRVCheckBox(TSRVCheckBox(AControl), PropertyName, PropertyValue);
  if AControl is TSRVRadioButton then
    SetPVSRVRadioButton(TSRVRadioButton(AControl), PropertyName, PropertyValue);
  if AControl is TSRVLabel then
    SetPVSRVLabel(TSRVLabel(AControl), PropertyName, PropertyValue);
  if AControl is TSRVPaintBox then
    SetPVSRVPaintBox(TSRVPaintBox(AControl), PropertyName, PropertyValue);
  if AControl is TSRVGroupBox then
    SetPVSRVGroupBox(TSRVGroupBox(AControl), PropertyName, PropertyValue);
  if AControl is TSRVPanel then
    SetPVSRVPanel(TSRVPanel(AControl), PropertyName, PropertyValue);
  if AControl is TSRVMediaPlayer then
    SetPVSRVMediaPlayer(TSRVMediaPlayer(AControl), PropertyName, PropertyValue);
  if AControl is TToolBar then
    SetPVToolBar(TToolBar(AControl), PropertyName, PropertyValue);
  if AControl is TToolButton then
    SetPVToolButton(TToolButton(AControl), PropertyName, PropertyValue);
  if AControl is TTrackBar then
    SetPVTrackBar(TTrackBar(AControl), PropertyName, PropertyValue);
  if AControl is TRadioButton then
    SetPVRadioButton(TRadioButton(AControl), PropertyName, PropertyValue);
  if AControl is TProgressBar then
    SetPVProgressBar(TProgressBar(AControl), PropertyName, PropertyValue);
  if AControl is TPanel then
    SetPVPanel(TPanel(AControl), PropertyName, PropertyValue);
  if AControl is TMonthCalendar then
    SetPVMonthCalendar(TMonthCalendar(AControl), PropertyName, PropertyValue);
  if AControl is TMemo then
    SetPVMemo(TMemo(AControl), PropertyName, PropertyValue);
  if AControl is TEdit then
    SetPVEdit(TEdit(AControl), PropertyName, PropertyValue);
  if AControl is TCheckBox then
    SetPVCheckBox(TCheckBox(AControl), PropertyName, PropertyValue);
  if AControl is TButton then
    SetPVButton(TButton(AControl), PropertyName, PropertyValue);
end;

{************* Get Property ********8}

function GetPVSRVButton(AControl : TSRVButton; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'DrawOnPrint' then
    Result := GetBool(AControl.DrawOnPrint);
  if PropertyName = 'Glyph' then
    if AControl.Glyph.Graphic = nil then Result := '[None]'
    else Result := '[Bitmap]';
  if PropertyName = 'TabStop' then
    Result := GetBool(AControl.TabStop);
  if PropertyName = 'ShowFocusRect' then
    Result := GetBool(AControl.ShowFocusRect);
  if PropertyName = 'ModalResult' then
    Result := GetModalResult(AControl.ModalResult);
end;

function GetPVSRVEdit(AControl : TSRVEdit; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'AutoSize' then
    Result := GetBool(AControl.AutoSize);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'EnabledBorderColor' then
    Result := '$' + IntToHex(AControl.EnabledBorderColor, 8);
  if PropertyName = 'EnabledBorderWidth' then
    Result := IntToStr(AControl.EnabledBorderWidth);
  if PropertyName = 'DisabledBorderColor' then
    Result := '$' + IntToHex(AControl.DisabledBorderColor, 8);
  if PropertyName = 'DisabledBorderWidth' then
    Result := IntToStr(AControl.DisabledBorderWidth);
  if PropertyName = 'MouseInBorderColor' then
    Result := '$' + IntToHex(AControl.MouseInBorderColor, 8);
  if PropertyName = 'MouseInBorderWidth' then
    Result := IntToStr(AControl.MouseInBorderWidth);
  if PropertyName = 'FocusedBorderColor' then
    Result := '$' + IntToHex(AControl.FocusedBorderColor, 8);
  if PropertyName = 'FocusedBorderWidth' then
    Result := IntToStr(AControl.FocusedBorderWidth);
  if PropertyName = 'DrawOnPrint' then
    Result := GetBool(AControl.DrawOnPrint);
  if PropertyName = 'CharCase' then
    Result := GetCharCase(AControl.CharCase);
  if PropertyName = 'MaxLength' then
    Result := IntToStr(AControl.MaxLength);
  if PropertyName = 'PasswordChar' then
    Result := AControl.PasswordChar;
  if PropertyName = 'ReadOnly' then
    Result := GetBool(AControl.ReadOnly);
  if PropertyName = 'Text' then
    Result := AControl.Text;
  if PropertyName = 'TabStop' then
    Result := GetBool(AControl.TabStop);
end;

function GetPVSRVCheckBox(AControl : TSRVCheckBox; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Alignment' then
    Result := GetAlignment(AControl.Alignment);
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
  if PropertyName = 'Checked' then
    Result := GetBool(AControl.Checked);
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
  if PropertyName = 'State' then
    Result := GetCBState(AControl.State);
  if PropertyName = 'DrawOnPrint' then
    Result := GetBool(AControl.DrawOnPrint);
  if PropertyName = 'TabStop' then
    Result := GetBool(AControl.TabStop);
end;

function GetPVSRVRadioButton(AControl : TSRVRadioButton; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Alignment' then
    Result := GetAlignment(AControl.Alignment);
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
  if PropertyName = 'Checked' then
    Result := GetBool(AControl.Checked);
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
  if PropertyName = 'DrawOnPrint' then
    Result := GetBool(AControl.DrawOnPrint);
  if PropertyName = 'TabStop' then
    Result := GetBool(AControl.TabStop);
end;

function GetPVSRVLabel(AControl : TSRVLabel; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Alignment' then
    Result := GetAlignment(AControl.Alignment);
  if PropertyName = 'AutoSize' then
    Result := GetBool(AControl.AutoSize);
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
  if PropertyName = 'ForegroundColor' then
    Result := '$' + IntToHex(AControl.ForegroundColor, 8);
  if PropertyName = 'BackgroundColor' then
    Result := '$' + IntToHex(AControl.BackgroundColor, 8);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
  if PropertyName = 'DrawOnPrint' then
    Result := GetBool(AControl.DrawOnPrint);
  if PropertyName = 'Offset' then
    Result := IntToStr(AControl.Offset);
end;

function GetPVSRVPaintBox(AControl : TSRVPaintBox; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Alignment' then
    Result := GetAlignment(AControl.Alignment);
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
  if PropertyName = 'DrawOnPrint' then
    Result := GetBool(AControl.DrawOnPrint);
end;

function GetPVSRVGroupBox(AControl : TSRVGroupBox; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Alignment' then
    Result := GetAlignment(AControl.Alignment);
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
  if PropertyName = 'BorderColor' then
    Result := '$' + IntToHex(AControl.BorderColor, 8);
  if PropertyName = 'BorderWidth' then
    Result := IntToStr(AControl.BorderWidth);
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
  if PropertyName = 'DrawOnPrint' then
    Result := GetBool(AControl.DrawOnPrint);
  if PropertyName = 'CaptionOffset' then
    Result := IntToStr(AControl.CaptionOffset);
  if PropertyName = 'CornersOffset' then
    Result := IntToStr(AControl.CornersOffset);
end;

function GetPVSRVPanel(AControl : TSRVPanel; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Alignment' then
    Result := GetAlignment(AControl.Alignment);
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
  if PropertyName = 'BorderColor' then
    Result := '$' + IntToHex(AControl.BorderColor, 8);
  if PropertyName = 'BorderWidth' then
    Result := IntToStr(AControl.BorderWidth);
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
  if PropertyName = 'DrawOnPrint' then
    Result := GetBool(AControl.DrawOnPrint);
  if PropertyName = 'CaptionOffset' then
    Result := IntToStr(AControl.CaptionOffset);
  if PropertyName = 'CornersOffset' then
    Result := IntToStr(AControl.CornersOffset);
end;

function GetPVSRVMediaPlayer(AControl : TSRVMediaPlayer; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'DrawOnPrint' then
    Result := GetBool(AControl.DrawOnPrint);
  if PropertyName = 'FileName' then
    Result := AControl.FileName;
  if PropertyName = 'TabStop' then
    Result := GetBool(AControl.TabStop);
end;

function GetPVButton(AControl : TButton; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
end;

function GetPVCheckBox(AControl : TCheckBox; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Checked' then
    Result := GetBool(AControl.Checked);
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
end;

function GetPVEdit(AControl : TEdit; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Text' then
    Result := AControl.Text;
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
end;

function GetPVMemo(AControl : TMemo; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Lines' then
    Result := AControl.Lines.Text;
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
end;

function GetPVMonthCalendar(AControl : TMonthCalendar; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Date' then
    Result := DateToStr(AControl.Date);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
end;

function GetPVPanel(AControl : TPanel; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
end;

function GetPVProgressBar(AControl : TProgressBar; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Smooth' then
    Result := GetBool(AControl.Smooth);
  if PropertyName = 'Position' then
    Result := IntToStr(AControl.Position);
  if PropertyName = 'Max' then
    Result := IntToStr(AControl.Max);
  if PropertyName = 'Min' then
    Result := IntToStr(AControl.Min);
end;

function GetPVRadioButton(AControl : TRadioButton; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
end;

function GetPVToolBar(AControl : TToolBar; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'AddButton' then
    Result := 'New Button';
  if PropertyName = 'ButtonWidth' then
    Result := IntToStr(AControl.ButtonWidth);
  if PropertyName = 'ButtonHeight' then
    Result := IntToStr(AControl.ButtonHeight);
  if PropertyName = 'Flat' then
    Result := GetBool(AControl.Flat);
  if PropertyName = 'ShowCaptions' then
    Result := GetBool(AControl.ShowCaptions);
  if PropertyName = 'Color' then
    Result := '$' + IntToHex(AControl.Color, 8);
  if PropertyName = 'Font' then
    begin
      CurFont := AControl.Font;
      Result := AControl.Font.Name;
    end;
end;

function GetPVToolButton(AControl : TToolButton; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Caption' then
    Result := AControl.Caption;
end;

function GetPVTrackBar(AControl : TTrackBar; PropertyName : String) : String;
begin
  Result := '';
  if PropertyName = 'Position' then
    Result := IntToStr(AControl.Position);
  if PropertyName = 'Max' then
    Result := IntToStr(AControl.Max);
  if PropertyName = 'Min' then
    Result := IntToStr(AControl.Min);
end;

{************* Set Property ********8}

procedure SetPVSRVButton(AControl : TSRVButton; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
  if PropertyName = 'DrawOnPrint' then
    AControl.DrawOnPrint := SetBool(PropertyValue);
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'Glyph' then
    AControl.Glyph.LoadFromFile(PropertyValue);
  if PropertyName = 'TabStop' then
    AControl.TabStop := SetBool(PropertyValue);
  if PropertyName = 'ShowFocusRect' then
    AControl.ShowFocusRect := SetBool(PropertyValue);
  if PropertyName = 'ModalResult' then
    AControl.ModalResult := SetModalResult(PropertyValue);
end;

procedure SetPVSRVEdit(AControl : TSRVEdit; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'AutoSize' then
    AControl.AutoSize := SetBool(PropertyValue);
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'EnabledBorderColor' then
    AControl.EnabledBorderColor := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'EnabledBorderWidth' then
    AControl.EnabledBorderWidth := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'DisabledBorderColor' then
    AControl.DisabledBorderColor := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'DisabledBorderWidth' then
    AControl.DisabledBorderWidth := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'MouseInBorderColor' then
    AControl.MouseInBorderColor := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'MouseInBorderWidth' then
    AControl.MouseInBorderWidth := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'FocusedBorderColor' then
    AControl.FocusedBorderColor := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'FocusedBorderWidth' then
    AControl.FocusedBorderWidth := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'DrawOnPrint' then
    AControl.DrawOnPrint := SetBool(PropertyValue);
  if PropertyName = 'CharCase' then
    AControl.CharCase := SetCharCase(PropertyValue);
  if PropertyName = 'MaxLength' then
    AControl.MaxLength := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'PasswordChar' then
    if Length(PropertyValue) > 0 then AControl.PasswordChar := PropertyValue[1]
    else AControl.PasswordChar := ' ';
  if PropertyName = 'ReadOnly' then
    AControl.ReadOnly := SetBool(PropertyValue);
  if PropertyName = 'Text' then
    AControl.Text := PropertyValue;
  if PropertyName = 'TabStop' then
    AControl.TabStop := SetBool(PropertyValue);
end;

procedure SetPVSRVCheckBox(AControl : TSRVCheckBox; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Alignment' then
    AControl.Alignment := SetAlignment(PropertyValue);
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
  if PropertyName = 'Checked' then
    AControl.Checked := SetBool(PropertyValue);
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'State' then
    AControl.State := SetCBState(PropertyValue);
  if PropertyName = 'DrawOnPrint' then
    AControl.DrawOnPrint := SetBool(PropertyValue);
  if PropertyName = 'TabStop' then
    AControl.TabStop := SetBool(PropertyValue);
end;

procedure SetPVSRVRadioButton(AControl : TSRVRadioButton; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Alignment' then
    AControl.Alignment := SetAlignment(PropertyValue);
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
  if PropertyName = 'Checked' then
    AControl.Checked := SetBool(PropertyValue);
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'DrawOnPrint' then
    AControl.DrawOnPrint := SetBool(PropertyValue);
  if PropertyName = 'TabStop' then
    AControl.TabStop := SetBool(PropertyValue);
end;

procedure SetPVSRVLabel(AControl : TSRVLabel; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Alignment' then
    AControl.Alignment := SetAlignment(PropertyValue);
  if PropertyName = 'AutoSize' then
    AControl.AutoSize := SetBool(PropertyValue);
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
  if PropertyName = 'ForegroundColor' then
    AControl.ForegroundColor := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'BackgroundColor' then
    AControl.BackgroundColor := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'DrawOnPrint' then
    AControl.DrawOnPrint := SetBool(PropertyValue);
  if PropertyName = 'Offset' then
    AControl.Offset := StrToIntDef(PropertyValue, 0);
end;

procedure SetPVSRVPaintBox(AControl : TSRVPaintBox; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Alignment' then
    AControl.Alignment := SetAlignment(PropertyValue);
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
  if PropertyName = 'DrawOnPrint' then
    AControl.DrawOnPrint := SetBool(PropertyValue);
end;

procedure SetPVSRVGroupBox(AControl : TSRVGroupBox; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Alignment' then
    AControl.Alignment := SetAlignment(PropertyValue);
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'BorderColor' then
    AControl.BorderColor := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'DrawOnPrint' then
    AControl.DrawOnPrint := SetBool(PropertyValue);
  if PropertyName = 'BorderWidth' then
    AControl.BorderWidth := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'CornersOffset' then
    AControl.CornersOffset := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'CaptionOffset' then
    AControl.CaptionOffset := StrToIntDef(PropertyValue, 0);
end;

procedure SetPVSRVPanel(AControl : TSRVPanel; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Alignment' then
    AControl.Alignment := SetAlignment(PropertyValue);
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'BorderColor' then
    AControl.BorderColor := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'DrawOnPrint' then
    AControl.DrawOnPrint := SetBool(PropertyValue);
  if PropertyName = 'BorderWidth' then
    AControl.BorderWidth := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'CornersOffset' then
    AControl.CornersOffset := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'CaptionOffset' then
    AControl.CaptionOffset := StrToIntDef(PropertyValue, 0);
end;

procedure SetPVSRVMediaPlayer(AControl : TSRVMediaPlayer; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'DrawOnPrint' then
    AControl.DrawOnPrint := SetBool(PropertyValue);
  if PropertyName = 'TabStop' then
    AControl.TabStop := SetBool(PropertyValue);
end;

procedure SetPVButton(AControl : TButton; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
end;

procedure SetPVCheckBox(AControl : TCheckBox; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Checked' then
    AControl.Checked := SetBool(PropertyValue);
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
end;

procedure SetPVEdit(AControl : TEdit; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Text' then
    AControl.Text := PropertyValue;
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
end;

procedure SetPVMemo(AControl : TMemo; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Lines' then
    AControl.Lines.Text := PropertyValue;
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
end;

procedure SetPVMonthCalendar(AControl : TMonthCalendar; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Date' then
    AControl.Date := StrToDate(PropertyValue);
end;

procedure SetPVPanel(AControl : TPanel; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
end;

procedure SetPVProgressBar(AControl : TProgressBar; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Position' then
    AControl.Position := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'Max' then
    AControl.Max := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'Min' then
    AControl.Min := StrToIntDef(PropertyValue, 0);
   if PropertyName = 'Smooth' then
    AControl.Smooth := SetBool(PropertyValue);
end;

procedure SetPVRadioButton(AControl : TRadioButton; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
end;

procedure SetPVToolBar(AControl : TToolBar; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'ButtonWidth' then
    AControl.ButtonWidth := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'ButtonHeight' then
    AControl.ButtonHeight := StrToIntDef(PropertyValue, 0);
   if PropertyName = 'Flat' then
    AControl.Flat := SetBool(PropertyValue);
   if PropertyName = 'ShowCaptions' then
    AControl.ShowCaptions := SetBool(PropertyValue);
  if PropertyName = 'Color' then
    AControl.Color := StrToIntDef(PropertyValue, 0);
end;

procedure SetPVToolButton(AControl : TToolButton; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Caption' then
    AControl.Caption := PropertyValue;
end;

procedure SetPVTrackBar(AControl : TTrackBar; PropertyName, PropertyValue : String);
begin
  if PropertyName = 'Position' then
    AControl.Position := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'Max' then
    AControl.Max := StrToIntDef(PropertyValue, 0);
  if PropertyName = 'Min' then
    AControl.Min := StrToIntDef(PropertyValue, 0);
end;

end.
