{****************************************************************************
This demo shows how to play and to control Flash movie.
It implements the commands:
- start playing;
- stop playing;
- go to the next frame;
- go to the previous frame;
- go to the specified frame;
- go to the first frame (rewind).

Based on the book
"Flash and Delphi ", Varibrus O.A., Odessa, November, 2006
****************************************************************************}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, OleCtrls, ShockwaveFlashObjects_TLB,
  SclRView, RVStyle;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label5: TLabel;
    btnStop: TButton;
    btnPlay: TButton;
    btnBack: TButton;
    btnForward: TButton;
    btnRewind: TButton;
    btnGoToFrame: TButton;
    SpinEdit1: TSpinEdit;
    OpenDialog1: TOpenDialog;
    btnLoad: TButton;
    SRichViewEdit1: TSRichViewEdit;
    Label3: TLabel;
    Label4: TLabel;
    procedure btnStopClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnBackClick(Sender: TObject);
    procedure btnForwardClick(Sender: TObject);
    procedure btnRewindClick(Sender: TObject);
    procedure btnGoToFrameClick(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure ShowCurFrame(); // show index of the current frame
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  ShockwaveFlash1 : TShockwaveFlash;

implementation

{$R *.dfm}

{ Showing index of the current frame }
procedure TForm1.ShowCurFrame();
begin
  Label2.Caption :=  IntToStr(ShockwaveFlash1.CurrentFrame());
  Label1.Visible := True;
  Label2.Visible := True;
end;

procedure TForm1.btnPlayClick(Sender: TObject);
begin
  ShockwaveFlash1.Play();
  Label1.Visible := False;
  Label2.Visible := False;
end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
  ShockwaveFlash1.Stop();
  ShowCurFrame();
end;

procedure TForm1.btnBackClick(Sender: TObject);
begin
  if ShockwaveFlash1.IsPlaying() then
    ShockwaveFlash1.Stop();  // if it is playing, then stop
  ShockwaveFlash1.Back();    // to the previous frame
  ShowCurFrame();
end;

procedure TForm1.btnForwardClick(Sender: TObject);
begin
  if ShockwaveFlash1.IsPlaying() then
    ShockwaveFlash1.Stop();  // if it is playing, then stop.
  ShockwaveFlash1.Forward(); // to the next frame
  ShowCurFrame();
end;

procedure TForm1.btnRewindClick(Sender: TObject);
begin
  if ShockwaveFlash1.IsPlaying() then
    ShockwaveFlash1.Stop();  // if it is playing, then stop.
  ShockwaveFlash1.Rewind(); // to the first frame
  ShowCurFrame();
end;

procedure TForm1.btnGoToFrameClick(Sender: TObject);
begin
  ShockwaveFlash1.GotoFrame(StrToInt(SpinEdit1.Text)); // to the chosen frame
  ShowCurFrame();
end;

procedure TForm1.btnLoadClick(Sender: TObject);
begin
  if OpenDialog1.Execute() then
  begin
    if (ShockwaveFlash1.IsPlaying()) then
      ShockwaveFlash1.Stop();  // if it is playing, then stop
    ShockwaveFlash1.Movie := OpenDialog1.FileName;
    Label4.Caption := IntToStr(ShockwaveFlash1.TotalFrames); // Total frame count
    ShockwaveFlash1.Play();
    Label2.Visible := false;
  end

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ShockwaveFlash1 := TShockwaveFlash.Create(SRichViewEdit1);
  SRichViewEdit1.RichViewEdit.InsertControl('teste', ShockwaveFlash1, rvvaMiddle);

  ShockwaveFlash1.Movie := ExtractFilePath(Application.ExeName) + 'ball.swf';
  Label4.Caption := IntToStr(ShockwaveFlash1.TotalFrames); // Total count frame
end;

initialization
  RegisterClass(TShockwaveFlash);

end.
