
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Dialog for entering margins, padding, etc.      }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit FourSidesRVFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, RVSpinEdit, BaseRVFrm, RVALocalize;

{$I RichViewActions.inc}  

type
  TfrmRVFourSides = class(TfrmRVBase)
    gb: TGroupBox;
    lblTop: TLabel;
    lblBottom: TLabel;
    seTop: TRVSpinEdit;
    seBottom: TRVSpinEdit;
    btnOk: TButton;
    btnCancel: TButton;
    lblLeft: TLabel;
    lblRight: TLabel;
    seLeft: TRVSpinEdit;
    seRight: TRVSpinEdit;
    cbEqual: TCheckBox;
    procedure cbEqualClick(Sender: TObject);
    procedure seTopChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    Updating: Boolean;
  protected
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    {$ENDIF}
  public
    { Public declarations }
    _gb, _cbEqual: TControl;
    procedure SetValues(Left,Top,Right,Bottom: Integer;
                        FLeft,FTop,FRight,FBottom: Boolean);
    procedure GetValues(var Left,Top,Right,Bottom: Integer;
                        var FLeft,FTop,FRight,FBottom: Boolean);
    procedure Localize; override;
  end;

implementation

{$R *.dfm}

{ TfrmRVFourSides }

procedure TfrmRVFourSides.GetValues(var Left, Top, Right,
  Bottom: Integer; var FLeft,FTop,FRight,FBottom: Boolean);
begin
  FLeft   := not seLeft.Indeterminate;
  FRight  := not seRight.Indeterminate;
  FTop    := not seTop.Indeterminate;
  FBottom := not seBottom.Indeterminate;
  Left   := seLeft.AsInteger;
  Right  := seRight.AsInteger;
  Top    := seTop.AsInteger;
  Bottom := seBottom.AsInteger;
end;

procedure TfrmRVFourSides.SetValues(Left, Top, Right, Bottom: Integer;
                                    FLeft,FTop,FRight,FBottom: Boolean);
begin
  if FLeft then
    seLeft.Value := Left
  else
    seLeft.Indeterminate := True;
  if FRight then
    seRight.Value := Right
  else
    seRight.Indeterminate := True;
  if FTop then
    seTop.Value := Top
  else
    seTop.Indeterminate := True;
  if FBottom then
    seBottom.Value := Bottom
  else
    seBottom.Indeterminate := True;

  SetCheckBoxChecked(_cbEqual, (Left=Top) and (Top=Right) and (Right=Bottom) and
    (FLeft=FTop) and (FTop=FRight) and (FRight=FBottom));
end;

procedure TfrmRVFourSides.cbEqualClick(Sender: TObject);
var v: Integer;
begin
  if not Visible then exit;
  if GetCheckBoxChecked(_cbEqual) then begin
    v := (seLeft.AsInteger+seRight.AsInteger+seTop.AsInteger+seBottom.AsInteger) div 4;
    seLeft.Value := v;
    seTop.Value := v;
    seRight.Value := v;
    seBottom.Value := v;
  end;
end;

procedure TfrmRVFourSides.seTopChange(Sender: TObject);
begin
  if not Visible or Updating or not GetCheckBoxChecked(_cbEqual) then
    exit;
  Updating := True;
  if seLeft<>Sender then begin
    seLeft.Indeterminate := TRVSpinEdit(Sender).Indeterminate;
    if not TRVSpinEdit(Sender).Indeterminate then
      seLeft.Value := TRVSpinEdit(Sender).Value;
  end;
  if seTop<>Sender then begin
    seTop.Indeterminate := TRVSpinEdit(Sender).Indeterminate;
    if not TRVSpinEdit(Sender).Indeterminate then
      seTop.Value := TRVSpinEdit(Sender).Value;
  end;
  if seRight<>Sender then begin
    seRight.Indeterminate := TRVSpinEdit(Sender).Indeterminate;
    if not TRVSpinEdit(Sender).Indeterminate then
      seRight.Value := TRVSpinEdit(Sender).Value;
  end;
  if seBottom<>Sender then begin
    seBottom.Indeterminate := TRVSpinEdit(Sender).Indeterminate;
    if not TRVSpinEdit(Sender).Indeterminate then
      seBottom.Value := TRVSpinEdit(Sender).Value;
  end;
  Updating := False;
end;

procedure TfrmRVFourSides.Localize;
begin
  inherited;
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
  Caption := {$IFDEF USERVTNT}_GetWideString{$ENDIF}(RVA_GetS(rvam_4s_DefTitle));
  gb.Caption := RVA_GetSH(rvam_4s_DefTitle);
  lblLeft.Caption := RVA_GetS(rvam_4s_Left);
  lblRight.Caption := RVA_GetS(rvam_4s_Right);
  lblTop.Caption := RVA_GetS(rvam_4s_Top);
  lblBottom.Caption := RVA_GetS(rvam_4s_Bottom);
  cbEqual.Caption := RVA_GetS(rvam_4s_EqualValues);
end;

{$IFDEF RVASKINNED}
procedure TfrmRVFourSides.OnCreateThemedControl(OldControl,
  NewControl: TControl);
begin
  if OldControl = _gb then
    _gb := NewControl
  else if OldControl = _cbEqual then
    _cbEqual := NewControl;
end;

{$ENDIF}

procedure TfrmRVFourSides.FormCreate(Sender: TObject);
begin
  _gb := gb;
  _cbEqual := cbEqual;
  inherited;
end;

end.
