// CodeGear C++Builder
// Copyright (c) 1995, 2007 by CodeGear
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Rvstyle.pas' rev: 11.00

#ifndef RvstyleHPP
#define RvstyleHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Inifiles.hpp>	// Pascal unit
#include <Registry.hpp>	// Pascal unit
#include <Imglist.hpp>	// Pascal unit
#include <Rvclasses.hpp>	// Pascal unit
#include <Rvmapwht.hpp>	// Pascal unit
#include <Rvscroll.hpp>	// Pascal unit
#include <Rvtypes.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Rvstyle
{
//-- type declarations -------------------------------------------------------
#pragma pack(push,4)
struct TRVScreenAndDevice
{
	
public:
	int ppixScreen;
	int ppiyScreen;
	int ppixDevice;
	int ppiyDevice;
	int LeftMargin;
	int RightMargin;
} ;
#pragma pack(pop)

typedef TRVScreenAndDevice *PRVScreenAndDevice;

#pragma option push -b-
enum TRVHoverEffect { rvheUnderline };
#pragma option pop

typedef Set<TRVHoverEffect, rvheUnderline, rvheUnderline>  TRVHoverEffects;

#pragma option push -b-
enum TRVSaveFormat { rvsfText, rvsfHTML, rvsfRTF, rvsfRVF };
#pragma option pop

#pragma option push -b-
enum TRVLoadFormat { rvlfText, rvlfHTML, rvlfRTF, rvlfRVF, rvlfURL, rvlfOther };
#pragma option pop

#pragma option push -b-
enum TRVRTFSaveArea { rv_rtfs_TextStyle, rv_rtfs_ParaStyle, rv_rtfs_CellProps, rv_rtfs_RowProps, rv_rtfs_Doc };
#pragma option pop

#pragma option push -b-
enum TRVHTMLSaveArea { rv_thms_Head, rv_thms_BodyAttribute, rv_thms_Body, rv_thms_End };
#pragma option pop

#pragma option push -b-
enum TRVReaderUnicode { rvruMixed, rvruNoUnicode, rvruOnlyUnicode };
#pragma option pop

#pragma option push -b-
enum TRVReaderStyleMode { rvrsUseSpecified, rvrsUseClosest, rvrsAddIfNeeded };
#pragma option pop

#pragma option push -b-
enum TRVFReaderStyleMode { rvf_sIgnore, rvf_sInsertMap, rvf_sInsertMerge };
#pragma option pop

#pragma option push -b-
enum TRVColorMode { rvcmColor, rvcmPrinterColor, rvcmGrayScale, rvcmBlackAndWhite, rvcmBlackOnWhite };
#pragma option pop

typedef unsigned TRVCodePage;

#pragma option push -b-
enum TRVItemBackgroundStyle { rvbsColor, rvbsStretched, rvbsTiled, rvbsCentered };
#pragma option pop

#pragma option push -b-
enum TRVSubSuperScriptType { rvsssNormal, rvsssSubscript, rvsssSuperScript };
#pragma option pop

#pragma option push -b-
enum TRVUnderlineType { rvutNormal, rvutThick, rvutDouble, rvutDotted, rvutThickDotted, rvutDashed, rvutThickDashed, rvutLongDashed, rvutThickLongDashed, rvutDashDotted, rvutThickDashDotted, rvutDashDotDotted, rvutThickDashDotDotted };
#pragma option pop

typedef void *TCheckpointData;

#pragma option push -b-
enum TRVTextDrawState { rvtsSelected, rvtsHover, rvtsItemStart, rvtsItemEnd, rvtsDrawItemStart, rvtsDrawItemEnd, rvtsControlFocused, rvtsSpecialCharacters };
#pragma option pop

typedef Set<TRVTextDrawState, rvtsSelected, rvtsSpecialCharacters>  TRVTextDrawStates;

#pragma option push -b-
enum TRVPageBreakType { rvpbSoftPageBreak, rvpbPageBreak };
#pragma option pop

#pragma option push -b-
enum TRVBreakStyle { rvbsLine, rvbsRectangle, rvbs3d, rvbsDotted, rvbsDashed };
#pragma option pop

#pragma option push -b-
enum TRVVAlign { rvvaBaseline, rvvaMiddle, rvvaAbsTop, rvvaAbsBottom, rvvaAbsMiddle };
#pragma option pop

#pragma option push -b-
enum TRVBorderStyle { rvbNone, rvbSingle, rvbDouble, rvbTriple, rvbThickInside, rvbThickOutside };
#pragma option pop

#pragma option push -b-
enum TRVSeqType { rvseqDecimal, rvseqLowerAlpha, rvseqUpperAlpha, rvseqLowerRoman, rvseqUpperRoman };
#pragma option pop

#pragma option push -b-
enum TRVListType { rvlstBullet, rvlstPicture, rvlstImageList, rvlstDecimal, rvlstLowerAlpha, rvlstUpperAlpha, rvlstLowerRoman, rvlstUpperRoman, rvlstImageListCounter, rvlstUnicodeBullet };
#pragma option pop

#pragma option push -b-
enum TRVMarkerAlignment { rvmaLeft, rvmaRight, rvmaCenter };
#pragma option pop

#pragma option push -b-
enum TRVListLevelOption { rvloContinuous, rvloLevelReset, rvloLegalStyleNumbering };
#pragma option pop

typedef Set<TRVListLevelOption, rvloContinuous, rvloLegalStyleNumbering>  TRVListLevelOptions;

typedef AnsiString TRVMarkerFormatString;

typedef WideString TRVMarkerFormatStringW;

#pragma option push -b-
enum TRVFOption { rvfoSavePicturesBody, rvfoSaveControlsBody, rvfoIgnoreUnknownPicFmt, rvfoIgnoreUnknownCtrls, rvfoConvUnknownStylesToZero, rvfoConvLargeImageIdxToZero, rvfoSaveBinary, rvfoUseStyleNames, rvfoSaveBack, rvfoLoadBack, rvfoSaveTextStyles, rvfoSaveParaStyles, rvfoSaveLayout, rvfoLoadLayout, rvfoSaveDocProperties, rvfoLoadDocProperties };
#pragma option pop

typedef Set<TRVFOption, rvfoSavePicturesBody, rvfoLoadDocProperties>  TRVFOptions;

#pragma option push -b-
enum TRVLongOperation { rvloLoading, rvloConverting };
#pragma option pop

#pragma option push -b-
enum TRVProgressStage { rvpstgStarting, rvpstgRunning, rvpstgEnding };
#pragma option pop

#pragma option push -b-
enum TRVFWarning { rvfwUnknownPicFmt, rvfwUnknownCtrls, rvfwConvUnknownStyles, rvfwConvLargeImageIdx, rvfwConvToUnicode, rvfwConvFromUnicode, rvfwInvalidPicture, rvfwUnknownStyleProperties };
#pragma option pop

typedef Set<TRVFWarning, rvfwUnknownPicFmt, rvfwUnknownStyleProperties>  TRVFWarnings;

#pragma option push -b-
enum TRVControlAction { rvcaAfterRVFLoad, rvcaDestroy, rvcaMoveToUndoList, rvcaMoveFromUndoList, rvcaDestroyInUndoList, rvcaBeforeRVFSave, rvcaAfterRVFSave };
#pragma option pop

#pragma option push -b-
enum TRVItemAction { rviaInserting, rviaInserted, rviaTextModifying, rviaDestroying, rviaMovingToUndoList };
#pragma option pop

#pragma option push -b-
enum TRVProtectOption { rvprStyleProtect, rvprStyleSplitProtect, rvprModifyProtect, rvprDeleteProtect, rvprConcateProtect, rvprRVFInsertProtect, rvprDoNotAutoSwitch, rvprParaStartProtect, rvprSticking, rvprSticking2, rvprSticking3, rvprStickToTop, rvprStickToBottom };
#pragma option pop

typedef Set<TRVProtectOption, rvprStyleProtect, rvprStickToBottom>  TRVProtectOptions;

#pragma option push -b-
enum TRVParaOption { rvpaoNoWrap, rvpaoReadOnly, rvpaoStyleProtect, rvpaoDoNotWantReturns, rvpaoKeepLinesTogether, rvpaoKeepWithNext, rvpaoWidowOrphanControl };
#pragma option pop

typedef Set<TRVParaOption, rvpaoNoWrap, rvpaoWidowOrphanControl>  TRVParaOptions;

#pragma option push -b-
enum TRVTextOption { rvteoHTMLCode, rvteoRTFCode };
#pragma option pop

typedef Set<TRVTextOption, rvteoHTMLCode, rvteoRTFCode>  TRVTextOptions;

#pragma option push -b-
enum TRVSaveOption { rvsoOverrideImages, rvsoFirstOnly, rvsoMiddleOnly, rvsoLastOnly, rvsoDefault0Style, rvsoNoHypertextImageBorders, rvsoImageSizes, rvsoForceNonTextCSS, rvsoUseCheckpointsNames, rvsoMarkersAsText, rvsoInlineCSS, rvsoNoDefCSSStyle, rvsoUseItemImageFileNames, rvsoXHTML, rvsoUTF8 };
#pragma option pop

typedef Set<TRVSaveOption, rvsoOverrideImages, rvsoUTF8>  TRVSaveOptions;

#pragma option push -b-
enum TRVRTFOption { rvrtfSaveStyleSheet, rvrtfDuplicateUnicode, rvrtfSaveEMFAsWMF, rvrtfSaveJpegAsJpeg, rvrtfSaveBitmapDefault, rvrtfSaveEMFDefault, rvrtfSavePicturesBinary, rvrtfPNGInsteadOfBitmap, rvrtfSaveDocParameters, rvrtfSaveHeaderFooter };
#pragma option pop

typedef Set<TRVRTFOption, rvrtfSaveStyleSheet, rvrtfSaveHeaderFooter>  TRVRTFOptions;

#pragma option push -b-
enum TRVFontStyle { rvfsOverline, rvfsAllCaps };
#pragma option pop

typedef Set<TRVFontStyle, rvfsOverline, rvfsAllCaps>  TRVFontStyles;

#pragma option push -b-
enum TRVAlignment { rvaLeft, rvaRight, rvaCenter, rvaJustify };
#pragma option pop

#pragma option push -b-
enum TRVUnits { rvuInches, rvuCentimeters, rvuMillimeters, rvuPicas, rvuPixels, rvuPoints };
#pragma option pop

#pragma pack(push,4)
struct TRVExtraFontInfo
{
	
public:
	int ScriptHeight;
} ;
#pragma pack(pop)

typedef TRVExtraFontInfo *PRVExtraFontInfo;

typedef TCustomIniFile TRVIniFile;
;

#pragma option push -b-
enum TRVSaveCSSOption { rvcssOnlyDifference, rvcssIgnoreLeftAlignment, rvcssNoDefCSSStyle, rvcssUTF8, rvcssDefault0Style };
#pragma option pop

typedef Set<TRVSaveCSSOption, rvcssOnlyDifference, rvcssDefault0Style>  TRVSaveCSSOptions;

#pragma option push -b-
enum TRVFontInfoProperty { rvfiFontName, rvfiSize, rvfiCharset, rvfiUnicode, rvfiBold, rvfiItalic, rvfiUnderline, rvfiStrikeout, rvfiOverline, rvfiAllCaps, rvfiSubSuperScriptType, rvfiVShift, rvfiColor, rvfiBackColor, rvfiJump, rvfiHoverBackColor, rvfiHoverColor, rvfiHoverUnderline, rvfiJumpCursor, rvfiNextStyleNo, rvfiProtection, rvfiCharScale, rvfiBaseStyleNo, rvfiBiDiMode, rvfiCharSpacing, rvfiHTMLCode, rvfiRTFCode, rvfiUnderlineType, rvfiUnderlineColor, rvfiHoverUnderlineColor, rvfiCustom };
#pragma option pop

#pragma option push -b-
enum TRVParaInfoProperty { rvpiFirstIndent, rvpiLeftIndent, rvpiRightIndent, rvpiSpaceBefore, rvpiSpaceAfter, rvpiAlignment, rvpiNextParaNo, rvpiDefStyleNo, rvpiLineSpacing, rvpiLineSpacingType, rvpiBackground_Color, rvpiBackground_BO_Left, rvpiBackground_BO_Top, rvpiBackground_BO_Right, rvpiBackground_BO_Bottom, rvpiBorder_Color, rvpiBorder_Style, rvpiBorder_Width, rvpiBorder_InternalWidth, rvpiBorder_BO_Left, rvpiBorder_BO_Top, rvpiBorder_BO_Right, rvpiBorder_BO_Bottom, rvpiBorder_Vis_Left, rvpiBorder_Vis_Top, rvpiBorder_Vis_Right, rvpiBorder_Vis_Bottom, rvpiNoWrap, rvpiReadOnly, rvpiStyleProtect, rvpiDoNotWantReturns, rvpiKeepLinesTogether, rvpiKeepWithNext, rvpiTabs, rvpiBiDiMode, rvpiCustom };
#pragma option pop

typedef TRVParaInfoProperty TRVParaInfoProperty1;

typedef TRVParaInfoProperty TRVParaInfoProperty2;

typedef Set<TRVFontInfoProperty, rvfiFontName, rvfiCustom>  TRVFontInfoProperties;

typedef Set<TRVParaInfoProperty, rvpiFirstIndent, rvpiCustom>  TRVParaInfoProperties;

typedef Set<TRVParaInfoProperty1, rvpiFirstIndent, rvpiBorder_Vis_Bottom>  TRVParaInfoProperties1;

typedef Set<TRVParaInfoProperty2, rvpiNoWrap, rvpiBiDiMode>  TRVParaInfoProperties2;

#pragma option push -b-
enum TRVLineSpacingType { rvlsPercent, rvlsSpaceBetween, rvlsLineHeightAtLeast, rvlsLineHeightExact };
#pragma option pop

#pragma option push -b-
enum TRVStyleMergeMode { rvs_merge_SmartMerge, rvs_merge_Map, rvs_merge_Append };
#pragma option pop

#pragma option push -b-
enum TRVSelectionMode { rvsmChar, rvsmWord, rvsmParagraph };
#pragma option pop

#pragma option push -b-
enum TRVSelectionStyle { rvssItems, rvssLines };
#pragma option pop

#pragma option push -b-
enum TRVTabAlign { rvtaLeft, rvtaRight, rvtaCenter };
#pragma option pop

typedef int TRVStyleTemplateId;

typedef AnsiString TRVStyleTemplateName;

#pragma option push -b-
enum TRVSpecialCharacter { rvscSpace, rvscNBSP, rvscParagraph, rvscSoftHyphen };
#pragma option pop

typedef Set<TRVSpecialCharacter, rvscSpace, rvscSoftHyphen>  TRVSpecialCharacters;

#pragma option push -b-
enum TRVFieldHighlightType { rvfhNever, rvfhCurrent, rvfhAlways };
#pragma option pop

class DELPHICLASS TRVStyle;
typedef void __fastcall (__closure *TRVDrawTextBackEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas, int StyleNo, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState, bool &DoDefault);

typedef void __fastcall (__closure *TRVApplyStyleEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas, int StyleNo, bool &DoDefault);

typedef void __fastcall (__closure *TRVApplyStyleColorEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas, int StyleNo, TRVTextDrawStates DrawState, bool &DoDefault);

typedef void __fastcall (__closure *TRVDrawStyleTextEvent)(TRVStyle* Sender, const AnsiString s, Graphics::TCanvas* Canvas, int StyleNo, int SpaceBefore, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState, bool &DoDefault);

typedef void __fastcall (__closure *TRVStyleHoverSensitiveEvent)(TRVStyle* Sender, int StyleNo, bool &Sensitive);

typedef void __fastcall (__closure *TRVDrawCheckpointEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas, int X, int Y, int ItemNo, int XShift, bool RaiseEvent, Controls::TControl* Control, bool &DoDefault);

typedef void __fastcall (__closure *TRVDrawPageBreakEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas, int Y, int XShift, TRVPageBreakType PageBreakType, Controls::TControl* Control, bool &DoDefault);

typedef void __fastcall (__closure *TRVDrawParaRectEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas, int ParaNo, const Types::TRect &ARect, bool &DoDefault);

class DELPHICLASS TCustomRVInfo;
class PASCALIMPLEMENTATION TCustomRVInfo : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	int FBaseStyleNo;
	AnsiString FName;
	bool FStandard;
	TRVStyleTemplateId FStyleTemplateId;
	
protected:
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID = true);
	DYNAMIC bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping);
	DYNAMIC int __fastcall SimilarityValue(TCustomRVInfo* Value);
	
public:
	__fastcall virtual TCustomRVInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual AnsiString __fastcall GetDisplayName();
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs, const AnsiString DefName);
	
__published:
	__property int BaseStyleNo = {read=FBaseStyleNo, write=FBaseStyleNo, default=-1};
	__property AnsiString StyleName = {read=FName, write=FName};
	__property bool Standard = {read=FStandard, write=FStandard, default=1};
	__property TRVStyleTemplateId StyleTemplateId = {read=FStyleTemplateId, write=FStyleTemplateId, default=-1};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TCustomRVInfo(void) { }
	#pragma option pop
	
};


class DELPHICLASS TCustomRVFontInfo;
class PASCALIMPLEMENTATION TCustomRVFontInfo : public TCustomRVInfo 
{
	typedef TCustomRVInfo inherited;
	
private:
	Rvscroll::TRVBiDiMode FBiDiMode;
	bool FJump;
	Controls::TCursor FJumpCursor;
	AnsiString FFontName;
	int FSize;
	Graphics::TColor FColor;
	Graphics::TColor FBackColor;
	Graphics::TColor FHoverColor;
	Graphics::TColor FHoverBackColor;
	Graphics::TColor FUnderlineColor;
	Graphics::TColor FHoverUnderlineColor;
	TRVUnderlineType FUnderlineType;
	TRVHoverEffects FHoverEffects;
	Graphics::TFontStyles FStyle;
	TRVFontStyles FStyleEx;
	int FVShift;
	Graphics::TFontCharset FCharset;
	TRVProtectOptions FProtection;
	TRVTextOptions FOptions;
	int FCharScale;
	int FCharSpacing;
	TRVSubSuperScriptType FSubSuperScriptType;
	void __fastcall SingleSymbolsReader(Classes::TReader* reader);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID = true);
	DYNAMIC int __fastcall SimilarityValue(TCustomRVInfo* Value);
	int __fastcall GetScriptHeight(Graphics::TCanvas* Canvas);
	
public:
	__fastcall virtual TCustomRVFontInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall AssignSelectedProperties(TCustomRVFontInfo* Source, TRVFontInfoProperties Props);
	void __fastcall AssignToLogFont(tagLOGFONTA &LogFont, Graphics::TCanvas* Canvas, bool CanUseCustomPPI, bool ExcludeUnderline);
	void __fastcall Apply(Graphics::TCanvas* Canvas, Rvscroll::TRVBiDiMode DefBiDiMode, bool CanUseCustomPPI, PRVExtraFontInfo ExtraFontInfo, bool IgnoreSubSuperScript);
	void __fastcall ApplyBiDiMode(Graphics::TCanvas* Canvas, Rvscroll::TRVBiDiMode DefBiDiMode);
	void __fastcall ApplyColor(Graphics::TCanvas* Canvas, TRVStyle* RVStyle, TRVTextDrawStates DrawState, bool Printing, TRVColorMode ColorMode);
	DYNAMIC bool __fastcall IsEqual(TCustomRVFontInfo* Value, TRVFontInfoProperties IgnoreList);
	HIDESBASEDYNAMIC void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	HIDESBASEDYNAMIC void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs, bool JumpByDefault, Controls::TCursor DefJumpCursor);
	void __fastcall SaveCSSToStream(Classes::TStream* Stream, TCustomRVFontInfo* BaseStyle, bool Multiline, bool UTF8);
	void __fastcall SaveRTFToStream(Classes::TStream* Stream, int StyleNo, double TwipsPerPixel, Rvclasses::TRVIntegerList* StyleToFont, Rvclasses::TRVIntegerList* ColorTable);
	
__published:
	__property Graphics::TFontCharset Charset = {read=FCharset, write=FCharset, default=1};
	__property AnsiString FontName = {read=FFontName, write=FFontName};
	__property int Size = {read=FSize, write=FSize, default=10};
	__property Graphics::TFontStyles Style = {read=FStyle, write=FStyle, default=0};
	__property int VShift = {read=FVShift, write=FVShift, default=0};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-16777208};
	__property Graphics::TColor BackColor = {read=FBackColor, write=FBackColor, default=536870911};
	__property Graphics::TColor HoverBackColor = {read=FHoverBackColor, write=FHoverBackColor, default=536870911};
	__property Graphics::TColor HoverColor = {read=FHoverColor, write=FHoverColor, default=536870911};
	__property TRVHoverEffects HoverEffects = {read=FHoverEffects, write=FHoverEffects, default=0};
	__property TRVFontStyles StyleEx = {read=FStyleEx, write=FStyleEx, default=0};
	__property bool Jump = {read=FJump, write=FJump, default=0};
	__property Controls::TCursor JumpCursor = {read=FJumpCursor, write=FJumpCursor, default=101};
	__property int CharScale = {read=FCharScale, write=FCharScale, default=100};
	__property int CharSpacing = {read=FCharSpacing, write=FCharSpacing, default=0};
	__property Rvscroll::TRVBiDiMode BiDiMode = {read=FBiDiMode, write=FBiDiMode, default=0};
	__property TRVSubSuperScriptType SubSuperScriptType = {read=FSubSuperScriptType, write=FSubSuperScriptType, default=0};
	__property TRVProtectOptions Protection = {read=FProtection, write=FProtection, default=0};
	__property TRVTextOptions Options = {read=FOptions, write=FOptions, default=0};
	__property TRVUnderlineType UnderlineType = {read=FUnderlineType, write=FUnderlineType, default=0};
	__property Graphics::TColor UnderlineColor = {read=FUnderlineColor, write=FUnderlineColor, default=536870911};
	__property Graphics::TColor HoverUnderlineColor = {read=FHoverUnderlineColor, write=FHoverUnderlineColor, default=536870911};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TCustomRVFontInfo(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFontInfo;
class PASCALIMPLEMENTATION TFontInfo : public TCustomRVFontInfo 
{
	typedef TCustomRVFontInfo inherited;
	
private:
	bool FUnicode;
	int FNextStyleNo;
	TRVFontInfoProperties FModifiedProperties;
	
protected:
	DYNAMIC bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping);
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID = true);
	void __fastcall ExcludeUnmodifiedProperties(TCustomRVFontInfo* Source, TRVFontInfoProperties PossibleProps);
	
public:
	__fastcall virtual TFontInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	DYNAMIC bool __fastcall IsEqual(TCustomRVFontInfo* Value, TRVFontInfoProperties IgnoreList);
	void __fastcall Draw(const AnsiString s, Graphics::TCanvas* Canvas, int ThisStyleNo, int SpaceBefore, int Left, int Top, int Width, int Height, int BaseLine, TRVStyle* RVStyle, TRVTextDrawStates DrawState, bool Printing, bool PreviewCorrection, TRVColorMode ColorMode, Rvscroll::TRVBiDiMode DefBiDiMode, Graphics::TCanvas* RefCanvas);
	void __fastcall DrawVertical(const AnsiString s, Graphics::TCanvas* Canvas, int ThisStyleNo, int SpaceBefore, int Left, int Top, int Width, int Height, TRVStyle* RVStyle, TRVTextDrawStates DrawState);
	DYNAMIC void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	DYNAMIC void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs, bool JumpByDefault, Controls::TCursor DefJumpCursor);
	
__published:
	__property int NextStyleNo = {read=FNextStyleNo, write=FNextStyleNo, default=-1};
	__property bool Unicode = {read=FUnicode, write=FUnicode, default=0};
	__property TRVFontInfoProperties ModifiedProperties = {read=FModifiedProperties, write=FModifiedProperties, default=0};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TFontInfo(void) { }
	#pragma option pop
	
};


class DELPHICLASS TCustomRVInfos;
class PASCALIMPLEMENTATION TCustomRVInfos : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
protected:
	Classes::TPersistent* FOwner;
	
public:
	__fastcall TCustomRVInfos(TMetaClass* ItemClass, Classes::TPersistent* Owner);
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall MergeWith(TCustomRVInfos* Styles, TRVStyleMergeMode Mode, Rvclasses::TRVIntegerList* Mapping, Rvclasses::TRVIntegerList* TextStyleMapping, Classes::TPersistent* RVData = (Classes::TPersistent*)(0x0));
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TCustomRVInfos(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFontInfos;
class PASCALIMPLEMENTATION TFontInfos : public TCustomRVInfos 
{
	typedef TCustomRVInfos inherited;
	
public:
	TFontInfo* operator[](int Index) { return Items[Index]; }
	
private:
	TFontInfo* FInvalidItem;
	HIDESBASE TFontInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TFontInfo* Value);
	TFontInfo* __fastcall GetInvalidItem(void);
	void __fastcall SetInvalidItem(const TFontInfo* Value);
	
public:
	int PixelsPerInch;
	__fastcall virtual ~TFontInfos(void);
	int __fastcall FindStyleWithCharset(int BaseStyle, Graphics::TFontCharset Charset);
	int __fastcall FindStyleWithFontStyle(int BaseStyle, Graphics::TFontStyles Value, Graphics::TFontStyles Mask);
	int __fastcall FindStyleWithFontSize(int BaseStyle, int Size);
	int __fastcall FindStyleWithColor(int BaseStyle, Graphics::TColor Color, Graphics::TColor BackColor);
	int __fastcall FindStyleWithFontName(int BaseStyle, const AnsiString FontName);
	int __fastcall FindSuchStyle(int BaseStyle, TFontInfo* Style, TRVFontInfoProperties Mask);
	int __fastcall FindStyleWithFont(int BaseStyle, Graphics::TFont* Font);
	HIDESBASE TFontInfo* __fastcall Add(void);
	TFontInfo* __fastcall AddFont(AnsiString Name, int Size, Graphics::TColor Color, Graphics::TColor BackColor, Graphics::TFontStyles Style);
	TFontInfo* __fastcall AddFontEx(AnsiString Name, int Size, Graphics::TColor Color, Graphics::TColor BackColor, Graphics::TFontStyles Style, Graphics::TFontCharset Charset);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, Controls::TCursor DefJumpCursor);
	__property TFontInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
	__property TFontInfo* InvalidItem = {read=GetInvalidItem, write=SetInvalidItem};
public:
	#pragma option push -w-inl
	/* TCustomRVInfos.Create */ inline __fastcall TFontInfos(TMetaClass* ItemClass, Classes::TPersistent* Owner) : TCustomRVInfos(ItemClass, Owner) { }
	#pragma option pop
	
};


class DELPHICLASS TRVRect;
class PASCALIMPLEMENTATION TRVRect : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	int FTop;
	int FLeft;
	int FRight;
	int FBottom;
	bool __fastcall IsEqualEx(TRVRect* Value, bool IgnL, bool IgnT, bool IgnR, bool IgnB);
	int __fastcall SimilarityValue(TRVRect* Value, int Weight);
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall AssignValidProperties(TRVRect* Source, bool ValL, bool ValT, bool ValR, bool ValB);
	void __fastcall SetAll(int Value);
	void __fastcall InflateRect(Types::TRect &Rect);
	void __fastcall InflateRectSaD(Types::TRect &Rect, const TRVScreenAndDevice &sad);
	void __fastcall AssignToRect(Types::TRect &Rect);
	void __fastcall AssignToRectIfGreater(Types::TRect &Rect);
	bool __fastcall IsEqual(TRVRect* Value);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	
__published:
	__property int Left = {read=FLeft, write=FLeft, default=0};
	__property int Right = {read=FRight, write=FRight, default=0};
	__property int Top = {read=FTop, write=FTop, default=0};
	__property int Bottom = {read=FBottom, write=FBottom, default=0};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TRVRect(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVRect(void) : Classes::TPersistent() { }
	#pragma option pop
	
};


class DELPHICLASS TRVBooleanRect;
class PASCALIMPLEMENTATION TRVBooleanRect : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FTop;
	bool FLeft;
	bool FRight;
	bool FBottom;
	bool __fastcall IsEqualEx(TRVBooleanRect* Value, bool IgnL, bool IgnT, bool IgnR, bool IgnB);
	
public:
	__fastcall TRVBooleanRect(bool DefValue);
	void __fastcall SetAll(bool Value);
	void __fastcall SetValues(bool ALeft, bool ATop, bool ARight, bool ABottom);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall AssignValidProperties(TRVBooleanRect* Source, bool ValL, bool ValT, bool ValR, bool ValB);
	bool __fastcall IsEqual(TRVBooleanRect* Value);
	bool __fastcall IsEqual2(bool ALeft, bool ATop, bool ARight, bool ABottom);
	bool __fastcall IsAllEqual(bool Value);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	
__published:
	__property bool Left = {read=FLeft, write=FLeft, default=1};
	__property bool Right = {read=FRight, write=FRight, default=1};
	__property bool Top = {read=FTop, write=FTop, default=1};
	__property bool Bottom = {read=FBottom, write=FBottom, default=1};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TRVBooleanRect(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVBorder;
class PASCALIMPLEMENTATION TRVBorder : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Graphics::TColor FColor;
	TRVBorderStyle FStyle;
	int FWidth;
	int FInternalWidth;
	TRVBooleanRect* FVisibleBorders;
	TRVRect* FBorderOffsets;
	void __fastcall SetBorderOffsets(const TRVRect* Value);
	void __fastcall SetVisibleBorders(const TRVBooleanRect* Value);
	int __fastcall SimilarityValue(TRVBorder* Value);
	
protected:
	void __fastcall DoDraw(const Types::TRect &Rect, Graphics::TCanvas* Canvas, int Width, int InternalWidth, int OnePixelWidth, TRVColorMode ColorMode);
	
public:
	__fastcall TRVBorder(void);
	__fastcall virtual ~TRVBorder(void);
	void __fastcall Draw(const Types::TRect &Rect, Graphics::TCanvas* Canvas);
	void __fastcall DrawSaD(const Types::TRect &Rect, Graphics::TCanvas* Canvas, const TRVScreenAndDevice &sad, TRVColorMode ColorMode);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	bool __fastcall IsEqual(TRVBorder* Value);
	bool __fastcall IsEqual_Para(TRVBorder* Value, const TRVParaInfoProperties &IgnoreList);
	void __fastcall AssignValidProperties(TRVBorder* Source, TRVParaInfoProperties1 ValidProperties);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	int __fastcall GetTotalWidth(void);
	
__published:
	__property int Width = {read=FWidth, write=FWidth, default=1};
	__property int InternalWidth = {read=FInternalWidth, write=FInternalWidth, default=1};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-16777208};
	__property TRVBorderStyle Style = {read=FStyle, write=FStyle, default=0};
	__property TRVBooleanRect* VisibleBorders = {read=FVisibleBorders, write=SetVisibleBorders};
	__property TRVRect* BorderOffsets = {read=FBorderOffsets, write=SetBorderOffsets};
};


class DELPHICLASS TRVBackgroundRect;
class PASCALIMPLEMENTATION TRVBackgroundRect : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TRVRect* FBorderOffsets;
	Graphics::TColor FColor;
	void __fastcall SetBorderOffsets(const TRVRect* Value);
	int __fastcall SimilarityValue(TRVBackgroundRect* Value);
	
public:
	__fastcall TRVBackgroundRect(void);
	__fastcall virtual ~TRVBackgroundRect(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall PrepareDraw(Types::TRect &Rect);
	void __fastcall PrepareDrawSaD(Types::TRect &Rect, const TRVScreenAndDevice &sad);
	void __fastcall Draw(const Types::TRect &Rect, Graphics::TCanvas* Canvas, bool Printing, TRVColorMode ColorMode);
	bool __fastcall IsEqual(TRVBackgroundRect* Value);
	bool __fastcall IsEqual_Para(TRVBackgroundRect* Value, const TRVParaInfoProperties &IgnoreList);
	void __fastcall AssignValidProperties(TRVBackgroundRect* Source, TRVParaInfoProperties1 ValidProperties);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	
__published:
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=536870911};
	__property TRVRect* BorderOffsets = {read=FBorderOffsets, write=SetBorderOffsets};
};


class DELPHICLASS TRVTabInfo;
class PASCALIMPLEMENTATION TRVTabInfo : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	int FPosition;
	AnsiString FLeader;
	TRVTabAlign FAlign;
	bool __fastcall StoreLeader(void);
	void __fastcall SetPosition(const int Value);
	
protected:
	virtual AnsiString __fastcall GetDisplayName();
	
public:
	bool __fastcall IsEqual(TRVTabInfo* Value);
	int __fastcall SimilarityValue(TRVTabInfo* Value);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	
__published:
	__property TRVTabAlign Align = {read=FAlign, write=FAlign, default=0};
	__property int Position = {read=FPosition, write=SetPosition, nodefault};
	__property AnsiString Leader = {read=FLeader, write=FLeader, stored=StoreLeader};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TRVTabInfo(Classes::TCollection* Collection) : Classes::TCollectionItem(Collection) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TRVTabInfo(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVTabInfos;
class PASCALIMPLEMENTATION TRVTabInfos : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
public:
	TRVTabInfo* operator[](int Index) { return Items[Index]; }
	
private:
	Classes::TPersistent* FOwner;
	HIDESBASE TRVTabInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TRVTabInfo* Value);
	
public:
	__fastcall TRVTabInfos(Classes::TPersistent* Owner);
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	HIDESBASE TRVTabInfo* __fastcall Add(void);
	void __fastcall SortTabs(void);
	bool __fastcall IsEqual(TRVTabInfos* Value);
	int __fastcall Find(int Position);
	int __fastcall SimilarityValue(TRVTabInfos* Value);
	void __fastcall Intersect(TRVTabInfos* Value);
	void __fastcall AddFrom(TRVTabInfos* Source);
	void __fastcall DeleteList(Rvclasses::TRVIntegerList* Positions);
	__property TRVTabInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TRVTabInfos(void) { }
	#pragma option pop
	
};


class DELPHICLASS TCustomRVParaInfo;
class DELPHICLASS TParaInfo;
class PASCALIMPLEMENTATION TCustomRVParaInfo : public TCustomRVInfo 
{
	typedef TCustomRVInfo inherited;
	
private:
	int FFirstIndent;
	int FLeftIndent;
	int FRightIndent;
	int FSpaceBefore;
	int FSpaceAfter;
	int FLineSpacing;
	TRVLineSpacingType FLineSpacingType;
	TRVAlignment FAlignment;
	TRVBorder* FBorder;
	TRVBackgroundRect* FBackground;
	TRVParaOptions FOptions;
	Rvscroll::TRVBiDiMode FBiDiMode;
	TRVTabInfos* FTabs;
	void __fastcall SetBorder(const TRVBorder* Value);
	void __fastcall SetBackground(const TRVBackgroundRect* Value);
	bool __fastcall ExtraLineSpacing(void);
	void __fastcall SetTabs(const TRVTabInfos* Value);
	
protected:
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID = true);
	DYNAMIC int __fastcall SimilarityValue(TCustomRVInfo* Value);
	
public:
	__fastcall virtual TCustomRVParaInfo(Classes::TCollection* Collection);
	__fastcall virtual ~TCustomRVParaInfo(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall AssignSelectedProperties(TCustomRVParaInfo* Source, const TRVParaInfoProperties &Props);
	HIDESBASEDYNAMIC void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	HIDESBASEDYNAMIC void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	DYNAMIC bool __fastcall IsEqual(TCustomRVParaInfo* Value, const TRVParaInfoProperties &IgnoreList);
	void __fastcall SaveCSSToStream(Classes::TStream* Stream, TParaInfo* BaseStyle, bool Multiline, bool IgnoreLeftAlignment, bool IgnoreLeftIndents);
	
__published:
	__property int FirstIndent = {read=FFirstIndent, write=FFirstIndent, default=0};
	__property int LeftIndent = {read=FLeftIndent, write=FLeftIndent, default=0};
	__property int RightIndent = {read=FRightIndent, write=FRightIndent, default=0};
	__property int SpaceBefore = {read=FSpaceBefore, write=FSpaceBefore, default=0};
	__property int SpaceAfter = {read=FSpaceAfter, write=FSpaceAfter, default=0};
	__property TRVAlignment Alignment = {read=FAlignment, write=FAlignment, default=0};
	__property TRVBorder* Border = {read=FBorder, write=SetBorder};
	__property TRVBackgroundRect* Background = {read=FBackground, write=SetBackground};
	__property int LineSpacing = {read=FLineSpacing, write=FLineSpacing, default=100};
	__property TRVLineSpacingType LineSpacingType = {read=FLineSpacingType, write=FLineSpacingType, default=0};
	__property TRVParaOptions Options = {read=FOptions, write=FOptions, default=0};
	__property Rvscroll::TRVBiDiMode BiDiMode = {read=FBiDiMode, write=FBiDiMode, default=0};
	__property TRVTabInfos* Tabs = {read=FTabs, write=SetTabs};
};


class PASCALIMPLEMENTATION TParaInfo : public TCustomRVParaInfo 
{
	typedef TCustomRVParaInfo inherited;
	
private:
	int FNextParaNo;
	int FDefStyleNo;
	TRVParaInfoProperties1 FModifiedProperties1;
	TRVParaInfoProperties2 FModifiedProperties2;
	
protected:
	DYNAMIC bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping);
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID = true);
	void __fastcall ExcludeUnmodifiedProperties(TCustomRVParaInfo* Source, const TRVParaInfoProperties &PossibleProps);
	
public:
	__fastcall virtual TParaInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	DYNAMIC bool __fastcall IsEqual(TCustomRVParaInfo* Value, const TRVParaInfoProperties &IgnoreList);
	DYNAMIC void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	DYNAMIC void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	
__published:
	__property int NextParaNo = {read=FNextParaNo, write=FNextParaNo, default=-1};
	__property int DefStyleNo = {read=FDefStyleNo, write=FDefStyleNo, default=-1};
	__property TRVParaInfoProperties1 ModifiedProperties1 = {read=FModifiedProperties1, write=FModifiedProperties1, default=0};
	__property TRVParaInfoProperties2 ModifiedProperties2 = {read=FModifiedProperties2, write=FModifiedProperties2, default=0};
public:
	#pragma option push -w-inl
	/* TCustomRVParaInfo.Destroy */ inline __fastcall virtual ~TParaInfo(void) { }
	#pragma option pop
	
};


class DELPHICLASS TParaInfos;
class PASCALIMPLEMENTATION TParaInfos : public TCustomRVInfos 
{
	typedef TCustomRVInfos inherited;
	
public:
	TParaInfo* operator[](int Index) { return Items[Index]; }
	
private:
	TParaInfo* FInvalidItem;
	HIDESBASE TParaInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TParaInfo* Value);
	TParaInfo* __fastcall GetInvalidItem(void);
	void __fastcall SetInvalidItem(const TParaInfo* Value);
	
public:
	HIDESBASE TParaInfo* __fastcall Add(void);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	__fastcall virtual ~TParaInfos(void);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	int __fastcall FindSuchStyle(int BaseStyle, TParaInfo* Style, const TRVParaInfoProperties &Mask);
	int __fastcall FindStyleWithAlignment(int BaseStyle, TRVAlignment Alignment);
	__property TParaInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
	__property TParaInfo* InvalidItem = {read=GetInvalidItem, write=SetInvalidItem};
public:
	#pragma option push -w-inl
	/* TCustomRVInfos.Create */ inline __fastcall TParaInfos(TMetaClass* ItemClass, Classes::TPersistent* Owner) : TCustomRVInfos(ItemClass, Owner) { }
	#pragma option pop
	
};


class DELPHICLASS TRVMarkerFont;
class PASCALIMPLEMENTATION TRVMarkerFont : public Graphics::TFont 
{
	typedef Graphics::TFont inherited;
	
private:
	bool __fastcall StoreName(void);
	bool __fastcall StoreHeight(void);
	
public:
	__fastcall TRVMarkerFont(void);
	bool __fastcall IsEqual(Graphics::TFont* Font);
	bool __fastcall IsDefault(void);
	
__published:
	__property Charset  = {default=1};
	__property Color  = {default=-16777208};
	__property Name  = {stored=StoreName};
	__property Style  = {default=0};
	__property Height  = {stored=StoreHeight};
public:
	#pragma option push -w-inl
	/* TFont.Destroy */ inline __fastcall virtual ~TRVMarkerFont(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVListLevel;
class PASCALIMPLEMENTATION TRVListLevel : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	TRVListType FListType;
	Graphics::TPicture* FPicture;
	Imglist::TCustomImageList* FImageList;
	int FImageIndex;
	AnsiString FFormatString;
	WideString FFormatStringW;
	int FLeftIndent;
	int FFirstIndent;
	int FMarkerIndent;
	TRVMarkerAlignment FMarkerAlignment;
	TRVMarkerFont* FFont;
	TRVListLevelOptions FOptions;
	int FStartFrom;
	Graphics::TPicture* __fastcall GetPicture(void);
	void __fastcall SetPicture(const Graphics::TPicture* Value);
	TRVMarkerFont* __fastcall GetFont(void);
	void __fastcall SetFont(const TRVMarkerFont* Value);
	bool __fastcall StoreFont(void);
	bool __fastcall StorePicture(void);
	void __fastcall ImageListTagWriter(Classes::TWriter* Writer);
	void __fastcall ImageListTagReader(Classes::TReader* Reader);
	void __fastcall FormatStringWCodeWriter(Classes::TWriter* Writer);
	void __fastcall FormatStringWCodeReader(Classes::TReader* Reader);
	void __fastcall FormatStringCodeWriter(Classes::TWriter* Writer);
	void __fastcall FormatStringCodeReader(Classes::TReader* Reader);
	void __fastcall FormatStringCodeWReader(Classes::TReader* Reader);
	bool __fastcall StoreImageList(void);
	Classes::TPersistent* __fastcall GetRVFRVData(void);
	
protected:
	virtual AnsiString __fastcall GetDisplayName();
	bool __fastcall IsSimpleEqual(TRVListLevel* Value);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	int __fastcall SimilarityValue(TRVListLevel* Value);
	
public:
	__fastcall virtual TRVListLevel(Classes::TCollection* Collection);
	__fastcall virtual ~TRVListLevel(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	AnsiString __fastcall GetHTMLOpenTagForCSS();
	AnsiString __fastcall GetIndentCSSForTextVersion();
	void __fastcall HTMLOpenTag(Classes::TStream* Stream, bool UseCSS);
	void __fastcall HTMLCloseTag(Classes::TStream* Stream, bool UseCSS);
	bool __fastcall HasPicture(void);
	bool __fastcall UsesFont(void);
	bool __fastcall HasNumbering(void);
	bool __fastcall HasVariableWidth(void);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	
__published:
	__property TRVListType ListType = {read=FListType, write=FListType, default=0};
	__property int StartFrom = {read=FStartFrom, write=FStartFrom, default=1};
	__property Imglist::TCustomImageList* ImageList = {read=FImageList, write=FImageList, stored=StoreImageList};
	__property int ImageIndex = {read=FImageIndex, write=FImageIndex, default=0};
	__property AnsiString FormatString = {read=FFormatString, write=FFormatString, stored=false};
	__property WideString FormatStringW = {read=FFormatStringW, write=FFormatStringW, stored=false};
	__property int LeftIndent = {read=FLeftIndent, write=FLeftIndent, default=0};
	__property int FirstIndent = {read=FFirstIndent, write=FFirstIndent, default=10};
	__property int MarkerIndent = {read=FMarkerIndent, write=FMarkerIndent, default=0};
	__property TRVMarkerAlignment MarkerAlignment = {read=FMarkerAlignment, write=FMarkerAlignment, default=0};
	__property Graphics::TPicture* Picture = {read=GetPicture, write=SetPicture, stored=StorePicture};
	__property TRVMarkerFont* Font = {read=GetFont, write=SetFont, stored=StoreFont};
	__property TRVListLevelOptions Options = {read=FOptions, write=FOptions, default=3};
};


class DELPHICLASS TRVListLevelCollection;
class PASCALIMPLEMENTATION TRVListLevelCollection : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
public:
	TRVListLevel* operator[](int Index) { return Items[Index]; }
	
private:
	Classes::TPersistent* FOwner;
	HIDESBASE TRVListLevel* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, const TRVListLevel* Value);
	
public:
	__fastcall TRVListLevelCollection(Classes::TPersistent* Owner);
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	HIDESBASE TRVListLevel* __fastcall Add(void);
	HIDESBASE TRVListLevel* __fastcall Insert(int Index);
	bool __fastcall IsSimpleEqual(TRVListLevelCollection* Value);
	__property TRVListLevel* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TRVListLevelCollection(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVListInfo;
class PASCALIMPLEMENTATION TRVListInfo : public TCustomRVInfo 
{
	typedef TCustomRVInfo inherited;
	
private:
	TRVListLevelCollection* FLevels;
	bool FOneLevelPreview;
	int FListID;
	void __fastcall SetLevels(const TRVListLevelCollection* Value);
	int __fastcall GetListID(void);
	void __fastcall ReadListID(Classes::TReader* Reader);
	void __fastcall WriteListID(Classes::TWriter* Writer);
	
protected:
	DYNAMIC int __fastcall SimilarityValue(TCustomRVInfo* Value);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	
public:
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID = true);
	DYNAMIC bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping);
	__fastcall virtual TRVListInfo(Classes::TCollection* Collection);
	__fastcall virtual ~TRVListInfo(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	HIDESBASEDYNAMIC void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	HIDESBASEDYNAMIC void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString fs);
	bool __fastcall HasNumbering(void);
	bool __fastcall AllNumbered(void);
	bool __fastcall HasVariableWidth(void);
	__property int ListID = {read=GetListID, nodefault};
	
__published:
	__property TRVListLevelCollection* Levels = {read=FLevels, write=SetLevels};
	__property bool OneLevelPreview = {read=FOneLevelPreview, write=FOneLevelPreview, default=0};
};


class DELPHICLASS TRVListInfos;
class PASCALIMPLEMENTATION TRVListInfos : public TCustomRVInfos 
{
	typedef TCustomRVInfos inherited;
	
public:
	TRVListInfo* operator[](int Index) { return Items[Index]; }
	
private:
	HIDESBASE TRVListInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, const TRVListInfo* Value);
	void __fastcall RemoveImageList(Imglist::TCustomImageList* ImageList);
	
public:
	Classes::TPersistent* FRVData;
	bool FRichViewAllowAssignListID;
	HIDESBASE TRVListInfo* __fastcall Add(void);
	HIDESBASE TRVListInfo* __fastcall Insert(int Index);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	int __fastcall FindSuchStyle(TRVListInfo* Style, bool AddIfNotFound);
	int __fastcall FindStyleWithLevels(TRVListLevelCollection* Levels, const AnsiString StyleNameForAdding, bool AddIfNotFound);
	__property TRVListInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
public:
	#pragma option push -w-inl
	/* TCustomRVInfos.Create */ inline __fastcall TRVListInfos(TMetaClass* ItemClass, Classes::TPersistent* Owner) : TCustomRVInfos(ItemClass, Owner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TRVListInfos(void) { }
	#pragma option pop
	
};


typedef TMetaClass* TRVFontInfoClass;

typedef TMetaClass* TRVParaInfoClass;

typedef TMetaClass* TRVListInfoClass;

class DELPHICLASS TRVSTFontInfo;
class PASCALIMPLEMENTATION TRVSTFontInfo : public TCustomRVFontInfo 
{
	typedef TCustomRVFontInfo inherited;
	
private:
	Classes::TPersistent* FOwner;
	void __fastcall SetNoProp(const int Value);
	
public:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	
__published:
	__property int StyleTemplateId = {write=SetNoProp, nodefault};
	__property int StyleName = {write=SetNoProp, nodefault};
	__property int Standard = {write=SetNoProp, nodefault};
	__property int BaseStyleNo = {write=SetNoProp, nodefault};
public:
	#pragma option push -w-inl
	/* TCustomRVFontInfo.Create */ inline __fastcall virtual TRVSTFontInfo(Classes::TCollection* Collection) : TCustomRVFontInfo(Collection) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TRVSTFontInfo(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVSTParaInfo;
class PASCALIMPLEMENTATION TRVSTParaInfo : public TCustomRVParaInfo 
{
	typedef TCustomRVParaInfo inherited;
	
private:
	Classes::TPersistent* FOwner;
	void __fastcall SetNoProp(const int Value);
	
public:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	
__published:
	__property int StyleTemplateId = {write=SetNoProp, nodefault};
	__property int StyleName = {write=SetNoProp, nodefault};
	__property int Standard = {write=SetNoProp, nodefault};
	__property int BaseStyleNo = {write=SetNoProp, nodefault};
public:
	#pragma option push -w-inl
	/* TCustomRVParaInfo.Create */ inline __fastcall virtual TRVSTParaInfo(Classes::TCollection* Collection) : TCustomRVParaInfo(Collection) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomRVParaInfo.Destroy */ inline __fastcall virtual ~TRVSTParaInfo(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVSTListInfo;
class PASCALIMPLEMENTATION TRVSTListInfo : public TRVListInfo 
{
	typedef TRVListInfo inherited;
	
private:
	Classes::TPersistent* FOwner;
	void __fastcall SetNoProp(const int Value);
	
public:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	
__published:
	__property int StyleTemplateId = {write=SetNoProp, nodefault};
	__property int StyleName = {write=SetNoProp, nodefault};
	__property int Standard = {write=SetNoProp, nodefault};
	__property int BaseStyleNo = {write=SetNoProp, nodefault};
public:
	#pragma option push -w-inl
	/* TRVListInfo.Create */ inline __fastcall virtual TRVSTListInfo(Classes::TCollection* Collection) : TRVListInfo(Collection) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TRVListInfo.Destroy */ inline __fastcall virtual ~TRVSTListInfo(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVStyleTemplate;
class PASCALIMPLEMENTATION TRVStyleTemplate : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	AnsiString FName;
	TRVStyleTemplateId FId;
	TRVStyleTemplateId FParentId;
	TRVSTFontInfo* FTextStyle;
	TRVSTParaInfo* FParaStyle;
	TRVSTListInfo* FListStyle;
	TRVFontInfoProperties FValidTextProperties;
	TRVParaInfoProperties1 FValidParaProperties1;
	TRVParaInfoProperties2 FValidParaProperties2;
	TRVStyleTemplate* FParent;
	Classes::TList* FChildren;
	TRVStyleTemplateId __fastcall GetId(void);
	void __fastcall SetTextStyle(const TRVSTFontInfo* Value);
	void __fastcall SetParaStyle(const TRVSTParaInfo* Value);
	void __fastcall ReadID(Classes::TReader* Reader);
	void __fastcall WriteID(Classes::TWriter* Writer);
	void __fastcall AddChild(TRVStyleTemplate* Child);
	void __fastcall RemoveChild(TRVStyleTemplate* Child);
	void __fastcall SetParentId(const TRVStyleTemplateId Value);
	void __fastcall UpdateParentReference(void);
	void __fastcall SetName(const AnsiString Value);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	TRVFontInfoProperties __fastcall AssignToTextStyle(TCustomRVFontInfo* ATextStyle, TRVFontInfoProperties AllowedProps);
	TRVParaInfoProperties __fastcall AssignToParaStyle(TCustomRVParaInfo* AParaStyle, const TRVParaInfoProperties &AllowedProps);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	
public:
	__fastcall virtual TRVStyleTemplate(Classes::TCollection* Collection);
	__fastcall virtual ~TRVStyleTemplate(void);
	virtual AnsiString __fastcall GetDisplayName();
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	bool __fastcall IsAncestorFor(TRVStyleTemplate* StyleTemplate);
	void __fastcall ExcludeUnmodifiedTextStyleProperties(TFontInfo* ATextStyle, TRVFontInfoProperties PossibleProps);
	void __fastcall ExcludeUnmodifiedParaStyleProperties(TParaInfo* AParaStyle, const TRVParaInfoProperties &PossibleProps);
	void __fastcall ApplyToTextStyle(TCustomRVFontInfo* ATextStyle, TCustomRVParaInfo* AParaStyle, bool OverrideModifiedProperties);
	void __fastcall ApplyToParaStyle(TCustomRVParaInfo* AParaStyle, bool OverrideModifiedProperties);
	
__published:
	__property TRVSTFontInfo* TextStyle = {read=FTextStyle, write=SetTextStyle};
	__property TRVSTParaInfo* ParaStyle = {read=FParaStyle, write=SetParaStyle};
	__property TRVFontInfoProperties ValidTextProperties = {read=FValidTextProperties, write=FValidTextProperties, default=0};
	__property TRVParaInfoProperties1 ValidParaProperties1 = {read=FValidParaProperties1, write=FValidParaProperties1, default=0};
	__property TRVParaInfoProperties2 ValidParaProperties2 = {read=FValidParaProperties2, write=FValidParaProperties2, default=0};
	__property AnsiString Name = {read=FName, write=SetName};
	__property TRVStyleTemplateId Id = {read=GetId, nodefault};
	__property TRVStyleTemplateId ParentId = {read=FParentId, write=SetParentId, default=-1};
};


class DELPHICLASS TRVStyleTemplateCollection;
class PASCALIMPLEMENTATION TRVStyleTemplateCollection : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
public:
	TRVStyleTemplate* operator[](int Index) { return Items[Index]; }
	
private:
	int FNameCounter;
	AnsiString FDefStyleName;
	TRVStyleTemplate* FNormalStyleTemplate;
	HIDESBASE TRVStyleTemplate* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, const TRVStyleTemplate* Value);
	void __fastcall AssignUniqueNameTo(TRVStyleTemplate* Item);
	bool __fastcall StoreDefStyleName(void);
	void __fastcall UpdateParentReferences(void);
	
protected:
	Classes::TPersistent* FOwner;
	
public:
	__fastcall TRVStyleTemplateCollection(Classes::TPersistent* Owner);
	void __fastcall ResetNameCounter(void);
	void __fastcall Sort(void);
	int __fastcall FindById(TRVStyleTemplateId Id);
	int __fastcall FindByName(const AnsiString Name);
	TRVStyleTemplate* __fastcall GetNormalStyleTemplate(void);
	void __fastcall AssignToStrings(Classes::TStrings* Strings, bool AssignObjects);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall AssignStyleTemplates(TRVStyleTemplateCollection* Source, bool CopyIds);
	void __fastcall ClearParaFormat(TCustomRVParaInfo* AParaStyle);
	void __fastcall ClearTextFormat(TCustomRVFontInfo* ATextStyle, TCustomRVParaInfo* AParaStyle);
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	__property TRVStyleTemplate* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
	
__published:
	__property AnsiString DefStyleName = {read=FDefStyleName, write=FDefStyleName, stored=StoreDefStyleName};
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TRVStyleTemplateCollection(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TRVStyle : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Graphics::TPicture* FInvalidPicture;
	Graphics::TColor FColor;
	Graphics::TColor FHoverColor;
	Graphics::TColor FCurrentItemColor;
	Graphics::TColor FSelColor;
	Graphics::TColor FSelTextColor;
	Graphics::TColor FInactiveSelColor;
	Graphics::TColor FInactiveSelTextColor;
	Graphics::TColor FCheckpointColor;
	Graphics::TColor FCheckpointEvColor;
	Controls::TCursor FJumpCursor;
	TFontInfos* FTextStyles;
	TParaInfos* FParaStyles;
	TRVListInfos* FListStyles;
	bool FFullRedraw;
	int FSpacesInTab;
	int FDefTabWidth;
	Graphics::TColor FPageBreakColor;
	Graphics::TColor FSoftPageBreakColor;
	Graphics::TColor FLiveSpellingColor;
	TRVApplyStyleColorEvent FOnApplyStyleColor;
	TRVApplyStyleEvent FOnApplyStyle;
	TRVDrawStyleTextEvent FOnDrawStyleText;
	TRVStyleHoverSensitiveEvent FOnStyleHoverSensitive;
	TRVDrawTextBackEvent FOnDrawTextBack;
	TRVDrawCheckpointEvent FOnDrawCheckpoint;
	TRVDrawPageBreakEvent FOnDrawPageBreak;
	TRVDrawParaRectEvent FOnDrawParaBack;
	Graphics::TColor FFieldHighlightColor;
	TRVFieldHighlightType FFieldHighlightType;
	TRVSeqType FFootnoteNumbering;
	TRVSeqType FEndnoteNumbering;
	bool FFootnotePageReset;
	bool FDefaultUnicodeStyles;
	int FDefUnicodeStyle;
	TRVCodePage FDefCodePage;
	bool FUseSound;
	TRVSelectionMode FSelectionMode;
	TRVSelectionStyle FSelectionStyle;
	Controls::TCursor FLineSelectCursor;
	TRVStyleTemplateCollection* FStyleTemplates;
	void __fastcall SetTextStyles(TFontInfos* Value);
	void __fastcall SetParaStyles(TParaInfos* Value);
	void __fastcall SetListStyles(TRVListInfos* Value);
	Graphics::TColor __fastcall GetHoverColorByColor(Graphics::TColor Color);
	Graphics::TPicture* __fastcall GetInvalidPicture(void);
	void __fastcall SetInvalidPicture(const Graphics::TPicture* Value);
	void __fastcall SetStyleTemplates(const TRVStyleTemplateCollection* Value);
	
protected:
	virtual void __fastcall ReadState(Classes::TReader* Reader);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall Loaded(void);
	
public:
	int ItemNo;
	int OffsetInItem;
	Classes::TPersistent* RVData;
	void __fastcall ResetTextStyles(void);
	void __fastcall ResetParaStyles(void);
	__fastcall virtual TRVStyle(Classes::TComponent* AOwner);
	__fastcall virtual ~TRVStyle(void);
	virtual TMetaClass* __fastcall GetTextStyleClass(void);
	virtual TMetaClass* __fastcall GetParaStyleClass(void);
	virtual TMetaClass* __fastcall GetListStyleClass(void);
	void __fastcall GetNextTab(int ParaNo, int X, const TRVScreenAndDevice &sad, int &Position, AnsiString &Leader, TRVTabAlign &Align, Rvscroll::TRVBiDiMode DefBiDiMode, int LeftIndent, int RightIndent);
	int __fastcall AddTextStyle(void);
	void __fastcall DeleteTextStyle(int Index);
	void __fastcall SaveINI(const AnsiString FileName, const AnsiString Section);
	void __fastcall LoadINI(const AnsiString FileName, const AnsiString Section);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, AnsiString Section);
	void __fastcall SaveReg(const AnsiString BaseKey);
	void __fastcall LoadReg(const AnsiString BaseKey);
	void __fastcall SaveCSSToStream(Classes::TStream* Stream, TRVSaveCSSOptions AOptions);
	bool __fastcall SaveCSS(const AnsiString FileName, TRVSaveCSSOptions AOptions);
	Graphics::TColor __fastcall GetHoverColor(int StyleNo);
	void __fastcall DrawTextBack(Graphics::TCanvas* Canvas, int ItemNo, int StyleNo, Classes::TPersistent* RVData, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState);
	void __fastcall ApplyStyle(Graphics::TCanvas* Canvas, int StyleNo, Rvscroll::TRVBiDiMode DefBiDiMode, bool CanUseCustomPPI, PRVExtraFontInfo ExtraFontInfo, bool IgnoreSubSuperScript);
	void __fastcall ApplyStyleColor(Graphics::TCanvas* Canvas, int StyleNo, TRVTextDrawStates DrawState, bool Printing, TRVColorMode ColorMode);
	void __fastcall DrawStyleText(const AnsiString s, Graphics::TCanvas* Canvas, int ItemNo, int OffsetInItem, int StyleNo, Classes::TPersistent* RVData, int SpaceBefore, int Left, int Top, int Width, int Height, int BaseLine, TRVTextDrawStates DrawState, bool Printing, bool PreviewCorrection, TRVColorMode ColorMode, Rvscroll::TRVBiDiMode DefBiDiMode, Graphics::TCanvas* RefCanvas);
	void __fastcall DrawCheckpoint(Graphics::TCanvas* Canvas, int X, int Y, int AreaLeft, int Width, Classes::TPersistent* RVData, int ItemNo, int XShift, bool RaiseEvent, Controls::TControl* Control);
	void __fastcall DrawPageBreak(Graphics::TCanvas* Canvas, int Y, int XShift, TRVPageBreakType PageBreakType, Controls::TControl* Control, Classes::TPersistent* RVData, int ItemNo);
	void __fastcall DrawParaBack(Graphics::TCanvas* Canvas, int ParaNo, const Types::TRect &Rect, bool Printing, TRVColorMode ColorMode);
	bool __fastcall StyleHoverSensitive(int StyleNo);
	__property bool DefaultUnicodeStyles = {read=FDefaultUnicodeStyles, write=FDefaultUnicodeStyles, nodefault};
	
__published:
	__property TFontInfos* TextStyles = {read=FTextStyles, write=SetTextStyles};
	__property TParaInfos* ParaStyles = {read=FParaStyles, write=SetParaStyles};
	__property TRVListInfos* ListStyles = {read=FListStyles, write=SetListStyles};
	__property int SpacesInTab = {read=FSpacesInTab, write=FSpacesInTab, default=0};
	__property int DefTabWidth = {read=FDefTabWidth, write=FDefTabWidth, default=48};
	__property Controls::TCursor JumpCursor = {read=FJumpCursor, write=FJumpCursor, default=101};
	__property Controls::TCursor LineSelectCursor = {read=FLineSelectCursor, write=FLineSelectCursor, default=106};
	__property bool FullRedraw = {read=FFullRedraw, write=FFullRedraw, default=0};
	__property bool UseSound = {read=FUseSound, write=FUseSound, default=1};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-16777211};
	__property Graphics::TColor HoverColor = {read=FHoverColor, write=FHoverColor, default=536870911};
	__property Graphics::TColor CurrentItemColor = {read=FCurrentItemColor, write=FCurrentItemColor, default=536870911};
	__property Graphics::TColor SelColor = {read=FSelColor, write=FSelColor, default=-16777203};
	__property Graphics::TColor SelTextColor = {read=FSelTextColor, write=FSelTextColor, default=-16777202};
	__property Graphics::TColor InactiveSelColor = {read=FInactiveSelColor, write=FInactiveSelColor, default=-16777203};
	__property Graphics::TColor InactiveSelTextColor = {read=FInactiveSelTextColor, write=FInactiveSelTextColor, default=-16777202};
	__property Graphics::TColor CheckpointColor = {read=FCheckpointColor, write=FCheckpointColor, default=32768};
	__property Graphics::TColor CheckpointEvColor = {read=FCheckpointEvColor, write=FCheckpointEvColor, default=65280};
	__property Graphics::TColor PageBreakColor = {read=FPageBreakColor, write=FPageBreakColor, default=-16777200};
	__property Graphics::TColor SoftPageBreakColor = {read=FSoftPageBreakColor, write=FSoftPageBreakColor, default=-16777201};
	__property Graphics::TColor LiveSpellingColor = {read=FLiveSpellingColor, write=FLiveSpellingColor, default=255};
	__property TRVSelectionMode SelectionMode = {read=FSelectionMode, write=FSelectionMode, default=1};
	__property TRVSelectionStyle SelectionStyle = {read=FSelectionStyle, write=FSelectionStyle, default=0};
	__property Graphics::TColor FieldHighlightColor = {read=FFieldHighlightColor, write=FFieldHighlightColor, default=-16777201};
	__property TRVFieldHighlightType FieldHighlightType = {read=FFieldHighlightType, write=FFieldHighlightType, default=1};
	__property TRVSeqType FootnoteNumbering = {read=FFootnoteNumbering, write=FFootnoteNumbering, default=0};
	__property TRVSeqType EndnoteNumbering = {read=FEndnoteNumbering, write=FEndnoteNumbering, default=3};
	__property bool FootnotePageReset = {read=FFootnotePageReset, write=FFootnotePageReset, default=1};
	__property int DefUnicodeStyle = {read=FDefUnicodeStyle, write=FDefUnicodeStyle, default=-1};
	__property TRVCodePage DefCodePage = {read=FDefCodePage, write=FDefCodePage, default=0};
	__property Graphics::TPicture* InvalidPicture = {read=GetInvalidPicture, write=SetInvalidPicture};
	__property TRVApplyStyleEvent OnApplyStyle = {read=FOnApplyStyle, write=FOnApplyStyle};
	__property TRVApplyStyleColorEvent OnApplyStyleColor = {read=FOnApplyStyleColor, write=FOnApplyStyleColor};
	__property TRVDrawStyleTextEvent OnDrawStyleText = {read=FOnDrawStyleText, write=FOnDrawStyleText};
	__property TRVStyleHoverSensitiveEvent OnStyleHoverSensitive = {read=FOnStyleHoverSensitive, write=FOnStyleHoverSensitive};
	__property TRVDrawTextBackEvent OnDrawTextBack = {read=FOnDrawTextBack, write=FOnDrawTextBack};
	__property TRVDrawCheckpointEvent OnDrawCheckpoint = {read=FOnDrawCheckpoint, write=FOnDrawCheckpoint};
	__property TRVDrawPageBreakEvent OnDrawPageBreak = {read=FOnDrawPageBreak, write=FOnDrawPageBreak};
	__property TRVDrawParaRectEvent OnDrawParaBack = {read=FOnDrawParaBack, write=FOnDrawParaBack};
	__property TRVStyleTemplateCollection* StyleTemplates = {read=FStyleTemplates, write=SetStyleTemplates};
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint crJump = 0x65;
static const Shortint crRVFlipArrow = 0x6a;
static const Shortint rvsNormal = 0x0;
static const Shortint rvsHeading = 0x1;
static const Shortint rvsSubheading = 0x2;
static const Shortint rvsKeyword = 0x3;
static const Shortint rvsJump1 = 0x4;
static const Shortint rvsJump2 = 0x5;
static const Shortint rvsBreak = -1;
static const Shortint rvsCheckpoint = -2;
static const Shortint rvsPicture = -3;
static const Shortint rvsHotspot = -4;
static const Shortint rvsComponent = -5;
static const Shortint rvsBullet = -6;
static const Shortint rvsBack = -7;
static const Shortint rvsVersionInfo = -8;
static const Shortint rvsDocProperty = -9;
static const Shortint rvsHotPicture = -10;
static const Shortint rvsListMarker = -11;
static const Shortint rvsTab = -12;
static const Shortint LAST_DEFAULT_STYLE_NO = 0x5;
static const int rvsDefStyle = 2147483647;
extern PACKAGE TRVRTFOptions rvrtfDefault;
extern PACKAGE TRVFontInfoProperties RVAllFontInfoProperties;
extern PACKAGE TRVParaInfoProperties RVAllParaInfoProperties;
extern PACKAGE TRVParaInfoProperties RVAllParaInfoProperties1;
extern PACKAGE TRVParaInfoProperties RVAllParaInfoProperties2;
extern PACKAGE TRVParaInfoProperties RVAllParaBackgroundProperties;
extern PACKAGE TRVParaInfoProperties RVAllParaBorderProperties;
extern PACKAGE bool RichViewResetStandardFlag;
extern PACKAGE bool RVNoLstIDProperty;
extern PACKAGE bool RichViewCompareStyleNames;
extern PACKAGE TRVSpecialCharacters RVVisibleSpecialCharacters;
extern PACKAGE void __fastcall RVDrawUnderline(Graphics::TCanvas* Canvas, TRVUnderlineType UnderlineType, Graphics::TColor Color, int Left, int Right, int Y, int BaseLineWidth);
extern PACKAGE void __fastcall RVWrite(Classes::TStream* Stream, const AnsiString s);
extern PACKAGE void __fastcall RVWriteLn(Classes::TStream* Stream, const AnsiString s);
extern PACKAGE void __fastcall RVWriteX(Classes::TStream* Stream, const AnsiString s, bool Multiline);

}	/* namespace Rvstyle */
using namespace Rvstyle;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Rvstyle
