//---------------------------------------------------------------------------
// Important settings:
//    rvoTagsArePChars in RichViewEdit1->Options
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void GetFieldItemNo(TCustomRichView* rv, const UnicodeString field, int& ItemNo)
{
  if (ItemNo>=0 && ItemNo<rv->ItemCount &&
     UnicodeString(PChar(rv->GetItemTag(ItemNo))) == field)
    return;
  ItemNo = -1;
  for (int i=0; i<rv->ItemCount; i++)
    if (UnicodeString(PChar(rv->GetItemTag(i))) == field)
    {
      ItemNo = i;
      return;
    }
}
//---------------------------------------------------------------------------
UnicodeString GetFieldValue(TCustomRichView* rv, const UnicodeString field,
  int& LastItemNo)
{
  GetFieldItemNo(rv, field, LastItemNo);
  if (LastItemNo>=0)
    return rv->GetItemTextW(LastItemNo);
  else
    return "";
}
//---------------------------------------------------------------------------
void SetFieldValue(TCustomRichViewEdit* rv, const UnicodeString field,
  const UnicodeString value, int& LastItemNo)
{
  GetFieldItemNo(rv, field, LastItemNo);
  if (LastItemNo>=0)
    rv->SetItemTextEdW(LastItemNo, value);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichViewEdit1->Clear();
  RichViewEdit1->AddNLWTag("Insert fields here",0,0,0);
  RichViewEdit1->Format();
}
//---------------------------------------------------------------------------
void TForm1::InsertField(const UnicodeString field, const UnicodeString value,
  int & LastItemNo)
{
  if (GetFieldValue(RichViewEdit1, field, LastItemNo)!="")
  {
    Application->MessageBox(L"Field already exists!", L"",0);
    return;
  }
  int StyleNo = RichViewEdit1->CurParaStyleNo;
  RichViewEdit1->CurTextStyleNo = 6;
  RichViewEdit1->InsertStringWTag(value, (int)StrNew(field.w_str()));
  RichViewEdit1->CurTextStyleNo = StyleNo;
  RichViewEdit1->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  InsertField("name", Edit1->Text, LastNameItemNo);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  InsertField("date", Edit2->Text, LastDateItemNo);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
  RichViewEdit1->ApplyTextStyle(0);
  RichViewEdit1->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit1Change(TObject *Sender)
{
  if (Freeze)
    return;
  Freeze = true;
  try
  {
    SetFieldValue(RichViewEdit1, "name", Edit1->Text, LastNameItemNo);
  }
  catch(...)
  {
  }
  Freeze = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit2Change(TObject *Sender)
{
  if (Freeze)
    return;
  Freeze = true;
  try
  {
    SetFieldValue(RichViewEdit1, "date", Edit2->Text, LastDateItemNo);
  }
  catch(...)
  {
  }
  Freeze = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichViewEdit1Change(TObject *Sender)
{
  if (Freeze)
    return;
  Freeze = true;
  try
  {
    UnicodeString s = GetFieldValue(RichViewEdit1, "name", LastNameItemNo);
    if (s!="")
      Edit1->Text = s;
    s = GetFieldValue(RichViewEdit1, "date", LastDateItemNo);
    if (s!="")
      Edit2->Text = s;
  }
  catch(...)
  {
  }
  Freeze = false;
}
//---------------------------------------------------------------------------