/*------------------------------------------------------------------------------
 Implementing "fields"
 The main property settings:
 - rvoTagsArePChars in RichViewEdit1->Options (so each item can have associated string)
 - RVStyle1->TextStyles collection has two styles (for static text and for fields)
   Especially look at Protection properties
 - RichViewEdit1 is set to "use predefined set of styles" (right click on
   RichViewEdit1 in design time, then choose "Settings")
 - AcceptDragDropFormats = []

------------------------------------------------------------------------------*/

#include <vcl\vcl.h>
#include <SysUtils.hpp>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"


TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
bool GetFieldLocation(TCustomRVData* RootRVData, const UnicodeString Field,
  TCustomRVData* &RVData, int &ItemNo)
{
  for (int i=0; i<RootRVData->ItemCount; i++)
    if (RootRVData->GetItemStyle(i)==rvsTable)
    {
      TRVTableItemInfo* table = (TRVTableItemInfo*)(RootRVData->GetItem(i));
      for (int r=0; r<table->Rows->Count; r++)
        for (int c=0; c<table->Rows->Items[r]->Count; c++)
          if (table->Cells[r][c])
            if (GetFieldLocation(table->Cells[r][c]->GetRVData(), Field, RVData, ItemNo))
              return true;
    }
    else if (UnicodeString((wchar_t*)(RootRVData->GetItemTag(i)))==Field)
    {
      ItemNo = i;
      RVData = RootRVData->GetSourceRVData();
      return true;
    }
  return false;
}
//---------------------------------------------------------------------------
AnsiString GetFieldValue(TCustomRichView* rv, const UnicodeString Field)
{
  TCustomRVData* RVData;
  int ItemNo;
  if (GetFieldLocation(rv->RVData, Field, RVData, ItemNo))
    return RVData->GetItemTextW(ItemNo);
  else
    return "";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichViewEdit1->Clear();
  RichViewEdit1->AddNLWTag("2 + 2 =", 1,0,0);
  RichViewEdit1->AddNLWTag("  ", 0,-1, Integer(StrNew(L"answer1")));
  RichViewEdit1->AddNLWTag("?", 1,-1,0);
  RichViewEdit1->AddNLWTag("3 + 3 =", 1,0,0);
  RichViewEdit1->AddNLWTag("  ", 0,-1, Integer(StrNew(L"answer2")));
  RichViewEdit1->AddNLWTag("?", 1,-1,0);
  RichViewEdit1->Format();
  RichViewEdit1->SetSelectionBounds(1,2,1,2);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichViewEdit1Paste(TCustomRichViewEdit *Sender,
  bool &DoDefault)
{
  // allowing to paste only one line text

  if (Clipboard()->HasFormat(CF_UNICODETEXT))
  {
  UnicodeString s = Clipboard()->AsText;
  if (!wcschr(s.w_str(), '\r') && !wcschr(s.w_str(), '\n'))
    RichViewEdit1->InsertTextW(s,false);
  }
  DoDefault = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  UnicodeString s = GetFieldValue(RichViewEdit1, "answer1");
  if (StrToIntDef(Trim(s), 0)!=4)
  {
    Application->MessageBox(L"Wrong! Try again", L"Test", 0);
    return;
  }
  s = GetFieldValue(RichViewEdit1, "answer2");
  if (StrToIntDef(Trim(s), 0)!=6)
  {
    Application->MessageBox(L"Wrong! Try again", L"Test", 0);
    return;
  }
  Application->MessageBox(L"Test is passed", L"Test", 0);
}
//---------------------------------------------------------------------------