// Link.cpp : implementation file
//
#include "stdafx.h"
#include "Link.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLink

CLink* CLink::m_pOldStatic = NULL;
const char cEmpty[]="";
const char cSansSerif[]="MS Sans Serif";


CLink::CLink()
{
	m_sAction = cEmpty;
	m_bMailAndHttp = true;
	m_pOldStatic = (this);
	m_bMouseOver = false;
	m_pLButtonDownProc = NULL;
	SetStyles();
}

CLink::~CLink()
{
}

BEGIN_MESSAGE_MAP(CLink, CStatic)
	//{{AFX_MSG_MAP(CLink)
	ON_WM_PAINT()
	ON_WM_MOUSEACTIVATE()
	ON_WM_SETCURSOR()
	ON_WM_NCHITTEST()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLink message handlers

void CLink::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	RECT rct;
	GetWindowRect(&rct);

	dc.FillSolidRect(0,0,rct.right - rct.left,rct.bottom - rct.top,m_BkColor);

	dc.SetBkColor(m_BkColor);

	if (m_bMouseOver) {
		dc.SetTextColor(m_OnColor);
		dc.SelectObject(&m_OnFont);
	}
	else {
		dc.SetTextColor(m_OutColor);
		dc.SelectObject(&m_OutFont);
	}

	GetWindowText(m_sText);
	dc.TextOut(0,0,m_sText);
}

UINT CLink::OnNcHitTest(CPoint point) 
{
	return HTCLIENT;
}

int CLink::OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message) 
{
	if (message==WM_LBUTTONDOWN) {
		if (m_pLButtonDownProc!=NULL) m_pLButtonDownProc();
		else if (m_bMailAndHttp) {
			if (m_sAction.IsEmpty()) GetWindowText(m_sText);
			else m_sText = m_sAction;
			ShellExecute(NULL,NULL,m_sText,NULL,NULL,SW_SHOWNORMAL);
		}
	}
	return MA_NOACTIVATE;
}

void CLink::RelaySetCursor(CWnd* pWnd)
{
	bool bNew = (pWnd->m_hWnd==m_hWnd);

	if (bNew!=m_bMouseOver) {
		m_bMouseOver = bNew;

		if (m_bMouseOver) {
			if (m_hCursor!=NULL)
				m_hOldCursor = ::SetCursor(m_hCursor);
			if (m_pOldStatic!=(this)) {
				m_pOldStatic->RelaySetCursor(pWnd);
				m_pOldStatic = (this);
			}
		}
		else {
			if (m_hOldCursor!=NULL) {
				::SetCursor(m_hOldCursor);
				m_hOldCursor = NULL;
			}
		}

		RECT rct;
		GetWindowRect(&rct);
		rct.bottom-= rct.top; rct.top = 0;
		rct.right-= rct.left; rct.left = 0;

		RedrawWindow(&rct,NULL,RDW_INVALIDATE | RDW_UPDATENOW | RDW_ERASE );
	}
}

BOOL CLink::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	RelaySetCursor(pWnd);
	return 0;
}

void CLink::SetStyles()
{
	m_hCursor = NULL;
	m_hOldCursor = NULL;
	m_OutFont.CreateFont(-8,0,0,0,FW_NORMAL,0,0,0,DEFAULT_CHARSET,OUT_RASTER_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,cSansSerif);
	m_OnFont.CreateFont(-8,0,0,0,FW_NORMAL,0,1,0,DEFAULT_CHARSET,OUT_RASTER_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH,cSansSerif);
	m_BkColor = GetSysColor(COLOR_3DFACE);
	m_OutColor = GetSysColor(COLOR_WINDOWTEXT)^0x0FF0000;
	m_OnColor = m_OutColor^0x0FF00FF;
}
