/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <signal.h>
#include <stdlib.h>
#include <stdio.h>
static int *_xceptblkptr;
static int ctrlchandlerInstalled ;

static void regdump(char *text, PCONTEXT p)
{
   // for console programs, dump an error to the console instead of
   // going to the crash message box
   if (GetStdHandle(STD_OUTPUT_HANDLE) != INVALID_HANDLE_VALUE) {
      fprintf(stderr,"\n%s\n\n",text);
      fprintf(stderr,"CS:EIP %04X:%08X  SS:ESP %04X:%08X\n",p->SegCs,p->Eip,p->SegSs,p->Esp);
		fprintf(stderr,"EAX: %08X  EBX: %08X  ECX: %08X  EDX: %08X  flags: %08X\n",
            p->Eax, p->Ebx, p->Ecx, p->Edx, p->EFlags);
      fprintf(stderr,"EBP: %08X  ESI: %08X  EDI: %08X\n",p->Ebp,p->Esi,p->Edi);
		fprintf(stderr," DS:     %04X   ES:     %04X   FS:     %04X   GS:     %04X\n",
         p->SegDs,p->SegEs,p->SegFs,p->SegGs);
      exit(1) ;
   }
}
static LONG PASCAL _xceptionhandle(PEXCEPTION_POINTERS p ) 
{

   int signum = -1,rv = 1;
   switch(p->ExceptionRecord->ExceptionCode) {
		case EXCEPTION_ACCESS_VIOLATION:
		case EXCEPTION_DATATYPE_MISALIGNMENT:
		case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:
			signum = SIGSEGV;
			break ;
		case EXCEPTION_PRIV_INSTRUCTION:
			signum = SIGILL;
			break ;
      case EXCEPTION_BREAKPOINT:
         // IF they really want to put a breakpoint in, let them but move on
         return EXCEPTION_CONTINUE_EXECUTION ;
		case EXCEPTION_SINGLE_STEP:
         return EXCEPTION_CONTINUE_EXECUTION ;
		case EXCEPTION_FLT_DENORMAL_OPERAND:
		case EXCEPTION_FLT_DIVIDE_BY_ZERO:
		case EXCEPTION_FLT_INEXACT_RESULT:
		case EXCEPTION_FLT_INVALID_OPERATION:
		case EXCEPTION_FLT_OVERFLOW:
		case EXCEPTION_FLT_STACK_CHECK:
		case EXCEPTION_FLT_UNDERFLOW:
			signum = SIGFPE ;
			break ;
		case EXCEPTION_INT_DIVIDE_BY_ZERO:
         regdump("Divide by zero", p->ContextRecord) ;
			break ;
		case EXCEPTION_INT_OVERFLOW:
			break ;
		case EXCEPTION_NONCONTINUABLE_EXCEPTION:
		case EXCEPTION_INVALID_DISPOSITION:
			break ;
		case EXCEPTION_STACK_OVERFLOW:
			break ;
	}
	if (signum != -1)
      rv = raise(signum);

   if (rv) {
      if (signum == SIGSEGV) {
         regdump("Access Violation",p->ContextRecord) ;
      }
      return EXCEPTION_CONTINUE_SEARCH ;
   } else {
      return EXCEPTION_CONTINUE_EXECUTION ;
   }
}
static BOOL PASCAL ControlCHandler(DWORD type)
{
   if (type == CTRL_C_EVENT || type == CTRL_BREAK_EVENT)
      raise(SIGINT) ;
   exit(0xff);
   return FALSE ;
}
void PASCAL __xceptinit(int *block)
{
   SetUnhandledExceptionFilter((LPTOP_LEVEL_EXCEPTION_FILTER)_xceptionhandle);
}
void PASCAL __xceptrundown(void)
{
   if (ctrlchandlerInstalled)
      SetConsoleCtrlHandler(ControlCHandler,0);
	return ;
}
void _ll_signal(int signum, void (*func)())
{
   if (signum == SIGINT && !ctrlchandlerInstalled) {
      SetConsoleCtrlHandler(ControlCHandler,1);
      ctrlchandlerInstalled = TRUE ;
   }
}