/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <stdarg.h>
#include <time.h>
#include <dir.h>
#include <libp.h>


static int spawnbase(const char *path, const char *args[], 
										 const char *env[], int toexit, int tosearch)
{
	FILE *fil;
  int rv;
	char name[128],*vv;
	char parms[500];
	parms[0] = ' ';
	parms[1] = 0;
	while (*++args)
		strcat(parms,*args);
	strcpy(name,path);
	if (!(vv = searchpath(name))) {
		strcat(name,".EXE");
		if (!(vv = searchpath(name))) {
			strcpy(name,path);
			strcat(name,".COM");
			if (!(vv = searchpath(name))) {
            return -1 ;
			}
		}
	}
   fflush(0) ;
   rv = _ll_spawn(vv,parms,env,toexit);
	if (toexit)
		exit(rv);
	return rv;
}
static char **findenv(const char **argv)
{
   char **vv;
	vv = argv;
	while (*vv)
		vv++;
   return (*++vv);
}
int execl(const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,0,1,0);
}
int execle(const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,findenv(&argv0),1,0);
}
int execlp(const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,0,1,1);
}
int execlpe(const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,findenv(&argv0),1,1);
}
int execv(const char *path, const char **argv)
{
	return spawnbase(path,&argv,0,1,0);
}
int execve(const char *path, const char **argv, const char **env)
{
	return spawnbase(path,argv,env,1,0);
}
int execvp(const char *path, const char **argv)
{
	return spawnbase(path,argv,0,1,1);
}
int execvpe(const char *path, const char **argv, const char **env)
{
	return spawnbase(path,argv,env,1,1);
}
int spawnl(int mode,const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,0,mode,0);
}
int spawnle(int mode,const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,findenv(&argv0),mode,0);
}
int spawnlp(int mode,const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,0,mode,1);
}
int spawnlpe(int mode,const char *path, const char *argv0,...)
{
	return spawnbase(path,&argv0,findenv(&argv0),mode,1);
}
int spawnv(int mode,const char *path, const char **argv)
{
	return spawnbase(path,&argv,0,mode,0);
}
int spawnve(int mode,const char *path, const char **argv, const char **env)
{
	return spawnbase(path,argv,env,mode,0);
}
int spawnvp(int mode,const char *path, const char **argv)
{
	return spawnbase(path,argv,0,mode,1);
}
int spawnvpe(int mode,const char *path, const char **argv, const char **env)
{
	return spawnbase(path,argv,env,mode,1);
}