/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include "i86.h"
#include "dpmi.h"

void _intr(int intr, union REGPACK *r)
{
   DPMI_REGS dr ;
   dr.d.edi = r->x.edi ;
   dr.d.esi = r->x.esi ;
   dr.d.ebp = r->x.ebp ;
   dr.d.eax = r->x.eax ;
   dr.d.ecx = r->x.ecx ;
   dr.d.edx = r->x.edx ;
   dr.d.ebx = r->x.ebx ;
   dr.h.ds = r->x.ds ;
   dr.h.es = r->x.es ;
   dr.h.fs = r->x.fs ;
   dr.h.gs = r->x.gs ;
   dr.h.flags = r->x.flags | 0x42;
   dr.h.ss = 0 ;
   dr.h.sp = 0 ;
   dpmi_simulate_real_interrupt(intr,&dr);
   r->x.edi = dr.d.edi ;
   r->x.esi = dr.d.esi ;
   r->x.ebp = dr.d.ebp ;
   r->x.eax = dr.d.eax ;
   r->x.ecx = dr.d.ecx ;
   r->x.edx = dr.d.edx ;
   r->x.ebx = dr.d.ebx ;
   r->x.ds = dr.h.ds ;
   r->x.es = dr.h.es ;
   r->x.fs = dr.h.fs ;
   r->x.gs = dr.h.gs ;
   r->x.flags = dr.h.flags ;
}