/***********************  MANDELF.CPP  ***********************************
*                                                                        *
*               Simple Mandelbrodt program                               *
*                         using                                          *
*                       C M A T H                                        *
*         with Borland C++ Builder 4 or higher,                          *
*                                                                        *
*   Copyright 1996-2008 by OptiCode - Dr. Martin Sander Software Dev.    *
*                                                                        *
*                                                                        *
*       This sample program is meant to demonstrate how to use           *
*       CMATH within your Windows programs. No efforts are made          *
*       to provide a comfortable user interface etc.                     *
*       Appearance could be considerably improved by refinement          *
*       of color definition.                                             *
*                                                                        *
**************************************************************************/

/*
In the Borland C++ Builder IDE:
	1. a) Borland C++ Builder 6 or higher, including Borland Developer
		  Studio and Turbo C++ 2006:
                  Open the project MANDELB6.BPR.
	   b) Borland C++ Builder 4 or 5:
                  Open the project MANDELB.BPR.
	2. Check that the include and library paths
	   contain your OptiVec directories
	   (Project/Options/Directories).
	3. In Project/Options/Linker, be sure that
	   "Dynamic RTL" is  n o t  checked.
        4. Compile and run.
*/

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "MANDELF.h"
#include <newcplx.h>
#include <math.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1   *Form1;

   /* Mandelbrodt parameters: */
fComplex  Offset(-0.5f,0), Asymmetry(-0.2f, +0.2f);
float     zoom = 1.0f;
unsigned  maxit = 120;
    // play around with these values!

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}

void __fastcall TForm1::ShowView(TObject *Sender)
{
    DWORD       Colors[16];
        // set the Mandelbrodt parameters at the top of this file
        // (below the #include directives)!
        // A more advanced user interface would have to allow for live
        // input of these parameters. For our purposes, setting them in
        // in the source code has to be enough.
    unsigned  i, j, kk;
    float     scal;
    int       ii, jj;
    unsigned  width, width_2, height, height_2;
    fComplex  CM, ZM;

    Colors[0]   =  0x00000000;  // Black
    Colors[1]   =  0x00800000;  // Dark Blue
    Colors[2]   =  0x00008000;  // Dark Green
    Colors[3]   =  0x00000080;  // Brown
    Colors[4]   =  0x000000A0;  // Dark Red
    Colors[5]   =  0x00808000;  // Cyan
    Colors[6]   =  0x00800080;  // Magenta
    Colors[7]   =  0x00808080;  // Dark Grey
    Colors[8]   =  0x00B0B0B0;  // Light Grey
    Colors[9]   =  0x00FF0000;  // Light Blue
    Colors[10]  =  0x0000FF00;  // Light Green
    Colors[11]  =  0x000000FF;  // Light Red
    Colors[12]  =  0x00FFFF00;  // Light Cyan
    Colors[13]  =  0x00FF00FF;  // Light Magenta
    Colors[14]  =  0x0000FFFF;  // Yellow
    Colors[15]  =  0x00FFFFFF;  // White
    width_2  = (width  = PaintBox1->Width) / 2;
    height_2 = (height = PaintBox1->Height) / 2;
    scal     = 1.5 / zoom / height_2;
    for (i = 0; i < width ; i++)
    {
        ii = i - width_2;
        for (j = 0; j < height; j++)
        {
        jj = j - height_2;
        ZM = fComplex((float)ii, (float)jj) * scal + Offset;
        CM = ZM + Asymmetry;
        for (kk = 0; kk < maxit; kk++)
        {     // iterate until |Z| > 2, or a maximum of maxit times
              // iterative Mandelbrodt formula
            ZM = (ZM*ZM) + CM;
            if( abs(ZM) > 2. ) break;
        }  // kk now can be mapped to the plotting color
        Canvas->Pixels[i][j] = (TColor)Colors[(int)(16.*fabs(sin( kk )))];
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ShowNext(TObject *Sender)
{
   PaintBox1->Invalidate();
}
//---------------------------------------------------------------------------
