from pychartdir import *


def main() :

	#The data for the bar chart
	data = [85, 156, 179.5, 211, 123]

	#The labels for the bar chart
	labels = ["Mon", "Tue", "Wed", "Thu", "Fri"]

	#First, create a XYChart of size 300 pixels x 300 pixels
	c = XYChart(300, 300)

	#Set the plotarea rectangle to start at (50, 40) and of 
	#200 pixels in width and 200 in height
	c.setPlotArea(50, 40, 200, 200)

	#Add a title to the chart
	c.addTitle("Weekly Server Load")

	#Add a title to the y axis
	c.yAxis().setTitle("MBytes")

	#Add a title to the x axis
	c.xAxis().setTitle("Work Week 25")

	#Add a bar chart layer using the supplied data
	c.addBarLayer(data).set3D()

	#Set the x axis labels using the supplied labels
	c.xAxis().setLabels(labels)

	#output the chart as a PNG file
	c.makeChart("threedbar.png")


if __name__ == '__main__':
    main()