from pychartdir import *


def main() :

	#The data for the chart
	data = [85, 156, 179.5, 211, 123]
	labels = ["Mon", "Tue", "Wed", "Thu", "Fri"]

	#First, create a XYChart of size 320 pixels x 320 pixels
	c = XYChart(320, 320)

	#Set the plotarea at (60, 60) and size 200(w) x 200(h). Turn off the
	#grid lines by setting their colors to Transparent.
	c.setPlotArea(60, 60, 200, 200).setGridColor(Transparent)

	#Add a title to the chart
	c.addTitle("Weekday Network Load")

	#Add a title to the y axis
	c.yAxis().setTitle("MBytes")

	#Add green (0x80ff80), yellow (0xffff80) and red (0xff8080) zones to 
	#the y axis to represent the ranges 0 - 100, 100 - 200, and > 200.
	c.yAxis().addZone(0, 100, 0x80ff80)
	c.yAxis().addZone(100, 200, 0xffff80)
	c.yAxis().addZone(200, 9999999, 0xff8080)
	
	#Add a purple (0x800080) mark at y = 155 using a line width of 2.
	c.yAxis().addMark(155, 0x800080, "Target").setLineWidth(2)

	#Add a legend box at the top of the chart at (55, 30). Use horizontal
	#layout, and set the font to 8 points Arial bold (arialbd.ttf).
	legend = c.addLegend(55, 30, 0, "arialbd.ttf", 8)
	
	#Disable the legend box boundary by setting the colors to Transparent
	legend.setBackground(Transparent, Transparent)

	#Add 3 custom entries to the legend box to represent the 3 zones
	legend.addKey("Critical", 0x80ff80)
	legend.addKey("Warning", 0xffff80)
	legend.addKey("Normal", 0xff8080)
	
	#Add a title to the x axis
	c.xAxis().setTitle("Work Week 25")

	#Set the labels on the x axis
	c.xAxis().setLabels(labels)

	#Add a 3D bar layer with the given data
	c.addBarLayer(data, 0x4040ff).set3D()
	
	#output the chart as a PNG file
	c.makeChart("markzone.png")


if __name__ == '__main__':
    main()