from pychartdir import *


def main() :

	#data for the chart
	data0 = [100, 125, 245.78, 147, 67]
	data1 = [85, 156, 179.5, 211, 123]
	data2 = [97, 87, 56, 267, 157]
	labels = ["Mon Jun 4", "Tue Jun 5", "Wed Jun 6", "Thu Jun 7", 
		"Fri Jun 8"]

	#First, create a XYChart of size 540 pixels x 350 pixels
	c = XYChart(540, 350)

	#Set the plot area to start at (120, 40) and of size 280(w) x 240(h)
	c.setPlotArea(120, 40, 280, 240)

	#Add a title to the chart using 20 point Monotype Corsiva (mtcorsva.ttf)
	#font and using a deep blue color (0x000080)
	c.addTitle("Weekly Server Load", "mtcorsva.ttf", 20, 0x000080)
	
	#Add a legend box at (420, 100) using 12 point Times New Roman Bold 
	#(timesbd.ttf) font. Sets the background of the legend box to light grey
	#color (0xd0d0d0) and the border to blue color (0x0000ff)
	c.addLegend(420, 100, 1, "timesbd.ttf", 12).setBackground(0xd0d0d0, 
		0x0000ff)
		
	#Add a title to the y-axis using 12 point Arial Bold (arialbd.ttf)
	#font and using a deep blue color (0x000080). Sets the background box
	#of the title to yellow (0xffff00) and the border to black (0x0)
	c.yAxis().setTitle("Throughput (per hour)", "arialbd.ttf", 12, 0x000080
		).setBackground(0xffff00, 0)

	#Use 10 point Impact (impact.ttf) font as the y-axis label font and
	#deep blue (0x000080) as the font color
	c.yAxis().setLabelStyle("impact.ttf", 10, 0x000080)

	#Set the axis label format to append "MBytes" to the numeric y value
	c.yAxis().setLabelFormat("&value& MBytes")

	#Use 10 point Impact (impact.ttf) font as the x-axis label font and
	#deep green (0x008000) as the font color. Sets the label angle to 45 deg.
	c.xAxis().setLabelStyle("impact.ttf", 10, 0x008000).setFontAngle(45)

	#Set the x axis labels using the supplied labels
	c.xAxis().setLabels(labels)

	#Add a stack bar layer
	layer = c.addBarLayer2(Layer.Stack, 5)

	#Use Arial Italic (ariali.ttf) as the default data label font in the bar	
	layer.setDataLabelStyle("ariali.ttf")

	#Use 10 point Times Bold Italic (timesbi.ttf) as the aggregate label font
	layer.setAggregateLabelStyle("timesbi.ttf", 10)

	#Add the three data sets using the supplied data. For the last data set,
	#set the data label font to Arial Bold (arialbd.ttf) with yellow color
	#to override the default data label font.
	layer.addDataSet(data0, -1, "Server #1")
	layer.addDataSet(data1, -1, "Server #2")
	layer.addDataSet(data2, -1, "Server #3"
		).setDataLabelStyle("arialbd.ttf").setFontColor(0xffff00)

	#output the chart as a PNG file
	c.makeChart("fontxy.png")


if __name__ == '__main__':
    main()
    