from pychartdir import *


#
#	colorpie
#	========
#	function to draw a pie
#
#	parameters:
#	- colorScheme: 0 = custom coloring
#	               1 = dark background coloring
#                 2 = wallpaper as background
#                 3 = wallpaper with semi-transparent pie
#
#	- title: the title shown on the chart
#	- filename: the file to save the chart
#
def colorpie(colorScheme, title, filename) :

	#The data for the pie chart
	data = [ 25, 18, 15, 12, 8, 30, 35 ]

	#The labels for the pie chart
	labels = [ "Labor", "Licenses", "Taxes", "Legal",
		"Insurance", "Facilities", "Production" ] 

	#Colors of the sectors if custom coloring is used
	colors = [ 0xb8bc9c, 0xecf0b9, 0x999966, 0x333366, 0xc3c3e6, 
		0x594330, 0xa0bdc4 ]

	#First, create a PieChart of size 280 pixels x 240 pixels
	c = PieChart(280, 240)

	#Set the center of the pie at (140, 120) and the radius to 80 pixels
	c.setPieSize(140, 120, 80)
	
	#Add a title to the pie chart
	c.addTitle(title)

	#Draw the pie in 3D
	c.set3D()

	#Set the coloring schema
	if colorScheme == 0 :
		#custom coloring, set the LineColor to light gray
		c.setColor(LineColor, 0xc0c0c0)
		#use the custom color array for the data colors (sector colors)
		c.setColors2(DataColor, colors)
	elif colorScheme == 1 :
		#dark background scheme, use the standard white on black palette
		c.setColors(whiteOnBlackPalette)
	elif colorScheme == 2 :
		#wallpaper as background
		c.setWallpaper("bg.png")
	else :
		#wallpaper as background, the sectors are drawn in 
		#semi-transparent colors to allow the background to be seen
		c.setWallpaper("bg.png")
		c.setColors(transparentPalette)

	#Set the pie data and the pie labels
	c.setData(data, labels)

	#Explode the 1st sector
	c.sector(0).setExplode()

	#output the chart as a PNG file
	c.makeChart(filename)


def main() :

	colorpie(0, "Custom Colors", "customcolorpie.png")
	colorpie(1, "Dark Background Colors", "darkbgpie.png")
	colorpie(2, "Wallpaper As Background", "wallpaperpie.png")
	colorpie(3, "Transparent Colors", "transparentpie.png")


if __name__ == '__main__':
    main()
    