from pychartdir import *


def axisscale(axisstyle, filename) :

	data = [5.5, 3.5, -3.7, 1.7, -1.4, 3.3]
	labels = ["Jan", "Feb", "Mar", "Apr", "May", "Jun"]

	c = XYChart(200, 180)
	c.setPlotArea(30, 20, 140, 130)

	if axisstyle == 0 :
		c.addTitle("No Axis Extension", "arial.ttf", 8)
	elif axisstyle == 1 :
		c.addTitle("Top Extension = 0.2", "arial.ttf", 8)
		c.yAxis().setAutoScale(0.2)
	elif axisstyle == 2 :
		c.addTitle("Top/Bottom Extensions = 0.2/0.2", "arial.ttf", 8)
		c.yAxis().setAutoScale(0.2, 0.2)
	elif axisstyle == 3 :
		c.addTitle("Axis Top Margin = 15", "arial.ttf", 8)
		c.yAxis().setTopMargin(15)
	else :
		c.addTitle("Manual Scale -5 to 10", "arial.ttf", 8)
		c.yAxis().setLinearScale(-5, 10, 5)

	c.xAxis().setLabels(labels)
	c.addBarLayer(data)
	c.makeChart(filename);


def main() :

	axisscale(0, "noextaxis.png")
	axisscale(1, "topextaxis.png")
	axisscale(2, "bothextaxis.png")
	axisscale(3, "marginaxis.png")
	axisscale(4, "manualaxis.png")


if __name__ == '__main__':
    main()
    