#include "chartdir.h"

int main(int argc, char *argv[])
{
	//The data for the bar chart
	double data[] = {85, 156, 179.5, 211, 123};

	//The labels for the bar chart
	const char *labels[] = {"Mon", "Tue", "Wed", "Thu", "Fri"};

	//First, create a XYChart of size 250 pixels x 250 pixels
	XYChart *c = XYChart::create(250, 250);

	//Set the plotarea rectangle to start at (30, 20) and of 
	//200 pixels in width and 200 in height
	c->setPlotArea(30, 20, 200, 200);

	//Add a bar chart layer using the supplied data
	c->addBarLayer(sizeof(data) / sizeof(data[0]), data);

	//Set the x axis labels using the supplied labels
	c->xAxis()->setLabels(sizeof(labels) / sizeof(labels[0]), labels);

	//output the chart as a PNG file
	c->makeChart("simplebar.png");

	//destroy the chart to free up resources
	c->destroy();

	return 0;
}
