#include "chartdir.h"

int main(int argc, char *argv[])
{
	//The data for the pie chart
	double data[] = { 25, 18, 15, 12, 8, 30, 35 };

	//The labels for the pie chart
	const char *labels[] = { "Labor", "Licenses", "Taxes", "Legal",
		"Insurance", "Facilities", "Production" }; 

	//First, create a PieChart of size 450 pixels x 300 pixels
	PieChart *c = PieChart::create(450, 300);

	//Set the center of the pie at (150, 150) and the radius to 100 pixels
	c->setPieSize(150, 150, 100);

	//Add a title to the pie chart
	c->addTitle("Project Cost Breakdown");
	
	//Draw the pie in 3D
	c->set3D();

	//add a legend box where the top left corner is at (330, 80)
	c->addLegend(330, 80);
	
	//modify the label format for the sectors to $nnnK (pp.pp%) 
	c->setLabelFormat("$&value&K\n(&percent&%)");
		
	//Set the pie data and the pie labels
	c->setData(sizeof(data)/sizeof(data[0]), data, labels);

	//Explode the 1st sector
	c->sector(0)->setExplode();

	//output the chart as a PNG file
	c->makeChart("legendpie.png");

	//destroy the chart to free up resources
	c->destroy();

	return 0;
}
