#include "chartdir.h"

void axisscale(int axisstyle, const char *filename)
{
	double data[] = {5.5, 3.5, -3.7, 1.7, -1.4, 3.3};
	const char *labels[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun"};

	XYChart *c = XYChart::create(200, 180);
	c->setPlotArea(30, 20, 140, 130);

	switch (axisstyle)
	{
	case 0 :
		c->addTitle("No Axis Extension", "arial.ttf", 8);
		break;
	case 1 :
		c->addTitle("Top Extension = 0.2", "arial.ttf", 8);
		c->yAxis()->setAutoScale(0.2);
		break;
	case 2 :
		c->addTitle("Top/Bottom Extensions = 0.2/0.2", "arial.ttf", 8);
		c->yAxis()->setAutoScale(0.2, 0.2);
		break;
	case 3 :
		c->addTitle("Axis Top Margin = 15", "arial.ttf", 8);
		c->yAxis()->setTopMargin(15);
		break;
	default :
		c->addTitle("Manual Scale -5 to 10", "arial.ttf", 8);
		c->yAxis()->setLinearScale(-5, 10, 5);
	}

	c->xAxis()->setLabels(sizeof(labels) / sizeof(labels[0]), labels);
	c->addBarLayer(sizeof(data) / sizeof(data[0]), data);
	c->makeChart(filename);
	c->destroy();
}

int main(int argc, char *argv[])
{
	axisscale(0, "noextaxis.png");
	axisscale(1, "topextaxis.png");
	axisscale(2, "bothextaxis.png");
	axisscale(3, "marginaxis.png");
	axisscale(4, "manualaxis.png");
	return 0;
}