#!/bin/sh
# MetaCard 2.3 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                 z 	versions  	-- copyright 2001 Garth Catterall-Heart, SpiritWorks Software Development
-- all rights reserved worldwide

on openStack
  global gRegistered,gStack,gPrevCard
  put "versions" into gStack
  if the short name of this stack <> gStack then exit openStack
  if gRegistered is empty then
    open stack "launcher"
  else
    lock screen
    if field "date" of card 1 is empty then
      go first card
      put the long date into field "date"
    else
      if gPrevCard is not empty then
        go card gPrevCard
      else
        go last card
      end if
    end if
    saveData
    setArrows
    unlock screen with visual plain
  end if
end openStack

on clearCardOne
  put the number of field "date" into firstField
  repeat with i = firstField to the number of fields
    put empty into field i
  end repeat
  put 1 into field "record"
end clearCardOne

on adjustTime dir,whichFld,whichNum
  global gStartDate
  if field "date" is empty then
    put the long date into field "date"
  end if
  put field "date" into gStartDate
  if field "time" is empty then
    put the time into field "time"
  end if
  
  if whichNum is "min" then
    put 5 into znum
  else
    put 4 into znum
  end if
  
  repeat while the mouse is "down"
    put field whichFld into temp
    convert temp to dateitems
    if dir is "up" then
      add 1 to item znum of temp
    else
      subtract 1 from item znum of temp
    end if
    if item 4 of temp is 24 then adjustDate "up"
    if item 4 of temp is 23 AND item 5 of temp is 60 then adjustDate "up"
    if item 4 of temp is 0 AND item 5 of temp is -1 then adjustDate "down"
    if item 4 of temp is -1 then adjustDate "down"
    convert temp to short time
    put temp into field whichFld
    wait 20 ticks
  end repeat
end adjustTime

on adjustDate which
  global gStartDate
  put gStartDate into temp
  convert temp to dateItems
  if which is "up" then
    add 1 to item 3 of temp
  else
    subtract 1 from item 3 of temp
  end if
  convert temp to long date
  put temp into field "date"
end adjustDate

on version
  ask "Enter a new version" with field "version" of stack "vprefs"
  put it into field "version" of stack "vprefs"
end version

on openCard
  if the short name of this stack is "versions" then
    saveData
  end if
end openCard

on closeCard
  global gDontSave
  if gDontSave then
    put false into gDontSave
    exit closeCard
  end if
  if the short name of this stack is "versions" then
    checkData
  else
    set cursor to watch
    save this stack
  end if
end closeCard
  w         dd CornflowerBlue    white        
       ^ Version Tracker    
  W 
Helvetica   U 
Helvetica  
 U 
Helvetica   U monaco  	 U monaco   U 
helvetica  
 W 
Helvetica  
 W 
Helvetica   W 
Helvetica  
 U Arial 8records,atmain.mc
taskTracker,tasks.mc
passwords,password.mc
launcher,itmain.mc
launcher,sbdmain.mc
launcher,aetmain.mc
launcher,sbmain.mc
writer,whelper.mc
versions,version.mc
vehicleExp,vehexp.mc
invoiceTracker,invoice.mc
inventory,inventry.mc
scheduler,schedule.mc
contacts,contact.mc
calculator,calculat.mc
       	@                  i        
   date label   on mouseUp
  ask "Go to the first record with date" with the short date
  if it is empty then exit mouseUp
  convert it to long date
  repeat with i = 1 to the number of cards
    if field "date" of card i is it then
      lock screen
      go card i
      unlock screen with visual plain
      setarrows
      exit mouseUp
    end if
  end repeat
  answer information "No records with that date."
end mouseUp
          l            Date 
   time label            ~            Time 
   label1c         X  4            	H      M 
   label3           ; l            Project 
   label4           ; j            
Version # 
   label5           l             
Change notes 
   label6           l v            Short description    New Ex  on mouseUp
  global gRegistered
  if gRegistered is false then
    answer warning "Your trial period has expired. Please register your software."
    toplevel  "Register"
    exit mouseUp
  end if
  
  if  field "project" is empty then
    answer information "You need to choose or create a project " & return & \
        "for this record before creating another."
    send mouseUp to button "select project"
    exit mouseUp
  end if
  
  answer question "Do you want a new blank record or" & return & " a duplicate of this record with or without notes?" \
      with "Blank Record" or "With Notes" or "Just Project and Version"
  put it into which
  unlock screen
  lock screen
  lock messages
  put field "project" into zProjectName
  put field "version" into zVersion
  
  if which is "With Notes" then
    clone this card
    repeat with i = 1 to the number of cards
      put i into field "record" of card i
    end repeat
  end if
  
  if which is "blank record" then
    go last
    create card
    put the number of this card into field "record"
    send mouseUp to button "select project"
  end if
  
  if which is "Just Project and Version" then
    go last
    create card
    put zProjectName into field "project"
    put zVersion into field "version"
    put the number of this card into field "record"
  end if
  
  if field "version" <> empty then
    put field "version" into temp
    put empty into zNumb
    repeat while last char of temp is a number
      put last char of temp before zNumb
      delete last char of temp
    end  repeat
    if zNumb is not empty then
      add 1 to zNumb
      put temp &zNumb into field "version"
    else
      ask "Increment version number to what?" with temp
      if it is empty then put empty into field "version"
      else put it into field "version"
    end if
  else
    put "v1" into field "version"
  end if
  
  put the long date into field "date"
  put the time into field "time"
  setArrows
  unlock screen with visual plain
end mouseUp
            
LightSkyBlue    & A             	     
   recNumLabel    $on mouseUp
  goCardNum
end mouseUp
         E            	Record # 
   date  	x  Mon mouseUp
  if field "date" is empty then
    put the long date into temp
  else
    put field "date" into temp
  end if
  
  convert temp to short date
  ask "Enter a Date" with temp
  if it is empty then exit mouseUp
  if offset(",",it)=0 AND offset("/",it)=0 then
    answer "Enter dates in the format dd/mm/yy."
    exit mouseUp
  end if
  if it is not a date then
    ask "You entered an invalid Date. Try again." with the date
    if it is empty then exit mouseUp
    if it is not a date then
      ask "You entered an invalid Date. Try again." with the date
      if it is empty then
        exit mouseUp
      end if
    else
      put it into temp
      convert temp to long date
      put temp into field "date"
    end if
  else
    put it into temp
    convert temp to long date
    put temp into field "date"
  end if
end mouseUp
        
             
   time  
x   on mouseUp

  put "time" into whichField
  put "" into altField
  put "Time" into prompt
  put "" into defaultTime
  put true into OKtoEmpty
  
  setTime whichfield,prompt,altField,defaultTime,OKtoEmpty
end mouseUp
          N           
   project  	x   on mouseUp
  global gStack
  put the short name of this stack into gStack
  go stack "vprojects"
  show stack "vprojects"
end mouseUp
        
 P            
   version  	x   on mouseUp
  ask "Enter a new version number." with field "version"
  if the result is "cancel" then exit mouseUp
  put it into field "version"
end mouseUp
         P            
   notes  )h         
                  	`    @    
 
   description  )x   }on enterInField
  -- trap
end enterInField

on returnInField
  answer "Returns not allowed in this field"
end returnInField
           X                	`    @ s   V 
   record  x    %on mouseUp
  goCardNum
end mouseUp

       Z  *          1    First @V  
 on mouseUp
  global gVeffect
  lock screen
  go first
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    
LightSkyBlue      * ,  ?         	   	  o    Prev @F  
 on mouseUp
  global gVeffect
  lock screen
  go prev
  setArrows
  if gVeffect then
    put "scroll  left fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    
LightSkyBlue     * ,  @         	      Next @F  
 on mouseUp
  global gVeffect
  lock screen
  go next
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    
LightSkyBlue   ?  * ,  A         	      Last @F  
 on mouseUp
  global gVeffect
  lock screen
  go last
  setArrows
  if gVeffect then
    put "scroll  right fast" into zeffect
  else
    put "plain" into zeffect
  end if
  unlock screen with visual effect zeffect
end mouseUp
    
LightSkyBlue   e  * ,  B         	      Delete Ex  on mouseUp
  if the optionKey is down then
    delete this card
    exit mouseUp
  end if
  if the number of cards = 1 then
    if field "project" is empty then
      answer information "There are no more records to delete."
    else
      lock screen
      clearCardOne
      put the long date into field "date"
    end if
    exit mouseUp
  end if
  answer question "Delete all records, old records or just this one?" with "All" or "Older" or "Just this one" or "Cancel"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock messages
  put the number of this card -1 into cardNum
  if it is "Older" then
    ask "Delete records older than what date?" with field "date"
    if it is empty or it is not a date then exit mouseUp
    unlock screen
    put it into theDate
    convert theDate to seconds
    lock screen
    repeat with i = the number of cards of stack "versions" down to 2
      set cursor to busy
      put field "date" of card i into zdate
      convert zdate to seconds
      if zdate < theDate then  delete card i
    end repeat
    
    go card 1
    put field "date" of card 1 into zdate
    convert zdate to seconds
    if zdate < theDate then
      if the number of cards of stack "versions" is 1 then
        clearCardOne
        put the long date into field "date"
      else
        delete card 1
      end if
    end if
  end if
  
  if it is "All" then
    lock screen
    repeat with i = the number of cards of stack "versions" down to 2
      set cursor to busy
      delete card i
    end repeat
    clearCardOne
    put the long date into field "date"
    setArrows
    saveData
    unlock screen with visual plain
    exit mouseUp
  end if
  
  if it is "Just this one" then
    lock screen
    if the number of cards > 1 then
      delete this card
    else
      clearCardOne
      put the long date into field "date"
    end if
    go card cardNum
  end if
  
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  saveData
  unlock screen with visual plain
end mouseUp
            
LightSkyBlue   C& A             	        Find Ex  on mouseUp
  global gFindStack, gFoundOne
  put "atFind" into zFindStack
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 220 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack zFindStack to it
  go card 1 of stack zFindStack
  show stack zFindStack
  select text of field "find" of stack zFindStack
end mouseUp
            
LightSkyBlue    @ A              	        Sort Ex  son mouseUp
  if field "project" is empty then
    answer information "No records to sort."
    exit mouseUp
  end if
  answer question "Sort records by date or project?" with  "Cancel" or "Project"  or "Date"
  if it is "Cancel" then exit mouseUp
  unlock screen
  lock screen
  lock messages
  repeat with i = 1 to the number of cards
    put empty into temp
    put field "time"  of card i into startTime
    put field "date"  of card i into startDate
    convert startDate to dateItems
    convert startTime to dateItems
    put item 4 to 5 of startTime into item 4 to 5 of startDate
    repeat with n = 1 to 5
      if item n of startDate < 10 then
        put "0"&item n of startDate after temp
      else
        put item n of startDate after temp
      end if
    end repeat
    put temp into field "Start items" of card i
  end repeat
  
  sort stack "versions" by field "Start items"
  if it is "Project" then
    sort stack "versions" by field "project"
  end if
  repeat with i = 1 to the number of cards
    put i into field "record" of card i
  end repeat
  setArrows
  saveData
  unlock screen with visual plain
end mouseUp
            
LightSkyBlue   C@ A              	        Import Ex  
on mouseUp
  put the number of cards into znum
  if (the number of cards = 1) and (field "project" is empty) then
    put 1 into firstCard
  else
    answer question "Delete all records first or add to existing?" with "Delete" or "Add" or "Cancel"
    if it is "cancel" then exit mouseUp
    unlock screen
    if it is "Delete" then
      lock messages
      lock screen
      repeat with i = znum down to 2
        set cursor to busy
        delete card i
      end repeat
      put 1 into firstCard
      clearCardOne
      put false into renumberTasks
      unlock screen with visual plain
    else
      go card znum
      if znum = 1 then
        put 1.5 into znum
      end if
      put znum into firstCard
      put true into renumberTasks
    end if
  end if
  importRecords firstCard, renumberTasks -- in this script
  setArrows
  saveData
  unlock screen with visual plain
  set cursor to watch
  save this stack
end mouseUp

on  importRecords  firstCard, renumberTasks
  -- read from file, create and populate new cards
  answer file "Select a version records file to import." with "version_records.txt"
  if the result is "Cancel" then exit to metacard
  unlock screen
  put it into fileName
  open file fileName for read
  if the result is empty then
    read from file fileName until eof
    put it into temp
    if word 1 of temp <> "Date" then
      answer error "This is not a valid version records file. Try again."
      close file fileName
      exit to metaCard
    end if
    put the number of lines of temp into znum
    lock messages
    lock recent
    lock screen
    if firstCard = 1.5 then
      add .5 to firstCard
      go card 1
    else
      if firstCard > 1 then
        add 1 to firstCard
      end if
      go card firstCard
    end if
    
    repeat with i = 2 to znum
      if line i of temp is empty then next repeat
      set cursor to busy
      if firstCard > 1 then create card
      put firstCard into field "record"
      put line i of temp into zline
      set the itemDelimiter to tab
      if NOT item 1 of zline is a date then next repeat
      put item 1 of zline into field "Date"
      put item 2 of zline into field "Time"
      put item 3 of zline into field "Project"
      put item 4 of zline into field "version"
      
      put item 5 of zline into tNotes
      repeat while offset(" | ",tnotes) > 0
        put offset(" | ",tnotes) into firstChar
        put firstChar + 2 into lastChar
        put return into char  firstChar to lastChar of tnotes
      end repeat
      put tnotes into field "Notes"
      
      put item 6 of zline into enotes
      repeat while offset(" | ",enotes) > 0
        put offset(" | ",enotes) into firstChar
        put firstChar + 2 into lastChar
        put return into char  firstChar to lastChar of enotes
      end repeat
      put enotes into field "description"
      
      checkList "Projects","Project","vProjects" --  whichList,whichField,whichStack
      
      add 1 to firstCard
    end repeat
    close file fileName
    if renumberTasks then
      repeat with n = 1 to the number of cards
        put n into field "record" of card n
      end repeat
    end if
    sort  field "projects" of stack "vprojects"
  else
    answer "There was a problem opening this file." & return & the result & return & sysError()
  end if
end  importRecords
            
LightSkyBlue    U A              	        Export Ex  on mouseUp
  global gElapsed
  
  if the number of cards is 1 and field "project" is empty then
    answer information "There are no records to export."
    exit mouseUp
  end if
  answer question "Export all records or specific records?" with "All" or "Specific" or "Cancel"
  if it is "Cancel" then exit mouseUp
  unlock screen
  put it into exportWhich
  put empty into whichProject
  put the short date into whichDate
  if it is "Specific" then
    answer question "Export old records, new records or project records?" with "New" or "Old" or "Project" or "Cancel"
    if it is "Cancel" then exit mouseUp
    unlock screen
    put it into exportWhich
    if exportWhich is "Project" then
      answer "Export records for project" && field "project" & "?" with "OK" or "Help" or "Cancel"
      if it is "Cancel" then exit mouseUp
      if it is "Help" then
        answer "You can only export project records from a record for that project."
        exit mouseUp
      end if
      put field "project" into whichProject
      put empty into whichDate
      ask file "Save records as... " with whichProject&"_vers_records.txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
    end if
    if exportWhich is "New" then
      ask "Export records newer than what date?" with whichDate
      if it is empty then exit mouseUp
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "vers_records_newer_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
    if exportWhich is "Old" then
      ask "Export records older than what date?" with whichDate
      if it is empty then exit mouseUp
      if it is not a date then
        answer error "Invalid date. Try again."
        exit mouseUp
      end if
      put it into whichDate
      put it into temp
      convert temp to short date
      repeat while offset("/",temp) > 0
        put "_" into char offset("/",temp) of temp
      end repeat
      ask file "Save records as... " with "vers_records_older_" & temp & ".txt"
      if the result is "Cancel" then exit mouseUp
      put checkExt(it) into fileName
      convert whichDate to seconds
    end if
  end if
  
  if exportWhich is "all" then
    repeat while offset("/",whichDate) > 0
      put "_" into char offset("/",whichDate) of whichDate
    end repeat
    ask file "Save records as... " with "all_vers_records_" & whichDate & ".txt"
    if the result is "Cancel" then exit mouseUp
    put checkExt(it) into fileName
    put empty into whichDate
  end if
  unlock screen
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    lock messages
    lock screen
    put true into noRecords
    write "Date" & tab & "Time" & tab & "Project" & tab & "Version #" & tab \
        & "Change notes" & tab & "Short description" & return to file fileName
    repeat with i = 1 to the number of cards
      set cursor to busy
      go card i of stack "versions"
      put true into exportRecord
      if whichProject <> empty then
        if  field "Project" <> whichProject then
          put false into exportRecord
        end if
      end if
      if whichDate<> empty then
        put field "date" into startDate
        convert startDate to seconds
        if exportWhich is "New" then
          if startDate <= whichDate then
            put false into exportRecord
          end if
        else -- exportWhich is "old"
          if startDate >= whichDate then
            put false into exportRecord
          end if
        end if
      end if
      if exportRecord then
        put false into noRecords
        
        put field "notes" into tnotes
        repeat while offset(return,tnotes) > 0
          put " | " into char offset(return,tnotes) of tnotes
        end repeat
        
        put field "description" into enotes
        repeat while offset(return,enotes) > 0
          put " | " into char offset(return,enotes) of enotes
        end repeat
        
        write field  "Date" & tab & field "Time" & tab & field "Project" & tab &  \
            field "version" & tab & tnotes & tab & enotes & return to file fileName
      end if
    end repeat
    setarrows
    saveData
    unlock screen with visual plain
    close file fileName
    
    if  noRecords then
      answer information "No records were found to export."
    end if
    
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
            
LightSkyBlue   CU A              	        Prefs Ex   "on mouseUp
  goPrefs
end mouseUp
    
LightSkyBlue    j A              	        Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "vHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "version tracker", helpStack, zStack
end mouseUp
    
LightSkyBlue   Cj A              	        Quit ux   (on mouseUp
  quitSBTracker
end mouseUp
    
LightSkyBlue     A      Quit          	        Save Ux   Kon mouseUp
  set cursor to watch
  save this stack
  saveData
end mouseUp
    
LightSkyBlue   C A              	        Version Report Ex  eon mouseUp
  if the number of cards is 1 and field "project" is empty then
    answer information "There are no records to report."
    exit mouseUp
  end if
  checkData
  lock screen
  put field "project" into field "project" of stack "vreport"
  set the hilite of button "all projects" of stack "vreport" to false
  set the disabled of group "sort" of stack "vreport" to true
  send mouseUp to button "create report" of stack "vreport"
  if the openStacks contains "vreport" then close stack "vreport"
  setHeight "vreport"
  go stack "vreport"
  setLoc "vreport"
  unlock screen with visual plain
end mouseUp
    
LightSkyBlue                  		        Today Ex  
 >on mouseUp
  put the long date into field "date"
end mouseUp
    
LightSkyBlue    d 	 (              	       	 Edit Ex  
 7on mouseUp
  send mouseUp to field "date"
end mouseUp
    
LightSkyBlue     	 (              	       
 Choose Ex  
 on mouseUp
  global gDateField,gStack,gStartDate
  
  put field "date" into gStartDate
  put "date" into gDateField
  put short name of this stack into gStack
  set the title of stack "dates" to "Choose a Date"
  modal stack "dates"
end mouseUp
    
LightSkyBlue     	 2              	        Now Ex  
 _on mouseUp
  put the time into field "time"
  put the long date into field "date"
end mouseUp
    
LightSkyBlue   ? 	 "              	        Edit Ex  
 7on mouseUp
  send mouseUp to field "time"
end mouseUp
    
LightSkyBlue   c 	 "              	           	D                   P       Y  ~ >           > ~ ~     <      ?           ?                             	D                   k       Y  ~ >           > ~ ~     <      ?           ?                         
 UpSH A :on mouseDown
  adjustTime "up","time","hr"
end mouseDown
    
LightSkyBlue @ P                	        DnSH A <on mouseDown
  adjustTime "down","time","hr"
end mouseDown
    
LightSkyBlue @ P (               	        UpSM A ;on mouseDown
  adjustTime "up","time","min"
end mouseDown
    
LightSkyBlue @ k                	        DNSM A =on mouseDown
  adjustTime "down","time","min"
end mouseDown
    
LightSkyBlue @ k (               	        Select Project ex   on mouseUp
  global gStack, gButton
  put the short name of me into gButton
  put the short name of this stack into gStack
  modal stack "vprojects"
end mouseUp
            
LightSkyBlue     9 f      Add/Select         	        Edit Ex  
 :on mouseUp
  send mouseUp to field "version"
end mouseUp
    
LightSkyBlue   a = "              	     
   start items  !h            t                  = 
Find Project ex  on mouseUp
  global gStack, gButton,gWhichCard
  put the short name of me into gButton
  put the short name of this stack into gStack
  answer question "Do you want to go to the first or last " & return & "record of a particular project?" \
      with "Cancel" or "First" or "Last"
  if it is "cancel" then exit mouseUp
  put it into gWhichCard
  modal stack "vprojects"
end mouseUp
            
LightSkyBlue    H 9 8      Go To         	       Q Transfer -> Ex  
 Oon mouseUp
  put line 1 of field "notes" into field "Description"
end mouseUp
    
LightSkyBlue     m F              	        
Main Menu }    Kon menuPick which
set cursor to watch
goSBTrackerStack which
end menuPick
    
LightSkyBlue    
       Small Business Tracker Menu   Activity && Expense Tracker
Contact Tracker - Address Book
Schedule Tracker - Calendar
Task Tracker - To Do List
-
Inventory Tracker
Invoice Tracker
Password Tracker
Vehicle Expense Tracker
-
Universal Calculator
(Version Tracker
Writer's Helper
Small Business Tracker Welcome
       	        
vprojects  Yon openCard
  global gProject
  if field "projects" = empty then exit openCard
  if gProject is empty then
    set the hilitedlines of field "projects" to 1
    put 1 into gProject
  else
    set the hilitedlines of field "projects" to gProject
  end if
end openCard

on arrowKey which
  global gProject
  put the number of lines of field "projects" into numLines
  if which is "up" then
    if gProject is 1 then
      put numLines into gProject
    else
      subtract 1 from gProject
    end if
  end if
  if which is "down" then
    if gProject is numLines then
      put 1 into gProject
    else
      add 1 to gProject
    end if
  end if
  set the hilitedlines of field "projects" to gProject
end arrowKey

on returnKey
  checkFocus
end returnKey

on enterKey
  checkFocus
end enterKey

on checkFocus
  global gProject
  if word 3 of the focusedObject is the id of button "Create Project" then
    send mouseUp to button "Create Project"
  else
    if gProject is empty then
      send mouseUp to the focusedObject
    else
      send mouseUp to button "Choose Project"
    end if
  end if
end checkFocus
           dd CornflowerBlue    # _^,         	Projects      U Arial   U Arial   U 
Helvetica  
 U Arial  	 U Arial   U Arial   U 
Helvetica  
 U 
Helvetica  
 W 
Helvetica   W Arial   W 
Helvetica       	@          ^,                  
   projectsbg  	h          6                    	`    @   7      Create Project Ex 
 ,on mouseUp
  global gProject
  put 32 into maxLength
  ask "Enter the name of the new project."
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this project that is" && maxLength && "characters or less." with char 1 to maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is it then
      answer information "You have already created this project."
      exit mouseUp
    end if
  end repeat
  
  put the number of lines of field "projects" + 1 into temp
  put it into newProject
  put newProject into line temp of field "projects"
  sort field "projects"
  unlock screen
  set cursor to watch
  save this stack
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is newProject then
      set the hilitedLines of field "projects" to i
      put i into gProject
      exit mouseUp
    end if
  end repeat
  
end mouseUp
            
LightSkyBlue     j s             	        Delete Project Ex  Kon mouseUp
  global gProject,gStack
  
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "Nothing to delete."
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select a project to delete."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into temp
  answer warning "Are you sure you want to delete project " &quote & temp & quote& "." with "Cancel" or "Delete"
  if it is "Cancel" then exit mouseUp
  delete line gProject of field "projects"
  put empty into gProject
  unlock screen
  set cursor to watch
  save this stack
end mouseUp
    
LightSkyBlue      s             	        Choose Project Mx  on mouseUp
  global gProject,gStack,gProjectName,gButton,gCallStack
  
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "First create a project."
      send mouseUp to button "Create Project"
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select or create a project."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into gProjectName
  send chooseProject to field "projects"
end mouseUp
    
LightSkyBlue     9 q %            	        
Close Window Ex   Xon mouseUp
  global gDontSave
  put true into gDontSave
  close this stack
end mouseUp
    
LightSkyBlue      s             	     
   instruction 	          F (           :Create a project or select one from the list on the left   &and then click a button on the right. 
   	projects  	x  
_on mouseUp
  global gProject
  put word 2 of the clickLine into gProject
end mouseUp

on mouseDoubleDown
  global gProject,gStack,gProjectName,gButton,gCallStack
  put word 2 of the clickLine into gProject
  put line gProject of field "projects" into gProjectName
  if gProjectName is empty then exit to metaCard
  
  chooseProject
end mouseDoubleDown

on chooseProject
  global gProject,gStack,gProjectName,gButton,gWhichCard,gCallStack,gDontSave
  put true into gDontSave
  lock screen
  put line gProject of field "projects" into gProjectName
  close this stack
  if gButton is "find project" then
    if gWhichCard is "Last" then
      repeat with i = the number of cards of stack gStack down to 1
        if field "project" of card i of stack gStack is gProjectName then
          go card i of stack gStack
          send setArrows to stack gStack
          exit repeat
        end if
      end repeat
    else
      repeat with i = 1 to the number of cards of stack gStack
        if field "project" of card i of stack gStack is gProjectName then
          go card i of stack gStack
          send setArrows to stack gStack
          exit repeat
        end if
      end repeat
    end if
  else
    if gCallStack is "vreport" then
      set the hilite of button "all projects" of stack gCallStack to false
      set the disabled of group "sort" of stack "vreport" to true
      put gProjectName into field "project" of stack gCallStack
      send mouseUp to button "create report" of stack gCallStack
    else
      if field "project" of stack gStack is empty then
        put gProjectName into field "project" of stack gStack
      else
        answer warning "Do you want to change the Project for this record" \
            & return & "or would you like to create a new record?" with "Change" or "New Record" or "Cancel"
        if it is "Cancel" then exit to metacard
        if it is "New Record" then
          put field "version" of stack gStack into zVersion
          go last card of stack gStack
          create card
          put gProjectName into field "project" of stack gStack
          put zVersion into field "version"  of stack gStack
          put the number of this card into field "record"   of stack gStack
          
          if field "version" of stack gStack <> empty then
            put field "version"  of stack gStack into temp
            put empty into zNumb
            repeat while last char of temp is a number
              put last char of temp before zNumb
              delete last char of temp
            end  repeat
            if zNumb is not empty then
              add 1 to zNumb
              put temp &zNumb into field "version"  of stack gStack
            else
              ask "Increment version number to what?" with temp
              if it is empty then put empty into field "version"  of stack gStack
              else put it into field "version"  of stack gStack
            end if
          else
            put "v1" into field "version"  of stack gStack
          end if
          
          put the long date into field "date"  of stack gStack
          put the time into field "time"  of stack gStack
          send setArrows to stack gStack
        end if
        if it is "Change" then put gProjectName into field "project" of stack gStack
      end if
    end if
  end if
  unlock screen with visual plain
  put empty into gProject
end chooseProject
        	 6                    	`    @   7      Modify Project Ex  5on mouseUp
  global gProject, gStack,gProjectName
  if the hilitedlines of field "projects" > 0 then
    put the hilitedlines of field "projects" into gProject
  end if
  
  if gProject is empty then
    put the number of lines of field "projects" into temp
    switch temp
    case 0
      answer information "Nothing to modify."
      exit mouseUp
    case 1
      put 1 into gProject
      break
    default
      answer information "First select a project."
      exit mouseUp
    end switch
  end if
  put line gProject of field "projects" into origProject
  
  put 32 into maxLength
  ask "Enter the new name for this project." with origProject
  if it is empty then exit mouseUp
  if length(it)> maxLength then
    ask "Enter a name for this project that is " & maxLength & " characters or less." with char 1 to  maxLength of it
    if it is empty then exit mouseUp
    if length(it)> maxLength then exit mouseUp
  end if
  
  put it into gProjectName
  put gProjectName into line gProject of field "projects"
  sort field "projects"
  
  repeat with i = 1 to the number of lines of  field "projects"
    if line i of field "projects" is gProjectName then
      set the hilitedLines of field "projects" to i
      put i into gProject
      exit repeat
    end if
  end repeat
  
  repeat with i = 1 to the number of cards of stack "versions"
    if field "project" of card i of stack "versions" is origProject then
      put gProjectName into field "project" of card i of stack "versions"
    end if
  end repeat
  unlock screen
  set cursor to watch
  save this stack
end mouseUp
    
LightSkyBlue      s             	        Import/Export Ex   on mouseUp
  put "projects" into zfield
  put "projects" into what
  put "a Project" into zstack
  put "projects.txt" into fileName
  
  importExport zfield,what,zstack,filename
end mouseUp

    
LightSkyBlue      s             	        vHelp   on closeStack
  set the locktext of field "main" to true
  set the traversalOn of  field "main"  to false
  hide group "devtools"
end closeStack

on closeCard
  -- trap
end closeCard
  w        Black dd CornflowerBlue ffffff      white       	darkgray    !w             Help      U Arial  
 U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  @W 
Helvetica  PW 
Helvetica  U 
Helvetica  @U 
Helvetica  W 
Helvetica   U 
Helvetica   W 
Helvetica   W 
Helvetica   W 
helvetica  @U 
helvetica  @W 
helvetica  PW 
helvetica    About Help   	@          w       	Tutorial   	@          w       Version Tracker   	@          w       Version Report   	@          w       Preferences   	@          w       Keyboard Shortcuts   	@          w      & Importing/Export Projects   	@          w    * About Projects   	@          w    . Adding a New Project   	@          w    / Adding a New Record   	@          w    1 Adjusting the Date   	@          w    2 Adjusting the Time   	@          w    3 Background Color   	@          w     Button Colors   	@          w    7 Changing Projects   	@          w    : Choose Date   	@          w    < Choose Project   	@          w    B Create Project   	@          w    D Default Settings   	@          w    G Delete Project   	@          w    H Deleting Records   	@          w    I 
Edit Date   	@          w    L 
Edit Time   	@          w    M Exporting Records   	@          w     
First Record   	@          w     Font   	@          w    V Highlight Color   	@          w    W Importing Records   	@          w     Last Record   	@          w    Z Look and Feel   	@          w    ] Modify Project   	@          w     Next Record   	@          w    b 	Now Time   	@          w     Prev Record   	@          w     Print   	@          w    g Quit   	@          w    h 	Record #   	@          w    i 
Registration   	@          w     Save As...   	@          w    n Save Record   	@          w    o Searching Records   	@          w     Sorting Records   	@          w    y Time Format   	@          w    z 
Today's Date   	@          w    { Visual Effects   	@          w     	Transfer   	@          w     Help Index   	@          w    !               help   i          t
   main  )x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
  if the textstyle of the clickChunk contains "group" then
    put the clickText into temp
    if last char of temp is "." then delete last char of temp
    if there is a card temp then
      push card
      go card temp
    end if
  end if
end mouseUp
         Xl(         About Help 
  @        
  
  @          !Welcome to Version Tracker Help. 
 @        Black        Listed in this Help system are all the features, fields and buttons of Version Tracker. (Buttons are things you click on and fields contain text.) 
         You can click the Save as... button at the bottom of this Help window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. 
       
      

      
 @      Blue   Y
    < W   The Search Help button at the bottom of this Help window will search for occurrences of a particular word or phrase in any of the help topics. 
       
      
        
         [Click blue underlined text to go directly to that Help topic (except for this example ;-). 
       
  @       
      @  
         Bolded words (like this) in this Help system indicate buttons or fields. (Again, buttons are things you click on and fields are where text is entered or displayed.) Blue text (like this) highlights important information. 
       
      	
      
  @       7   [You can easily return to the previous topic by clicking the Back to Previous Topic button. 
       <
     < 
     R   
         Each "record" in Version Tracker consists of the date, time, project, version number, change notes and a short description of the changes made.  You can add new records or edit the information for any record at any time.    \Use the buttons at the top of this Help window to learn more about the following subjects:  
       #
     # 
     ' 4   The Version Tracker window is where you can make notes about changes you have made to the latest version of your work. You can easily create a report of all the changes made on a particular project. 
       
  @       
      
 @        Black   
        
         The Preferences window is where you can change background and button colors, time formats, and the general "look and feel" of the program.  
       
  @       
      |   jAlmost every button in this program has a keyboard shortcut. For more information see Keyboard Shortcuts. 
       V
  @      V 
     h    IThere's an extensive tutorial available by clicking the Tutorial button. 
       8
  @      8 
     @    iThe newest version of this software is available at http://productivity-software/sbtracker/download.html 
 @      Blue    h  
 @      Blue      ~Your comments, suggestions and bug reports are always welcome. Please send your email to: comments@productivity-software.com. 
       Z
 @      Red  Z "
     |    #Thank you for using this software,    Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470      Version Tracker 
  @          
  @          OThe Version Tracker window is where you will add all your version information. 
 @        Black    
 @      red   
 @        Black   3   Each "record" in Version Tracker consists of the date, time, project, version number, change notes and a short description of the changes made.  You can add new records or edit the information for any record at any time.   rThe Date field is automatically filled in. If it is incorrect, you can click on the field, or the Edit button, to enter another date. Enter the current date by clicking the Today button. You can also use the date chooser by clicking Choose. See Choose Date for more information. You can go directly to the first record with a particular date by clicking the Date label. 
       
      
      Z
     b 
     f G
      
      7
      
      
  @       
      
     N
    e 
    j   The Time field is also automatically filled in. If you want to change it, you can click on the field, or the Edit button, to enter another time. Another method is to click the small up or down arrows next to the time field. You can increase or decrease the hours with the first set of buttons, and increase or decrease the minutes with the second set of buttons. You can hold down the mouse button on any of these arrows to get continuous adjustment. 
       
      
      e
     m 
     q  
     1  6To add a new project, click the Add/Select button. Next click the Create Project button. Enter the name for the new project. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. For more information see About Projects. 
        
       

     * 
     B 
     P 
      
     "
  @     &    To go to the last record of a particular project, click the Go To button. Next click the project name and finally click the Choose Project button. You can also double-click the project name to save the last step. For more information see About Projects. 
       ;
     ; 
     A :
     { 
      d
  @         
  @          TYou can add or edit the Version# by clicking the field or the Edit button above it. 
       
      
       3   6Type your text directly into the Change Notes field.  
       !
     ! 
     -    yClicking the Transfer -> button will transfer the first line of the Change Notes field into the Short Description field. 
       

     
 
      ,
     D 
     P 
     ` 
     q    You can enter a short description of your changes in the Short Description field. This field is the one that is used when creating reports.  
       9
     9 
     J B   You can generate a list of the changes you have made for a particular project or all projects. See Version Report  for more information. 
       c
 @      Blue  c 
     q   
         0Adding, Deleting, Searching and Sorting Records 
  @        /  
  @         To add a new record click the New button. You will be asked if you want to duplicate the current record with or without notes. There are three choices. If you choose Just Project & Version, only the current project information will be copied onto the new record. If you choose With Notes, then all information from the current record will be copied to the new record. If you choose Blank Record, then none of the information from the current record will be copied and a blank record will be created. 
       
      
     ! 
      
      Y
     

     _
    ~ 
     i  <You may delete one or all of the records by clicking the Delete button. You will be asked if you want to delete just the record you are on, all records, or just those older than a certain date. If you choose the last option you will be asked for a date. You may want to export the records, before deleting them all. 
       9
     9 
     ?    Search for text in any record by clicking Find. You can search for the first few characters of a word or complete words. You may also limit your search to words with the exact capitalization as the word you enter, by clicking "case sensitive". 
       *
     * 
     .   
         You can sort records by clicking the Sort button. You will be asked if you want to sort the records by Date or Project. All records are renumbered after sorting. 
       %
     % 
     ) M
     v 
     w *  
         Import and Exporting Records 
  @           You can import or export the records to a tab delimited text file by clicking the Import or Export button. There are a couple of reasons you might want to do this: 
       R
     R 
     X 
     \ 
     b A  
         1) Rather than archiving the whole program, you might want to export all the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.    The exported file is called version_records.txt with contains the data for all the records. You can change this name if you wish. Be sure to make a note of its location.  
       
 @      Red   
     / S
 @      Blue   (   You can export one or all records, or records that are newer or older than a certain date. See Exporting Records for more information. 
       _
  @      _ 
     p   
         Other Buttons 
  @        
  vYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open Schedule Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q {
      
      
      
      4
     
     
    % 
    ) /
 @      Blue X X
     0
     
        The Prefs button brings up the Preferences window, where you can change Background colors and Button colors as well as the Time Format. For more information see Preferences. 
       
      
     	 
  @       
     1 p
  @       
        
         To register Small Business Tracker, click the Register button. Read the instructions for getting a registration number. When you receive your number, fill in your full name and the registration number. You will then be able to continue using the software. 
       .
     . 
     6    /The Help button brings you to the Help window. 
       
      
      
  @      " 
     -    The Report button makes it easy to save a list of changes for a particular project to a text file for importing into other programs. See Report  for more information. 
       
      
 @        Black   
      
     " a
      
 @      blue   
         mThe Save button saves your data. All records are saved automatically when going to another record or window. 
       
      
      d   The Quit button saves the data and quits the program.  You can quit the program from any window by using the Control + Q (or Command + q on the MAC) key combination. 
       
      
      .
     6 o         Version Report 
  @          
  @          You can generate a list of the changes you have made for a particular project or all projects. The current project is automatically entered into the project field and a report is generated when you click the Version Report button. 
       
      
         You can change the project by clicking the Select Project button in the Version Report window, or you can click All Projects button to generate a report on all of your projects. 
       +
     + 
     9 
 @      Red  H 
     ^ 
     p 
     | 5   You can include any of the following options in your reports: Show Dates, Show Times, Show Descriptions, show Change Notes, and you can Sort By Project or Date. 
       >
     > +
     i 
     m 
     | 
      
      
        
         {You can save the report as a text file for archiving or importing into another program, by clicking the Save as... button. 
       h
     h 

     r   
         UYou can change the font face or size of the report text by clicking the Font button. 
       H
 @      Blue  H 
     L   
         7You can print the report by clicking the Print button. 
       )
 @      Blue  ) 
     .   
           Save As... 
  @        
  You can use the Save as... button at the bottom of this window, to export the help topic you are currently viewing. Or you can export all of the help topics. You can save the text as either a .txt file or an .html file. You can view the .html file, complete with all formatting, by opening it in your browser. You can open the .txt  file, for reading or printing, in your favorite word processor. See About Help for more information about printable versions of this Help system. 
       
      

      
 @      Blue   Y
    5 \
  @      

     C   Keyboard Shortcuts 
  @          
  @          /Almost every button has a keyboard equivalent. 
 @        Black    .  
  @          Shortcuts are indicated by the letter of the button that is underlined. Just press the letter on your keyboard to activate the button.    cIf a keyboard shortcut does not work, try pressing the tab key and then the shortcut letter again. 
  @        b   If you are typing notes, many of the following shortcuts will not work unless you also hold down the Alt key (or Command key on the Macintosh).   CYou can also use the Tab key to move between most of the buttons and editable fields of each window. (Buttons are things you click on, fields are places where text is entered or displayed.) Buttons will appear with a dotted rectangle when they are active. Then you can press the return or enter key to activate the button.    In any field that you can type in, you can also use the standard Cut (Ctrl - x), Copy (Ctrl - c) and Paste (Ctrl - v) keyboard shortcuts.    "Version Tracker window shortcuts: 
 @        Black    
      
 Add/Select - a  
Go To - g  New - n  Delete - d  Version Report - r  	Save - s  	Quit - q    !Version Report window shortcuts: 
 @        Black    
      
 	Help - h  Close Window - c  Select Project - s  Save as - v  	Font - f  
Print - p    Add/Projects window shortcuts: 
        Choose Project - t  Create Project - r  Modify Project - m  Delete Project - d  Import/Export - i  Close Window - c  'Move up in list of projects - Up arrow  +Move down in list of projects - Down arrow    Help window shortcuts: 
        About Help - a  Version Tracker - v  Keyboard Shortcuts- k  
Tutorial - t  Preferences - p  Help Index - h  Back to Previous Topic - b  Search Help - s  Close Window - c          	Tutorial 
  @          
  @          QHere's a quick tutorial for those just getting started with the Version Tracker. 
 @        Black    P   Each "record" in Version Tracker consists of the date, time, project, version number, change notes and a short description of the changes made.  You can add new records or edit the information for any record at any time.   To add a new record click the New button. You will be asked if you want to duplicate the current record with or without notes. There are three choices. If you choose Just Project & Version, only the current project information will be copied onto the new record. If you choose With Notes, then all information from the current record will be copied to the new record. If you choose Blank Record, then none of the information from the current record will be copied and a blank record will be created. 
       
      
     ! 
      
      Y
     

     _
    ~ 
     i   The Date and Time fields are filled in automatically. You can easily change these at any time by clicking the Today, Edit, or Choose, or Now buttons. For more information see Adjusting the Date and Adjusting the Time .  
       
      
      
      
      ]
     n 
     s 
     u 
     y 
     ~ 
      
      
      #
  @       
      
  @       
        6To add a new project, click the Add/Select button. Next click the Create Project button. Enter the name for the new project. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. For more information see About Projects. 
        
       

     * 
     B 
     P 
      
     "
  @     &    To go to the last record of a particular project, click the Go To button. Next click the project name and finally click the Choose Project button. You can also double-click the project name to save the last step. For more information see About Projects. 
       ;
     ; 
     A :
     { 
      d
  @         
  @          TYou can add or edit the Version# by clicking the field or the Edit button above it. 
       
      
       
     > 
     B    6Type your text directly into the Change Notes field.  
       !
     ! 
     -    yClicking the Transfer -> button will transfer the first line of the Change Notes field into the Short Description field. 
       

     
 
      ,
     D 
     P 
     ` 
     q    You can enter a short description of your changes in the Short Description field. This field is the one that is used when creating reports.  
       9
     9 
     J B   You can generate a list of the changes you have made for a particular project or all projects. See Version Report  for more information. 
       c
 @      Blue  c 
     q   
         Other features: 
  @          uYou can use the arrow buttons to go to the first, previous, next or last record. (These buttons are hidden when you first open Version Tracker because there are no other records available to go to.) The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record. The number of the current record appears in the Record # field. You can also go directly to any record by clicking on the record # field. A dialog will ask you what record number you want to go to. 
       Q
     Q z
      
      
      
      4
     
     
    $ 
    ( /
 @      Blue W X
     0
     
        Search for text in any record by clicking the Find button. You can search for the first part of a word (partial words) or one or more whole words. If capitalization matters, click the "case sensitive" button. 
       .
     . 
     2   
         oSort all the records by date or project by clicking the Sort button. You will be asked which field to sort by. 
       8
     8 
     < 2   Delete one or all of the records by clicking the Delete button. You will be asked which records you want to delete. For more information see Deleting Records. 
       1
     1 
     7 V
  @         You may want to export the records by clicking Export. You can then import the data into a spreadsheet or word processing program. You can export the data for archiving purposes too. You can Import the saved data back into Version Tracker at any time. You will want to export your data when updating to a newer version of Version Tracker. For more information see Exporting Records and Importing Records. 
       /
     / 
     5 
      
      
  @     l 
    } 
  @      
       
         To access the Preferences window, click the Prefs button. You can change the highlight, button and background colors, time format, etc. For more information see Preferences. 
       ,
     , 
     1 p
  @          To access the other components of Small Business Tracker, click the Small Business Tracker Menu button. Choose the tool you want to go to from this menu. The current tool's name is dimmed so you can tell where you are on the menu. 
       D
     D 
     _    You can save your work to a text field for importing into other programs by clicking the Save As... button. See Save As...  for more information. 
       X
 @        Black  X 
     c 

 @      blue  p 

     z    The Save button saves your data. All records are saved automatically when going to another record or when you Quit the program. You can quit the program from any window by using the Control + Q (or Command + q on the MAC) key combination. 
       
      
      f
     n 
     r |  
         5To access the help system, click on the Help button. 
       (
     ( 
     ,    \For more information, check the Help Index or any of the buttons at the top of this window. 
        
 @        Black    

     * 1  
         You can use the Save As... button below, to save any or all of the text in the help system, as either a .txt or .html file, for reading or printing. Saving the text in .html format allows you to view the formatted help text in your web browser. 
       
      
      z
 @      Blue   _  
              g Quit 
  @           You can quit (or exit) the program at any time by clicking the Quit button. All data will be saved before quitting.  You can quit the program from any window by using the Control + Q (or command + q on the Macintosh) key combination. 
       ?
     ? 
     C        Font 
  @          
         You may want to adjust the font, size or line height of the schedule text by clicking the Font button. Choose a new font by clicking its name in the font list. 
       Z
     Z 
     ^ A  
         Change the font size by clicking one of the pt size radio buttons. Not all fonts are available in all sizes, so you may not notice a change.  
         
         Click the line height field to enter a new number. The minimum line height is equal to the text size plus one (i.e., if the text size = 14 then the minimum line height = 15). 
       3
     3 {  
        You can also set the tab stops of the list text by clicking the Font... button and then the Tab button. You will be given the choices of Default and Custom. The custom option allows you to specify exact numbers for the tab stops in pixels. Some experimentation will probably be necessary. Make minor changes to each of the three numbers to see what the effects are. Tabs may need to be readjusted after each report or invoice has been generated. 
       
      !
     @ 
     G 
     \ 
     _ *
      
      
      
      
 @      Blue n O  
 @      Blue      QReset the font face and size to 10 pt Arial by clicking the Default Font button. 
 @        Black    <
 @        Black  < 
 @        Black  H   
             xx    Print 
  @          
  @         You can print either a specific project's version records or all version records by clicking Version Report  button in the  Version Tracker window. Then click the appropriate options at the top of the Version Report window. Next print the list  by clicking the Print button. 
       \
     \ 
     l 
 @      Red  { 
      5
 @      Red   
      '
     
    
    The font face, size, line height and tab stops of the list can be modified by clicking the Font button. See Font  for more information. 
       [
     [ 
     _ 

 @      Blue  l 
     p      Prev Record 
  @           {Go the previous record (the record with the next lowest number) by clicking the Prev button (the one with the left arrow). 
       P
     P 
     T &   The First Record and Prev Record buttons are hidden on the first record. You can also use the arrow keys to move from one record to the next or previous record.  
            
First Record 
  @           |Go the first record (the record with the lowest number) by clicking the First button (the one with the left arrow and bar). 
       H
     H 
     M .  
         IThe First Record and Prev Record buttons are hidden on the first record. 
       H        M Exporting Records 
  @          3You can export the records to a text file by clicking the Export button. You will be asked if you want export All records or just Specific ones. If you choose All then all records will be exported. Records are exported in a tab delimited format, so they can be easily imported into many other applications. 
       :
     : 
     @ .
     n 
     y 	
      
      
      
      $
 @      Blue   l   If you choose Specific you will then be asked if you want to export Old records, New records or Project records. If you click the Project button, only records for the project on the current record will be exported. 
       
      
      .
     D 
     G 

     Q 
     T 
     ` 
     g 
      
      M   If you choose New, you will be asked to enter a date. Only records newer than that date will be exported. Using this feature allows you to export just the records for the last week (for example) so that they can be sent to an administrator for importing. 
       
      
        
         If you choose Old, you will also be asked to enter a date. Only records older than that date will be exported. This feature is useful if you want to delete old records, but want to export and archive them first. 
       
      
        
         If there are no records found to be exported, you will see a message to that effect, but a file will still be written to disk. To avoid confusion, you may want to delete that file. 
         
         You can export records which have their timer running. However, when these records are imported again, the timer will be paused at the time it was exported. The note "timer running or paused" is added to the exported record. 
       
      :   @There are a couple of reasons you might want to export records: 
  @        ? 1) Rather than archiving the whole program, you might want to export all (or some of) the records and just archive the much smaller text file.    2) When updating to a newer version of the program, you should export all your records and then import them into the new version.   
  @          The exported file is called version_records.txt which contains the data for all the records in a tab delimited format. You can change this name if you wish. Be sure to make a note of its location. 
       
 @      Red   
  @      , 
     / n
  @       '      i 
Registration 
  @          'To register Small Business Tracker, click the Small Business Tracker Menu button and choose Small Business Tracker Welcome. Then click the Register button. Read the instructions for getting a registration number. Once you receive your number, fill in your full name and the registration number. 
       .
     . 
     I 
     [ 
     \ 
     { 
      

      
         HYou can also review the License Agreement from the Registration window. 
       
      
     )          Preferences 
  @          
  @          ?There are several preferences you can set for Version Tracker. 
 @        Black    >   XTo access the Preferences window, click the Prefs button in the Version Tracker window. 
       ,
     , 
     1 
 @      Red  O 
     V   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
      
      e
     v 

      a
      	
      H
  @     2 
    D    jThe Time Format defaults to AM/PM, but if you would want times displayed in 24 hour format, click 24 Hrs. 
       
      
      Z  You can change the Background color from the Preferences window. Choose a color from the Background Color list. The background color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     # 

  @      - 
     ?   You can change the Button colors from the Preferences window. Choose a color from the Button Colors list. The button colors will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      

       

  @      * 
     <    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.   You can also change the Highlight color from the Preferences window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       
      
     ' 

  @      1 
     C   -There is a visual effect that helps to indicate the movement from one record to another in the Version Tracker window when using the arrow buttons or keys. Some people find this effect annoying or slow. Other people think it is great. So you can choose to turn it On or Off in the Preferences window. 
       n
 @      red  n 
     u 
     
    
 
     
     
  @      
    +   The Open new tools in a different window? button allows you to choose if you want each tool to open in a new, separate window or if you want each new tool to open in the same window as the current tool. Opening new tools in new windows sometimes creates too many open windows on the screen for some people. Some tools, such as the Universal Calculator,  always open in a new window. 
       
      %
     )U  
         WClick the Default Settings button to return all settings back to their default values. 
       

     
 
      <        { Visual Effects 
  @          *There is a visual effect that helps to indicate the movement from one record to another in the Version Tracker window when using the arrow keys. Some people found this effect annoying or slow. Other people thought is was great. So you may now choose to turn it On or Off in the Preferences window. 
       n
 @      red  n 
     u 
     
     
     
     
  @      
    (    See also Record #. 
       	
 @      Blue  	 	   	Transfer 
  @           yClicking the Transfer -> button will transfer the first line of the Change Notes field into the Short Description field. 
       

     
 
      ,
     D 
     P 
     ` 
     q   z 
Today's Date 
  @           rTo easily enter today's date into a record, click the Today button above either the Start Date or End Date field. 
       6
     6 
     ; 
     T 

     ^ 
     b 
     j    aYou can go directly to the first record with a particular date by clicking the Start Date label. 
       O
     O 

     Y     y Time Format 
  @           In the Preferences window, you can set the Time Format to either 24 Hr or AM/PM. Times previously entered will not be modified, but all new times entered will be in the new format. 
       
  @       
      
     + 
     7 }         Sorting Records 
  @           You can sort records by Date or Project  by clicking the Sort button in the Version Tracker window.  All records are renumbered after sorting. 
       
      
      
       
     ' 
     9 
     = 
 @      red  K 
     b ,    o Searching Records 
  @          You can search records for particular text by clicking the Find button. A dialog will ask for a partial or whole word to search for. You can find the beginning of a word or phrase by using the partial words option. To find an exact word or phrase, use the whole words option. 
       ;
     ; 
     ? 
      

      2
      
        You can also specify that you want your search to be case sensitive (i.e., a search for "UNIX" will not find "unix"). Click the checkbox next to this option to enable it. 
       5
     5 
     C g   [You can go directly to the first record with a particular date by clicking the Date label. 
       N
     N 
     S     n Save Record 
  @           You can save all the data in the record window by clicking the Save button. All data is saved automatically when going to another record or when quitting the program. 
       ?
     ? 
     C c        h 	Record # 
  @          Each Record in Version Tracker has a number. This number may change when you add or delete records. You can go directly to a particular record by clicking the Record # field or label. Or you can use the arrow buttons to go the First Record, Prev Record, Next Record or Last Record. 
       -
  @      - 6
     c <
      
      <
  @       
      
  @       
      
  @       
    	 
  @     
 
        The First Record and Prev Record buttons are hidden on the first record. The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
          See also Visual Effects. 
       	
 @      Blue  	   b 	Now Time 
  @           You can easily enter the current time by clicking the Now button. This button also enters the current date into the appropriate date field. 
       6
     6 
     9 R         Next Record 
  @           yGo the next record (the record with the next highest number) by clicking the Next button (the one with the right arrow). 
       M
     M 
     Q '   The Last Record and Next Record buttons are hidden on the last record. You can also use the arrow keys to move from one record to the next or previous record.  
           ] Modify Project 
  @          To modify a project name, click the Add/Select Project button. Then select a project name to modify and click the Modify Project button. You will be asked for a new name. All records with the old project name will be updated with the new name. For more information see About Projects. 
       $
     $ 
     6 <
     r 
      +
  @       I
      
  @     
         Z Look and Feel 
  @        
  aIn the Preferences window, the Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts. 
       
  @       
      
      

     , e
      

      a
      	
     H
  @     M 
    _          Last Record 
  @           |Go the last record (the record with the highest number) by clicking the Last button (the one with the right arrow and bar). 
       H
     H 
     L /   GThe Last Record and Next Record buttons are hidden on the last record. 
       F    W Importing Records 
  @          .You can import previously exported records by clicking the Import button in the Version Tracker window. First you will be asked if you want to Delete all existing records before importing or Add the imported records to the existing ones. You then will be asked to locate a version.txt file to import.  
       ;
     ; 
     A 
 @      Red  _ 
     f )
      
      *
      
      O
  @      
        ,See Exporting Records for more information. 
       
  @       
          V Highlight Color 
  @           You can change the highlight color from the Preferences window. Click the Prefs button in the Version Tracker window, then choose a color from the Highlight Color list. The highlight color will automatically change to the new color. 
       ,
  @      , 
     > 
     J 
     O 
 @      red  m 
     t 
      
      F        L 
Edit Time 
  @        	   The time can be adjusted several ways. If you want to enter the current time, click the Now button above the start or end field. If you want to edit the time field, click on the Edit button or the field itself. A dialog box will ask you for a new time. 
       X
     X 
     [ W
      
      F  2Another method is to click the small up or down arrows next to the time field. You can increase or decrease the hours with the first set of buttons, and increase or decrease the minutes with the second set of buttons. You can hold down the mouse button on any of these arrows to get continuous adjustment.     I 
Edit Date 
  @        	   The date can be adjusted several ways. If you want to enter today's date, click the Today button above the start or end field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       T
     T 
     Y W
      
      F  Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date, closes the window and enters that date into the current record. 
       
      
     %       H Deleting Records 
  @          You can delete some or all records by clicking the Delete button. You will be asked if you want to delete Just this one record, Older records or All records. If you choose Older then you will be asked for a date. This feature is useful when you have many old records that you do not need to keep. You will probably want to export the old records first. See Exporting Records for more information. 
       3
     3 
     9 1
     j 

     w 	
      
      
      
      
  @     e 
    v         G Delete Project 
  @           To delete a project name, click the Add/Select Project button. Then select a project name to delete and click the Delete Project button. You will no longer be able to create reports for that project. 
       $
     $ 
     6 ;
     q 
      G        D Default Settings 
  @           }If you want to return the settings in the Preferences window to their default state, just click the Default Settings button. 
       *
  @      * 
     < (
     d 
     t    See also Preferences. 
       	
  @      	     B Create Project 
  @          /To create a project name, click the Add/Select Project button. Then click the Create Project button and enter a name. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. For more information see About Projects. 
       $
     $ 
     6 
     N 
     \ 
      
      "
  @              < Choose Project 
  @           To choose a project, click the Add/Select Project button. Then select a project name and click the Choose Project button. You may also double-click on the project name to add it directly to the current record. For more information see About Projects. 
       
      
     2 1
     c 
     q z
  @               : Choose Date 
  @          3One method for changing a date, is to click the Choose button above the date field. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the appropriate field. 
       0
     0 
     6     7 Changing Projects 
  @           To add a new project name to the current record, click the Add/Select Project button. Then select the new name and then click the Choose Project button. You may also double-click on the project name to add the project to the current record. 
       ;
     ; 
     M 5
      
      `  ITo change projects, click the Add/Select Project button. If you want to modify an existing name, select the project to be changed, click the Modify Project button and enter a new name. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. 
       
      
     0 ]
      
      
    2 
    @          Button Colors 
  @        
   You can change the button colors from the Preferences window. Click the Prefs button, then choose a color from the Button Colors list. The button colors will automatically change to the new color. 
       *
  @      * 
     < 
     H 
     M &
     s 

      D        3 Background Color 
  @           You can change the background color from the Preferences window. Click the Prefs button, then choose a color from the Background Color list. The background color will automatically change to the new color. 
       -
  @      - 
     ? 
     K 
     P &
     v 
      G        2 Adjusting the Time 
  @          The Start and End Times can be adjusted several ways. If you want to enter the current time, click the Now button above the start or end field. If you want to edit the time field, click on the Edit button or the field itself. A dialog box will ask you for a new time. 
       g
     g 
     j W
      
      F  2Another method is to click the small up or down arrows next to the time field. You can increase or decrease the hours with the first set of buttons, and increase or decrease the minutes with the second set of buttons. You can hold down the mouse button on any of these arrows to get continuous adjustment.       1 Adjusting the Date 
  @           The date can be adjusted several ways. If you want to enter today's date, click the Today button above the start or end field. If you want to edit the date field, click on the Edit button or the field itself. A dialog box will ask you for a new date. 
       T
     T 
     Y W
      
      F  
Another method is to click the Choose button. A new window will open that allows you to select a new date by clicking the year, the month and then the date from a calendar interface. Clicking on a date closes the window and enters that date into the current record. 
       
      
     %       / Adding a New Record 
  @          To add a new record click the New button. You will be asked if you want to duplicate the current record with or without notes. There are three choices. If you choose Just Project & Version, only the current project information will be copied onto the new record. If you choose With Notes, then all information from the current record will be copied to the new record. If you choose Blank Record, then none of the information from the current record will be copied and a blank record will be created. 
       
      
     ! 
      
      Y
     

     _
    ~ 
     i        . Adding a New Project 
  @          >To add a new project, click the Add/Select Project button. Next click the Create Project button. Enter the name for the new project. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. For more information see About Projects. 
        
       
     2 
     J 
     X 
      
     "
  @     .         * About Projects 
  @          lYou can enter any number of projects into Version Tracker. If you have several clients, you may want to use the client's name for the project name. If you work on different projects for the same client, you will want to combine the client and project name somehow. Project names are limited to 25 characters, but commas and other special characters are permitted.    To choose a project, click the Add/Select Project button. Then select a project name and click the Choose Project button. You may also double-click on the project name. 
       
      
     1 2
     c 
     q 7  To create a project name, click the Add/Select Project button. Then click the Create Project button and enter a name. The maximum length for project names is 32 characters. To transfer the new project name to the current record, click the Choose Project button. 
       $
     $ 
     6 
     N 
     ] 
      
         To modify a project name, click the Add/Select Project button. Then select a project name to modify and click the Modify Project button. You will be asked for a new name. All records with the old project name will be updated with the new name. 
       $
     $ 
     6 <
     r 
      *
  @       H
         To delete a project name, click the Add/Select Project button. Then select a project name to delete and click the Delete Project button.  
       $
     $ 
     6 <
     r 
      	  
        $To import or export a list of project names, click the Import/Export  button. If you choose Import, you will be asked to locate a project.txt file. If you choose Export, save the project.txt file to your computer so that you can then import it into another module of this productivity suite. 
       7
     7 
     E 
     \ 
     b  
 @      Red   
      
      
      
 @      Red   
      e      & Importing/Export Projects 
  @          You can import or export lists of projects from other components of (whatever we're going to call this package). Just click the Import/Export button in the Projects window.  If you choose Import, you will be asked to locate a project.txt file. If you choose Export, save the project.txt file to your computer so that you can then import it into another module of this productivity suite. 
       
      

      
 @      Red   
      
      
       
 @      Red   
      
     
     
 @      Red  
     e     Preferences 
          There are several preferences you can set for Activity & Expense Tracker. Start by clicking the Prefs button in the record window.   FThe Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible. For more information see Keyboard Shortcuts.    iThe Time Format defaults to AM/PM but if you would want times displayed in 24 hour format, click 24 Hrs.    You can change the background color from the Preferences Window. Choose a color from the Background Color list. The background color will automatically change to the new color.    You can change the button colors from the Preferences Window. Choose a color from the Button Colors list. The button colors will automatically change to the new color.    rPlay around with these two groups of selections until you find a color combination that is pleasing to your eyes.    You can also change the highlight color from the Preferences Window. Choose a color from the Highlight Color list. The highlight color will automatically change to the new color.   =You can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol. The new symbol will be displayed on the records screen and in all reports.    WClick the Default Settings button to return all settings back to their default values.             	`    @ _ Y &    About Help Ux   Ion mouseUp
  lock screen
  push card
  go card "About Help"
end mouseUp
    
LightSkyBlue      ]             	        Keyboard Shortcuts Ex   Oon mouseUp
  lock screen
push card
  go card "Keyboard Shortcuts"
end mouseUp
    
LightSkyBlue      ~             	        	Tutorial Ex   Eon mouseUp
  lock screen
push card
  go card "Tutorial"
end mouseUp
    
LightSkyBlue     " P             	        Version Tracker Ex   Non mouseUp
  lock screen
  push card
  go card "Version Tracker"
end mouseUp
    
LightSkyBlue    ` "              	        Preferences Ex   Oon mouseUp
  lock screen
push card
  go card the short name of me
end mouseUp
    
LightSkyBlue     " f             	        Help Index Ex   Gon mouseUp
  lock screen
push card
  go card "Help Index"
end mouseUp
    
LightSkyBlue     <              	        Back to Previous Topic Ex   on mouseUp
  pop card into temp
  if temp is empty or NOT (temp contains "help") then
    go card "Help Index"
  else
    go temp
  end if
end mouseUp
    
LightSkyBlue     <              	        Search Help Ex  ]on mouseUp
  global gFindStack,gFoundOne
  put false into gFoundOne
  put the short name of this stack into gFindStack
  get the loc of this stack
  add 320 to item 1 of it
  add 75 to item 2 of it
  set the loc of stack "atFind" to it
  go card 1 of stack "atFind"
  show stack "atFind"
  select text of field "find" of stack "atFind"
end mouseUp
            
LightSkyBlue     l             	        Save as... Ex   on mouseUp
  global gStackName
  
  insert the script of button "SaveHelp" of stack "Launcher" into back
  put "Version Tracker Help" into gStackName
  exportHelp
  remove the script of button "SaveHelp" of stack "Launcher" from back
end mouseUp
    
LightSkyBlue     Q              	        
Close Window Ex   [on mouseUp
  lock screen
  close this stack
  unlock screen with visual plain
end mouseUp
    
LightSkyBlue     y             	        	devtools   a         tH    Save Ex   *on mouseUp
  save this stack
end mouseUp
    
LightSkyBlue    x Q              	        go next Ex   'on mouseUp
  go next card
end mouseUp
    
LightSkyBlue    \x Q              	        delete Ex   +on mouseUp
  delete this card
end mouseUp
    
LightSkyBlue   x 2              	        go prev Ex   'on mouseUp
  go prev card
end mouseUp
    
LightSkyBlue    x Q              	        Version Report Ex   Mon mouseUp
  lock screen
  push card
  go card "Version Report"
end mouseUp
    
LightSkyBlue    m  o             		           K        
  b          K        ^             K           j          K                    K        
   T    
  ! index  	x  on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the listbehavior of me to false
    set the traversalOn of me to true
  else
    put line (the hilitedLine of me) of field "index" into temp
    push card
    go card temp
  end if
end mouseUp
         Xl(           About Help  About Projects  Adding a New Project  Adding a New Record  Adjusting the Date  Adjusting the Time  Background Color  Button Colors  Changing Projects  Choose Date  Choose Project  Create Project  Default Settings  Delete Project  Deleting Records  
Edit Date  
Edit Time  Exporting Records  
First Record  Font  Highlight Color  Importing Records  Importing/Export Projects  Keyboard Shortcuts  Last Record  Look and Feel  Modify Project  Next Record  	Now Time  Preferences  Prev Record  Print  Quit  	Record #  
Registration  Save As...  Save Record  Searching Records  Sorting Records  Time Format  
Today's Date  	Transfer  	Tutorial  Version Report  Version Tracker  Visual Effects         	`    @ ` Y & 
   title 	H          ;h            Help Index 
   instruction 
         h @            *Click a topic below for more information.    New Button EpGon mouseUp
sort this stack by field "main"
  beep
end mouseUp


  repeat with i = 1 to the number of cards
    put empty into field "main" of card i
  end repeat

repeat with i = 1 to the number of lines of field index
  if there is a card line i of field index then next repeat
  else answer line i of field index
end repeat
          `              	        Export EpJon mouseUp
global gHelpText
  open file "helptext.html" for write
  repeat with i = 1 to the number of cards --lines of zlist
    put the htmltext of field "main" of card i into gHelpText
    exportHTML 
    write gHelpText & "<p>&nbsp;<p>"  & return to file "helptext.html"
  end repeat
  close file "helptext.html"
end mouseUp
        D ` ,             	        Import Ep	on mouseUp
  
  answer file "Select a  helptext.html file to import." with "helptext.html"
  if the result is "Cancel" then exit to metacard
  put it into fileName
  open file fileName for read
  --  lock screen
  read from file fileName until eof
  put it into allText
  close file fileName
  
  put "adding group close tags"
  put "</B></U></FONT>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "</B></U></GROUP></FONT>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  put "adding group open tags"
  put "<FONT color="& quote&"#0000FF"&quote&"><U><B>" into zstring
  repeat while offset(zstring,allText) > 0
    set cursor to busy
    put offset(zstring,allText) into firstchar
    put "<FONT color="& quote&"#0000FF"&quote&"><GROUP><U><B>" into char firstchar to (firstChar + length(zstring)-1) of allText
  end repeat
  
  repeat with i = 1 to the number of cards
    put empty into cardText
    put "working on card" && i && "of" && the number of cards
    set cursor to busy
    put offset("<p>&nbsp;",allText) +2 into lastChar
    put char 1 to lastChar of allText into cardText
    delete char 1 to (lastChar+length("<p>&nbsp;")-1) of allText
    
    repeat while offset(return,cardText) > 0
      put offset(return,cardText) into firstchar
      delete char firstchar of cardText
    end repeat
    
    repeat while offset("  ",cardText) > 0
      delete char offset("  ",cardText) of cardText
    end repeat
    
    repeat while char 1 to 3 of cardText is "<p>"
      delete char 1 to 3 of cardText
    end repeat
    
    if char 1 of cardText is ">" then delete char 1 of cardText
    if char 1 of cardText <> "<" then put "<" before cardText
  --  answer cardText with "OK" or "Cancel" --**
 --   if it is "cancel" then exit mouseUp --**
    set the htmltext of  field "main" of card i to cardText
  end repeat
  
end mouseUp

put "<p>" & return & "<p>" & return & "<p>" & return into cardEnd
put "<p><p><p><p>" & return into cardEnd2

repeat while offset(cardEnd,allText) > 0
  set cursor to busy
  put offset(cardEnd,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd)) of allText
end repeat

repeat while offset(cardEnd2,allText) > 0
  set cursor to busy
  put offset(cardEnd2,allText) into firstchar
  put "<p>&nbsp;" into char firstchar to (firstChar + length(cardEnd2)) of allText
end repeat
put "<p>&nbsp;"  after allText
         ` 8             	        reindex and sort EpMon mouseUp
  put empty into field "index"
  repeat with i = 1 to the number of cards
    if char 1 of field "main" of card i <> "x" then
      set the name of card i to line 1 of field "main" of card i
      put line 1 of field "main" of card i  & return after field "index"
    end if
  end repeat
  sort field "index"
end mouseUp
        T               	           K        j  t      a Ask Dialog   ron openCard
end openCard

on preOpenCard
end preOpenCard

on closeCard
end closeCard

on openStack
end openStack
   dd CornflowerBlue    2 @                     U 
Helvetica       	Pon doresize
  local twidth, iwidth
  put the width of this stack into twidth
  set the width of field 1 to twidth - 64
  set the left of field 1 to 48
  set the width of field 2 to twidth - 64
  set the left of field 2 to 48
  set the top of field 2 to the bottom of field 1
  set the top of button 1 to the height of field 1 div 2 - 8
  put (twidth - 120 ) div 3 into iwidth
  put iwidth into twidth
  set the default of button 2 to false
  repeat with i = 2 to the number of buttons
    set the left of button i to twidth
    set the bottom of button i to the height of this stack - 12
    add the width of button i + iwidth to twidth
  end repeat
  set the default of button 2 to true
end doresize

on star
  local tstring
  put empty into tstring
  repeat with i = 1 to the number of characters in field 3
    put "*" after tstring
  end repeat
  put tstring into field 2
end star

on preOpenStack
  local twidth
  set the itemDelimiter to numToChar(0)
  set the fieldmode of me to word 2 of item 1 of the dialogData
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field 1
  put max(the formattedWidth of field 1 + 64,\
      the formattedWidth of field 2 + 64, 320) into twidth
  set the width of this stack to twidth
  set the height of field 1 to the formattedHeight of field 1
  set the top of field 1 to 8
  set the height of this stack to (the height of field 1) + 100
  doresize
  if the fieldmode of me is not "plain" then
    put item 4 of the dialogData into field 3
    star
  else put item 4 of the dialogData into field 2
  set the dialogData to numToChar(0)
  set the itemDelimiter to comma
  set the icon of button 1 to item itemOffset(the lookAndFeel,"Motif,Macintosh,Windows 95") of "330,994,998"
end preOpenStack

on keyDown which
  local tpos
  if the name of the target contains "field" and the fieldmode of me is not "plain" then
    put the selectedChunk into tpos
    put which into character (word 2 of tpos) to (word 4 of tpos) of field 3
    star
    select after character (word 2 of tpos) of field 2
  else pass keyDown
end keyDown

on deleteKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass deleteKey
end deleteKey

on backspaceKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass backspaceKey
end backspaceKey

on deleteone
  local tpos
  put word 2 of the selectedChunk into tpos
  put empty into character (tpos - 1) of field 3
  star
  select before character (tpos - 1) of field 2
end deleteone

on commandKeyDown which
  if the fieldmode of me is not "plain"
  then
    local tpos
    switch which
    case "D"
      put word 2 of the selectedChunk into tpos
      put empty into character tpos of field 3
      star
      select before character tpos of field 1
      break
    case "H"
      deleteone
      break
    default
      pass commandKeyDown
    end switch
  else pass commandKeyDown
end commandKeyDown

on openField
  select the text of the target
end openField

on resizeStack
  doresize
end resizeStack

on returnInField
  click at the loc of button "OK"
end returnInField

on closeStack
  put empty into field 1
  put empty into field 2
  put empty into field 3
end closeStack
          @    
fieldmode  plain  a    _  \  ]  `
             0                  \ OK Lp on mouseUp
  switch the fieldmode of this card
  case "plain"
    get field 2
    break
  case "clear"
    get field 3
    break
  case "password"
    get mcencrypt(field 3)
    break
  end switch
  set the dialogData to it
  close this stack
end mouseUp
    
LightSkyBlue    B \ 4             	     ] Cancel Dp +on mouseUp
  close this stack
end mouseUp
            
LightSkyBlue     \ <             	   
  _   `       0 (              
  `   
!`       b 8 |             a New Button B@   
LightSkyBlue      $ (          	      Answer Dialog   on resizeStack
end resizeStack

on openStack
end openStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard
   dd CornflowerBlue   c   d   macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica       	P(on preOpenStack
  local dtype, foffset, oldwidth, bwidth, twidth, iwidth, theight, curx, nchoices
  set the itemDelimiter to numToChar(0)
  if word 2 of item 1 of the dialogData is "plain" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    put word 2 of item 1 of the dialogData into dtype
    set the itemDelimiter to comma
    set the icon of button "icon" to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of dialogData into field 1
  get item 4 of dialogData
  if it is empty then get "OK"
  put the number of lines in it into nchoices
  put 32 into bwidth
  if nchoices > the number of buttons - 1
  then put the number of buttons - 1 into nchoices
  repeat with i = 2 to nchoices + 1
    show button i
    set the name of button i to line nchoices + 2 - i of it
    set the width of button i to the formattedWidth of button i + 24
    add the width of button i + 32 to bwidth
  end repeat
  set the dontWrap of field 1 to true
  put max(the formattedWidth of field 1 + foffset + 16, bwidth) into twidth
  if twidth > 600 then
    put 600 into twidth
    set the dontWrap of field 1 to false
  end if
  put the width of this stack into oldwidth
  set the width of this stack to twidth
  set the width of field 1 to twidth - foffset - 16
  put the formattedHeight of field 1 + 68 into theight
  if theight > 400 then
    set the vScrollbar of field 1 to true
    put 400 into theight
  else set the vScrollbar of field 1 to false
  set the height of this stack to theight
  set the height of field 1 to theight - 68
  set the top of button 1 to the height of field 1 div 2 - 12
  set the topLeft of field 1 to foffset + 8, 8
  put (twidth - bwidth) div (nchoices + 1) + 32 into iwidth
  put iwidth into curx
  if the lookAndFeel is "Macintosh" then
    repeat with i = nchoices + 1 down to 2
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  else
    repeat with i = 2 to nchoices + 1
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  end if
  set the default of button 2 to true
  set the dialogData to empty
end preOpenStack

on closeStack
  repeat with i = 3 to the number of buttons
    hide button i
  end repeat
  set the default of button 2 to false
end closeStack

on mouseUp
  if the name of the target contains "button" then
    set the dialogData to the short name of the target
    close this stack
  end if
end mouseUp
             d  z                
     @                      "Returns not allowed in this field   z icon BP on mouseUp
end mouseUp
    
LightSkyBlue      , (         	      OK D`   
LightSkyBlue    U 6 4            	      Project D`   
LightSkyBlue    ~ 6 L            	      Cancel D`   
LightSkyBlue     6 L            	      All D`   
LightSkyBlue   | 6 /            	      y D`   
LightSkyBlue     4 '            	      x D`   
LightSkyBlue    i 4 '            	      w D`   
LightSkyBlue      4 )            	      vReport  :on closeCard
  global gDontSave
  put true into gDontSave
  if the visible of group "font" then hide group "font"
end closeCard

on setVersionTabs
  if the hilite of button "all projects" then
    if (the hilite of button "show date" AND the hilite of button "show version")  then
      set the tabstops of field "report" to "55,210,260,400"
    else
      if the hilite of button "show version" then
        set the tabstops of field "report" to "150,200,400"
      else -- just show date
        set the tabstops of field "report" to "50,200,400"
      end if
    end if
    if NOT (the hilite of button "show date" OR the hilite of button "show version") then
      set the tabstops of field "report" to "150,400"
    end if
  else -- just one project
    if (the hilite of button "show date" AND the hilite of button "show version")  then
      set the tabstops of field "report" to "100,150,400"
    else
      if the hilite of button "show version" then
        set the tabstops of field "report" to "50,400"
      else -- just show date
        set the tabstops of field "report" to "100,150,400"
      end if
    end if
    if NOT (the hilite of button "show date" OR the hilite of button "show version") then
      set the tabstops of field "report" to "150,400"
    end if
  end if
end setVersionTabs


























  w        Black dd CornflowerBlue ffffff      white       	darkgray    
 ?         Version Report      U Arial   U Arial   U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica   W Arial   W 
Helvetica  
 U 
Helvetica  
 U Arial   U 
Helvetica  	 U 
Helvetica   U Impact   U Impact   U Minion Web       	@          ?&                                                Create Report Ex   on mouseUp
  global gVersionTabs
  
  if the hilitedButtonName of group "sort" is empty then
    set the hilitedButtonName of group "sort" to "Project"
  end if
  
  if the hilite of button "show date" then
    put "Date" & tab  into temp
  end if
  if the hilite of button "all projects" then
    put "Project" & tab  after temp
    put empty into theProject
  else
    put  field "Project" into theProject
    put "Version report for project:" && field "Project" & return & return  before temp
  end if
  if the hilite of button "show version" then
    put "Version" & tab  after temp
  end if
  
  if the hilite of button "Short Description" then
    put "Short Description" & tab  after temp
  end if
  put temp & return & return into field "report"
  
  if gVersionTabs is empty then
    setVersionTabs
  else
    set the tabstops of field "report" to gVersionTabs
  end if
  
  set the itemDelimiter to tab
  put 1 into sortLine
  put the hilitedButtonName of group "sort" into sortBy
  
  put true into nodata
  put the number of cards of stack "versions" into zcards
  repeat with i = 1 to zcards
    if zcards > 50 then set cursor to busy
    --  if checkItems(i) then next repeat
    
    if field "project" of card i of stack "versions" is empty then next repeat
    if theProject is not empty then
      put field "project" of card i of stack "versions" into zProject
      if zProject <> theProject then next repeat
    end if
    
    put field "date" of card i of stack "versions" into zdate
    put field "time" of card i of stack "versions" into ztime
    convert zdate to dateitems
    convert ztime to dateitems
    put item 1 to 3 of zdate into item 1 to 3 of ztime
    
    put convertDate(ztime) & tab into temp
    put field "project" of card i of stack "versions" & tab after temp
    put i into item 3 of temp
    put temp into line sortLine of zSorter
    add 1 to sortLine
    put false into nodata
  end repeat
  
  if nodata then
    unlock screen with visual plain
    answer information "There were no versions found for these options."
    exit to metacard
  end if
  
  set the itemDelimiter to tab
  sort lines of zSorter by item 1 of each -- always sort by date first
  if sortBy is "project" then
    sort lines of zSorter  by item 2 of each
  end if
  repeat with i = 1 to the number of lines of zsorter
    put item 3 of line i of zsorter into cardNum
    put empty into temp
    if the hilite of button "show date" then
      put field "Date" of card cardNum of stack "versions" into zdate
     -- if  the hilite of button "show version" then
      if  the hilite of button "all projects" then
        convert zdate to short date
      else
        convert zdate to abbr date
      end if
      put zdate & tab after temp
    end if
    if the hilite of button "all projects" then put field "Project" of card cardNum of stack "versions" & tab after temp
    if the hilite of button "show version" then put field "version" of card cardNum of stack "versions" & tab after temp
    
    if the hilite of button "Short Description" then
      -- if  the hilite of button "show times" then
      put field "Description" of card cardNum of stack "versions" after temp
    end if
    put cardNum into item 8 of temp
    put temp & return after field "report"
    if the hilite of button "Change Notes" then
      put "Change Notes:" & return after field "report"
      put field "Notes" of card cardNum of stack "versions" & return & return after field "report"
    end if
  end repeat
end mouseUp

function convertDate zdate
  --convert zdate to dateitems -- comes as dateitems
  put item 1 of zdate into temp
  repeat with i = 2 to the number of items of zdate
    if item i of zdate < 10 then
      put "0" & item i of zdate after temp
    else
      put item i of zdate after temp
    end if
  end repeat
  return temp
end convertDate
    
LightSkyBlue     t             	         sort   y        	 ^ F   Date @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
    
LightSkyBlue    5 R              	      Project @D   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
    
LightSkyBlue    " F              	     Sort By  D     
LightSkyBlue    
 L              	      Show Date Entered @E  on mouseUp
  if the hilite of me then
    set the disabled of button "date entered" to false
  else
    set the disabled of button "date entered" to true
    set the hilitedButtonName of group "sort" to "task" -- "priority"
  end if
  send mouseUp to button "create report"
end mouseUp
    
LightSkyBlue     #               	       Show Invoice  @E  	on mouseUp
  if the hilite of me then
    set the disabled of button "deadline" to false
  else
    set the disabled of button "deadline" to true
    set the hilitedButtonName of group "sort" to "task"
  end if
  send mouseUp to button "create report"
end mouseUp
    
LightSkyBlue                    	       bg  @h     
LightSkyBlue    	 + E            	   	     
   project  	x   on mouseUp
  global gStack
  put the short name of this stack into gStack
  go stack "vprojects"
  show stack "vprojects"
end mouseUp
                    Writer's Helper    Select Project Ex   on mouseUp
  global gCallStack, gButton
  put the short name of me into gButton
  put the short name of this stack into gCallStack
  go stack "vprojects"
  show stack "vprojects"
end mouseUp
            
LightSkyBlue   t  `             	        options   i          p    
List Options  D     
LightSkyBlue      h              	      
All Projects @E  on mouseUp
  if the hilite of me then
    set the disabled of group "sort" to false
    send mouseUp to button "create report"
    put empty into field "project"
  else
    set the disabled of group "sort" to true
    send mouseUp to button "select project"
  end if
end mouseUp
            
LightSkyBlue    t  \              	        
Show Version @E   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
            
LightSkyBlue    o 4 q              	       
Show Date @E   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
            
LightSkyBlue     4 _              	       Short Description @E   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
            
LightSkyBlue     4               	       
Change Notes @E   Aon mouseUp
  send mouseUp to button "create report"
end mouseUp
            
LightSkyBlue   ^ 4 x              	        size   a         ` Z
   short  )h 	 
       d  <           button "Help"	48,410,120,431  &button "Close Window"	129,410,261,431  $button "Save as..."	270,410,358,431  button "Font"	368,410,440,431  button "Print"	449,410,521,431  field "report"	9,98,564,404       	`    @ s e  : 
   long  )h 	 
       d  <           button "Help"	48,520,120,541  &button "Close Window"	129,520,261,541  $button "Save as..."	270,520,358,541  button "Font"	368,520,440,541  button "Print"	449,520,521,541  field "report"	9,98,564,512       	`    @  e  :    putLong Ex  
;on mouseUp
  put "long" into whichField
  put empty into field whichField
  repeat with i = 1 to 5
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field "report" & tab & the rect of field "report" after field whichField
end mouseUp
    
LightSkyBlue     :              	     	      setLong Ex  
kon mouseUp
  set itemdelimiter to tab
  put "long" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
    
LightSkyBlue     :              	     	      	putShort Ex  
<on mouseUp
  put "short" into whichField
  put empty into field whichField
  repeat with i = 1 to 5
    put the name of button i & tab & the rect of button i into line i of field whichField
  end repeat
  put return & the name of field "report" & tab & the rect of field "report" after field whichField
end mouseUp
    
LightSkyBlue     :              	     	      	setShort Ex  
lon mouseUp
  set itemdelimiter to tab
  put "short" into whichField
  repeat with i = 1 to the number of lines of field whichField
    if line i of field whichField is empty then next repeat
    put item 1 of line i of field whichField into which
    put item 2 of line i of field whichField into where
    set the rect of which to where
  end repeat
end mouseUp
    
LightSkyBlue   G  :              	     	      Help Ux   on mouseUp
  put the short name of this stack into zStack
  put "vHelp" into helpStack
  if the openStacks contains helpStack then close stack helpStack
  goHelp "version report", helpStack, zStack
end mouseUp
    
LightSkyBlue    0 H             	        
Close Window Ex   on mouseUp
  global gStack
  lock screen
  hide group "font"
  close this stack
  goStack gStack
  unlock screen with visual plain
end mouseUp
    
LightSkyBlue                  	        Save as... Ux  on mouseUp
  
  put the date into whichDate
  put whichDate into temp
  repeat while offset("/",temp) > 0
    put "_" into char offset("/",temp) of temp
  end repeat
  ask file "Save invoice list as... " with "invoice_list_" & temp & ".txt"
  if the result is "Cancel" then exit mouseUp
  put checkExt(it) into fileName
  
  -- save data from all cards to txt file
  open file fileName for write
  if the result is empty then
    put field "report" into temp
    write "List of Invoices as of " & whichdate & return & line 1 of temp & return to file filename
    set itemdelimiter to tab
    repeat with i = 2 to the number of lines of temp
      delete item 6 to 8 of line i of temp
      write line i of temp & return to file filename
    end repeat
    close file fileName
  else
    answer "There was a problem saving this file." & return & the result & return & sysError()
  end if
end mouseUp
    
LightSkyBlue    X             	        Font Ux  on mouseUp
  lock screen
  put the fontNames into field "fonts"
  sort field "fonts"
  repeat with i = 1 to the number of lines of field "fonts"
    if the textfont of field "report" is line i of field "fonts" then
      set the hilitedlines of field "fonts" to i
      exit repeat
    end if
  end repeat
  put the textHeight of field "report" into field "lheight"
  show group "font"
  unlock screen --with visual wipe right
end mouseUp
    
LightSkyBlue   p H             	        Print Ux   &on mouseUp
  printReport
end mouseUp
    
LightSkyBlue    H             	     
   report 	x 	 
 )on mouseUp
  goReportLine 8
end mouseUp
        	 b+2 
 
 
 
    d    ,Version report for project: Writer's Helper     Date	Version	Short Description	    OTue, Feb 6, 2001	v0.1	Cloned stack versions and created Writer's Helper					20  PTue, Feb 13, 2001	v0.2	deleted tips field and added writers tips to help					21  7Wed, Feb 14, 2001	v0.3	first pass at help stack					22               	`    @ # c 0    font   a         4   font bg E`   
LightSkyBlue     ,             	        bgrect   K@              v    
   fonts  )x   won mouseUp
  put the hilitedlines of me into temp
  set the textfont of field "report" to line temp of me
end mouseUp
                      
.Keyboard  
AGaramond  AGaramond Italic  AGaramond Semibold  AGaramond SemiboldItalic  Andale Mono  Arial  Arial Black  B Friz Quadrata Bold  C Helvetica Condensed  	Capitals  CB Helvetica Condensed Bold  	Charcoal  Chicago  Comic Sans MS  Courier  Courier New  
FrenchScript  Friz Quadrata  Gadget  
GarthGraphic  GarthGraphic Black  GarthGraphic Bold  GarthGraphic BoldCondensed  GarthGraphic BoldItalic  GarthGraphic Condensed  GarthGraphic ExtraBold  GarthGraphic Italic  Geneva  Georgia  
Helvetica  Impact  	Kidprint  L Helvetica Light  LB Helvetica Black  
Lydian MT  Minion Web  Monaco  Monotype Sorts  
Monotype.com  	MT Extra  	New York  	Palatino  Sand  Swing  Swis721 BdCn BT  Swis721 BdCnOul BT  Swis721 BdOul BT  Swis721 BdRnd BT  Swis721 BlkCn BT  Swis721 BlkOul BT  Swis721 BlkRnd BT  Swis721 BT  Swis721 Hv BT  Swis721 It BT  Swis721 LtCn BT  Swis721 Th BT  Symbol  Techno  Tekton  Tekton Bold  Textile  Times  Times New Roman  
Trebuchet MS  Verdana  	Webdings  
Wingdings  Zapf Dingbats       	`    @        Close Ex  ;on mouseUp
  lock screen
  hide group "font"
  unlock screen --with visual wipe left
end mouseUp

on mouseUp
  global gDefaultFont
  set the hilitedButtonName of group "sizes" to "12 pt"
  send mouseUp to group "sizes"
  set the textfont of field "text" to gDefaultFont
  send mouseUp to button "font"
end mouseUp
    
LightSkyBlue     L              	     
   inst 	                      +Pick a font face and size for your report.    sizes   i   on mouseUp
  set the textSize of field "report" to word 1 of the hilitedButtonName of me
  put the textHeight of field "report" into field "lheight"
end mouseUp
         z K   9 pt @D   
LightSkyBlue     8              	      10 pt @D   
LightSkyBlue     8              	     11 pt @D   
LightSkyBlue     8              	      12 pt @D   
LightSkyBlue     8              	      14 pt @D   
LightSkyBlue     8              	      16 pt @D   
LightSkyBlue     8              	   
   label3 	         ]N ,           jAfter making changes to the font or size, you may need to adjust the tabs and other numbers to the right. 
   label2 
          T             Line Height 
   lheight  7)x  on mouseUp
  put field "lheight" into temp
  put the hilitedButtonName of group "sizes" into tsize
  ask "Enter a new line height > " & tsize &"." with temp
  if it is empty or it is not a number or it < tsize then
    answer information "You must enter a number larger than the font size."
    exit mouseUp
  end if
  put it into field "lheight"
  set the textHeight of field "report" to it
end mouseUp
         '            13    Tabs Ex  on mouseUp
  global gVersionTabs
  answer question "Set the tab stops to" with "Default" or "Custom"
  switch it
  case "Default"
    setVersionTabs
    put the tabstops of field "report" into gVersionTabs
    break
    
  case "Custom"
    if gVersionTabs is empty then put the tabstops of field "report" into gVersionTabs
    ask "Set the tab stops of the report field to" with gVersionTabs
    if it is empty then exit mouseUp
    put true into flag
    repeat with i = 1 to 3
      if item i of it is a number then
        put true into flag
      else
        put false into flag
      end if
    end repeat
    if flag then
      set the tabstops of field "report" to it
      put it into gVersionTabs
    end if
  end switch
end mouseUp
    
LightSkyBlue    4              	        
Default Font Ex   on mouseUp
  set the hilitedButtonName of group "sizes" to "10 pt"
  send mouseUp to group "sizes"
  set the textfont of field "report" to  "Arial"
  send mouseUp to button "font"
end mouseUp
    
LightSkyBlue    `              	     	   
   instruction 	  
        P            5Click an item name in the list to go to that record.  