/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   AP_EightBitAudioDevice.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.io.*;
import sun.audio.*;

/**
 * The <code>EightBitAP_AudioDevice</code> implements an audio
 * device by using the sun.audio.AudioAP_Player class
 *
 */
public class AP_EightBitAudioDevice extends AP_AudioDeviceBase implements Runnable
{
//	private int outputCapacity = 8192 * 4;
//	private byte[] byteBuf = new byte[1024];
	private int outputCapacity = 8192 * 4;
	private byte[] byteBuf = new byte[1024];

	AP_BigPipedInputStream pis;
	OutputStream pos;

	public boolean isEightBitEightKhzMuLaw() {
		return true;
	}

	protected void openImpl() throws AD_JavaLayerException {
		try {
			pis = new AP_BigPipedInputStream(outputCapacity);
			pos = new PipedOutputStream(pis);

		} catch (IOException ex) {
			System.out.println("Trouble creating pis/pos " + ex);
		}

		// Set decoder to create 8-bit ulaw audio
		getDecoder().getParams().setDownconvert();
	}

	protected void closeImpl() { }

	protected synchronized void writeImpl(short[] samples, int offset, int len, long pts, SystemDecoder systemDecoder) throws AD_JavaLayerException {
		byte[] output = getByteArray(len);
		int count = toByteArray(samples, offset, len, output, getDecoder().getOutputChannels() > 1);

                if (pts!=0) {
                  try {
                    long msInBuffer = pis.available()/8; // au: 8000 bytes/sec = 8 bytes/ms
                    long stc = systemDecoder.getSTC();
                    long stcWhenStartingToPlay = stc+msInBuffer; // stc when this data will start to play (if not adjusted)
                    long delta = pts-stcWhenStartingToPlay; // How much ahead of time the sound is
                    if (delta>50) {
                      Thread.currentThread().sleep(msInBuffer+delta);
                    } else if (delta<-50) {
                      systemDecoder.slowdownSTC(-delta);
                    }
                  } catch (Exception e) {}
                }
		try {
			// System.out.println("Audio Writing " + count + " buf fill: " + pis.available());
			pos.write(output, 0, count); //
		} catch (IOException ex) {
			//System.out.println("Trouble writing to pis/pos " + ex);
		}

		// System.out.println("writeImpl done");
	}



	protected byte[] getByteArray(int length) {
		if (byteBuf.length < length) {
			byteBuf = new byte[length + 1024];
		}
		return byteBuf;
	}

	int toByteArray(short[] samples, int offset, int len, byte[] b, boolean stereoToMono) {
		int idx = 0, preMu, signBit;

		while (len-- > 0) {

			if (stereoToMono) {
				preMu = (samples[offset++] + samples[offset++]) >> 1;
				len--;
			} else {
				preMu = samples[offset++];
			}

			// Cap preMu
			preMu = preMu < -32767 ? -32767 : preMu > 32767 ? 32767 : preMu;

            if (preMu >= 0) {
                signBit = 128;
            } else {
                preMu = -preMu;
                signBit = 0;
            }

            preMu = 132 + preMu >> 3;
            if (preMu < 32)
                b[idx++] = (byte)(signBit | 0x70 | 31 - preMu);
            else if (preMu < 64)
                b[idx++] = (byte)(signBit | 0x60 | 31 - (preMu >> 1));
            else if (preMu < 128)
                b[idx++] = (byte)(signBit | 0x50 | 31 - (preMu >> 2));
            else if (preMu < 256)
                b[idx++] = (byte)(signBit | 0x40 | 31 - (preMu >> 3));
            else if (preMu < 512)
                b[idx++] = (byte)(signBit | 0x30 | 31 - (preMu >> 4));
            else if (preMu < 1024)
                b[idx++] = (byte)(signBit | 0x20 | 31 - (preMu >> 5));
            else if (preMu < 2048)
                b[idx++] = (byte)(signBit | 0x10 | 31 - (preMu >> 6));
            else if (preMu < 4096)
                b[idx++] = (byte)(signBit | 31 - (preMu >> 7));
            else
                b[idx++] = (byte)signBit;
		}
		return idx;
	}

	/*protected void flushImpl() {
		// FIXME
	}*/

	public int getPosition() {
		// FIXME
		return 0;
	}


	public float getFillRatio() {
		float ret = 0;
		try {
			ret = (float)pis.available() / (float) outputCapacity;
		} catch (IOException ex) {
		}
		return ret;
	}

	/**
	 * Start player playing
	 */
	public void play() { // Run in thread, will lock otherwire if no audio available in video
          (new Thread(this)).start();
	}

        public void run() {
          AudioPlayer.player.start(pis);
        }

	/**
	 * Stop player playing
	 */
	public void stop() {
		try {
			// pis.close();
			pos.close();
		} catch (IOException ex) { System.out.println("AP_EightBitAudioDevice::stop(): Trouble--caught IOException"); }
		AudioPlayer.player.stop(pis);
                //pis.skip(pis.available()) // flush, so that write can be done soon again by AP_Player.decodeFrame, so that thread wont be locked
	}

	/**
	 * Runs a short test by playing a short silent sound.
	 */
	public boolean test() throws AD_JavaLayerException {
		return true;
	}
}
