/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class Category {
    private int id;
    private int index;
    private String name;
    private boolean isModified;
    public static final int MAX_CATEGORIES = 16;
    public static final int CATEGORY_LENGTH = 16;

    public Category() {
    }

    public Category(String string) {
        this(string, 0, 0, false);
    }

    public Category(String string, int n, int n2) {
        this(string, n, n2, false);
    }

    public Category(String string, int n, int n2, boolean bl) {
        this.name = string;
        this.id = n;
        this.index = n2;
        this.isModified = bl;
    }

    public static Vector parseCategories(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, 258);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray, 258, 16);
        DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream2);
        Vector<Category> vector = new Vector<Category>(16);
        short s = dataInputStream.readShort();
        int n = 1;
        int n2 = 0;
        while (n2 < 16) {
            int n3 = n2;
            int n4 = dataInputStream2.read();
            String string = "";
            boolean bl = (n & s) > 0;
            boolean bl2 = false;
            int n5 = 0;
            while (n5 < 16) {
                byte by = (byte)dataInputStream.read();
                if (by == 0) {
                    bl2 = true;
                } else if (!bl2) {
                    string = string + (char)by;
                }
                ++n5;
            }
            vector.addElement(new Category(string, n4, n3, bl));
            n <<= 1;
            ++n2;
        }
        return vector;
    }

    public static byte[] toBytes(Vector vector) throws IOException {
        if (vector.size() > 16) {
            throw new IOException("Error: maximum categories exceeded");
        }
        byte[] byArray = new byte[274];
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < 16) {
            Category category = (Category)vector.elementAt(n3);
            if (category.isModified()) {
                n |= n2;
            }
            n2 <<= 1;
            String string = category.getName();
            if (string.length() > 16) {
                string = string.substring(0, 16);
            }
            System.arraycopy(string.getBytes(), 0, byArray, 2 + 16 * n3, string.length());
            byArray[258 + n3] = (byte)category.getId();
            ++n3;
        }
        byArray[0] = (byte)(n2 >> 8);
        byArray[1] = (byte)(n2 & 0xF);
        return byArray;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setIsModified(boolean bl) {
        this.isModified = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void delete() {
        this.name = "";
        this.id = 0;
        this.index = 0;
        this.isModified = false;
    }
}

