/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import palm.conduit.Record;

public abstract class AbstractRecord
implements Record {
    int recId;
    int recIndex;
    int categoryIndex;
    boolean isDeleted = false;
    boolean isModified = false;
    boolean isNew = false;
    boolean isArchived = false;
    boolean isPrivate = false;
    static final int YEAR_SHIFT_FACTOR = 9;
    static final int MONTH_SHIFT_FACTOR = 5;
    static final int HOUR_SHIFT_FACTOR = 8;
    static final int FIRST_YEAR = 1904;

    public abstract void writeData(DataOutputStream var1) throws IOException;

    public abstract void readData(DataInputStream var1) throws IOException;

    public int getId() {
        return this.recId;
    }

    public void setId(int n) {
        this.recId = n;
    }

    public int getIndex() {
        return this.recIndex;
    }

    public void setIndex(int n) {
        this.recIndex = n;
    }

    public int getCategoryIndex() {
        return this.categoryIndex;
    }

    public void setCategoryIndex(int n) {
        this.categoryIndex = n;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(boolean bl) {
        this.isDeleted = bl;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setIsModified(boolean bl) {
        this.isModified = bl;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setIsNew(boolean bl) {
        this.isNew = bl;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setIsPrivate(boolean bl) {
        this.isPrivate = bl;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public void setIsArchived(boolean bl) {
        this.isArchived = bl;
    }

    static byte[] _getBytes(Record record) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        record.writeData(dataOutputStream);
        dataOutputStream.flush();
        dataOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public boolean equals(Object object) {
        byte[] byArray;
        byte[] byArray2;
        try {
            Record record = (Record)object;
            byArray2 = AbstractRecord._getBytes(this);
            byArray = AbstractRecord._getBytes(record);
        }
        catch (IOException iOException) {
            return false;
        }
        if (byArray2.length != byArray.length) {
            return false;
        }
        int n = 0;
        while (n < byArray2.length) {
            if (byArray2[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    String nullIfEmpty(String string) {
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    public static int toMinutes(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        if (n != -1) {
            n2 = (n & 0xFF00) >> 8;
            n3 = n & 0xFF;
        }
        return n2 * 60 + n3;
    }

    public static int fromMinutes(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        n2 = n / 60;
        n3 = n % 60;
        return n2 << 8 | n3;
    }

    public static Date readDate(DataInputStream dataInputStream) throws IOException {
        short s = dataInputStream.readShort();
        if (s == -1) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int n = ((s & 0xFE00) >>> 9) + 1904;
        int n2 = ((s & 0x1E0) >>> 5) - 1;
        int n3 = s & 0x1F;
        calendar.set(n, n2, n3);
        return calendar.getTime();
    }

    public static void writeDate(DataOutputStream dataOutputStream, Date date) throws IOException {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n = calendar.get(2) + 1;
            int n2 = calendar.get(5);
            int n3 = calendar.get(1) - 1904;
            int n4 = n3 << 9 | n << 5 | n2;
            dataOutputStream.writeShort(n4);
        } else {
            dataOutputStream.writeShort(-1);
        }
    }

    public static String readCString(DataInputStream dataInputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((n = dataInputStream.read()) == 0) continue;
            stringBuffer.append((char)n);
        } while (n > 0);
        return stringBuffer.toString();
    }

    public static void writeCString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.write(string.getBytes());
        dataOutputStream.write(0);
    }

    static String stringWithoutCarriageReturns(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c != '\r' || n + 1 >= n2 || string.charAt(n + 1) != '\n') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "<record id: " + this.getId() + "> <record index: " + this.getIndex() + "> <is deleted: " + this.isDeleted() + "> <is new: " + this.isNew() + "> <is archived: " + this.isArchived() + "> <isPrivate: " + this.isPrivate() + ">";
    }

    public String toFormattedString() {
        return "AbstractRecord: {\n  record id: " + this.getId() + "\n" + "  record index: " + this.getIndex() + "\n" + "  is deleted: " + this.isDeleted() + "\n" + "  is new: " + this.isNew() + "\n" + "  is archived: " + this.isArchived() + "\n" + "  isPrivate: " + this.isPrivate() + "\n" + "}\n";
    }
}

