/*

    To my parents
    Eduard Svjatoslavovich and Ludmila Aleksandrovna Barkhatov

        (c) Barkhatov Andrej Eduardovich

*/

#include "placer.h"
#include "office.h"

HWND hDlg, hWnd, hWndR;

BOOL CALLBACK dlg_proc(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg) {
	case WM_CLOSE:
		EndDialog(hdlg, 0);
		return 1;
	case WM_INITDIALOG:
		hDlg = hdlg;
		dlg_init();
		return 1;
	case WM_SIZE:
		dlg_size(lParam);
		return 1;
	case WM_DRAWITEM:
		return dlg_drawitem(lParam);
	case WM_COMMAND:
		SetCapture(hdlg);
		SetCursor(LoadCursor(0, IDC_WAIT));
		switch (LOWORD(wParam)) {
		case ID_INFO:
			dlg_info();
			break;
		case ID_OPEN:
			dlg_open();
			break;
		case ID_SAVE:
			dlg_save();
			break;
		case ID_MLOAD:
			macro_load();
			break;
		case ID_MSAVE:
			SendMessage(hWndR, WM_COMMAND, ID_MSAVE, 0);
			break;
		case ID_MLIST:
			if (CBN_SELCHANGE == HIWORD(wParam) && !macro_sel())
				MessageBox(hdlg, "Unable to Select Macro", PROG_NAME, MB_OK);
			break;
		case ID_ZOOMIN:
			SendMessage(hWnd, WM_COMMAND, ID_ZOOMIN, 0);
			break;
		case ID_ZOOMOUT:
			SendMessage(hWnd, WM_COMMAND, ID_ZOOMOUT, 0);
			break;
		case ID_RECT:
			SendMessage(hWnd, WM_COMMAND, ID_RECT, 0);
			break;
		case ID_REF:
			SendMessage(hWndR, WM_COMMAND, ID_REF, 0);
			break;
		case ID_COLOR:
			DialogBox(hInstance, "ColorDlg", hDlg, (DLGPROC) color_proc);
			break;
		case ID_HIST:
			SendMessage(hWndR, WM_COMMAND, ID_HIST, 0);
			break;
		case ID_PYRM:
			SendMessage(hWndR, WM_COMMAND, ID_PYRM, 0);
			break;
		case ID_FILL:
			SendMessage(hWndR, WM_COMMAND, ID_FILL, 0);
			break;
		case ID_RGBG:
			SendMessage(hWndR, WM_COMMAND, ID_RGBG, 0);
			break;
		case ID_EROD:
			SendMessage(hWndR, WM_COMMAND, ID_EROD, 0);
			break;
		case ID_SMOO:
			SendMessage(hWndR, WM_COMMAND, ID_SMOO, 0);
			break;
		case ID_CONT:
			SendMessage(hWndR, WM_COMMAND, ID_CONT, 0);
			break;
		case ID_THRE:
			SendMessage(hWndR, WM_COMMAND, ID_THRE, 0);
			break;
		case ID_EDGE:
			SendMessage(hWndR, WM_COMMAND, ID_EDGE, 0);
			break;
		case ID_APPR:
			SendMessage(hWndR, WM_COMMAND, ID_APPR, 0);
			break;
		case ID_SNAK:
			SendMessage(hWndR, WM_COMMAND, ID_SNAK, 0);
			break;
		case ID_HOUG:
			SendMessage(hWndR, WM_COMMAND, ID_HOUG, 0);
			break;
		case ID_CNVX:
			SendMessage(hWndR, WM_COMMAND, ID_CNVX, 0);
			break;
		case ID_CLOSE:
			DestroyWindow(hWndR);
			DestroyWindow(hWnd);
			break;
		case ID_UNDO:
			SendMessage(hWnd, WM_COMMAND, ID_UNDO, 0);
			break;
		case ID_FLATTEN:
			SendMessage(hWnd, WM_COMMAND, ID_FLATTEN, 0);
			break;
		default:
			ReleaseCapture();
			SetCursor(LoadCursor(0, IDC_ARROW));
			return 0;
		}
		ReleaseCapture();
		SetCursor(LoadCursor(0, IDC_ARROW));
		return 1;
	}
	return 0;
}

HINSTANCE hInstance;

int APIENTRY WinMain(HINSTANCE hinst, HINSTANCE hinstPrev, LPSTR lpCmdLine, int nCmdShow)
{
	WNDCLASS wc;
	INITCOMMONCONTROLSEX icex;

	memset(&icex, 0, sizeof(INITCOMMONCONTROLSEX));
	icex.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icex.dwICC = ICC_COOL_CLASSES|ICC_USEREX_CLASSES|ICC_UPDOWN_CLASS|ICC_WIN95_CLASSES;
	CoInitialize(0);
	InitCommonControlsEx(&icex);
	memset(&wc, 0, sizeof(wc));
	wc.lpfnWndProc = DefDlgProc;
	wc.cbWndExtra = DLGWINDOWEXTRA;
	wc.hInstance = hInstance = hinst;
	wc.hCursor = LoadCursor(0, IDC_ARROW);
	wc.hIcon = LoadIcon(hinst, "APLACER");
	wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
	wc.lpszClassName = "WinPlacer";
	RegisterClass(&wc);
	return DialogBox(hinst, "MainDlg", NULL, (DLGPROC) dlg_proc);
}
