unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  apCreate = function(pFileName:PChar  ): Longint	; stdcall	;
  apOpen = function(pFileName:PChar  ): Longint	; stdcall	;
  apClose = procedure(id:Longint ); stdcall ;

  apAddInfo = function(id:Longint;Title:PChar;Subject:PChar;Author:PChar;Keyword:PChar;Creator:PChar):Longint;stdcall;
  apSetFunction = function(id:Longint;func_code:Longint;
                             para1:Longint;para2:Longint;para3:PChar ;para4:PChar ): Longint	; stdcall	;
  apGetFunction = function(id:Longint;func_code:Longint;
                             para1:Longint;para2:Longint;para3:PChar ;para4:PChar ): Longint	; stdcall	;

  apAddImage = function( id:Longint;filename:PChar): Longint	; stdcall	;
  apAddImageData = function (id:Longint;data:PChar;width:Longint;height:Longint;color:Longint):Longint;stdcall;


  apAddText = function(id:Longint;x:Longint;y:Longint;width:Longint;height:Longint;
                      str:PChar;color:Longint;bkcolor:Longint;lFormat:Longint):Longint;stdcall;

  apAddTextEx= function(id:Longint;x:Longint;y:Longint;str:PChar;color:Longint):Longint;stdcall;

  apAddTxt = function (id:Longint;filename:PChar;color:Longint;
                        PageWidth:Longint;PageHeight:Longint;AutoNewLine:Longint;AutoWidthAdjust:Longint;
						            LeftMargin:Longint;RightMargin:Longint;TopMargin:Longint;BottomMargin:Longint;
						            TabSize:Longint):Longint;stdcall;
                        
  apAddLine = function (id:Longint;sx:Longint;sy:Longint;ex:Longint;ey:Longint;width:Longint;color:Longint):Longint;stdcall;

  apAddRect = function(id:Longint;sx:Longint;sy:Longint;ex:Longint;ey:Longint;
							          side_width:Longint;side_color:Longint;
							          flagFill:Longint;fill_color:Longint):Longint;stdcall;

const

//define for ApSetFunction
Ap_Set_MultiPage        : Longint =	101 ;
Ap_Set_ImagePosAndSize  : Longint =	104 ;
Ap_Set_Encrypt 				  : Longint = 105 ;
Ap_Set_Font					    : Longint = 106 ;
Ap_Set_NewOrClosePage	  : Longint = 109 ;
Ap_Set_BookMark				  : Longint = 110 ;
Ap_Set_ViewerPreferences: Longint = 121 ;
Ap_Set_Recompress			  : Longint = 123 ;
//define for ApGetFunction
Ap_Get_ImagePageCount		: Longint = 201 ;
Ap_Get_ImageSizeW			  : Longint = 202 ;
Ap_Get_ImageSizeH			  : Longint = 203 ;
Ap_Get_ImageDpiX			  : Longint = 204 ;
Ap_Get_ImageDpiY			  : Longint = 205 ;
Ap_Get_PdfPageCount			: Longint = 206 ;
Ap_Get_PdfCurrentPageSize	: Longint = 209 ;
Ap_Get_StringWidth			  : Longint = 250 ;
Ap_Get_StringHeight			  : Longint = 251 ;
Ap_Get_Recomporess			  : Longint = 210 ;
Ap_Get_ImageBits			    : Longint = 211 ;
//define for ApAddText
Ap_DT_LEFT			: Longint = 0 ;
Ap_DT_CENTER		: Longint = 1 ;
Ap_DT_RIGHT			: Longint = 2 ;
Ap_DT_WORDBREAK	: Longint = 16;   //0x10 ;
Ap_DT_CALCRECT	: Longint = 1024; //0x400 ;

//set password and permission
permission_Print	: Longint = 1 ;
permission_Copy		: Longint = 2 ;
permission_Modify	: Longint = 4 ;


var
  Form1: TForm1;

  g_hapW : HMODULE	;
  papCreate: apCreate;
  papOpen: apOpen ;
  papClose: apClose ;
  papAddInfo: apAddInfo;
  papSetFunction: apSetFunction ;
  papGetFunction: apGetFunction ;
  papAddImage: apAddImage ;
  papAddImageData: apAddImageData;
  papAddText: apAddText ;
  papAddTextEx: apAddTextEx;
  papAddTxt: apAddTxt;
  papAddLine: apAddLine ;
  papAddRect: apAddRect;

implementation

{$R *.dfm}


//****************************************************************************

function FreeapWDll() : Boolean;
begin
	if(g_hapW = 0) then begin
		FreeapWDll:=False;
    Exit;
  end;
	FreeLibrary(g_hapW);
	g_hapW:=0;
  Result:=True;
end;
//****************************************************************************

function  LoadapWDll :Boolean ;
var
  path:PAnsiChar ;
  proc :FARPROC ;
label
  Failer;

begin
  path := 'tifftopdf.dll';
  g_hapW :=LoadLibrary(path);
	if(g_hapW=0) then
		goto Failer;

	proc:=GetProcAddress(g_hapW,'ApCreate');
	if(proc=nil)then
		goto Failer;
  papCreate:=proc ;
	proc:=GetProcAddress(g_hapW,'ApOpen');
	if(proc=nil)then
		goto Failer;
  papOpen:=proc ;
  proc:=GetProcAddress(g_hapW,'ApClose');
	if(proc=nil)then
		goto Failer;
  papClose:=proc ;
  proc:=GetProcAddress(g_hapW,'ApAddInfo');
	if(proc=nil)then
		goto Failer;
  papAddInfo:=proc ;
  proc:=GetProcAddress(g_hapW,'ApSetFunction');
	if(proc=nil)then
		goto Failer;
  papSetFunction:=proc ;
  proc:=GetProcAddress(g_hapW,'ApGetFunction');
	if(proc=nil)then
		goto Failer;
  papGetFunction:=proc ;
  proc:=GetProcAddress(g_hapW,'ApAddImage');
	if(proc=nil)then
		goto Failer;
  papAddImage:=proc ;
  proc:=GetProcAddress(g_hapW,'ApAddImageData');
	if(proc=nil)then
		goto Failer;
  papAddImageData:=proc ;
  proc:=GetProcAddress(g_hapW,'ApAddText');
	if(proc=nil)then
		goto Failer;
  papAddText:=proc ;
  proc:=GetProcAddress(g_hapW,'ApAddTextEx');
	if(proc=nil)then
		goto Failer;
  papAddTextEx:=proc ;
  proc:=GetProcAddress(g_hapW,'ApAddTxt');
	if(proc=nil)then
		goto Failer;
  papAddTxt:=proc ;
  proc:=GetProcAddress(g_hapW,'ApAddLine');
	if(proc=nil)then
		goto Failer;
  papAddLine:=proc ;
  proc:=GetProcAddress(g_hapW,'ApAddRect');
	if(proc=nil)then
		goto Failer;
  papAddRect:=proc ;

  Result:=True;
  Exit;

  Failer:
    FreeapWDll();
    Result:=False;
end;


procedure AddImageData(id:Longint );
type

   TMemData = array[0..128*128*3] of Char;
var
  i:Integer;
  j:Integer;
  temp1:Integer;
  temp2:Integer;
  red:Integer;
  green:Integer;
  blue:Integer;
  MemImageWidth:Integer;
  MemImageHeight:Integer;
  color:Integer;
  MemData:TMemData;

begin

	MemImageWidth:=128;
	MemImageHeight:=128;
	color:=24;//can equal 1 and 8 and 24

  if id <= 0 then
    Exit;

	for i:=0 to MemImageHeight - 1 do
		for j:=0 to MemImageWidth - 1 do
    begin
    	temp1:=i And 8;
			temp2:=j And 8;
			if  ( temp1 Xor temp2 ) <> 0 then
      begin
				red :=255 ;
				green := 0;
        blue := 0;
      end
			else
      begin
        red := 0;
        green := 0;
        blue := 255;
      end;
            MemData[i * MemImageWidth * 3 + j * 3 + 0] := char(red);
            MemData[i * MemImageWidth * 3 + j * 3 + 1] := char(green);
            MemData[i * MemImageWidth * 3 + j * 3 + 2] := char(blue);
	  end;

	papAddImageData(id,MemData,MemImageWidth,MemImageHeight,color);

end;

procedure RecompressTruecolorFile(pImageFile:PChar);
var
	id:Longint;
	szPDFFile:PChar;
begin
  // recompress lzw
	szPDFFile:='Truecolor_lzw.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,3,0,'lzw',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;
  // recompress zip
	szPDFFile:='Truecolor_zip.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,3,0,'zip',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;
  // recompress packbits
	szPDFFile:='Truecolor_packbits.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,3,0,'packbits',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;
  // recompress jpeg
	szPDFFile:='Truecolor_jpeg.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,3,0,'jpeg',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;

end;

procedure RecompressGrayFile(pImageFile:PChar);
var
	id:Longint;
	szPDFFile:PChar;
begin
  // recompress lzw
	szPDFFile:='Gray_lzw.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,2,0,'lzw',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;
  // recompress zip
	szPDFFile:='Gray_zip.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,2,0,'zip',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;
  // recompress packbits
	szPDFFile:='Gray_packbits.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,2,0,'packbits',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;
  // recompress jpeg
	szPDFFile:='Gray_jpeg.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,2,0,'jpeg',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;

end;

procedure RecompressBlackWhiteFile(pImageFile:PChar);
var
	id:Longint;
	szPDFFile:PChar;
begin
  // recompress lzw
	szPDFFile:='Black_White_lzw.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,1,0,'lzw',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;
  // recompress zip
	szPDFFile:='Black_White_zip.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,1,0,'zip',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;
  // recompress g3
	szPDFFile:='Black_White_g3.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,1,0,'g3',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;
  // recompress g4
	szPDFFile:='Black_White_g4.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Recompress,1,0,'g4',NIL);
		papAddImage(id,pImageFile);
		papClose(id);
	end;

end;

procedure Recompress(pImageFile:PChar);
var
	bits:Longint;
begin
	bits:=papGetFunction(0,Ap_Get_ImageBits,0,0,pImageFile,NIL);
	case bits of
	  1:  RecompressBlackWhiteFile(pImageFile);
	  8:  RecompressGrayFile(pImageFile);
		24: RecompressTruecolorFile(pImageFile);
	end;
end;

procedure AddPDFInfo();
var
	id:Longint;
	szPDFFile:PChar;
	szImageFile:PChar;
begin
	szImageFile:='multipage.tif';
	szPDFFile:='Information.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 )then
	begin
		papAddInfo(id,'Title','Subject','Author','Keywords','Creator');
		papAddImage(id,szImageFile);
		papClose(id);
	end;
end;

procedure PDFsecurity();
var
	id:Longint;
	szPDFFile:PChar;
	szImageFile:PChar;
begin
	szImageFile:='Truecolor.tif';
	szPDFFile:='Security.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		papSetFunction(id,Ap_Set_Encrypt,128,permission_Print+permission_Copy+permission_Modify,'wner','user');
		papAddImage(id,szImageFile);
		papClose(id);
	end;
end;

procedure AddPDFBookmark();
var
	beginpage:Longint;
	pagenums:Longint;
	pagecount:Longint;
	id:Longint;
	szPDFFile:PChar;
	szImageFile:PChar;
	szBookmark:PChar;
begin
	szImageFile:='multipage.tif';
	szPDFFile:='Bookmark.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 )then
	begin
		//get multi page tiff page count
		pagecount:=papGetFunction(id,Ap_Get_ImagePageCount,0,0,szImageFile,NIL);
		for beginpage:=1 to pagecount do
    begin
			//add bookmark
      szBookmark:= PChar( 'bookmark' + IntToStr(beginpage) );
			papSetFunction(id,Ap_Set_BookMark,0,0,szBookmark,NIL);
			//Add one page
			pagenums:=1;
			papSetFunction(id,Ap_Set_MultiPage,beginpage,pagenums,NIL,NIL);
			papAddImage(id,szImageFile);
     end;
		pApClose(id);
	end;
end;

procedure AppendPDF() ;
var
	id:Longint;
	szPDFFile:PChar;
	szImageFile:PChar;
begin
	szImageFile:='multipage.tif';
	szPDFFile:='Append.pdf';
	//Append PDF file
  id:=papOpen(szPDFFile);
	if( id >0 ) then
	begin
		pApAddImage(id,szImageFile);
		pApClose(id);
  end
	else
  begin
	  //Create new PDF file
    id:=papCreate(szPDFFile);
	  if( id >0 ) then
	  begin
		  papAddImage(id,szImageFile);
		  papClose(id);
	  end;
  end;
end;


procedure Other();
var
	id:Longint;
  iret:Longint;
  width:Longint;
  height:Longint;
  xdpi:Longint;
  ydpi:Longint;
	beginpage:Longint;
  pagenums:Longint;
  pagecount:Longint;
	szBookmark:PChar;
	szPDFFile:PChar;
	szImageFile:Pchar;
begin
	szImageFile:='multipage.tif';
	szPDFFile:='Other.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		//set info
		papAddInfo(id,'Title','Subject','Author','Keywords','Creator');
    //set view
		papSetFunction(id,Ap_Set_ViewerPreferences,4+4096,2,NIL,NIL);
		//set encrypt
		papSetFunction(id,Ap_Set_Encrypt,128,permission_Print+permission_Copy+permission_Modify,'owner','user');

		//get multi page tiff page count
		pagecount:=papGetFunction(id,Ap_Get_ImagePageCount,0,0,szImageFile,NIL);
		for beginpage:=1 to pagecount do
    begin
			//Get image width and height
			iret:=papGetFunction(id,Ap_Get_ImageSizeW,Longint(@width),Longint(@height),szImageFile,PChar(IntToStr(beginpage)) );
			//Get image dpi (Resolution)
			iret:=papGetFunction(id,Ap_Get_ImageDpiX,Longint(@xdpi),Longint(@ydpi),szImageFile,PChar(IntToStr(beginpage)));
			if( ( xdpi>0) and (ydpi>0) ) then
      begin
 				width  := Trunc(width * (72.0/xdpi) );
 				height := Trunc(height* (72.0/ydpi) );
			end;
			//new page
			iret:=papSetFunction(id,Ap_Set_NewOrClosePage,width,height,0,0);
			//set image size
			iret:=papSetFunction(id,Ap_Set_ImagePosAndSize,0,0,PChar(IntToStr(width)),PChar(IntToStr(height)) );
			//add bookmark
      szBookmark:=PChar('bookmark ' + IntToStr(beginpage) );
			papSetFunction(id,Ap_Set_BookMark,0,0,szBookmark,0);
			//add one
			pagenums:=1;
			papSetFunction(id,Ap_Set_MultiPage,beginpage,pagenums,0,0);
			iret:=papAddImage(id,szImageFile);
			//close the page
			iret:=papSetFunction(id,Ap_Set_NewOrClosePage,0,0,0,0);
		end;

		//add bookmark
		papSetFunction(id,Ap_Set_BookMark,0,0,'bookmark memory image',0);
		//add image four, the example for bit 24 bmp
		addImageData(id);

		papClose(id);
	end;
end;

procedure Other2() ;
var
	id:Longint;
  iret:longint;
  width:longint;
  height:longint;
  xdpi:longint;
  ydpi:longint;
	beginpage:longint;
  pagenums:longint;
  pagecount:longint;
	szBookmark:pchar;
	szPDFFile:pchar;
	szImageFile:pchar;
  buffer:pchar;
begin

	szPDFFile :='Other2.pdf';
  id:=papCreate(szPDFFile);
	if( id >0 ) then
	begin
		//new a page for a3
		papSetFunction(id,Ap_Set_NewOrClosePage,1,1,0,0);
		//add bookmark
		papSetFunction(id,Ap_Set_BookMark,0,0,'bookmark one',0);
		//set system font and size
		papSetFunction(id,Ap_Set_Font,1,32,'Arial',0);
		//add text
		papAddTextEx(id,300,300,'this is a text!',RGB(0,255,255));

		//set system font and size
		pApSetFunction(id,Ap_Set_Font,1,32,'Helvetica',0);
		//add text
		pApAddTextEx(id,300,400,'this is a text!',RGB(0,255,255));

		//set font and size
		pApSetFunction(id,Ap_Set_Font,203,32,0,0);

		buffer :='this is a text! this is a text! this is a text! this is a text!';
		//add text for rect
		width:=200;
		height:=0;
		pApAddText(id,1,1,Longint(@width),Longint(@height),buffer,
					 RGB(0,0,255),RGB(255,0,255),Ap_DT_WORDBREAK or Ap_DT_CALCRECT);
		pApAddText(id,1,1,width,height,buffer,
					 RGB(0,0,255),RGB(255,0,255),Ap_DT_WORDBREAK or Ap_DT_CENTER);

		//set system font and size
		pApSetFunction(id,Ap_Set_Font,1,32,'Verdana',0);
		//add text
		pApAddTextEx(id,300,500,'this is a text!',RGB(0,255,255));

		//new a page for b5
		pApSetFunction(id,Ap_Set_NewOrClosePage,4,4,0,0);
		//add bookmark
		pApSetFunction(id,Ap_Set_BookMark,0,0,'bookmark two',0);
		//add graphic
		pApAddLine  (id,10,10,100,200,5,RGB(0,0,255));
		pApAddRect(id,20,210,300,400,3,RGB(0,255,0),1,RGB(255,0,255));

		szImageFile := 'test.txt';
		pApSetFunction(id,Ap_Set_Font,200,16,0,0);
		pApAddTxt(id,szImageFile,0,0,0,1,1,64,64,64,64,4);


		pApClose(id);

	end;
end;



procedure TForm1.Button1Click(Sender: TObject);
var
  szImageFile : PChar ;
begin

  if( LoadapWDll() = True ) then
  begin

	  //recompress tiff files to PDFs
	  Recompress('Black_White.tif');
	  Recompress('Gray.tif');
	  Recompress('Truecolor.tif');

	  AddPDFInfo();

	  PDFsecurity();

	  AddPDFBookmark();

	  AppendPDF();
	  AppendPDF();

	  Other();

	  Other2();


    FreeapWDll();
  end;

end;

end.
