/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DListBox;
import common.ListItem;
import common.Tool;
import common.VectorBoolean;
import common.VectorLong;
import common.VectorString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;

public class DirBox
extends DListBox {
    VectorBoolean VType;
    VectorLong VSize;
    VectorLong VDate;
    public long TotalSize;
    public long TaggedSize;
    int namePos = 20;
    int sizePos;
    int datePos;
    int endPos;
    int charWidth = 8;
    int dateWidth;
    int sizeWidth;
    static final int sizeLen = 9;
    static final int dateLen = 11;
    static DateFormat df = DateFormat.getDateTimeInstance(3, 0);
    int oldWidth = 0;
    boolean restarted = true;
    int fullLineLength;

    DirBox(boolean bl) {
        super(bl);
    }

    DirBox() {
        this(false);
    }

    public void crossOut(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            listItem.deleted = true;
            listItem.bDirty = true;
        }
    }

    public void crossOut(int n, boolean bl) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            listItem.deleted = bl;
            listItem.bDirty = true;
        }
    }

    public boolean isCrossOut(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            return listItem.deleted;
        }
        return false;
    }

    public boolean isCrossOut() {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            if (!listItem.deleted) continue;
            return true;
        }
        return false;
    }

    public synchronized void selectAllFiles(int n) {
        if (!this.bMultipleSelections) {
            return;
        }
        int n2 = this.items.size();
        for (int i = n; i < n2; ++i) {
            ListItem listItem = (ListItem)this.items.elementAt(i);
            if (!listItem.bEnabled) continue;
            listItem.bSelected = true;
        }
        this.countSelected = n2;
        this.lastSelected = n2 - 1;
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.restarted = true;
    }

    public void adjustFontWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.charWidth = fontMetrics.charWidth('0');
        this.sizeWidth = 9 * this.charWidth;
        this.dateWidth = fontMetrics.stringWidth("00/00/2010 00:00");
        this.restarted = false;
    }

    public void adjustWidth() {
        Dimension dimension = this.getSize();
        if (this.restarted) {
            this.adjustFontWidth();
        }
        this.fullLineLength = this.longestLineValue;
        int n = dimension.width - this.barSize - 4;
        int n2 = this.sizeWidth + this.dateWidth + 12 + 28;
        int n3 = n - n2;
        int n4 = 20 * this.charWidth;
        if (n3 < n4) {
            n3 = n4;
        }
        if (this.fullLineLength + 4 < n3) {
            this.fullLineLength = n3;
        }
        this.sizePos = this.fullLineLength;
        this.datePos = this.sizePos + this.sizeWidth + 12;
        this.endPos = this.datePos + this.dateWidth + 28;
        this.fullLineLength = this.endPos - 4;
    }

    public String[] getFiles(String string) {
        int n = this.countItems();
        VectorString vectorString = new VectorString(n);
        for (int i = 0; i < n; ++i) {
            String string2 = this.getText(i);
            if (new File(string, string2).isDirectory()) continue;
            vectorString.addElement(this.getText(i));
        }
        return vectorString.toArray();
    }

    public void update(Graphics graphics) {
        super.update(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        Color color;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (this.listChanged) {
            this.adjustWidth();
        }
        if (!Tool.objectsEqual(color = this.getBackground(), this.cachedBackground)) {
            this.cachedBackground = color;
            this.calculateBorderColors(this.PanelColor);
        }
        Rectangle rectangle = this.getBounds();
        this.font = graphics.getFont();
        this.fm = graphics.getFontMetrics(this.font);
        this.fontHeight = this.fm.getHeight();
        this.fontDescent = this.fm.getDescent();
        int n6 = this.items.size();
        this.cellHt = this.bCellBorders ? this.fontHeight + 5 : this.fontHeight + 1;
        if (n6 == 0) {
            this.nTopRow = 0;
            this.visibleRows = 0;
            bl2 = false;
            bl = false;
            this.xCoord = 0;
        } else {
            if (this.bAllowShowHBar && this.fullLineLength > rectangle.width - this.borderWidth) {
                bl2 = true;
                n2 = this.barSize;
            } else {
                bl2 = false;
                n2 = 0;
            }
            int n7 = (rectangle.height - n2 - this.borderWidth - this.yAdj) / this.cellHt;
            if (this.bAllowShowVBar && n6 > n7) {
                bl = true;
                n = this.barSize;
                if (!bl2 && this.bAllowShowHBar && this.fullLineLength > rectangle.width - this.borderWidth - n) {
                    bl2 = true;
                    n2 = this.barSize;
                    n7 = (rectangle.height - n2 - this.borderWidth - this.yAdj) / this.cellHt;
                }
            } else {
                bl = false;
                n = 0;
            }
            if (this.visibleRows != n7) {
                this.visibleRows = n7;
                this.bAllDirty = true;
            }
            if (bl) {
                this.VBar.setBounds(rectangle.width - this.barSize - this.halfBorderWidth, this.halfBorderWidth, this.barSize, rectangle.height - this.borderWidth - n2);
                this.VBar.setValues(this.nTopRow, this.visibleRows, 0, n6);
                this.VBar.setBlockIncrement(this.visibleRows);
                this.lWidth = rectangle.width - n - this.borderWidth;
                if (!this.bVBarVisible) {
                    this.bVBarVisible = true;
                    this.VBar.setVisible(true);
                }
            } else {
                this.lWidth = rectangle.width - this.borderWidth;
                if (this.bVBarVisible) {
                    this.bVBarVisible = false;
                    this.VBar.setVisible(false);
                }
            }
            if (bl2) {
                this.HBar.setBounds(this.halfBorderWidth, rectangle.height - this.barSize - this.halfBorderWidth, rectangle.width - this.borderWidth - n, this.barSize);
                this.HBar.setValues(-this.xCoord, this.lWidth, 0, this.fullLineLength);
                this.HBar.setBlockIncrement(this.lWidth);
                if (!this.bHBarVisible) {
                    this.bHBarVisible = true;
                    this.HBar.setVisible(true);
                }
            } else if (this.bHBarVisible) {
                this.bHBarVisible = false;
                this.HBar.setVisible(false);
            }
        }
        if (this.borderType == 0) {
            graphics.setColor(this.borderDarkerColor);
            graphics.drawLine(0, 0, rectangle.width - 1, 0);
            graphics.drawLine(0, 0, 0, rectangle.height - 1);
            graphics.setColor(this.borderDarkColor);
            graphics.drawLine(1, 1, rectangle.width - 2, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 2);
            graphics.setColor(this.borderLightColor);
            graphics.drawLine(1, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
            graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
            graphics.setColor(this.borderLighterColor);
            graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.clipRect(this.halfBorderWidth, this.halfBorderWidth, this.lWidth, rectangle.height - this.borderWidth);
        if (this.nTopRow >= n6) {
            this.nTopRow -= this.visibleRows + 1;
        }
        int n8 = this.nTopRow;
        int n9 = Math.min(this.nTopRow + this.visibleRows, n6);
        int n10 = 0;
        while (n8 < n9) {
            n4 = n10 * this.cellHt + this.yAdj + this.halfBorderWidth;
            n5 = (n10 + 1) * this.cellHt + this.yAdj + this.halfBorderWidth;
            ListItem listItem = (ListItem)this.items.elementAt(n8);
            if (listItem.bDirty || this.bAllDirty) {
                listItem.bDirty = false;
                graphics.clearRect(this.halfBorderWidth, n4, this.lWidth, this.cellHt);
            }
            int n11 = listItem.image != null ? this.halfBorderWidth + 20 + 2 : this.halfBorderWidth;
            n3 = listItem.bCellBorder ? 2 : 0;
            int n12 = this.lWidth - this.xCoord - 20 - 2;
            if (listItem.bSelected) {
                graphics.setColor(this.textHighlight);
                graphics.fillRect(this.xCoord + n11 + n3, n4, n12, this.cellHt);
                graphics.setColor(this.textHighlightText);
            } else {
                graphics.setColor(this.enabledColor);
            }
            int n13 = this.xCoord + n11 + n3 + 2;
            int n14 = n5 - this.fontDescent;
            graphics.drawString(listItem.sText, n13, n14);
            if (this.VType.elementData[n8]) {
                try {
                    String string = Tool.longToString(this.VSize.elementAt(n8), 9);
                    String string2 = df.format(new Date(this.VDate.elementAt(n8)));
                    int n15 = this.sizeWidth - string.length() * this.charWidth;
                    graphics.drawString(string, n13 + this.sizePos + n15, n14);
                    graphics.drawString(string2, n13 + this.datePos, n14);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                }
            }
            if (listItem.image != null) {
                graphics.drawImage(listItem.image, this.xCoord + this.halfBorderWidth + n3 + 2, n4 + 2, 20, this.cellHt - 3, this);
            }
            if (listItem.deleted) {
                graphics.setColor(Color.red);
                int n16 = n4 + this.cellHt / 2;
                graphics.drawLine(this.xCoord + this.halfBorderWidth + n3 + 2, n16, this.lWidth, n16);
            }
            if (listItem.tagged) {
                graphics.setColor(this.textHighlight);
                graphics.drawRect(this.xCoord + n11 + n3, n4 + 1, n12 - this.xCoord - 2, this.cellHt - 2);
            }
            ++n8;
            ++n10;
        }
        this.bAllDirty = false;
        this.listChanged = false;
    }

    public long getTaggedSize() {
        this.TaggedSize = 0L;
        for (int i = 0; i < this.countItems(); ++i) {
            if (!this.isSelected(i)) continue;
            this.TaggedSize += this.VSize.elementAt(i);
        }
        return this.TaggedSize;
    }

    public void clear(int n) {
        super.clear(n);
        this.VType = new VectorBoolean(n, 16);
        this.VSize = new VectorLong(n, 16);
        this.VDate = new VectorLong(n, 16);
        this.TotalSize = 0L;
    }

    public synchronized void addItemDir(int n) {
        this.addItem(n);
        this.VType.addElement(false);
        this.VSize.addElement(0L);
        this.VDate.addElement(0L);
    }

    public void addItemFile(Image image, int n, long l, long l2) {
        this.addItem(image, n);
        this.VType.addElement(true);
        this.VSize.addElement(l);
        this.VDate.addElement(l2);
        this.TotalSize += l;
    }

    public void delItem(int n) {
        super.delItem(n);
        this.TotalSize -= this.VSize.elementAt(n);
        this.VType.removeElementAt(n);
        this.VSize.removeElementAt(n);
        this.VDate.removeElementAt(n);
    }

    public long[] getSelectedSizes() {
        long[] lArray = new long[this.countSelected];
        if (this.countSelected > 0) {
            int n = 0;
            int n2 = this.items.size();
            for (int i = 0; i < n2; ++i) {
                ListItem listItem = (ListItem)this.items.elementAt(i);
                if (!listItem.bSelected && !listItem.tagged) continue;
                lArray[n] = this.VSize.elementAt(i);
                if (++n == this.countSelected) break;
            }
        }
        return lArray;
    }
}

