* PE32 Default Keys

* Tabs at 9 17 25 ...
set tabs 9 8

* Set screen colors (data, selected data, command line, dialog boxes)
*          Background  Foreground
set colors blue        brightwhite \
           red         brightwhite \
           green       brightwhite \
           brightwhite red

* Set extensions to use coloring scheme 0
set syntaxcoloringext0 .cxx .cpp .c .inl .hxx .hpp .h .tlh .tli

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring0 blue        lightaqua   \
                    blue        lightaqua   \
                    blue        lightyellow \
                    blue        lightyellow \
                    blue        green       \
                    blue        aqua


* Set the setting commands for syntax coloring
set syntaxcoloringset0 tabs 5 4, delimiters "\t\n\r [](),'+-*=/\\\""

* Set the profile file for syntax coloring
* set syntaxcoloringpro0 cpp.pro

* Set extensions to use coloring scheme 1
set syntaxcoloringext1 .htm .html

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring1 blue        lightaqua   \
                    blue        lightaqua   \
                    blue        lightyellow \
                    blue        lightyellow \
                    blue        green       \
                    blue        aqua

* Set the setting commands for syntax coloring
set syntaxcoloringset1 tabs 9 8, delimiters "\t\n\r"

* Set the profile file for syntax coloring
* set syntaxcoloringpro1 html.pro

* Set extensions to use coloring scheme 2
set syntaxcoloringext2 .txt .doc .hlp .msg

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring2 blue        lightaqua   \
                    blue        lightaqua   \
                    blue        lightyellow \
                    blue        lightyellow \
                    blue        green       \
                    blue        aqua

* Set the setting commands for syntax coloring
set syntaxcoloringset2 tabs 1 17 25 43, delimiters "\t\n\r [](){}<>,;:.!?'+-*=/\\\"

* Set the profile file for syntax coloring
* set syntaxcoloringpro2 txt.pro

* Set extensions to use coloring scheme 3
set syntaxcoloringext3 .bat .cmd

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring3 blue        lightaqua   \
                    blue        lightaqua   \
                    blue        lightyellow \
                    blue        lightyellow \
                    blue        green       \
                    blue        aqua

* Set the setting commands for syntax coloring
set syntaxcoloringset3 tabs 9 8, delimiters "\t\n\r"

* Set the profile file for syntax coloring
* set syntaxcoloringpro3 bat.pro

* Set extensions to use coloring scheme 4
set syntaxcoloringext4 .pro

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring4 blue        lightaqua   \
                    blue        lightaqua   \
                    blue        lightyellow \
                    blue        lightyellow \
                    blue        green       \
                    blue        aqua

* Set the setting commands for syntax coloring
set syntaxcoloringset4 tabs 9 8, delimiters "\t\n\r [](){}<>,;:.!?'+-*=/\\\"

* Set the profile file for syntax coloring
* set syntaxcoloringpro4 pro.pro

* Set extensions to use coloring scheme 5
set syntaxcoloringext5 .vbs

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring5 blue        lightaqua   \
                    blue        lightaqua   \
                    blue        lightyellow \
                    blue        lightyellow \
                    blue        green       \
                    blue        aqua

* Set the setting commands for syntax coloring
set syntaxcoloringset5 tabs 3 2, delimiters "\t\n\r ()<>,.'+-*=/\\\"

* Set the profile file for syntax coloring
* set syntaxcoloringpro5 vbs.pro

* Set extensions to use coloring scheme 6
set syntaxcoloringext6 .asm

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring6 blue        lightaqua   \
                    blue        lightaqua   \
                    blue        lightyellow \
                    blue        lightyellow \
                    blue        green       \
                    blue        aqua

* Set the setting commands for syntax coloring
set syntaxcoloringset6 tabs 1 17 25 43, delimiters "\t\n\r [](){}<>,;:.!?'+-*=/\\\"

* Set the profile file for syntax coloring
* set syntaxcoloringpro6 asm.pro

* Set extensions to use coloring scheme 7
set syntaxcoloringext7 .vb

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring7 blue        lightaqua   \
                    blue        lightaqua   \
                    blue        lightyellow \
                    blue        lightyellow \
                    blue        green       \
                    blue        aqua

* Set the setting commands for syntax coloring
set syntaxcoloringset7 tabs 3 2, delimiters "\t\n\r ()<>,.'+-*=/\\\"

* Set the profile file for syntax coloring
* set syntaxcoloringpro7 vb.pro

* Set extensions to use coloring scheme 8
set syntaxcoloringext8 .js

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring8 blue        lightaqua   \
                    blue        lightaqua   \
                    blue        lightyellow \
                    blue        lightyellow \
                    blue        green       \
                    blue        aqua

* Set the setting commands for syntax coloring
set syntaxcoloringset8 tabs 3 2, delimiters "\t\n\r ()<>,.'+-*=/\\\"

* Set the profile file for syntax coloring
* set syntaxcoloringpro8 js.pro

* Margins 1 to 80, paragraph starts at 1 (no indent), max char 32767
set margins 1 80 1 32767

* Enable this line to set the screen display size
* set display 25 80

* Set default printer
set printer lpt1

* Set extensions to backup
set backup .cpp .c .hpp .h

* Modifier to up/down arrows to control history (when on command line)
* Modifier to up/down arrows to enter history dialog (when on not command line)
set historyon shift

* When saving file trim trailing blanks from lines
set linetrim trailing

* No context help file ... set to path for the compiler help of your choice
set helpfile

* Set to overwrite existing files without a confirming message
set confirm off

* Start in replace character mode
set insert off

* Define format of [date] command ... s-f11 will insert actual date as text
set date [dd]/[mm]/[yyyy]

* Define format of [time] command ... s-f12 will insert actual time as text
set time [24]:[mm]

* Disable password protection for files
set encryption off

* Set to remember cursor position between edits
set restorecursor on

* Status line enabled with bright white on black color
*        (lightyellow on black if file is modified)
set StatusLine on black brightwhite lightyellow on

* Enable the command line
* Moving off command line set to move from prior cursor position
set commandline on off

* Enable backspace over dummy blank lines at end of line
set bkspinfreespace on

* Set no ctrl-Z in file
set eof off

* Set LF to separate lines
set linefeed on

* Set CR to separate lines
set carriagereturn on

* Disable word wrapping at right margin
set wordwrap off

* Allow lower case characters
set uppercase off

* Force the initial cursor onto the command line
set oncommand on

* Start with menu system on
set onmenu on

* When opening file tabs will be expanded to columns 8 columns apart
set tabexpand 8

* Set Tab, CR, LF, and blank as characters that separate words
set delimiters "\t\n\r "

* Disable blanks compression to tab while saving
set blankcompress off

* Turn off screen updates during script processing
set vbsrefresh off

* Default script timeouts (1 minute)
set vbstimeout 60000

* Enable this line to load your own vbs file
* set vbsload "<path>"

* Set the number of lines to scroll with the mouse wheel
set wheelscrollline 1

* Enable this line to change the characters codepage
* set codepage 437

* Enable this line to change the borders characters
* set borders ͺĳ

* Set the cursor height in overwrite and insert mode
set cursor 20 90

* Enable the display of the bookmarks
set showbookmarks on

* Enable this line to change the default locate switches
* set locateswitch

* Enable this line to change the default change switches
* set changeswitch

* Set the time in seconds to automatically save the modified files
set autosave 0

* Set the number of lines to search back for unknown words in autocomplete
set linesback 10000

*
* Synonyms
*

* Shortcuts to screen display sizes
syn s25 = [set display 25 80]
syn s30 = [set display 30 80]
syn s40 = [set display 40 80]
syn s50 = [set display 50 80]
syn max = [set display max]

*
* General macros
*

* Fancy Enter (even better than release F10 = AEnter):
*
* Insert a line beyond current position with the cursor aligned below leftmost
*    prior word and duplicate any delimiters prior to that word on the line
*    above the original line
syn FEnter = [cursor data]                 [* Insure in data area]             \
             [insert line] [push mark]     [* Add new line]                    \
             [mark line]                   [* Save place to return to]         \
             [backtab word]                [* May skip over several lines]     \
             [begin line] [begin word]     [* Start of first prior word]       \
             [end mark] [unmark] [up]      [* Have setup ending column]        \
             [mark block] [begin line]     [* Mark prefix plus 1 char]         \
             [mark block] [down]           [* Return to cursor]                \
             [overlay block]               [* Copy prefix]                     \
             [end mark] [down]             [* Return to cursor for last time]  \
             [delete char] [pop mark]      [* Remove extra character]

* Insert a line beyond current position with the cursor aligned below leftmost
*    prior word ... be careful words do not contain delimiters
syn AEnter = [cursor data]                 [* Insure in data area]             \
             [insert line] [push mark]     [* Add new line]                    \
             [mark line]                   [* Save place to return to]         \
             [backtab word]                [* May skip over several lines]     \
             [begin line] [begin word]     [* Start of first prior word]       \
             [begin mark] [pop mark]       [* Return to cursor]

* Insert a line beyond current position with the cursor aligned below leftmost
*    non-blank
syn XEnter = [cursor data]                 [* Insure in data area]             \
             [insert line] [up]            [* Add new line]                    \
             [first nonblank]              [* Start of first non-blank char]   \
             [down]                        [* Position on new line]

* Insert a line beyond current position with the cursor alignment unchanged
syn YEnter = [cursor data]                 [* Insure in data area]             \
             [push mark] [mark char]       [* Save position]                   \
             [insert line]                 [* Add new line]                    \
             [begin mark]                  [* Reposition cursor]               \
             [down] [pop mark]             [* Position on new line]

* Split line into two lines at cursor position (cursor does not move),
* duplicate any initial delimiters, and indent new line
syn FSplit = [split] [push mark]           [* Split line]                      \
             [mark char] [push mark]       [* Save cursor position]            \
             [begin line] [begin word]     [* Start of first word on line]     \
             [mark block] [begin line]     [* Mark prefix plus 1 char]         \
             [mark block] [down]           [* Goto new line]                   \
             [insert mode] [copy mark]     [* Copy prefix]                     \
             [end mark] [down]             [* Position to extra character]     \
             [delete char] [pop mark]      [* Remove extra character]          \
             [begin mark] [pop mark]       [* Restore cursor position, mark]

* Split a list of items separated by commas
syn SplitList = [push mark] [mark line]                                        \
                [copy mark] [end line]     [* Duplicate line]                  \
                [locate] '/,/-mi'          [* Locate last list separator]      \
                [unmark] [erase end line]  [* Remove last item from 1st line]  \
                [down] [bookmark set 'Z']  [* Mark so can return]              \
                [mark block] [begin line]  [* Mark up to last item 2nd line]   \
                [mark block] [end mark]                                        \
                [locate] '/ /-mi' [unmark] [* Find start of list]              \
                [right] [mark block]       [* Mark the start]                  \
                [bookmark goto 'Z']        [* Return to end of list]           \
                [mark block] [delete mark] [* Delete initial list items]       \
                [pop mark] [up]            [* Back for more splitting]

* Move current line to top of screen (ASSUME Small font, large screen)
syn TopScr50 = [push mark] [mark line]                                         \
               [center line]               [* Move line to center]             \
               [scrolldown 25]             [* Move line to top]                \
               [begin mark] [pop mark]     [* Return to original position]

* Move current line to top of screen (ASSUME Small font, large screen)
syn TopScr25 = [push mark] [mark line]                                         \
               [center line]               [* Move line to center]             \
               [scrolldown 12]             [* Move line to top]                \
               [begin mark] [pop mark]     [* Return to original position]

* Assume initial screen mode is large
syn TopScr   = [TopScr50]

* Set Small font, large screen
syn SmallFont = [set display 50 80] [cursor command]   [* Set large screen]    \
                [delete line] 'syn TopScr=[TopScr50]'  [* Redefine TopScr]     \
                [execute] [cursor data]

* Large font, small screen
syn LargeFont = [set display 25 80] [cursor command]   [* Set small screen]    \
                [delete line] 'syn TopScr=[TopScr25]'  [* Redefine TopScr]     \
                [execute] [cursor data]


* Erase all characters on line before the cursor
syn ErsBefore = [push mark] [insert mode] ' ' [* Save, add extra character]    \
                [left] [mark block]           [* Select new character]         \
                [begin line] [mark block]     [* Extend mark to line start]    \
                [fill mark ' ']               [* Fill before cursor]           \
                [end mark] [pop mark]         [* Position over extra blank]    \
                [replace mode] [delete char]  [* Cleanup]

* Join with following line (leave one extra blank between contents)
syn FJoin = [push mark] [down] [first nonblank] [* Locate non-blank 2nd line]  \
            [mark block] [end line] [left]      [* Mark good stuff on 2nd line]\
            [mark block] [up] [end line] [right][* Return past end of 1st line]\
            [copy mark] [down] [unmark]         [* Copy to 1st line]           \
            [delete line] [up] [pop mark]    [* Delete 2nd line and reposition]

* Convert mark to line mark and reflow the mark
syn RefMark = [end mark] [bookmark set 'Z']       [* Remember end]             \
              [begin mark] [unmark] [mark line]   [* Reflow needs line mark]   \
              [bookmark goto 'Z'] [mark line]     [* Finish mark conversion]   \
              [begin mark] [reflow] [begin mark]  [* Move text inside margins] \
              [first nonblank]                    [* Leave cursor at top corner]

* Search for highlighted word (no embedded "~"s)
syn FindMark = [cursor command] [delete line] 'l~'      [* Clear command]      \
               [copy mark] [end line] '~[cl]' [execute] [* Build locate mark]

* Shift left mark by 4 characters
* If cursor is not in mark reverts to [backtab]
* syn Tab_Left  = [ve Tab_N_Left(4)]

* Shift right mark by 4 characters
* If cursor is not in mark reverts to [tab]
* syn Tab_Right = [ve Tab_N_Right(4)]

* Shift left mark by distance between first two tab stops
* If cursor is not in mark reverts to [backtab]
syn Tab_Left  = [ve Tab_N_Left(0)]

* Shift right mark by distance between first two tab stops
* If cursor is not in mark reverts to [tab]
syn Tab_Right = [ve Tab_N_Right(0)]

* Set margins to edges of current block mark and reflow the mark checking for
*   multiple paragraphs.
* If parameter is 0 then assumes paragraphs are separated by blank lines.
* If parameter is 1 then assumes any line that ends in a "." is also a
*   paragraph (note that this may guess wrong).
* If parameter is 2 then assumes any line that ends in a "." is also a
*   paragraph and adds the missing blank line.
* def ? = [ve Set_Margins] [ve Reflow_Mult(2)]

* Prompt for global operation ... clobbers command line
syn PromptGlobal = [cursor command] [delete line]                        \
                   '<%@input "Enter Global Command String"%>'            \
                   've Prompt_Global("<%Enter Global Command String%>")' \
                   [execute]


*
* Shortcuts to C++ structures
*

*
* Note that you may type the synonym name into the text area then hit c-i
* (which is set to [expand]).  When this is done the synonym name is deleted
* and the synonym is executed!
*

* Block style 1 (both { and } indented, on separate lines)

* Generates an if block (assumes indenting is 4 characters)
syn 1if     = [cursor data] 'if (  )' [XEnter] [right 4] '{' [XEnter]          \
              '}' [up 2] [begin line] [first nonblank] [right 5] [insert mode]

* Generates an else block (assumes cursor above } line)
syn 1else   = [cursor data] [down] [XEnter] [left 4] 'else' [XEnter]           \
              [right 4] '{' [XEnter] '}' [up] [XEnter] [replace mode]

* Generates an else if block (assumes cursor above } line)
syn 1ei     = [cursor data] [down] [XEnter] [left 4] [1if] [left 5]            \
              'else ' [right 5]

* Generates an if/else block (assumes indenting is 4 characters)
syn 1ie     = [1if] [bookmark set 'Z'] [1else] [delete line] [bookmark goto 'Z']

* Generates an while block (assumes indenting is 4 characters)
syn 1while  = [cursor data] 'while (  )' [XEnter] [right 4] '{' [XEnter]       \
              '}' [up 2] [begin line] [first nonblank] [right 8] [insert mode]

* Generates an for block (assumes indenting is 4 characters)
syn 1for    = [cursor data] 'for (  ;  ;  )' [XEnter] [right 4] '{'            \
              [XEnter] '}' [up 2] [begin line] [first nonblank] [right 6]      \
              [insert mode]

* Generates an switch/case/default block (assumes indenting is 4 characters)
syn 1switch = [cursor data] 'switch (  )' [XEnter] [right 4] '{'               \
              [XEnter] 'case  :' [XEnter] [right 4] 'break;' [XEnter]          \
              [YEnter] [left 4] 'default:' [XEnter] [right 4] 'break;'         \
              [XEnter] [left 4] '}' [up 7] [begin line] [first nonblank]       \
              [right 9] [insert mode]

* Generates an case block (assumes cursor above break; line)
syn 1case   = [cursor data] [down] [XEnter] [left 4] [YEnter] 'case  :'        \
              [XEnter] [right 4] 'break;' [up] [begin line] [first nonblank]   \
              [right 5] [insert mode]

* Generates an do/while block (assumes indenting is 4 characters)
syn 1do     = [cursor data] 'do' [XEnter] [right 4] '{' [XEnter] '}'           \
              [XEnter] [left 4] 'while (  );' [left 3] [insert mode]

* Block style 2 (neither { nor } indented, on separate lines)

* Generates an if block (assumes indenting is 4 characters)
syn 2if     = [cursor data] 'if (  )' [XEnter] '{' [XEnter]                    \
              '}' [up 2] [begin line] [first nonblank] [right 5] [insert mode]

* Generates an else block (assumes cursor above } line)
syn 2else   = [cursor data] [down] [XEnter] 'else' [XEnter] '{'                \
              [XEnter] '}' [up] [XEnter] [right 4] [replace mode]

* Generates an else if block (assumes cursor above } line)
syn 2ei     = [cursor data] [down] [XEnter] [2if] [left 5] 'else ' [right 5]

* Generates an if/else block (assumes indenting is 4 characters)
syn 2ie     = [2if] [bookmark set 'Z'] [down] [2else] [delete line]            \
              [bookmark goto 'Z']

* Generates an while block (assumes indenting is 4 characters)
syn 2while  = [cursor data] 'while (  )' [XEnter] '{' [XEnter]                 \
              '}' [up 2] [begin line] [first nonblank] [right 8] [insert mode]

* Generates an for block (assumes indenting is 4 characters)
syn 2for    = [cursor data] 'for (  ;  ;  )' [XEnter] '{'                      \
              [XEnter] '}' [up 2] [begin line] [first nonblank] [right 6]      \
              [insert mode]

* Generates an switch/case/default block (assumes indenting is 4 characters)
syn 2switch = [cursor data] 'switch (  )' [XEnter] '{'                         \
              [XEnter] 'case  :' [XEnter] [right 4] 'break;' [XEnter]          \
              [YEnter] [left 4] 'default:' [XEnter] [right 4] 'break;'         \
              [XEnter] [left 4] '}' [up 7] [begin line] [first nonblank]       \
              [right 9] [insert mode]

* Generates an case block (assumes cursor above break; line)
syn 2case   = [cursor data] [down] [XEnter] [left 4] [YEnter] 'case  :'        \
              [XEnter] [right 4] 'break;' [up] [begin line] [first nonblank]   \
              [right 5] [insert mode]

* Generates an do/while block (assumes indenting is 4 characters)
syn 2do     = [cursor data] 'do' [XEnter] '{' [XEnter] '}'                     \
              [XEnter] 'while (  );' [left 3] [insert mode]

* Block style 3 (neither { nor } indented, only } gets a separate line)

* Generates an if block (assumes indenting is 4 characters)
syn 3if     = [cursor data] 'if (  ) {' [XEnter]                               \
              '}' [up] [begin line] [first nonblank] [right 5] [insert mode]

* Generates an else block (assumes cursor above } line)
syn 3else   = [cursor data] [down] [end line] ' else {'                         \
              [XEnter] '}' [up] [XEnter] [right 4] [replace mode]

* Generates an else if block (assumes cursor above } line)
syn 3ei     = [cursor data] [down] [end line] [3if] [left 4] ' else ' [right 4]

* Generates an if/else block (assumes indenting is 4 characters)
syn 3ie     = [3if] [bookmark set 'Z'] [3else] [delete line] [bookmark goto 'Z']

* Generates an while block (assumes indenting is 4 characters)
syn 3while  = [cursor data] 'while (  ) {' [XEnter]                            \
              '}' [up] [begin line] [first nonblank] [right 8] [insert mode]

* Generates an for block (assumes indenting is 4 characters)
syn 3for    = [cursor data] 'for (  ;  ;  ) {'                                 \
              [XEnter] '}' [up] [begin line] [first nonblank] [right 6]        \
              [insert mode]

* Generates an switch/case/default block (assumes indenting is 4 characters)
syn 3switch = [cursor data] 'switch (  ) {'                                    \
              [XEnter] 'case  :' [XEnter] [right 4] 'break;' [XEnter]          \
              [YEnter] [left 4] 'default:' [XEnter] [right 4] 'break;'         \
              [XEnter] [left 4] '}' [up 6] [begin line] [first nonblank]       \
              [right 9] [insert mode]

* Generates an case block (assumes cursor above break; line)
syn 3case   = [cursor data] [down] [XEnter] [left 4] [YEnter] 'case  :'        \
              [XEnter] [right 4] 'break;' [up] [begin line] [first nonblank]   \
              [right 5] [insert mode]

* Generates an do/while block (assumes indenting is 4 characters)
syn 3do     = [cursor data] 'do {' [XEnter] '}'                                \
              [XEnter] 'while (  );' [left 3] [insert mode]

* Install preferred indenting method

syn if      = [2ie]
syn while   = [2while]
syn for     = [2for]
syn switch  = [2switch]
syn case    = [2case]
syn do      = [2do]

* Does not work ... can not find name: ??
syn ??     = [cursor data] [insert mode] '(  ) ?  : ' [left 8]

* Shortcut to see key definitions
syn keys   = [edit .keydefs]

* Shortcut to write a date/time C++ remark
syn dtr    = [cursor data] [insert mode]      [* Set to insert text into data] \
             '/* ' [date] ' '                 [* Start frame, add date]        \
             [time] ' */' [insert toggle]     [* Add time, finish frame]

* Shortcut to write an author name C++ remark
syn anr    = [cursor data] [insert mode]      [* Set to insert text into data] \
             '/* Author: <%"Type author name"="Your name"%> */' [* Add name]   \
             [insert toggle]                  [* Back (?) to replace mode]

* Shortcut to write a C++ header
syn head   = [import header.txt]

*
* Shortcuts to ASM structures
*

* Utility to remove one blank from marked area
syn EraseBlank   = [begin mark] [change] '/ //mi'

* Utility to move comment right a column and return to start of mark
syn CommentRight = [change] '/;/ ;/*mi' [begin mark]

* Utility to move comment left a column and return to start of mark
syn CommentLeft  = [change] '/  ;/ ;/*mi' [begin mark]

* Tab to comment column from most recent previous line with comment past column 1
syn CommentCol = [push mark] [mark line]        [* Save position]              \
                 [begin line]                   [* Do not look on this line]   \
                 [locate] '/ ;/-i' [right]      [* Locate prior comment]       \
                 [end mark] [pop mark]          [* Return to original line]

* Move comment start to cursor position then move down
syn AlignC = [push mark] [mark block]           [* Save position]              \
             [begin line] [right] [mark block]  [* Mark initial part of line]  \
             [CommentRight 42] [end mark]       [* Shift comment right]        \
             [left] [unmark] [mark block]       [*   forcing it past cursor]   \
             [end line] [mark block]            [* Mark terminal part of line] \
             [begin mark] [CommentLeft 42]      [* Shift comment left]         \
             [right] [unmark] [pop mark]        [* Restore mark ]              \
             [down]                             [* Down to repeat]

* Remove any SHORT modifiers from line, realign comment
syn NoShort = [push mark] [mark char] [push mark] [* Save position]            \
              [column 25] [mark block] [end line] [* Mark operators to EOL]    \
              [mark block] [locate] '/;/mi-'      [* Find comment start]       \
              [unmark] [left 1] [mark block]      [* Mark area between comment]\
              [column 25] [mark block]            [*  and operator start]      \
              [change] '/short //*moi' [unmark]   [* Erase any SHORT modifiers]\
              [begin line] [mark block]           [* Mark area where no]       \
              [column 42] [mark block]            [*  comments are wanted]     \
              [begin mark] [CommentRight 42]      [* Move comment out of area] \
              [CommentCol] [AlignC]               [* Align comment to above]   \
              [pop mark] [begin mark] [pop mark]  [* Restore position]

* Make SHORT label
syn MakeShort = [push mark] [mark char]            [* Save position]           \
                [push mark] [column 25]                                        \
                [insert mode] 'SHORT '             [* Add modifier]            \
                [replace mode]                                                 \
                [CommentCol] [AlignC]              [* Align comment to above]  \
                [pop mark] [begin mark] [pop mark] [* Restore position]

* Insert Jump label (get label from same line)
Syn Jump = [push mark] [mark char] [NoShort]    [* Save position, erase SHORT] \
           [push mark] [column 25]                                             \
           [insert mode] 'SHORT ' [unmark]      [* Add modifier]               \
           [mark char] [end word] [mark char]   [* Mark label]                 \
           [CommentCol] [AlignC] [up]           [* Align comment to above]     \
           [replace mode] [insert line]         [* Make room for new code]     \
           [insert line] [insert line]                                         \
           [copy mark] [end line] ':'           [* Create label]               \
           [pop mark] [begin mark]              [* Restore position]           \
           [down] [unmark] [mark line]          [* Down a line]                \
           [backtab word] [begin line]                                         \
           [begin word] [begin mark]            [* Find word to align below]   \
           [down] [pop mark]                    [* Align and restore mark]

* Replace opcode with EXTRN, isolate identifier, and position before any comment
syn Extrn = [column 17] [replace mode] 'EXTRN ' [* Wipe out command]           \
            [end word] [right]                  [* Position past identifier]   \
            [bookmark set 'Z']                                                 \
            [push mark] [mark block] [end line] [* Mark possible comment area] \
            [mark block] [locate] '/ ;/mi-'     [* Find comment start]         \
            [unmark] [mark block]               [* Mark area between comment]  \
            [bookmark goto 'Z'] [mark block]    [*  and end of identifier]     \
            [fill mark ' '] [end mark] [unmark] [* Erase that area]

* Set EXTRN type BYTE (removing past possible identifier)
syn Byte  = [push mark] [mark char]             [* Save position]              \
            [Extrn] [left]                      [* Set EXTRN, isolate name]    \
            [mark char] [left 4] [mark char]    [* Mark area before comment]   \
            [EraseBlank 5] [unmark]             [* Remove up to 5 blanks]      \
            [begin line] [end word] [right]     [* End of command]             \
            [end word] [right]                  [* Position past identifier]   \
            [insert mode] ':BYTE'               [* Add identifier type]        \
            [pop mark] [begin mark]             [* Restore cursor]             \
            [down] [pop mark] [replace mode]    [* Set to repeat on next line]

* Set EXTRN type WORD (removing past possible identifier)
syn DWord = [push mark] [mark char]             [* Save position]              \
            [Extrn] [left]                      [* Set EXTRN, isolate name]    \
            [mark char] [left 5] [mark char]    [* Mark area before comment]   \
            [EraseBlank 6] [unmark]             [* Remove up to 5 blanks]      \
            [begin line] [end word] [right]     [* End of command]             \
            [end word] [right]                  [* Position past identifier]   \
            [insert mode] ':DWORD'              [* Add identifier type]        \
            [pop mark] [begin mark]             [* Restore cursor]             \
            [down] [pop mark] [replace mode]    [* Set to repeat on next line]

* Set EXTRN type Near
syn Near  = [push mark] [mark char]             [* Save position]              \
            [Extrn] [left]                      [* Set EXTRN, isolate name]    \
            [mark char] [left 4] [mark char]    [* Mark area before comment]   \
            [EraseBlank 5] [unmark]             [* Remove up to 5 blanks]      \
            [begin line] [end word] [right]     [* End of command]             \
            [end word] [right]                  [* Position past identifier]   \
            [insert mode] ':NEAR'               [* Add identifier type]        \
            [pop mark] [begin mark]             [* Restore cursor]             \
            [down] [pop mark] [replace mode]    [* Set to repeat on next line]

* Set EXTRN type WORD (removing past possible identifier)
syn Word  = [push mark] [mark char]             [* Save position]              \
            [Extrn] [left]                      [* Set EXTRN, isolate name]    \
            [mark char] [left 4] [mark char]    [* Mark area before comment]   \
            [EraseBlank 5] [unmark]             [* Remove up to 5 blanks]      \
            [begin line] [end word] [right]     [* End of command]             \
            [end word] [right]                  [* Position past identifier]   \
            [insert mode] ':WORD'               [* Add identifier type]        \
            [pop mark] [begin mark]             [* Restore cursor]             \
            [down] [pop mark] [replace mode]    [* Set to repeat on next line]

*
* Regular keys
*

* Cursor movement keys
def up = [up]
def down = [down]
def left = [left]
def right = [right]

* Page up (two lines overlap)
def pgup = [page up]

* Page down (two lines overlap)
def pgdn = [page down]

* Move cursor to beginning of line
def home = [begin line]

* Move cursor to end of Line
def end = [end line]

* Flip between insert and replace character modes
def ins = [insert toggle]

* Delete character under the cursor
def del = [delete char]

* Position cursor to start of line one line below
* def enter = [begin line] [down] old version
def enter = [AEnter]

* Erase character before cursor and move cursor left (stop at first column)
def backspace = [rubout]

* Flip cursor between command line and file text (command toggle)
def esc = [command toggle]

* Move cursor to next tab position
def tab = [tab]

* If no mark then move cursor to next tab position
*   else shift mark right
* d tab = [Tab_Right]

* View help text
def f1 = [edit pe32.hlp]

* Save changes to file
def f2 = [save]

* Setup to save changes to file and close
def f3 = [cursor command] [begin line] [erase end line] 'file '

* Exit file without saving changes
def f4 = [quit]

* Open popup window with directory of current files
def f5 = [dir]

* Erase to end of line
def f6 = [erase end line]

* Open popup window with recently entered commands
def f7 = [history]

* Edit next file
def f8 = [edit]

* Insert a blank line
def f9 = [insert line]

* Insert line with cursor aligned below prior non-blank data (skip blank lines)
* def f10 = [AEnter] old version
def f10 = [begin line] [down]

* Finish typing using best match keyword
def f11 = [autocomplete]

* Move to command line and copy next executed command back to command line
*    Use c-f12 first else there is no next command
def f12 = [next history]

def padplus = '+'
def padminus = '-'
def space = ' '

*
* Shift keys
*

def s-up = '8'
def s-down = '2'
def s-left = '4'
def s-right = '6'
def s-pgup = '9'
def s-pgdn = '3'
def s-home = '7'
def s-end = '1'
def s-ins = '0'
def s-del = '.'

* Move cursor to prior tab
def s-tab = [backtab]

* If no mark then move cursor to prior tab position
*   else shift mark left
* d s-tab = [Tab_Left]

* Get compiler contextual help from set helpfile <file>
def s-f1 = [context help]

* Next full page up
def s-f2 = [page up] [top edge] [up] [up] [cursor command]

* Next full page down
def s-f3 = [page down] [bottom edge] [down] [down] [cursor command]

* Undo edits
def s-f4 = [undo]

* Edit file described on this file directory line (assumed in default directory)
*     Move to next directory entry after the file is opened
*
*     Obsolete with interactive [dir] and wildcards in filename
*
def s-f5 = [push mark] [cursor data] [begin line] [mark line] [locate] '/(/' \
           [erase end line] [begin line] [shift right] [shift right] 'e '    \
           [copy to command] [down] [execute] [unmark] [pop mark]

* Erase current character and all data on the line before it
def s-f6 = [erase begin line] [begin line]

* Erase first column of marked area
def s-f7 = [shift left]

* Add blank column to start of marked area and erase last column
def s-f8 = [shift right]

* Open most recently used file list
def s-f9 = [mru]

* Open opened file list
def s-f10 = [open]

* Insert date as text
def s-f11 = [date]

* Insert time as text
def s-f12 = [time]

def s-pad5 = '5'

*
* Ctrl keys
*

* Fix cursor position and scroll viewing area
def c-up = [scrollup]
def c-down = [scrolldown]
def c-left = [scrollleft]
def c-right = [scrollright]

* Move cursor to top edge of screen
def c-pgup = [top edge]

* Move cursor to bottom edge of screen
def c-pgdn = [bottom edge]

* Move cursor to top of file
def c-home = [top]

* Move cursor to bottom of file
def c-end = [bottom]

* Execute command on command line
def c-enter = [execute]

* Delete current line
def c-backspace = [delete line]

* Delete current line
def c-a = [delete line]

* Move cursor to beginning of word
def c-b = [begin word]

* Copy to clipboard
def c-c = [copy to clipboard]

* Center data on line (see set margins)
def c-d = [push mark] [mark line] [center in margins] [unmark] [pop mark]

* Move cursor beyond end of word
def c-e = [end word]

* Copy From command line onto new line below cursor
def c-f = [copy from command]

* Play current macro
def c-g = [macro play]

* Delete the current word
def c-h = [delete word]

* Zoom out using this view (see c-s)
def c-i = [zoom window]

* Join with following line (leave one extra blank between contents)
* d c-j = [FJoin]

* Join with following line
def c-j = [push mark] [down] [first nonblank] [* Locate non-blank 2nd line]  \
          [mark block] [end line] [left]      [* Mark good stuff on 2nd line]\
          [mark block] [up] [end line]        [* Return past end of 1st line]\
          [copy mark] [down] [unmark]         [* Copy to 1st line]           \
          [delete line] [up] [pop mark]    [* Delete 2nd line and reposition]

* Erase to beginning of line
def c-k = [erase begin line]

* Force mark to lower case
def c-l = [lowercase]

* Center text in margins
def c-m = [center in margins]

* Like [edit] for windows
def c-n = [next window]

* Move cursor to paragraph margin location
def c-o = [paragraph margin]

* Print marked area
def c-p = [print mark]

* Record a macro
def c-q = [macro define]

* Goto next view same file (when file is split ... key c-s)
def c-r = [next view]

* Split screen
def c-s = [split screen]

* Copy line with cursor on it to command line
def c-t = [copy to command]

* Force mark to upper case
def c-u = [uppercase]

* Copy from clipboard
def c-v = [copy from clipboard]

* Mark the current word
def c-w = [get word]

* Cut to clipboard
def c-x = [begin mark] [copy to clipboard] [delete mark]

* After undo re-apply the change
def c-y = [redo]

* Undo edits
def c-z = [undo]

*
* C++
*

* Build a C if block with insert cursor placed at condition
def c-f1 = [2if]

* Build a C else block and indent to next level
def c-f2 = [2else]

* Build a C while block with insert cursor placed at condition
def c-f3 = [2while]

* Build a C for block with insert cursor placed at loop definition
def c-f4 = [2for]

* Build a C switch block with insert cursor placed at switch variable
def c-f5 = [2switch]

* Build a C case statement with insert cursor placed at case designator
def c-f6 = [2case]

* Build a C if if-then-else statement with insert cursor placed at condition
def c-f7 = '(  ) ?  : ' [left 8] [insert mode]

* Build a C do while block with insert cursor placed at condition
def c-f8 = [2do]

* Build a C block with insert cursor placed at condition
* d c-f9 = '(' [XEnter] [tab] ') ;' [up] [XEnter] [tab]

* Build a C else if block and indent to next level
def c-f9 = [2ei]

* Build a C block comment with insert cursor placed at comment start
def c-f10 = '/**    **/' [insert mode] [left 5]

* Expand the synonym at the cursor position
def c-f11 = [expand]

* Move to command line and copy prior executed command back to command line
def c-f12 = [prev history]

* Turn command and status lines off
def c-padminus = [cursor command] [begin line] [erase end line]   \
                  'set commandline off' [execute] [cursor command] \
                  'set statusline off' [execute] [cursor data]

* Turn command and status lines on
def c-padplus = [cursor command] [begin line] [erase end line]   \
                  'set commandline on' [execute] [cursor command]  \
                  'set statusline on' [execute] [cursor command]

* Move cursor to matching brace
def c-space = [match brace]

*
* Alt keys
*

* Duplicate current line
def a-a = [dup line]

* Mark one corner of a rectangular block mark
def a-b = [mark block]

* Mark first or last character of a paragraph style block
def a-c = [mark char]

* Delete mark
def a-d = [delete mark]

* Move to end of marked area
def a-e = [end mark]

* Fill marked area (character will be prompted)
def a-f = [fill mark]

* Delete to start of word
def a-g = [unmark] [mark char] [backtab word] [tab word] [mark char]        \
          [delete mark]

* Delete to start of next word
def a-h = [unmark] [mark char] [tab word] [left] [left] [mark char]         \
          [begin mark] [delete mark]

* Make current word lower case and skip to next word
def a-i = [unmark] [tab word] [left] [mark char] [backtab word] [mark char] \
          [end mark] [right] [lowercase] [unmark]

* Join two lines
def a-j = [join]

* Make current word upper case and skip to next word
def a-k = [unmark] [tab word] [left] [mark char] [backtab word] [mark char] \
          [end mark] [right] [uppercase] [unmark]

* Mark first/last/only line of a group of lines
def a-l = [mark line]

* Move mark to current location
def a-m = [move mark]

* Move mark and its highlighting
* d a-m = [ve Move_Mark]

* Add Next page separator (form feed)
def a-n = [insert line] [012]

* Overlay marked block at current location
def a-o = [overlay block]

* Reflow the remainder of the current paragraph,
*   position cursor to presumed start of next paragraph
def a-p = [cursor data] [unmark] [mark line] [find blank line] [up]         \
          [mark line] [reflow] [end mark] [down] [down] [unmark]

* Pause the recording of a macro
def a-q = [macro pause]

* Repeat the last command
def a-r = [repeat command]

* Split line into two lines at cursor position (cursor does not move)
def a-s = [split]

* Overlay block at cursor position then blank fill prior copy and erase mark
def a-t = [overlay block] [fill mark ' '] [unmark]

* Unmark block
def a-u = [unmark]

* Make current word lower case except for leading capital and skip to next word
def a-v = [unmark] [tab word] [left] [mark char] [backtab word] [mark char] \
          [lowercase] [unmark] [mark char] [uppercase] [unmark] [tab word]

* Mark next Word
def a-w = [unmark] [tab word] [mark char] [end word] [right] [mark char]    \
          [begin mark]

* Setup to delete all file lines (an extra enter confirms action)
def a-x = [cursor command] [begin line] [erase end line] '[delete all]'

* Goto top of marked area
def a-y = [begin mark]

* Copy marked area
def a-z = [copy mark]

* Move cursor to next word
def a-f1 = [tab word]

* Move cursor to prior word
def a-f2 = [backtab word]

* Center current line on screen
def a-f3 = [center line]

* Exit all edits
def a-f4 = [quit all]

* Move cursor to next totally blank line
def a-f5 = [find blank line]

* Delete fron beginning of line up to and including cursor position
def a-f6 = [unmark] [mark char] [begin line] [mark char] [delete mark]

* Move cursor to next non-blank character
def a-f7 = [first nonblank]

* Edit prior file
def a-f8 = [edit -]

* Open menu
def a-f10 = [menu]

* Push mark
def a-f11 = [push mark]

* Pop mark
def a-f12 = [pop mark]

* Align all lines to be within left and right margins
def a-0 = [reformat all]

* Align all lines to the right margin
def a-1 = [justify all]

* Remove leading blanks from current line
def a-2 = [trim leading]

* Remove trailing blanks from current line
def a-3 = [trim trailing]

* Remove multiple blanks from current line
def a-4 = [trim compress]

* Align marked lines to be within left and right margins
def a-5 = [reflow]

* Align paragraph to be within left and right margins
def a-6 = [reformat paragraph]

* Align the paragraph to the right margin
def a-7 = [justify paragraph]

* Align the line to the right margin
def a-8 = [justify line]

* Edit file with current definitions for all keys
def a-9 = [edit .keydefs]

*
* Ctrl+Shift keys (User keys)
*

def u-b = 'BOOL '
def u-c = 'char '
def u-d = 'double '
def u-e = 'extern '
def u-h = 'HWND '
def u-i = 'int '
def u-j = 'long '
def u-k = 'const '
def u-l = 'LPCTSTR'
def u-o = 'CObject'
def u-p = 'CPoint '
def u-r = 'CRect '
def u-s = 'CString '
def u-t = 'this'
def u-u = 'unsigned '
def u-v = 'void'

* Prompt for bookmark letter and remember current position
def u-f1 = [bookmark set]

* Prompt for bookmark letter and restore cursor position
def u-f2 = [bookmark goto]

* Prompt for bookmark letter and erase bookmark memory
def u-f3 = [bookmark remove]

* Move cursor to left margin
def u-f4 = [left margin]

* Move cursor to right margin
def u-f5 = [right margin]

* Open the bookmarks list
def u-f6 = [bookmarks]

* Open the workspace list
def u-f7 = [workspace]

* Erase character before cursor and join the previous line if at first column
def u-f8 = [rubout join]

* Erase character under the cursor and join the next line if at last column
def u-f9 = [delete join]

* Add bookmark at current position
def u-1  = [vbsexec Call Set_Book(0)]

* Goto prior bookmark before current position
def u-2  = [vbsexec Call Goto_Book(-1,1)]

* Goto next bookmark beyond current position
def u-3  = [vbsexec Call Goto_Book(1,1)]

* Remove bookmark at current position
def u-4  = [vbsexec Call Rem_Book(0)]

* Clear all bookmarks all files
def u-5 = [vbsexec Call Clear_Books(1)]

* Add line number to the mark
def u-6 = [vbsexec Number_Mark]

* Remove line number to the mark
def u-7 = [vbsexec UnNumber_Mark]

* Up all files
def u-up = [up all]

* Down all files
def u-down = [down all]

* Move cursor to left edge of screen
def u-left = [left edge]

* Move cursor to right edge of screen
def u-right = [right edge]

* Page up all files
def u-pgup = [page up all]

* Page down all files
def u-pgdn = [page down all]

* Top all files
def u-home = [top all]

* Bottom all files
def u-end = [bottom all]

*
* Commands to run at execution time
*

* Remove this line to skip loading the pe32 help file
e pe32.hlp
