// Control.h : header file
//

// Copyright (c) 1999 by Andrew W. Phillips.
//
// No restrictions are placed on the noncommercial use of this code,
// as long as this text (from the above copyright notice to the
// disclaimer below) is preserved.
//
// This code may be redistributed as long as it remains unmodified
// and is not sold for profit without the author's written consent.
//
// This code, or any part of it, may not be used in any software that
// is sold for profit, without the author's written consent.
//
// DISCLAIMER: This file is provided "as is" with no expressed or
// implied warranty. The author accepts no liability for any damage
// or loss of business that this product may cause.
//

/////////////////////////////////////////////////////////////////////////////
// CHexEditControl window

class CHexEditControl : public CEdit
{
// Construction
public:
	CHexEditControl();

// Attributes
public:

// Operations
public:
    void add_spaces();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CHexEditControl)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CHexEditControl();

	// Generated message map functions
protected:
	//{{AFX_MSG(CHexEditControl)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	afx_msg LRESULT OnCommandHelp(WPARAM, LPARAM);

	DECLARE_MESSAGE_MAP()

private:
};

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CDecEditControl window

class CDecEditControl : public CEdit
{
// Construction
public:
	CDecEditControl();

// Attributes
public:

// Operations
public:
    void add_commas();
    char sep_char_;		// Char to use as "thousands" separator
    int group_;			// Number of digits in "thousands" group

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDecEditControl)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CDecEditControl();

	// Generated message map functions
protected:
	//{{AFX_MSG(CDecEditControl)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	afx_msg LRESULT OnCommandHelp(WPARAM, LPARAM);

	DECLARE_MESSAGE_MAP()

private:
};

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CSearchEditControl window

class CSearchEditControl : public CEdit
{
// Construction
public:
	CSearchEditControl();

// Attributes
public:
    // The characters used for an ASCII search + ASCII search ignoring case
    enum { sflag_char = '=', iflag_char = '~' };
    enum mode_t { mode_none, mode_hex, mode_char, mode_icase };
    void SetMode(enum mode_t m) { mode_ = m; }
    void Redisplay()		    // Make sure hex digits case OK etc
    {
	CString ss;
	GetWindowText(ss);
	if (ss.GetLength() > 0 && ss[0] != sflag_char && ss[0] != iflag_char)
	    normalize_hex();
    }
    BOOL in_edit_;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSearchEditControl)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSearchEditControl();

	// Generated message map functions
protected:
	//{{AFX_MSG(CSearchEditControl)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	//}}AFX_MSG
	afx_msg LRESULT OnCommandHelp(WPARAM, LPARAM);

	DECLARE_MESSAGE_MAP()

private:
    CString saved_;
    enum mode_t mode_;

    void convert2hex();
    void convert2chars(char c1 = sflag_char);
    void normalize_hex();
};

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CStatBar window

class CStatBar : public CStatusBar
{
// Construction
public:
	CStatBar();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CStatBar)
	//}}AFX_VIRTUAL
    virtual BOOL PreTranslateMessage(MSG* pMsg);

// Implementation
public:
	virtual ~CStatBar();

	CToolTipCtrl ttip_;

	// Generated message map functions
protected:
	//{{AFX_MSG(CStatBar)
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
    void add_tooltip(UINT id, const char *ss);
    void move_tooltip(UINT id);
};

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CDlgBar window

class CDlgBar : public CDialogBar
{
// Construction
public:
 
// Attributes
public:
 
// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgBar)
	//}}AFX_VIRTUAL

// Implementation
public:

	// Generated message map functions
protected:
	//{{AFX_MSG(CDlgBar)
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	//}}AFX_MSG
	afx_msg LRESULT OnHelpHitTest(WPARAM, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
